/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.misc;

import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.enumeration.misc.ConnectingIdType;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;

public final class ImpersonatedUserId {
    private ConnectingIdType idType;
    private String id;

    public ImpersonatedUserId() {
    }

    public ImpersonatedUserId(ConnectingIdType idType, String id) {
        this();
        this.idType = idType;
        this.id = id;
    }

    public void writeToXml(EwsServiceXmlWriter writer) throws Exception {
        if (this.id == null || this.id.isEmpty()) {
            throw new Exception("The Id property must be set.");
        }
        writer.writeStartElement(XmlNamespace.Types, "ExchangeImpersonation");
        writer.writeStartElement(XmlNamespace.Types, "ConnectingSID");
        String connectingIdTypeLocalName = this.idType == ConnectingIdType.SmtpAddress && writer.getService().getRequestedServerVersion() == ExchangeVersion.Exchange2007_SP1 ? "PrimarySmtpAddress" : this.getIdType().toString();
        writer.writeElementValue(XmlNamespace.Types, connectingIdTypeLocalName, this.id);
        writer.writeEndElement();
        writer.writeEndElement();
    }

    public ConnectingIdType getIdType() {
        return this.idType;
    }

    public void setIdType(ConnectingIdType idType) {
        this.idType = idType;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

