/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import microsoft.exchange.webservices.data.attribute.ServiceObjectDefinition;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.PropertyBag;
import microsoft.exchange.webservices.data.core.PropertySet;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.service.DeleteMode;
import microsoft.exchange.webservices.data.core.enumeration.service.SendCancellationsMode;
import microsoft.exchange.webservices.data.core.enumeration.service.calendar.AffectedTaskOccurrence;
import microsoft.exchange.webservices.data.core.exception.misc.InvalidOperationException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceLocalException;
import microsoft.exchange.webservices.data.core.service.schema.ServiceObjectSchema;
import microsoft.exchange.webservices.data.misc.OutParam;
import microsoft.exchange.webservices.data.property.complex.ExtendedProperty;
import microsoft.exchange.webservices.data.property.complex.ExtendedPropertyCollection;
import microsoft.exchange.webservices.data.property.complex.IServiceObjectChangedDelegate;
import microsoft.exchange.webservices.data.property.complex.ServiceId;
import microsoft.exchange.webservices.data.property.definition.ExtendedPropertyDefinition;
import microsoft.exchange.webservices.data.property.definition.PropertyDefinition;
import microsoft.exchange.webservices.data.property.definition.PropertyDefinitionBase;

public abstract class ServiceObject {
    private Object lockObject = new Object();
    private ExchangeService service;
    private PropertyBag propertyBag;
    private String xmlElementName;
    private List<IServiceObjectChangedDelegate> onChange = new ArrayList<IServiceObjectChangedDelegate>();

    public void changed() {
        for (IServiceObjectChangedDelegate change : this.onChange) {
            change.serviceObjectChanged(this);
        }
    }

    public void throwIfThisIsNew() throws InvalidOperationException, ServiceLocalException {
        if (this.isNew()) {
            throw new InvalidOperationException("This operation can't be performed because this service object doesn't have an Id.");
        }
    }

    protected void throwIfThisIsNotNew() throws InvalidOperationException, ServiceLocalException {
        if (!this.isNew()) {
            throw new InvalidOperationException("This operation can't be performed because this service object already has an ID. To update this service object, use the Update() method instead.");
        }
    }

    protected String getXmlElementNameOverride() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getXmlElementName() {
        if (this.isNullOrEmpty(this.xmlElementName)) {
            this.xmlElementName = this.getXmlElementNameOverride();
            if (this.isNullOrEmpty(this.xmlElementName)) {
                Object object = this.lockObject;
                synchronized (object) {
                    ServiceObjectDefinition annotation = this.getClass().getAnnotation(ServiceObjectDefinition.class);
                    if (null != annotation) {
                        this.xmlElementName = annotation.xmlElementName();
                    }
                }
            }
        }
        EwsUtilities.ewsAssert(!this.isNullOrEmpty(this.xmlElementName), "EwsObject.GetXmlElementName", String.format("The class %s does not have an associated XML element name.", this.getClass().getName()));
        return this.xmlElementName;
    }

    public String getChangeXmlElementName() {
        return "ItemChange";
    }

    public String getSetFieldXmlElementName() {
        return "SetItemField";
    }

    public String getDeleteFieldXmlElementName() {
        return "DeleteItemField";
    }

    protected boolean getIsTimeZoneHeaderRequired(boolean isUpdateOperation) throws ServiceLocalException, Exception {
        return false;
    }

    protected boolean getIsCustomDateTimeScopingRequired() {
        return false;
    }

    public PropertyBag getPropertyBag() {
        return this.propertyBag;
    }

    protected ServiceObject(ExchangeService service) throws Exception {
        EwsUtilities.validateParam(service, "service");
        EwsUtilities.validateServiceObjectVersion(this, service.getRequestedServerVersion());
        this.service = service;
        this.propertyBag = new PropertyBag(this);
    }

    public ServiceObjectSchema schema() {
        return this.getSchema();
    }

    public abstract ServiceObjectSchema getSchema();

    public abstract ExchangeVersion getMinimumRequiredServerVersion();

    public void loadFromXml(EwsServiceXmlReader reader, boolean clearPropertyBag) throws Exception {
        this.getPropertyBag().loadFromXml(reader, clearPropertyBag, null, false);
    }

    protected void validate() throws Exception {
        this.getPropertyBag().validate();
    }

    public void loadFromXml(EwsServiceXmlReader reader, boolean clearPropertyBag, PropertySet requestedPropertySet, boolean summaryPropertiesOnly) throws Exception {
        this.getPropertyBag().loadFromXml(reader, clearPropertyBag, requestedPropertySet, summaryPropertiesOnly);
    }

    public void clearChangeLog() {
        this.getPropertyBag().clearChangeLog();
    }

    public void writeToXml(EwsServiceXmlWriter writer) throws Exception {
        this.getPropertyBag().writeToXml(writer);
    }

    public void writeToXmlForUpdate(EwsServiceXmlWriter writer) throws Exception {
        this.getPropertyBag().writeToXmlForUpdate(writer);
    }

    protected abstract void internalLoad(PropertySet var1) throws Exception;

    protected abstract void internalDelete(DeleteMode var1, SendCancellationsMode var2, AffectedTaskOccurrence var3) throws Exception;

    public void load(PropertySet propertySet) throws Exception {
        this.internalLoad(propertySet);
    }

    public void load() throws Exception {
        this.internalLoad(PropertySet.getFirstClassProperties());
    }

    public Object getObjectFromPropertyDefinition(PropertyDefinitionBase propertyDefinition) throws Exception {
        PropertyDefinition propDef = (PropertyDefinition)propertyDefinition;
        if (propDef != null) {
            return this.getPropertyBag().getObjectFromPropertyDefinition(propDef);
        }
        throw new UnsupportedOperationException(String.format("This operation isn't supported for property definition type %s.", propertyDefinition.getType().getName()));
    }

    protected <T> boolean tryGetExtendedProperty(Class<T> cls, ExtendedPropertyDefinition propertyDefinition, OutParam<T> propertyValue) throws Exception {
        ExtendedPropertyCollection propertyCollection = this.getExtendedProperties();
        if (propertyCollection != null && propertyCollection.tryGetValue(cls, propertyDefinition, propertyValue)) {
            return true;
        }
        propertyValue.setParam((Object)null);
        return false;
    }

    public boolean tryGetProperty(PropertyDefinitionBase propertyDefinition, OutParam<Object> propertyValue) throws Exception {
        return this.tryGetProperty(Object.class, propertyDefinition, propertyValue);
    }

    public <T> boolean tryGetProperty(Class<T> cls, PropertyDefinitionBase propertyDefinition, OutParam<T> propertyValue) throws Exception {
        PropertyDefinition propDef = (PropertyDefinition)propertyDefinition;
        if (propDef != null) {
            return this.getPropertyBag().tryGetPropertyType(cls, propDef, propertyValue);
        }
        throw new UnsupportedOperationException(String.format("This operation isn't supported for property definition type %s.", propertyDefinition.getType().getName()));
    }

    public Collection<PropertyDefinitionBase> getLoadedPropertyDefinitions() throws Exception {
        ArrayList<PropertyDefinitionBase> propDefs = new ArrayList<PropertyDefinitionBase>();
        for (PropertyDefinition propDef : this.getPropertyBag().getProperties().keySet()) {
            propDefs.add(propDef);
        }
        if (this.getExtendedProperties() != null) {
            for (ExtendedProperty extProp : this.getExtendedProperties()) {
                propDefs.add(extProp.getPropertyDefinition());
            }
        }
        return propDefs;
    }

    public ExchangeService getService() {
        return this.service;
    }

    protected void setService(ExchangeService service) {
        this.service = service;
    }

    public PropertyDefinition getIdPropertyDefinition() {
        return null;
    }

    public ServiceId getId() throws ServiceLocalException {
        PropertyDefinition idPropertyDefinition = this.getIdPropertyDefinition();
        OutParam serviceId = new OutParam();
        if (idPropertyDefinition != null) {
            this.getPropertyBag().tryGetValue(idPropertyDefinition, serviceId);
        }
        return (ServiceId)serviceId.getParam();
    }

    public boolean isNew() throws ServiceLocalException {
        ServiceId id = this.getId();
        return id == null ? true : !id.isValid();
    }

    public boolean isDirty() {
        return this.getPropertyBag().getIsDirty();
    }

    protected ExtendedPropertyCollection getExtendedProperties() throws Exception {
        return null;
    }

    private boolean isNullOrEmpty(String namespacePrefix) {
        return namespacePrefix == null || namespacePrefix.isEmpty();
    }

    public void addServiceObjectChangedEvent(IServiceObjectChangedDelegate change) {
        this.onChange.add(change);
    }

    public void removeServiceObjectChangedEvent(IServiceObjectChangedDelegate change) {
        this.onChange.remove(change);
    }

    public void clearServiceObjectChangedEvent() {
        this.onChange.clear();
    }
}

