/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.request;

import java.util.ArrayList;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.service.error.ServiceErrorHandling;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceLocalException;
import microsoft.exchange.webservices.data.core.request.MultiResponseServiceRequest;
import microsoft.exchange.webservices.data.core.response.ServiceResponse;
import microsoft.exchange.webservices.data.core.response.UpdateFolderResponse;
import microsoft.exchange.webservices.data.core.service.folder.Folder;

public final class UpdateFolderRequest
extends MultiResponseServiceRequest<ServiceResponse> {
    private ArrayList<Folder> folders = new ArrayList();

    public UpdateFolderRequest(ExchangeService service, ServiceErrorHandling errorHandlingMode) throws Exception {
        super(service, errorHandlingMode);
    }

    @Override
    protected void validate() throws ServiceLocalException, Exception {
        super.validate();
        EwsUtilities.validateParamCollection(this.getFolders().iterator(), "Folders");
        for (int i = 0; i < this.getFolders().size(); ++i) {
            Folder folder = this.getFolders().get(i);
            if (folder == null || folder.isNew()) {
                throw new IllegalArgumentException(String.format("Folders[%d] is either null or does not have an Id.", i));
            }
            folder.validate();
        }
    }

    @Override
    protected ServiceResponse createServiceResponse(ExchangeService session, int responseIndex) {
        return new UpdateFolderResponse(this.getFolders().get(responseIndex));
    }

    @Override
    public String getXmlElementName() {
        return "UpdateFolder";
    }

    @Override
    protected String getResponseXmlElementName() {
        return "UpdateFolderResponse";
    }

    @Override
    protected String getResponseMessageXmlElementName() {
        return "UpdateFolderResponseMessage";
    }

    @Override
    protected int getExpectedResponseMessageCount() {
        return this.getFolders().size();
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        writer.writeStartElement(XmlNamespace.Messages, "FolderChanges");
        for (Folder folder : this.folders) {
            folder.writeToXmlForUpdate(writer);
        }
        writer.writeEndElement();
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    public ArrayList<Folder> getFolders() {
        return this.folders;
    }
}

