/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.request;

import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.exception.misc.ArgumentException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.core.request.SubscribeRequest;
import microsoft.exchange.webservices.data.core.response.SubscribeResponse;
import microsoft.exchange.webservices.data.notification.PullSubscription;

public class SubscribeToPullNotificationsRequest
extends SubscribeRequest<PullSubscription> {
    private int timeout = 30;

    public SubscribeToPullNotificationsRequest(ExchangeService service) throws Exception {
        super(service);
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeOut(int timeout) {
        this.timeout = timeout;
    }

    @Override
    protected void validate() throws Exception {
        super.validate();
        if (this.getTimeout() < 1 || this.getTimeout() > 1440) {
            throw new ArgumentException(String.format("%d is not a valid timeout value. Valid values range from 1 to 1440.", this.getTimeout()));
        }
    }

    @Override
    protected SubscribeResponse<PullSubscription> createServiceResponse(ExchangeService service, int responseIndex) throws Exception {
        return new SubscribeResponse<PullSubscription>(new PullSubscription(service));
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    @Override
    protected String getSubscriptionXmlElementName() {
        return "PullSubscriptionRequest";
    }

    @Override
    protected void internalWriteElementsToXml(EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException {
        writer.writeElementValue(XmlNamespace.Types, "Timeout", this.getTimeout());
    }
}

