/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import microsoft.exchange.webservices.data.core.CookieProcessingTargetAuthenticationStrategy;
import microsoft.exchange.webservices.data.core.EwsSSLProtocolSocketFactory;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeServerInfo;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.ICustomXmlSerialization;
import microsoft.exchange.webservices.data.core.WebProxy;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.misc.TraceFlags;
import microsoft.exchange.webservices.data.core.exception.http.EWSHttpException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceLocalException;
import microsoft.exchange.webservices.data.core.exception.service.remote.AccountIsLockedException;
import microsoft.exchange.webservices.data.core.request.HttpClientWebRequest;
import microsoft.exchange.webservices.data.core.request.HttpWebRequest;
import microsoft.exchange.webservices.data.credential.ExchangeCredentials;
import microsoft.exchange.webservices.data.misc.EwsTraceListener;
import microsoft.exchange.webservices.data.misc.ITraceListener;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.CookieStore;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public abstract class ExchangeServiceBase
implements Closeable {
    private static final Log LOG = LogFactory.getLog(ExchangeService.class);
    private ExchangeCredentials credentials;
    private boolean useDefaultCredentials;
    private static byte[] binarySecret;
    private int timeout = 100000;
    private boolean traceEnabled;
    private EnumSet<TraceFlags> traceFlags = EnumSet.allOf(TraceFlags.class);
    private ITraceListener traceListener = new EwsTraceListener();
    private boolean preAuthenticate;
    private String userAgent = defaultUserAgent;
    private boolean acceptGzipEncoding = true;
    private ExchangeVersion requestedServerVersion = ExchangeVersion.Exchange2010_SP2;
    private ExchangeServerInfo serverInfo;
    private Map<String, String> httpHeaders = new HashMap<String, String>();
    private Map<String, String> httpResponseHeaders = new HashMap<String, String>();
    private WebProxy webProxy;
    protected CloseableHttpClient httpClient;
    protected HttpClientContext httpContext;
    protected CloseableHttpClient httpPoolingClient;
    private int maximumPoolingConnections = 10;
    private static String defaultUserAgent;
    private List<ICustomXmlSerialization> OnSerializeCustomSoapHeaders;

    protected ExchangeServiceBase() {
        this.setUseDefaultCredentials(true);
        this.initializeHttpClient();
        this.initializeHttpContext();
    }

    protected ExchangeServiceBase(ExchangeVersion requestedServerVersion) {
        this();
        this.requestedServerVersion = requestedServerVersion;
    }

    protected ExchangeServiceBase(ExchangeServiceBase service, ExchangeVersion requestedServerVersion) {
        this(requestedServerVersion);
        this.useDefaultCredentials = service.getUseDefaultCredentials();
        this.credentials = service.getCredentials();
        this.traceEnabled = service.isTraceEnabled();
        this.traceListener = service.getTraceListener();
        this.traceFlags = service.getTraceFlags();
        this.timeout = service.getTimeout();
        this.preAuthenticate = service.isPreAuthenticate();
        this.userAgent = service.getUserAgent();
        this.acceptGzipEncoding = service.getAcceptGzipEncoding();
        this.httpHeaders = service.getHttpHeaders();
    }

    private void initializeHttpClient() {
        Registry<ConnectionSocketFactory> registry = this.createConnectionSocketFactoryRegistry();
        BasicHttpClientConnectionManager httpConnectionManager = new BasicHttpClientConnectionManager(registry);
        CookieProcessingTargetAuthenticationStrategy authStrategy = new CookieProcessingTargetAuthenticationStrategy();
        this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)httpConnectionManager).setTargetAuthenticationStrategy((AuthenticationStrategy)authStrategy).build();
    }

    private void initializeHttpPoolingClient() {
        Registry<ConnectionSocketFactory> registry = this.createConnectionSocketFactoryRegistry();
        PoolingHttpClientConnectionManager httpConnectionManager = new PoolingHttpClientConnectionManager(registry);
        httpConnectionManager.setMaxTotal(this.maximumPoolingConnections);
        httpConnectionManager.setDefaultMaxPerRoute(this.maximumPoolingConnections);
        CookieProcessingTargetAuthenticationStrategy authStrategy = new CookieProcessingTargetAuthenticationStrategy();
        this.httpPoolingClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)httpConnectionManager).setTargetAuthenticationStrategy((AuthenticationStrategy)authStrategy).build();
    }

    public void setMaximumPoolingConnections(int maximumPoolingConnections) {
        if (maximumPoolingConnections < 1) {
            throw new IllegalArgumentException("maximumPoolingConnections must be 1 or greater");
        }
        this.maximumPoolingConnections = maximumPoolingConnections;
    }

    protected Registry<ConnectionSocketFactory> createConnectionSocketFactoryRegistry() {
        try {
            return RegistryBuilder.create().register("http", (Object)new PlainConnectionSocketFactory()).register("https", (Object)EwsSSLProtocolSocketFactory.build(null)).build();
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Could not initialize ConnectionSocketFactory instances for HttpClientConnectionManager", e);
        }
    }

    private void initializeHttpContext() {
        BasicCookieStore cookieStore = new BasicCookieStore();
        this.httpContext = HttpClientContext.create();
        this.httpContext.setCookieStore((CookieStore)cookieStore);
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((Closeable)this.httpClient);
        IOUtils.closeQuietly((Closeable)this.httpPoolingClient);
    }

    public void doOnSerializeCustomSoapHeaders(XMLStreamWriter writer) {
        EwsUtilities.ewsAssert(writer != null, "ExchangeService.DoOnSerializeCustomSoapHeaders", "writer is null");
        if (null != this.getOnSerializeCustomSoapHeaders() && !this.getOnSerializeCustomSoapHeaders().isEmpty()) {
            for (ICustomXmlSerialization customSerialization : this.getOnSerializeCustomSoapHeaders()) {
                customSerialization.CustomXmlSerialization(writer);
            }
        }
    }

    protected HttpWebRequest prepareHttpWebRequestForUrl(URI url, boolean acceptGzipEncoding, boolean allowAutoRedirect) throws ServiceLocalException, URISyntaxException {
        String scheme = url.getScheme();
        if (!scheme.equalsIgnoreCase("http") && !scheme.equalsIgnoreCase("https")) {
            String strErr = String.format("Protocol %s isn't supported for service request.", scheme);
            throw new ServiceLocalException(strErr);
        }
        HttpClientWebRequest request = new HttpClientWebRequest(this.httpClient, this.httpContext);
        this.prepareHttpWebRequestForUrl(url, acceptGzipEncoding, allowAutoRedirect, request);
        return request;
    }

    protected HttpWebRequest prepareHttpPoolingWebRequestForUrl(URI url, boolean acceptGzipEncoding, boolean allowAutoRedirect) throws ServiceLocalException, URISyntaxException {
        String scheme = url.getScheme();
        if (!scheme.equalsIgnoreCase("http") && !scheme.equalsIgnoreCase("https")) {
            String strErr = String.format("Protocol %s isn't supported for service request.", scheme);
            throw new ServiceLocalException(strErr);
        }
        if (this.httpPoolingClient == null) {
            this.initializeHttpPoolingClient();
        }
        HttpClientWebRequest request = new HttpClientWebRequest(this.httpPoolingClient, this.httpContext);
        this.prepareHttpWebRequestForUrl(url, acceptGzipEncoding, allowAutoRedirect, request);
        return request;
    }

    private void prepareHttpWebRequestForUrl(URI url, boolean acceptGzipEncoding, boolean allowAutoRedirect, HttpClientWebRequest request) throws ServiceLocalException, URISyntaxException {
        try {
            request.setUrl(url.toURL());
        }
        catch (MalformedURLException e) {
            String strErr = String.format("Incorrect format : %s", url);
            throw new ServiceLocalException(strErr);
        }
        request.setPreAuthenticate(this.preAuthenticate);
        request.setTimeout(this.timeout);
        request.setContentType("text/xml; charset=utf-8");
        request.setAccept("text/xml");
        request.setUserAgent(this.userAgent);
        request.setAllowAutoRedirect(allowAutoRedirect);
        request.setAcceptGzipEncoding(acceptGzipEncoding);
        request.setHeaders(this.getHttpHeaders());
        request.setProxy(this.getWebProxy());
        this.prepareCredentials(request);
        request.prepareConnection();
        this.httpResponseHeaders.clear();
    }

    protected void prepareCredentials(HttpWebRequest request) throws ServiceLocalException, URISyntaxException {
        request.setUseDefaultCredentials(this.useDefaultCredentials);
        if (!this.useDefaultCredentials) {
            if (this.credentials == null) {
                throw new ServiceLocalException("Credentials are required to make a service request.");
            }
            this.credentials.preAuthenticate();
            this.credentials.prepareWebRequest(request);
        }
    }

    protected void internalProcessHttpErrorResponse(HttpWebRequest httpWebResponse, Exception webException, TraceFlags responseHeadersTraceFlag, TraceFlags responseTraceFlag) throws Exception {
        EwsUtilities.ewsAssert(500 != httpWebResponse.getResponseCode(), "ExchangeServiceBase.InternalProcessHttpErrorResponse", "InternalProcessHttpErrorResponse does not handle 500 ISE errors, the caller is supposed to handle this.");
        this.processHttpResponseHeaders(responseHeadersTraceFlag, httpWebResponse);
        if (httpWebResponse.getResponseCode() == 456) {
            String location = httpWebResponse.getResponseContentType();
            URI accountUnlockUrl = null;
            if (ExchangeServiceBase.checkURIPath(location)) {
                accountUnlockUrl = new URI(location);
            }
            String message = String.format("This account is locked. Visit %s to unlock it.", accountUnlockUrl);
            this.traceMessage(responseTraceFlag, message);
            throw new AccountIsLockedException(message, accountUnlockUrl, webException);
        }
    }

    public static boolean checkURIPath(String location) {
        if (location == null) {
            return false;
        }
        File file = new File(location);
        return file.isAbsolute();
    }

    protected abstract void processHttpErrorResponse(HttpWebRequest var1, Exception var2) throws Exception;

    public boolean isTraceEnabledFor(TraceFlags traceFlags) {
        return this.isTraceEnabled() && this.traceFlags.contains((Object)traceFlags);
    }

    public void traceMessage(TraceFlags traceType, String logEntry) throws XMLStreamException, IOException {
        if (this.isTraceEnabledFor(traceType)) {
            String traceTypeStr = traceType.toString();
            String logMessage = EwsUtilities.formatLogMessage(traceTypeStr, logEntry);
            this.traceListener.trace(traceTypeStr, logMessage);
        }
    }

    public void traceXml(TraceFlags traceType, ByteArrayOutputStream stream) {
        if (this.isTraceEnabledFor(traceType)) {
            String traceTypeStr = traceType.toString();
            String logMessage = EwsUtilities.formatLogMessageWithXmlContent(traceTypeStr, stream);
            this.traceListener.trace(traceTypeStr, logMessage);
        }
    }

    public void traceHttpRequestHeaders(TraceFlags traceType, HttpWebRequest request) throws URISyntaxException, EWSHttpException, XMLStreamException, IOException {
        if (this.isTraceEnabledFor(traceType)) {
            String traceTypeStr = traceType.toString();
            String headersAsString = EwsUtilities.formatHttpRequestHeaders(request);
            String logMessage = EwsUtilities.formatLogMessage(traceTypeStr, headersAsString);
            this.traceListener.trace(traceTypeStr, logMessage);
        }
    }

    private void traceHttpResponseHeaders(TraceFlags traceType, HttpWebRequest request) throws XMLStreamException, IOException, EWSHttpException {
        if (this.isTraceEnabledFor(traceType)) {
            String traceTypeStr = traceType.toString();
            String headersAsString = EwsUtilities.formatHttpResponseHeaders(request);
            String logMessage = EwsUtilities.formatLogMessage(traceTypeStr, headersAsString);
            this.traceListener.trace(traceTypeStr, logMessage);
        }
    }

    public String convertDateTimeToUniversalDateTimeString(Date dt) {
        String utcPattern = "yyyy-MM-dd'T'HH:mm:ss'Z'";
        SimpleDateFormat utcFormatter = new SimpleDateFormat(utcPattern);
        utcFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        return utcFormatter.format(dt);
    }

    protected void setCustomUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void validate() throws ServiceLocalException {
    }

    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    public void setTraceEnabled(boolean traceEnabled) {
        this.traceEnabled = traceEnabled;
        if (this.traceEnabled && this.traceListener == null) {
            this.traceListener = new EwsTraceListener();
        }
    }

    public EnumSet<TraceFlags> getTraceFlags() {
        return this.traceFlags;
    }

    public void setTraceFlags(EnumSet<TraceFlags> traceFlags) {
        this.traceFlags = traceFlags;
    }

    public ITraceListener getTraceListener() {
        return this.traceListener;
    }

    public void setTraceListener(ITraceListener traceListener) {
        this.traceListener = traceListener;
        this.traceEnabled = traceListener != null;
    }

    public ExchangeCredentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(ExchangeCredentials credentials) {
        this.credentials = credentials;
        this.useDefaultCredentials = false;
        this.initializeHttpContext();
    }

    public boolean getUseDefaultCredentials() {
        return this.useDefaultCredentials;
    }

    public void setUseDefaultCredentials(boolean value) {
        this.useDefaultCredentials = value;
        if (value) {
            this.credentials = null;
        }
        this.initializeHttpContext();
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        if (timeout < 1) {
            throw new IllegalArgumentException("Timeout must be greater than zero.");
        }
        this.timeout = timeout;
    }

    public boolean isPreAuthenticate() {
        return this.preAuthenticate;
    }

    public void setPreAuthenticate(boolean preAuthenticate) {
        this.preAuthenticate = preAuthenticate;
    }

    public boolean getAcceptGzipEncoding() {
        return this.acceptGzipEncoding;
    }

    public void setAcceptGzipEncoding(boolean acceptGzipEncoding) {
        this.acceptGzipEncoding = acceptGzipEncoding;
    }

    public ExchangeVersion getRequestedServerVersion() {
        return this.requestedServerVersion;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent + " (" + defaultUserAgent + ")";
    }

    public ExchangeServerInfo getServerInfo() {
        return this.serverInfo;
    }

    public void setServerInfo(ExchangeServerInfo serverInfo) {
        this.serverInfo = serverInfo;
    }

    public WebProxy getWebProxy() {
        return this.webProxy;
    }

    public void setWebProxy(WebProxy value) {
        this.webProxy = value;
    }

    public Map<String, String> getHttpHeaders() {
        return this.httpHeaders;
    }

    public List<ICustomXmlSerialization> getOnSerializeCustomSoapHeaders() {
        return this.OnSerializeCustomSoapHeaders;
    }

    public void setOnSerializeCustomSoapHeaders(List<ICustomXmlSerialization> onSerializeCustomSoapHeaders) {
        this.OnSerializeCustomSoapHeaders = onSerializeCustomSoapHeaders;
    }

    public void processHttpResponseHeaders(TraceFlags traceType, HttpWebRequest request) throws XMLStreamException, IOException, EWSHttpException {
        this.traceHttpResponseHeaders(traceType, request);
        this.saveHttpResponseHeaders(request.getResponseHeaders());
    }

    private void saveHttpResponseHeaders(Map<String, String> headers) {
        this.httpResponseHeaders.clear();
        for (String key : headers.keySet()) {
            this.httpResponseHeaders.put(key, headers.get(key));
        }
    }

    public Map<String, String> getHttpResponseHeaders() {
        return this.httpResponseHeaders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getSessionKey() {
        Class<ExchangeServiceBase> clazz = ExchangeServiceBase.class;
        synchronized (ExchangeServiceBase.class) {
            if (binarySecret == null) {
                Random randomNumberGenerator = new Random();
                binarySecret = new byte[32];
                randomNumberGenerator.nextBytes(binarySecret);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return binarySecret;
        }
    }

    public int getMaximumPoolingConnections() {
        return this.maximumPoolingConnections;
    }

    static {
        defaultUserAgent = "ExchangeServicesClient/" + EwsUtilities.getBuildVersion();
    }
}

