/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.xml.rpc.module;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.axis2.util.CommandLineOption;
import org.apache.axis2.util.CommandLineOptionConstants;
import org.apache.axis2.wsdl.codegen.CodeGenConfiguration;
import org.apache.axis2.wsdl.codegen.CodeGenerationException;
import org.apache.axis2.wsdl.i18n.CodegenMessages;

public class CFCodegenConfigLoader
implements CommandLineOptionConstants {
    public static void loadConfig(CodeGenConfiguration config, Map<String, CommandLineOption> optionMap) throws CodeGenerationException {
        String optionValue;
        String value;
        boolean syncFlagPresent;
        String outputLocation = ".";
        CommandLineOption commandLineOption = CFCodegenConfigLoader.loadOption("o", "output", optionMap);
        if (commandLineOption != null) {
            config.setoutputSourceLocation(true);
            outputLocation = commandLineOption.getOptionValue();
        }
        File outputLocationFile = new File(outputLocation);
        config.setOutputLocation(outputLocationFile);
        if (outputLocationFile.exists()) {
            if (outputLocationFile.isFile()) {
                throw new RuntimeException(CodegenMessages.getMessage((String)"options.notADirectoryException"));
            }
        } else {
            outputLocationFile.mkdirs();
        }
        config.setServerSide(CFCodegenConfigLoader.loadOption("ss", "server-side", optionMap) != null);
        config.setGenerateDeployementDescriptor(CFCodegenConfigLoader.loadOption("sd", "service-description", optionMap) != null);
        config.setWriteTestCase(CFCodegenConfigLoader.loadOption("t", "test-case", optionMap) != null);
        config.setSkipWriteWSDLs(CFCodegenConfigLoader.loadOption(null, "noWSDL", optionMap) != null);
        config.setSkipMessageReceiver(CFCodegenConfigLoader.loadOption(null, "noMessageReceiver", optionMap) != null);
        config.setSkipBuildXML(CFCodegenConfigLoader.loadOption(null, "noBuildXML", optionMap) != null);
        boolean asyncFlagPresent = CFCodegenConfigLoader.loadOption("a", "async", optionMap) != null;
        boolean bl = syncFlagPresent = CFCodegenConfigLoader.loadOption("s", "sync", optionMap) != null;
        if (asyncFlagPresent && !syncFlagPresent) {
            config.setAsyncOn(true);
            config.setSyncOn(false);
        }
        if (syncFlagPresent && !asyncFlagPresent) {
            config.setAsyncOn(false);
            config.setSyncOn(true);
        }
        if ((commandLineOption = CFCodegenConfigLoader.loadOption("p", "package", optionMap)) != null) {
            config.setPackageName(commandLineOption.getOptionValue());
        }
        if ((commandLineOption = CFCodegenConfigLoader.loadOption("l", "language", optionMap)) != null) {
            config.setOutputLanguage(commandLineOption.getOptionValue());
        }
        if ((commandLineOption = CFCodegenConfigLoader.loadOption("d", "databinding-method", optionMap)) != null) {
            config.setDatabindingType(commandLineOption.getOptionValue());
        }
        if ((commandLineOption = CFCodegenConfigLoader.loadOption("u", "unpack-classes", optionMap)) != null) {
            config.setPackClasses(false);
        }
        if ((commandLineOption = CFCodegenConfigLoader.loadOption("S", "source-folder", optionMap)) != null) {
            config.setSourceLocation(commandLineOption.getOptionValue());
        }
        if ((commandLineOption = CFCodegenConfigLoader.loadOption("R", "resource-folder", optionMap)) != null) {
            config.setResourceLocation(commandLineOption.getOptionValue());
        }
        config.setPortName((commandLineOption = CFCodegenConfigLoader.loadOption("pn", "port-name", optionMap)) != null ? commandLineOption.getOptionValue() : null);
        commandLineOption = CFCodegenConfigLoader.loadOption("sn", "service-name", optionMap);
        config.setServiceName(commandLineOption != null ? commandLineOption.getOptionValue() : null);
        commandLineOption = CFCodegenConfigLoader.loadOption("r", "repository-path", optionMap);
        config.setRepositoryPath(commandLineOption != null ? commandLineOption.getOptionValue() : null);
        config.setServerSideInterface(CFCodegenConfigLoader.loadOption("ssi", "serverside-interface", optionMap) != null);
        config.setGenerateAll(CFCodegenConfigLoader.loadOption("g", "generate-all", optionMap) != null);
        commandLineOption = CFCodegenConfigLoader.loadOption("em", "external-mapping", optionMap);
        if (commandLineOption != null) {
            try {
                config.setTypeMappingFile(new File(commandLineOption.getOptionValue()));
            }
            catch (Exception e) {
                throw new RuntimeException(CodegenMessages.getMessage((String)"options.nomappingFile"), e);
            }
        }
        if ((commandLineOption = CFCodegenConfigLoader.loadOption("ns2p", "namespace2package", optionMap)) != null && (value = commandLineOption.getOptionValue()) != null) {
            if (value.indexOf(61) != -1) {
                String[] valuepairs = value.split(",");
                if (valuepairs.length > 0) {
                    map = new HashMap<String, String>(valuepairs.length);
                    for (int i = 0; i < valuepairs.length; ++i) {
                        String[] values = valuepairs[i].split("=");
                        if (values.length != 2) continue;
                        map.put(values[0], values[1]);
                    }
                    config.setUri2PackageNameMap(map);
                }
            } else {
                try {
                    Properties p = new Properties();
                    p.load(new FileInputStream(value));
                    map = new HashMap();
                    for (Map.Entry<Object, Object> entry : p.entrySet()) {
                        map.put((String)entry.getKey(), (String)entry.getValue());
                    }
                    config.setUri2PackageNameMap(map);
                }
                catch (IOException e) {
                    throw new RuntimeException(CodegenMessages.getMessage((String)"options.noFile", (String)value), e);
                }
            }
        }
        if ((commandLineOption = CFCodegenConfigLoader.loadOption("uw", "unwrap-params", optionMap)) != null) {
            config.setParametersWrapped(false);
        }
        if ((commandLineOption = CFCodegenConfigLoader.loadOption("wv", "wsdl-version", optionMap)) != null && ("2.0".equals(optionValue = commandLineOption.getOptionValue()) || "2".equals(optionValue))) {
            config.setWSDLVersion("2.0");
        }
        config.setFlattenFiles(CFCodegenConfigLoader.loadOption("f", "flatten-files", optionMap) != null);
        commandLineOption = CFCodegenConfigLoader.loadOption("b", "backword-compatible", optionMap);
        if (commandLineOption != null) {
            config.setBackwordCompatibilityMode(true);
        }
        if ((commandLineOption = CFCodegenConfigLoader.loadOption("sp", "suppress-prefixes", optionMap)) != null) {
            config.setSuppressPrefixesMode(true);
        }
        if ((commandLineOption = CFCodegenConfigLoader.loadOption("xc", "xsdconfig", optionMap)) != null) {
            config.getProperties().put("xc", commandLineOption.getOptionValue());
        }
        if ((commandLineOption = CFCodegenConfigLoader.loadOption(null, "http-proxy-host", optionMap)) != null) {
            System.setProperty("http.proxyHost", commandLineOption.getOptionValue());
        }
        if ((commandLineOption = CFCodegenConfigLoader.loadOption(null, "http-proxy-port", optionMap)) != null) {
            System.setProperty("http.proxyPort", commandLineOption.getOptionValue());
        }
        if ((commandLineOption = CFCodegenConfigLoader.loadOption("ep", "exclude-packages", optionMap)) != null) {
            config.setExcludeProperties(commandLineOption.getOptionValue());
        }
        if ((commandLineOption = CFCodegenConfigLoader.loadOption("sin", "skelton-interface-name", optionMap)) != null) {
            config.setSkeltonInterfaceName(commandLineOption.getOptionValue());
        }
        if ((commandLineOption = CFCodegenConfigLoader.loadOption("scn", "skelton-class-name", optionMap)) != null) {
            config.setSkeltonClassName(commandLineOption.getOptionValue());
        }
        if ((commandLineOption = CFCodegenConfigLoader.loadOption("ebc", "exception-base-class", optionMap)) != null) {
            config.setExceptionBaseClassName(commandLineOption.getOptionValue());
        }
        config.setAllPorts(CFCodegenConfigLoader.loadOption("ap", "all-ports", optionMap) != null);
        config.setOverride(CFCodegenConfigLoader.loadOption("or", "over-ride", optionMap) != null);
        config.setOverrideAbsoluteAddress(CFCodegenConfigLoader.loadOption("oaa", "override-absolute-address", optionMap) != null);
        config.setUseOperationName(CFCodegenConfigLoader.loadOption("uon", "use-operation-name", optionMap) != null);
        for (Map.Entry<String, CommandLineOption> entry : optionMap.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith("E")) continue;
            config.getProperties().put(key.replaceFirst("E", ""), entry.getValue().getOptionValue());
        }
    }

    private static CommandLineOption loadOption(String shortOption, String longOption, Map<String, CommandLineOption> options) {
        CommandLineOption option = null;
        if (longOption != null && (option = options.get(longOption)) != null) {
            return option;
        }
        if (shortOption != null) {
            option = options.get(shortOption);
        }
        return option;
    }
}

