/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.slbase;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import macromedia.jdbc.slbase.BaseCharStreamOnFileChunk;
import macromedia.jdbc.slbase.BaseColumn;
import macromedia.jdbc.slbase.BaseConnection;
import macromedia.jdbc.slbase.BaseData;
import macromedia.jdbc.slbase.BaseImplBlob;
import macromedia.jdbc.slbase.BaseImplClob;
import macromedia.jdbc.slbase.BaseImplResultSetService;
import macromedia.jdbc.slbase.BaseInputStreamOnFileChunk;
import macromedia.slutil.UtilException;
import macromedia.slutil.UtilPagedTempBuffer;
import macromedia.slutil.UtilTempFile;

public final class BaseImplResultSetClientSideInsensitive
extends BaseImplResultSetService {
    boolean tempFilesAreReady = false;
    protected File longDataFileHandle;
    private RandomAccessFile longDataFile;
    UtilPagedTempBuffer rowDataBuff;
    UtilPagedTempBuffer rowPositionBuff;
    private int rowsFetchedFromSubResultSet = 0;
    private BaseData[] rowData;
    private boolean endOfResultSetReached = false;
    private int maxLongDataSize;
    byte[] byteArrayForReading;
    static int DEFAULT_BUFF_INCREMENT = 1024;
    int maxMem;
    BaseConnection connection;

    public BaseImplResultSetClientSideInsensitive(int n2, BaseConnection baseConnection) {
        if (n2 == 0) {
            n2 = 0x200000;
        }
        this.maxMem = n2;
        this.connection = baseConnection;
        this.rowDataBuff = new UtilPagedTempBuffer(n2);
        this.rowPositionBuff = new UtilPagedTempBuffer(16);
        this.byteArrayForReading = new byte[DEFAULT_BUFF_INCREMENT];
    }

    public BaseImplResultSetClientSideInsensitive(BaseConnection baseConnection) {
        this(2048, baseConnection);
    }

    public void postSetupInitialize() throws SQLException {
        this.tempFilesAreReady = false;
        super.postSetupInitialize();
        this.fetchAtPosition(1);
    }

    void setMaxLongDataFieldCacheSize(int n2) {
        this.maxLongDataSize = n2;
    }

    private void setupTempFiles() throws SQLException {
        if (this.tempFilesAreReady) {
            return;
        }
        try {
            this.longDataFileHandle = UtilTempFile.createTempFile("scb_");
            try {
                this.longDataFile = (RandomAccessFile)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return new RandomAccessFile(BaseImplResultSetClientSideInsensitive.this.longDataFileHandle, "rw");
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (IOException)privilegedActionException.getException();
            }
            this.tempFilesAreReady = true;
        }
        catch (IOException iOException) {
            SQLException sQLException = this.implStatement.implConnection.exceptions.getException(iOException);
            throw this.implStatement.implConnection.exceptions.getException(sQLException, 6038, "TMPDIR");
        }
    }

    public void close() throws SQLException {
        super.close();
        try {
            this.rowDataBuff.truncate();
            this.rowPositionBuff.truncate();
            this.longDataFile.close();
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    BaseImplResultSetClientSideInsensitive.this.longDataFileHandle.delete();
                    return null;
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getScrollType() {
        return 1004;
    }

    public int getColumnAccess() {
        return 2;
    }

    public boolean fetchAtPosition(int n2) throws SQLException {
        boolean bl2 = this.fetch(n2);
        if (bl2) {
            this.fetch(n2 + 1);
        }
        if (bl2) {
            bl2 = n2 > this.rowsFetchedFromSubResultSet ? false : this.getCachedRow(n2 - 1);
        }
        return bl2;
    }

    private boolean fetch(int n2) throws SQLException {
        boolean bl2 = true;
        if (n2 > this.rowsFetchedFromSubResultSet) {
            bl2 = this.fetchAndCache(n2 - this.rowsFetchedFromSubResultSet, false, 0);
        }
        return bl2;
    }

    boolean fetchAndCache(int n2, boolean bl2, int n3) throws SQLException {
        boolean bl3 = true;
        for (int i2 = 0; bl3 && i2 < n2; ++i2) {
            if (this.endOfResultSetReached) {
                bl3 = false;
            } else if (!bl2) {
                bl3 = this.subImplResultSet.next();
            }
            if (bl3) {
                ++this.rowsFetchedFromSubResultSet;
                this.cacheCurrentRow(n3);
                bl2 = false;
                n3 = 0;
                continue;
            }
            this.endOfResultSetReached = true;
            this.maxCursorPosition = this.rowsFetchedFromSubResultSet;
        }
        return bl3;
    }

    void cacheCurrentRow(int n2) throws SQLException {
        try {
            this.rowPositionBuff.writeLong(this.rowDataBuff.getSize());
            for (int i2 = n2; i2 < this.columns.count(0); ++i2) {
                BaseColumn baseColumn = this.columns.get(i2 + 1);
                BaseData baseData = this.subImplResultSet.getData(i2 + 1, baseColumn.baseDataType);
                if (baseData.isNull()) {
                    this.rowDataBuff.writeInt(baseData.getType());
                    this.rowDataBuff.writeInt(-1);
                    continue;
                }
                if (baseData.getType() == 2 || baseData.getType() > 100 && baseData.getType() < 200) {
                    byte[] byArray = baseData.getBytesNoConvert();
                    this.rowDataBuff.writeInt(baseData.getType());
                    this.rowDataBuff.writeInt(byArray.length);
                    this.rowDataBuff.write(this.rowDataBuff.getSize(), byArray);
                    if (baseData.getType() == 110) {
                        this.rowDataBuff.writeInt(baseData.getOracleTZScale());
                        this.rowDataBuff.writeInt(baseData.getOracleFetchTSWTZasTimestamp() ? 1 : 0);
                        continue;
                    }
                    if (baseData.getType() != 111) continue;
                    this.rowDataBuff.writeInt(baseData.getOracleTZHours());
                    this.rowDataBuff.writeInt(baseData.getOracleTZMinutes());
                    continue;
                }
                if (baseData.getType() == 15 || baseData.getType() == 14) {
                    this.cacheBinaryStream(baseData.getType(), (InputStream)baseData.getObject());
                    continue;
                }
                if (baseData.getType() == 19) {
                    this.cacheBlob((BaseImplBlob)baseData.getObject());
                    continue;
                }
                if (baseData.getType() == 18 || baseData.getType() == 17 || baseData.getType() == 16) {
                    this.cacheCharacterStream(18, (Reader)baseData.getObject());
                    continue;
                }
                if (baseData.getType() == 20) {
                    this.cacheClob((BaseImplClob)baseData.getObject());
                    continue;
                }
                this.rowDataBuff.writeInt(baseData.getType());
                String string = baseData.getString(-1, this.implStatement.implConnection.exceptions);
                int n3 = string.length();
                this.rowDataBuff.writeInt(n3 * 2);
                int n4 = 0;
                while (n4 < n3) {
                    this.rowDataBuff.write(this.rowDataBuff.getSize(), (byte)(string.charAt(n4) >>> 8 & 0xFF));
                    this.rowDataBuff.write(this.rowDataBuff.getSize(), (byte)(string.charAt(n4++) >>> 0 & 0xFF));
                }
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            SQLException sQLException = this.implStatement.implConnection.exceptions.getException(exception);
            throw this.implStatement.implConnection.exceptions.getException(sQLException, 6039, "TMPDIR");
        }
    }

    private void cacheBinaryStream(int n2, InputStream inputStream) throws SQLException, IOException, UtilException {
        this.setupTempFiles();
        this.rowDataBuff.writeInt(n2);
        this.rowDataBuff.writeLong(this.longDataFile.length());
        long l2 = 0L;
        this.longDataFile.seek(this.longDataFile.length());
        int n3 = this.maxLongDataSize != 0 ? this.maxLongDataSize : 1024;
        byte[] byArray = new byte[n3];
        int n4 = inputStream.read(byArray, 0, n3);
        while (n4 != -1) {
            this.longDataFile.write(byArray, 0, n4);
            l2 += (long)n4;
            if (this.maxLongDataSize != 0) {
                if (n4 >= n3) break;
                n3 = this.maxLongDataSize - (int)l2;
            }
            n4 = inputStream.read(byArray, 0, n3);
        }
        this.rowDataBuff.writeLong(l2);
    }

    private void cacheCharacterStream(int n2, Reader reader) throws SQLException, IOException, UtilException {
        this.setupTempFiles();
        this.rowDataBuff.writeInt(n2);
        this.rowDataBuff.writeLong(this.longDataFile.length());
        long l2 = 0L;
        this.longDataFile.seek(this.longDataFile.length());
        int n3 = this.maxLongDataSize != 0 ? this.maxLongDataSize : 1024;
        char[] cArray = new char[n3];
        int n4 = reader.read(cArray, 0, n3);
        while (n4 != -1) {
            for (int i2 = 0; i2 < n4; ++i2) {
                this.longDataFile.writeChar(cArray[i2]);
            }
            l2 += (long)(n4 * 2);
            if (this.maxLongDataSize != 0) {
                if (n4 >= n3) break;
                n3 = this.maxLongDataSize - (int)(l2 / 2L);
            }
            n4 = reader.read(cArray, 0, n3);
        }
        this.rowDataBuff.writeLong(l2);
    }

    private void cacheBlob(BaseImplBlob baseImplBlob) throws SQLException, IOException, UtilException {
        this.setupTempFiles();
        this.rowDataBuff.writeInt(19);
        this.rowDataBuff.writeLong(this.longDataFile.length());
        this.longDataFile.seek(this.longDataFile.length());
        this.subImplResultSet.writeBlob(this.longDataFile, baseImplBlob);
    }

    private void cacheClob(BaseImplClob baseImplClob) throws SQLException, IOException, UtilException {
        this.setupTempFiles();
        this.rowDataBuff.writeInt(20);
        this.rowDataBuff.writeLong(this.longDataFile.length());
        this.longDataFile.seek(this.longDataFile.length());
        this.subImplResultSet.writeClob(this.longDataFile, baseImplClob);
    }

    boolean getCachedRow(int n2) throws SQLException {
        boolean bl2 = false;
        try {
            long l2 = n2 * 8;
            long l3 = this.rowPositionBuff.readLong((int)l2);
            this.intializeRow();
            StringBuffer stringBuffer = new StringBuffer();
            block15: for (int i2 = 0; i2 < this.columns.count(0); ++i2) {
                int n3;
                int n4;
                int n5 = this.rowDataBuff.readInt(l3);
                int n6 = this.rowDataBuff.readInt(l3 += 4L);
                if (n6 == -1) {
                    l3 += 4L;
                    this.rowData[i2].setNull(n5);
                    continue;
                }
                if (n5 == 2) {
                    this.rowData[i2].setBytes(this.rowDataBuff.read(l3 += 4L, n6));
                    l3 += (long)n6;
                    continue;
                }
                if (n5 > 100 && n5 < 200) {
                    byte[] byArray = this.rowDataBuff.read(l3 += 4L, n6);
                    l3 += (long)n6;
                    if (n5 == 110) {
                        n4 = this.rowDataBuff.readInt(l3);
                        n3 = this.rowDataBuff.readInt(l3 += 4L) == 1 ? 1 : 0;
                        l3 += 4L;
                        this.rowData[i2].setNativeOracleTimestampWithTimeZone(byArray, byArray.length, n4, n3 != 0);
                        continue;
                    }
                    if (n5 == 111) {
                        n4 = this.rowDataBuff.readInt(l3);
                        n3 = this.rowDataBuff.readInt(l3 += 4L);
                        l3 += 4L;
                        this.rowData[i2].setNativeOracleTimestampWithLocalTimeZone(byArray, byArray.length, n4, n3);
                        continue;
                    }
                    this.rowData[i2].setNativeBytes(byArray, n6, n5);
                    continue;
                }
                if (n5 == 15 || n5 == 14) {
                    this.getCachedBinaryStream(n5, l3, this.rowData[i2]);
                    l3 += 16L;
                    continue;
                }
                if (n5 == 18) {
                    this.getCachedCharStream(n5, l3, this.rowData[i2]);
                    l3 += 16L;
                    continue;
                }
                if (n5 == 19) {
                    this.getCachedBlob(this.rowDataBuff.readLong(l3), this.rowData[i2]);
                    l3 += 8L;
                    continue;
                }
                if (n5 == 20) {
                    this.getCachedClob(this.rowDataBuff.readLong(l3), this.rowData[i2]);
                    l3 += 8L;
                    continue;
                }
                l3 += 4L;
                stringBuffer.setLength(0);
                char c2 = '\u0000';
                int n7 = 0;
                while (n7 < n6) {
                    n4 = this.rowDataBuff.read(l3 + (long)n7++);
                    n3 = this.rowDataBuff.read(l3 + (long)n7++);
                    c2 = (char)(((n4 & 0xFF) << 8) + ((n3 & 0xFF) << 0));
                    stringBuffer.append(c2);
                }
                l3 += (long)n6;
                if (n5 > 200) {
                    this.rowData[i2].setNativeString(stringBuffer.toString(), n5);
                } else {
                    this.rowData[i2].setString(stringBuffer.toString());
                }
                switch (n5) {
                    case 1: {
                        this.rowData[i2].setByte(this.rowData[i2].getByte(this.implStatement.implConnection.exceptions));
                        continue block15;
                    }
                    case 3: {
                        this.rowData[i2].setShort(this.rowData[i2].getShort(this.implStatement.implConnection.exceptions));
                        continue block15;
                    }
                    case 4: {
                        this.rowData[i2].setInteger(this.rowData[i2].getInteger(this.implStatement.implConnection.exceptions));
                        continue block15;
                    }
                    case 5: {
                        this.rowData[i2].setLong(this.rowData[i2].getLong(this.implStatement.implConnection.exceptions));
                        continue block15;
                    }
                    case 6: {
                        this.rowData[i2].setFloat(this.rowData[i2].getFloat(this.implStatement.implConnection.exceptions));
                        continue block15;
                    }
                    case 7: {
                        this.rowData[i2].setDouble(this.rowData[i2].getDouble(this.implStatement.implConnection.exceptions));
                        continue block15;
                    }
                    case 8: 
                    case 21: {
                        this.rowData[i2].setBigDecimal(this.rowData[i2].getBigDecimal(this.implStatement.implConnection.exceptions));
                        continue block15;
                    }
                    case 9: {
                        this.rowData[i2].setBoolean(this.rowData[i2].getBoolean(this.implStatement.implConnection.exceptions));
                        continue block15;
                    }
                    case 11: {
                        this.rowData[i2].setDate(this.rowData[i2].getDate(this.implStatement.implConnection.exceptions));
                        continue block15;
                    }
                    case 12: {
                        this.rowData[i2].setTime(this.rowData[i2].getTime(this.implStatement.implConnection.exceptions));
                        continue block15;
                    }
                    case 13: {
                        this.rowData[i2].setTimestamp(this.rowData[i2].getTimestamp(this.implStatement.implConnection.exceptions));
                    }
                }
            }
            bl2 = true;
        }
        catch (Exception exception) {
            SQLException sQLException = this.implStatement.implConnection.exceptions.getException(exception);
            throw this.implStatement.implConnection.exceptions.getException(sQLException, 6040);
        }
        return bl2;
    }

    private void getCachedBinaryStream(int n2, long l2, BaseData baseData) throws IOException, UtilException {
        long l3 = this.rowDataBuff.readLong(l2);
        long l4 = this.rowDataBuff.readLong(l2 + 8L);
        BaseInputStreamOnFileChunk baseInputStreamOnFileChunk = new BaseInputStreamOnFileChunk(this.longDataFile, l3, l4);
        baseData.setData(n2, baseInputStreamOnFileChunk);
    }

    private void getCachedCharStream(int n2, long l2, BaseData baseData) throws IOException, UtilException {
        long l3 = this.rowDataBuff.readLong(l2);
        long l4 = this.rowDataBuff.readLong(l2 + 8L);
        BaseCharStreamOnFileChunk baseCharStreamOnFileChunk = new BaseCharStreamOnFileChunk(this.longDataFile, l3, l4);
        baseData.setData(n2, baseCharStreamOnFileChunk);
    }

    private void getCachedBlob(long l2, BaseData baseData) throws SQLException, IOException {
        this.longDataFile.seek(l2);
        baseData.setBlob(this.subImplResultSet.readBlob(this.longDataFile));
    }

    private void getCachedClob(long l2, BaseData baseData) throws SQLException, IOException {
        this.longDataFile.seek(l2);
        baseData.setClob(this.subImplResultSet.readClob(this.longDataFile));
    }

    private void intializeRow() {
        if (this.rowData == null) {
            this.rowData = new BaseData[this.columns.count(0)];
            for (int i2 = 0; i2 < this.columns.count(0); ++i2) {
                BaseColumn baseColumn = this.columns.get(i2 + 1);
                this.rowData[i2] = new BaseData(this.connection);
            }
        }
    }

    public BaseData getData(int n2, int n3) throws SQLException {
        BaseData baseData = this.rowData[n2 - 1];
        Object object = baseData.getObject();
        if (object instanceof BaseInputStreamOnFileChunk) {
            BaseInputStreamOnFileChunk baseInputStreamOnFileChunk = (BaseInputStreamOnFileChunk)object;
            baseData.setData(baseData.getType(), new BaseInputStreamOnFileChunk(baseInputStreamOnFileChunk.file, baseInputStreamOnFileChunk.offset, baseInputStreamOnFileChunk.length));
        } else if (object instanceof BaseCharStreamOnFileChunk) {
            BaseCharStreamOnFileChunk baseCharStreamOnFileChunk = (BaseCharStreamOnFileChunk)object;
            baseData.setData(baseData.getType(), new BaseCharStreamOnFileChunk(baseCharStreamOnFileChunk.file, baseCharStreamOnFileChunk.offset, baseCharStreamOnFileChunk.length));
        }
        return baseData;
    }

    protected boolean setupForNextResultSetInMultipleResult(int n2) throws SQLException {
        boolean bl2 = this.rowDataBuff == null;
        boolean bl3 = n2 == -1;
        boolean bl4 = false;
        if (n2 == -1) {
            n2 = 0;
        }
        if (bl2) {
            this.tempFilesAreReady = false;
            if (!bl3) {
                bl4 = true;
            }
        }
        this.fetchAndCache(Integer.MAX_VALUE, bl4, n2);
        if (bl2 && !bl3) {
            this.getCachedRow(0);
            this.cursorPosition = 1;
        }
        return true;
    }
}

