/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sequelink;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.sql.SQLException;
import macromedia.jdbc.sequelink.SequeLinkImplBlob;
import macromedia.jdbc.sequelink.SequeLinkImplClob;
import macromedia.jdbc.sequelink.SequeLinkImplConnection;
import macromedia.jdbc.sequelink.SequeLinkImplStatement;
import macromedia.jdbc.slbase.BaseData;
import macromedia.jdbc.slbase.BaseImplBlob;
import macromedia.jdbc.slbase.BaseImplClob;
import macromedia.jdbc.slbase.BaseImplResultSet;
import macromedia.sequelink.ssp.DiagnosticList;
import macromedia.slutil.UtilTransliterator;

public final class SequeLinkImplResultSet
extends BaseImplResultSet {
    private SequeLinkImplStatement implStmt;
    private int row;
    private boolean alreadyFalse;
    private boolean alreadyClosed;

    SequeLinkImplResultSet(SequeLinkImplStatement sequeLinkImplStatement) {
        this.implStmt = sequeLinkImplStatement;
    }

    public BaseData getData(int n2, int n3) throws SQLException {
        return this.implStmt.getData(n2, n3);
    }

    public boolean fetchAtPosition(int n2) throws SQLException {
        if (this.alreadyFalse) {
            throw new InternalError(this.getClass().getName() + " positionCursor - already end of resultset");
        }
        if (n2 != this.row + 1) {
            throw new InternalError(this.getClass().getName() + " positionCursor - not forward only behavior");
        }
        boolean bl2 = this.implStmt.fetchRow();
        if (bl2) {
            ++this.row;
        } else {
            this.alreadyFalse = true;
        }
        return bl2;
    }

    public void close() throws SQLException {
        if (this.alreadyClosed) {
            return;
        }
        this.alreadyClosed = true;
        this.implStmt.closeCursor();
    }

    public int getColumnAccess() {
        return 2;
    }

    private SequeLinkImplConnection getImplConnection() {
        return this.implStmt.getImplConnection();
    }

    private int getLobLocatorSize(SequeLinkImplConnection sequeLinkImplConnection) throws SQLException {
        return sequeLinkImplConnection.conCtxt.getPidList().getPidInt(11406, DiagnosticList.GetADummyList());
    }

    private UtilTransliterator getTransliterator(SequeLinkImplConnection sequeLinkImplConnection, String string) throws SQLException {
        return sequeLinkImplConnection.conCtxt.getSsp().getTransliterator(string);
    }

    public void writeBlob(RandomAccessFile randomAccessFile, BaseImplBlob baseImplBlob) throws SQLException, IOException {
        SequeLinkImplBlob sequeLinkImplBlob = (SequeLinkImplBlob)baseImplBlob;
        randomAccessFile.write(sequeLinkImplBlob.getLocator());
    }

    public BaseImplBlob readBlob(RandomAccessFile randomAccessFile) throws SQLException, IOException {
        SequeLinkImplConnection sequeLinkImplConnection = this.getImplConnection();
        int n2 = this.getLobLocatorSize(sequeLinkImplConnection);
        byte[] byArray = new byte[n2];
        randomAccessFile.read(byArray);
        return new SequeLinkImplBlob(sequeLinkImplConnection, byArray);
    }

    public void writeClob(RandomAccessFile randomAccessFile, BaseImplClob baseImplClob) throws SQLException, IOException {
        SequeLinkImplClob sequeLinkImplClob = (SequeLinkImplClob)baseImplClob;
        randomAccessFile.write(sequeLinkImplClob.getLocator());
        randomAccessFile.writeUTF(sequeLinkImplClob.getEncoding());
    }

    public BaseImplClob readClob(RandomAccessFile randomAccessFile) throws SQLException, IOException {
        SequeLinkImplConnection sequeLinkImplConnection = this.getImplConnection();
        int n2 = this.getLobLocatorSize(sequeLinkImplConnection);
        byte[] byArray = new byte[n2];
        randomAccessFile.read(byArray);
        String string = randomAccessFile.readUTF();
        UtilTransliterator utilTransliterator = this.getTransliterator(sequeLinkImplConnection, string);
        return new SequeLinkImplClob(sequeLinkImplConnection, byArray, string, utilTransliterator);
    }
}

