/*
 * Decompiled with CFR 0.152.
 */
package macromedia.sequelink.net;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import macromedia.sequelink.net.IIOP;
import macromedia.sequelink.net.NetByteOrder;
import macromedia.sequelink.net.NetworkException;
import macromedia.sequelink.util.OutputStreamOnByteArray;

public final class IIOPString {
    private byte[] javaString;
    private byte[] iiopString;

    IIOPString(byte[] byArray, boolean bl2) throws NetworkException {
        this.javaString = byArray;
        this.encodeString(bl2);
    }

    IIOPString(DataInputStream dataInputStream, boolean bl2) throws NetworkException {
        this.decodeString(dataInputStream, bl2);
        this.encodeString(bl2);
    }

    public byte[] getJavaString() {
        return this.javaString;
    }

    public byte[] getIIOPString() {
        return this.iiopString;
    }

    public static int getLengthIIOPString(byte[] byArray) {
        return IIOPString.lengthString(byArray.length);
    }

    private static int lengthString(int n2) {
        return 4 + n2 + 1;
    }

    private void encodeString(boolean bl2) throws NetworkException {
        int n2 = this.javaString.length;
        int n3 = IIOPString.lengthString(n2);
        this.iiopString = new byte[n3];
        OutputStreamOnByteArray outputStreamOnByteArray = new OutputStreamOnByteArray(this.iiopString);
        DataOutputStream dataOutputStream = new DataOutputStream(outputStreamOnByteArray);
        int n4 = NetByteOrder.htonl(n2 + 1, bl2);
        try {
            dataOutputStream.writeInt(n4);
            outputStreamOnByteArray.write(this.javaString, 0, n2);
            outputStreamOnByteArray.write(0);
        }
        catch (IOException iOException) {
            throw IIOP.getException(7531, iOException.getMessage());
        }
    }

    private void decodeString(DataInputStream dataInputStream, boolean bl2) throws NetworkException {
        try {
            int n2 = dataInputStream.readInt();
            int n3 = NetByteOrder.htonl(n2, bl2);
            this.javaString = new byte[n3];
            dataInputStream.readFully(this.javaString, 0, n3);
        }
        catch (IOException iOException) {
            throw IIOP.getException(7531, iOException.getMessage());
        }
    }
}

