/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.slbase;

import java.io.Reader;
import java.sql.SQLException;
import macromedia.jdbc.slbase.BaseExceptions;
import macromedia.jdbc.slbase.BaseImplClob;
import macromedia.slutil.UtilException;
import macromedia.slutil.UtilPagedTempBuffer;

public class BaseImplClobEmulated
extends BaseImplClob {
    private UtilPagedTempBuffer clobData;
    private boolean byteSwapped = false;

    public BaseImplClobEmulated(BaseExceptions baseExceptions, UtilPagedTempBuffer utilPagedTempBuffer, boolean bl2) throws SQLException {
        super(baseExceptions);
        this.clobData = utilPagedTempBuffer;
        this.byteSwapped = bl2;
    }

    public BaseImplClobEmulated(BaseExceptions baseExceptions, Reader reader) throws SQLException {
        super(baseExceptions);
        try {
            this.clobData = new UtilPagedTempBuffer(2, 16);
            int n2 = 1024;
            char[] cArray = new char[n2];
            byte[] byArray = new byte[n2 * 2];
            int n3 = reader.read(cArray);
            long l2 = 0L;
            while (n3 != -1) {
                int n4 = 0;
                int n5 = 0;
                while (n5 < n3) {
                    byArray[n4++] = (byte)(cArray[n5] >>> 8 & 0xFF);
                    byArray[n4++] = (byte)(cArray[n5++] >>> 0 & 0xFF);
                }
                this.clobData.write(l2, byArray, 0, n4);
                l2 += (long)n4;
                n3 = reader.read(cArray);
            }
        }
        catch (Exception exception) {
            throw baseExceptions.getException(exception);
        }
    }

    public boolean supportsSearch() {
        return true;
    }

    public long find(String string, long l2) throws SQLException {
        long l3 = this.getLength() * 2L;
        long l4 = (l2 - 1L) * 2L;
        long l5 = string.length();
        long l6 = 0L;
        byte[] byArray = new byte[2];
        long l7 = l4;
        try {
            while (l6 < l5) {
                byte by2;
                if (l4 == l3) {
                    return -1L;
                }
                char c2 = string.charAt((int)l6++);
                this.clobData.read(l4, byArray, 0, 2);
                if (this.byteSwapped) {
                    by2 = byArray[0];
                    byArray[0] = byArray[1];
                    byArray[1] = by2;
                }
                l4 += 2L;
                char c3 = (char)(((byArray[0] & 0xFF) << 8) + ((byArray[1] & 0xFF) << 0));
                if (c2 == c3) continue;
                l6 = 0L;
                c2 = string.charAt((int)l6++);
                l4 = l7 + 2L;
                do {
                    if (l4 >= l3) {
                        return -1L;
                    }
                    this.clobData.read(l4, byArray, 0, 2);
                    if (this.byteSwapped) {
                        by2 = byArray[0];
                        byArray[0] = byArray[1];
                        byArray[1] = by2;
                    }
                    l4 += 2L;
                } while (c2 != (c3 = (char)(((byArray[0] & 0xFF) << 8) + ((byArray[1] & 0xFF) << 0))));
                l7 = l4 - 2L;
            }
        }
        catch (Exception exception) {
            throw this.exceptions.getException(exception);
        }
        return l7 / 2L + 1L;
    }

    public int readData(byte[] byArray, int n2, long l2, int n3) throws SQLException {
        try {
            int n4 = this.clobData.read((l2 - 1L) * 2L, byArray, n2, n3 * 2);
            if (this.byteSwapped) {
                for (int i2 = 0; i2 < n4; i2 += 2) {
                    byte by2 = byArray[n2 + i2];
                    byArray[n2 + i2] = byArray[n2 + i2 + 1];
                    byArray[n2 + i2 + 1] = by2;
                }
            }
            return n4;
        }
        catch (Exception exception) {
            throw this.exceptions.getException(exception);
        }
    }

    public int writeData(long l2, byte[] byArray, int n2, int n3) throws SQLException {
        try {
            if (this.byteSwapped) {
                int n4;
                int n5 = n3 * 2;
                for (n4 = 0; n4 < n5; n4 += 2) {
                    this.clobData.write((l2 - 1L) * 2L + (long)n4, byArray, n2 + n4 + 1, 1);
                    this.clobData.write((l2 - 1L) * 2L + (long)n4 + 1L, byArray, n2 + n4, 1);
                }
                return n4 / 2;
            }
            return this.clobData.write((l2 - 1L) * 2L, byArray, n2, n3 * 2) / 2;
        }
        catch (UtilException utilException) {
            throw this.exceptions.getException(utilException);
        }
    }

    public void truncate(long l2) throws SQLException {
        try {
            this.clobData.truncate(l2 * 2L);
        }
        catch (UtilException utilException) {
            throw this.exceptions.getException(utilException);
        }
    }

    public long getLength() throws SQLException {
        return this.clobData.getSize() / 2L;
    }

    public int getCharacterEncoding() {
        return 2;
    }

    public void close() throws SQLException {
        try {
            this.clobData.truncate(true);
        }
        catch (UtilException utilException) {
            throw this.exceptions.getException(utilException);
        }
    }
}

