/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Grego;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.AnnualTimeZoneRule;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.BasicTimeZone;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.DateTimeRule;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.InitialTimeZoneRule;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.RuleBasedTimeZone;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.TimeArrayTimeZoneRule;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.TimeZone;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.TimeZoneRule;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.TimeZoneTransition;

public class VTimeZone
extends BasicTimeZone {
    private static final long serialVersionUID = -6851467294127795902L;
    private BasicTimeZone tz;
    private List<String> vtzlines;
    private String olsonzid = null;
    private String tzurl = null;
    private Date lastmod = null;
    private static String ICU_TZVERSION;
    private static final String ICU_TZINFO_PROP = "X-TZINFO";
    private static final int DEF_DSTSAVINGS = 3600000;
    private static final long DEF_TZSTARTTIME = 0L;
    private static final long MIN_TIME = Long.MIN_VALUE;
    private static final long MAX_TIME = Long.MAX_VALUE;
    private static final String COLON = ":";
    private static final String SEMICOLON = ";";
    private static final String EQUALS_SIGN = "=";
    private static final String COMMA = ",";
    private static final String NEWLINE = "\r\n";
    private static final String ICAL_BEGIN_VTIMEZONE = "BEGIN:VTIMEZONE";
    private static final String ICAL_END_VTIMEZONE = "END:VTIMEZONE";
    private static final String ICAL_BEGIN = "BEGIN";
    private static final String ICAL_END = "END";
    private static final String ICAL_VTIMEZONE = "VTIMEZONE";
    private static final String ICAL_TZID = "TZID";
    private static final String ICAL_STANDARD = "STANDARD";
    private static final String ICAL_DAYLIGHT = "DAYLIGHT";
    private static final String ICAL_DTSTART = "DTSTART";
    private static final String ICAL_TZOFFSETFROM = "TZOFFSETFROM";
    private static final String ICAL_TZOFFSETTO = "TZOFFSETTO";
    private static final String ICAL_RDATE = "RDATE";
    private static final String ICAL_RRULE = "RRULE";
    private static final String ICAL_TZNAME = "TZNAME";
    private static final String ICAL_TZURL = "TZURL";
    private static final String ICAL_LASTMOD = "LAST-MODIFIED";
    private static final String ICAL_FREQ = "FREQ";
    private static final String ICAL_UNTIL = "UNTIL";
    private static final String ICAL_YEARLY = "YEARLY";
    private static final String ICAL_BYMONTH = "BYMONTH";
    private static final String ICAL_BYDAY = "BYDAY";
    private static final String ICAL_BYMONTHDAY = "BYMONTHDAY";
    private static final String[] ICAL_DOW_NAMES;
    private static final int[] MONTHLENGTH;
    private static final int INI = 0;
    private static final int VTZ = 1;
    private static final int TZI = 2;
    private static final int ERR = 3;
    private volatile transient boolean isFrozen = false;

    public static VTimeZone create(String string) {
        BasicTimeZone basicTimeZone = TimeZone.getFrozenICUTimeZone(string, true);
        if (basicTimeZone == null) {
            return null;
        }
        VTimeZone vTimeZone = new VTimeZone(string);
        vTimeZone.tz = (BasicTimeZone)basicTimeZone.cloneAsThawed();
        vTimeZone.olsonzid = vTimeZone.tz.getID();
        return vTimeZone;
    }

    public static VTimeZone create(Reader reader) {
        VTimeZone vTimeZone = new VTimeZone();
        if (vTimeZone.load(reader)) {
            return vTimeZone;
        }
        return null;
    }

    @Override
    public int getOffset(int n2, int n3, int n4, int n5, int n6, int n7) {
        return this.tz.getOffset(n2, n3, n4, n5, n6, n7);
    }

    @Override
    public void getOffset(long l2, boolean bl2, int[] nArray) {
        this.tz.getOffset(l2, bl2, nArray);
    }

    @Override
    public void getOffsetFromLocal(long l2, BasicTimeZone.LocalOption localOption, BasicTimeZone.LocalOption localOption2, int[] nArray) {
        this.tz.getOffsetFromLocal(l2, localOption, localOption2, nArray);
    }

    @Override
    public int getRawOffset() {
        return this.tz.getRawOffset();
    }

    @Override
    public boolean inDaylightTime(Date date) {
        return this.tz.inDaylightTime(date);
    }

    @Override
    public void setRawOffset(int n2) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify a frozen VTimeZone instance.");
        }
        this.tz.setRawOffset(n2);
    }

    @Override
    public boolean useDaylightTime() {
        return this.tz.useDaylightTime();
    }

    @Override
    public boolean observesDaylightTime() {
        return this.tz.observesDaylightTime();
    }

    @Override
    public boolean hasSameRules(TimeZone timeZone) {
        if (this == timeZone) {
            return true;
        }
        if (timeZone instanceof VTimeZone) {
            return this.tz.hasSameRules(((VTimeZone)timeZone).tz);
        }
        return this.tz.hasSameRules(timeZone);
    }

    public String getTZURL() {
        return this.tzurl;
    }

    public void setTZURL(String string) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify a frozen VTimeZone instance.");
        }
        this.tzurl = string;
    }

    public Date getLastModified() {
        return this.lastmod;
    }

    public void setLastModified(Date date) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify a frozen VTimeZone instance.");
        }
        this.lastmod = date;
    }

    public void write(Writer writer) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(writer);
        if (this.vtzlines != null) {
            for (String string : this.vtzlines) {
                if (string.startsWith("TZURL:")) {
                    if (this.tzurl == null) continue;
                    bufferedWriter.write(ICAL_TZURL);
                    bufferedWriter.write(COLON);
                    bufferedWriter.write(this.tzurl);
                    bufferedWriter.write(NEWLINE);
                    continue;
                }
                if (string.startsWith("LAST-MODIFIED:")) {
                    if (this.lastmod == null) continue;
                    bufferedWriter.write(ICAL_LASTMOD);
                    bufferedWriter.write(COLON);
                    bufferedWriter.write(VTimeZone.getUTCDateTimeString(this.lastmod.getTime()));
                    bufferedWriter.write(NEWLINE);
                    continue;
                }
                bufferedWriter.write(string);
                bufferedWriter.write(NEWLINE);
            }
            bufferedWriter.flush();
        } else {
            String[] stringArray = null;
            if (this.olsonzid != null && ICU_TZVERSION != null) {
                stringArray = new String[]{"X-TZINFO:" + this.olsonzid + "[" + ICU_TZVERSION + "]"};
            }
            this.writeZone(writer, this.tz, stringArray);
        }
    }

    public void write(Writer writer, long l2) throws IOException {
        TimeZoneRule[] timeZoneRuleArray = this.tz.getTimeZoneRules(l2);
        RuleBasedTimeZone ruleBasedTimeZone = new RuleBasedTimeZone(this.tz.getID(), (InitialTimeZoneRule)timeZoneRuleArray[0]);
        for (int i2 = 1; i2 < timeZoneRuleArray.length; ++i2) {
            ruleBasedTimeZone.addTransitionRule(timeZoneRuleArray[i2]);
        }
        String[] stringArray = null;
        if (this.olsonzid != null && ICU_TZVERSION != null) {
            stringArray = new String[]{"X-TZINFO:" + this.olsonzid + "[" + ICU_TZVERSION + "/Partial@" + l2 + "]"};
        }
        this.writeZone(writer, ruleBasedTimeZone, stringArray);
    }

    public void writeSimple(Writer writer, long l2) throws IOException {
        TimeZoneRule[] timeZoneRuleArray = this.tz.getSimpleTimeZoneRulesNear(l2);
        RuleBasedTimeZone ruleBasedTimeZone = new RuleBasedTimeZone(this.tz.getID(), (InitialTimeZoneRule)timeZoneRuleArray[0]);
        for (int i2 = 1; i2 < timeZoneRuleArray.length; ++i2) {
            ruleBasedTimeZone.addTransitionRule(timeZoneRuleArray[i2]);
        }
        String[] stringArray = null;
        if (this.olsonzid != null && ICU_TZVERSION != null) {
            stringArray = new String[]{"X-TZINFO:" + this.olsonzid + "[" + ICU_TZVERSION + "/Simple@" + l2 + "]"};
        }
        this.writeZone(writer, ruleBasedTimeZone, stringArray);
    }

    @Override
    public TimeZoneTransition getNextTransition(long l2, boolean bl2) {
        return this.tz.getNextTransition(l2, bl2);
    }

    @Override
    public TimeZoneTransition getPreviousTransition(long l2, boolean bl2) {
        return this.tz.getPreviousTransition(l2, bl2);
    }

    @Override
    public boolean hasEquivalentTransitions(TimeZone timeZone, long l2, long l3) {
        if (this == timeZone) {
            return true;
        }
        return this.tz.hasEquivalentTransitions(timeZone, l2, l3);
    }

    @Override
    public TimeZoneRule[] getTimeZoneRules() {
        return this.tz.getTimeZoneRules();
    }

    @Override
    public TimeZoneRule[] getTimeZoneRules(long l2) {
        return this.tz.getTimeZoneRules(l2);
    }

    @Override
    public Object clone() {
        if (this.isFrozen()) {
            return this;
        }
        return this.cloneAsThawed();
    }

    private VTimeZone() {
    }

    private VTimeZone(String string) {
        super(string);
    }

    private boolean load(Reader reader) {
        try {
            this.vtzlines = new LinkedList<String>();
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            StringBuilder stringBuilder = new StringBuilder();
            while (true) {
                int n2;
                if ((n2 = reader.read()) == -1) {
                    if (!bl3 || !stringBuilder.toString().startsWith(ICAL_END_VTIMEZONE)) break;
                    this.vtzlines.add(stringBuilder.toString());
                    bl4 = true;
                    break;
                }
                if (n2 == 13) continue;
                if (bl2) {
                    if (n2 != 9 && n2 != 32) {
                        if (bl3 && stringBuilder.length() > 0) {
                            this.vtzlines.add(stringBuilder.toString());
                        }
                        stringBuilder.setLength(0);
                        if (n2 != 10) {
                            stringBuilder.append((char)n2);
                        }
                    }
                    bl2 = false;
                    continue;
                }
                if (n2 == 10) {
                    bl2 = true;
                    if (bl3) {
                        if (!stringBuilder.toString().startsWith(ICAL_END_VTIMEZONE)) continue;
                        this.vtzlines.add(stringBuilder.toString());
                        bl4 = true;
                        break;
                    }
                    if (!stringBuilder.toString().startsWith(ICAL_BEGIN_VTIMEZONE)) continue;
                    this.vtzlines.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    bl3 = true;
                    bl2 = false;
                    continue;
                }
                stringBuilder.append((char)n2);
            }
            if (!bl4) {
                return false;
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return this.parse();
    }

    private boolean parse() {
        int timeZoneRule3;
        int n2;
        if (this.vtzlines == null || this.vtzlines.size() == 0) {
            return false;
        }
        String string = null;
        int n4 = 0;
        boolean bl2 = false;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        boolean bl3 = false;
        LinkedList<String> linkedList = null;
        ArrayList<TimeZoneRule> arrayList = new ArrayList<TimeZoneRule>();
        int n5 = 0;
        int n6 = 0;
        long l2 = Long.MAX_VALUE;
        for (String object2 : this.vtzlines) {
            n2 = object2.indexOf(COLON);
            if (n2 < 0) continue;
            String n10 = object2.substring(0, n2);
            String i2 = object2.substring(n2 + 1);
            switch (n4) {
                case 0: {
                    if (!n10.equals(ICAL_BEGIN) || !i2.equals(ICAL_VTIMEZONE)) break;
                    n4 = 1;
                    break;
                }
                case 1: {
                    if (n10.equals(ICAL_TZID)) {
                        string = i2;
                        break;
                    }
                    if (n10.equals(ICAL_TZURL)) {
                        this.tzurl = i2;
                        break;
                    }
                    if (n10.equals(ICAL_LASTMOD)) {
                        this.lastmod = new Date(VTimeZone.parseDateTimeString(i2, 0));
                        break;
                    }
                    if (n10.equals(ICAL_BEGIN)) {
                        boolean stringTokenizer = i2.equals(ICAL_DAYLIGHT);
                        if (i2.equals(ICAL_STANDARD) || stringTokenizer) {
                            if (string == null) {
                                n4 = 3;
                                break;
                            }
                            linkedList = null;
                            bl3 = false;
                            string2 = null;
                            string3 = null;
                            string4 = null;
                            bl2 = stringTokenizer;
                            n4 = 2;
                            break;
                        }
                        n4 = 3;
                        break;
                    }
                    if (!n10.equals(ICAL_END)) break;
                    break;
                }
                case 2: {
                    if (n10.equals(ICAL_DTSTART)) {
                        string5 = i2;
                        break;
                    }
                    if (n10.equals(ICAL_TZNAME)) {
                        string4 = i2;
                        break;
                    }
                    if (n10.equals(ICAL_TZOFFSETFROM)) {
                        string2 = i2;
                        break;
                    }
                    if (n10.equals(ICAL_TZOFFSETTO)) {
                        string3 = i2;
                        break;
                    }
                    if (n10.equals(ICAL_RDATE)) {
                        if (bl3) {
                            n4 = 3;
                            break;
                        }
                        if (linkedList == null) {
                            linkedList = new LinkedList<String>();
                        }
                        StringTokenizer timeZoneRule = new StringTokenizer(i2, COMMA);
                        while (timeZoneRule.hasMoreTokens()) {
                            String n7 = timeZoneRule.nextToken();
                            linkedList.add(n7);
                        }
                        break;
                    }
                    if (n10.equals(ICAL_RRULE)) {
                        if (!bl3 && linkedList != null) {
                            n4 = 3;
                            break;
                        }
                        if (linkedList == null) {
                            linkedList = new LinkedList();
                        }
                        bl3 = true;
                        linkedList.add(i2);
                        break;
                    }
                    if (!n10.equals(ICAL_END)) break;
                    if (string5 == null || string2 == null || string3 == null) {
                        n4 = 3;
                        break;
                    }
                    if (string4 == null) {
                        string4 = VTimeZone.getDefaultTZName(string, bl2);
                    }
                    TimeZoneRule timeZoneRule = null;
                    int n12 = 0;
                    int date = 0;
                    int date2 = 0;
                    timeZoneRule3 = 0;
                    long l3 = 0L;
                    try {
                        n12 = VTimeZone.offsetStrToMillis(string2);
                        date = VTimeZone.offsetStrToMillis(string3);
                        if (bl2) {
                            if (date - n12 > 0) {
                                date2 = n12;
                                timeZoneRule3 = date - n12;
                            } else {
                                date2 = date - 3600000;
                                timeZoneRule3 = 3600000;
                            }
                        } else {
                            date2 = date;
                            timeZoneRule3 = 0;
                        }
                        l3 = VTimeZone.parseDateTimeString(string5, n12);
                        Date illegalArgumentException = null;
                        timeZoneRule = bl3 ? VTimeZone.createRuleByRRULE(string4, date2, timeZoneRule3, l3, linkedList, n12) : VTimeZone.createRuleByRDATE(string4, date2, timeZoneRule3, l3, linkedList, n12);
                        if (timeZoneRule != null && (illegalArgumentException = timeZoneRule.getFirstStart(n12, 0)).getTime() < l2) {
                            l2 = illegalArgumentException.getTime();
                            if (timeZoneRule3 > 0) {
                                n5 = n12;
                                n6 = 0;
                            } else if (n12 - date == 3600000) {
                                n5 = n12 - 3600000;
                                n6 = 3600000;
                            } else {
                                n5 = n12;
                                n6 = 0;
                            }
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (timeZoneRule == null) {
                        n4 = 3;
                        break;
                    }
                    arrayList.add(timeZoneRule);
                    n4 = 1;
                }
            }
            if (n4 != 3) continue;
            this.vtzlines = null;
            return false;
        }
        if (arrayList.size() == 0) {
            return false;
        }
        InitialTimeZoneRule initialTimeZoneRule = new InitialTimeZoneRule(VTimeZone.getDefaultTZName(string, false), n5, n6);
        RuleBasedTimeZone ruleBasedTimeZone = new RuleBasedTimeZone(string, initialTimeZoneRule);
        n2 = -1;
        int n3 = 0;
        for (int annualTimeZoneRule = 0; annualTimeZoneRule < arrayList.size(); ++annualTimeZoneRule) {
            TimeZoneRule n11 = (TimeZoneRule)arrayList.get(annualTimeZoneRule);
            if (!(n11 instanceof AnnualTimeZoneRule) || ((AnnualTimeZoneRule)n11).getEndYear() != Integer.MAX_VALUE) continue;
            ++n3;
            n2 = annualTimeZoneRule;
        }
        if (n3 > 2) {
            return false;
        }
        if (n3 == 1) {
            if (arrayList.size() == 1) {
                arrayList.clear();
            } else {
                TimeZoneRule timeZoneRule;
                Date date;
                AnnualTimeZoneRule annualTimeZoneRule = (AnnualTimeZoneRule)arrayList.get(n2);
                int timeZoneRule2 = annualTimeZoneRule.getRawOffset();
                int n7 = annualTimeZoneRule.getDSTSavings();
                Date date2 = date = annualTimeZoneRule.getFirstStart(n5, n6);
                for (timeZoneRule3 = 0; timeZoneRule3 < arrayList.size(); ++timeZoneRule3) {
                    TimeZoneRule nArray;
                    Date date3;
                    if (n2 == timeZoneRule3 || !(date3 = (nArray = (TimeZoneRule)arrayList.get(timeZoneRule3)).getFinalStart(timeZoneRule2, n7)).after(date2)) continue;
                    date2 = annualTimeZoneRule.getNextStart(date3.getTime(), nArray.getRawOffset(), nArray.getDSTSavings(), false);
                }
                if (date2 == date) {
                    timeZoneRule = new TimeArrayTimeZoneRule(annualTimeZoneRule.getName(), annualTimeZoneRule.getRawOffset(), annualTimeZoneRule.getDSTSavings(), new long[]{date.getTime()}, 2);
                } else {
                    int[] nArray = Grego.timeToFields(date2.getTime(), null);
                    timeZoneRule = new AnnualTimeZoneRule(annualTimeZoneRule.getName(), annualTimeZoneRule.getRawOffset(), annualTimeZoneRule.getDSTSavings(), annualTimeZoneRule.getRule(), annualTimeZoneRule.getStartYear(), nArray[0]);
                }
                arrayList.set(n2, timeZoneRule);
            }
        }
        for (TimeZoneRule timeZoneRule : arrayList) {
            ruleBasedTimeZone.addTransitionRule(timeZoneRule);
        }
        this.tz = ruleBasedTimeZone;
        this.setID(string);
        return true;
    }

    private static String getDefaultTZName(String string, boolean bl2) {
        if (bl2) {
            return string + "(DST)";
        }
        return string + "(STD)";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static TimeZoneRule createRuleByRRULE(String string, int n2, int n3, long l2, List<String> list, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        long[] lArray;
        if (list == null || list.size() == 0) {
            return null;
        }
        String string2 = list.get(0);
        int[] nArray = VTimeZone.parseRRULE(string2, lArray = new long[1]);
        if (nArray == null) {
            return null;
        }
        int n9 = nArray[0];
        int n10 = nArray[1];
        int n11 = nArray[2];
        int n12 = nArray[3];
        if (list.size() == 1) {
            if (nArray.length > 4) {
                if (nArray.length != 10 || n9 == -1 || n10 == 0) {
                    return null;
                }
                n8 = 31;
                int[] nArray2 = new int[7];
                for (n7 = 0; n7 < 7; ++n7) {
                    nArray2[n7] = nArray[3 + n7];
                    nArray2[n7] = nArray2[n7] > 0 ? nArray2[n7] : MONTHLENGTH[n9] + nArray2[n7] + 1;
                    n8 = nArray2[n7] < n8 ? nArray2[n7] : n8;
                }
                for (n7 = 1; n7 < 7; ++n7) {
                    n6 = 0;
                    for (n5 = 0; n5 < 7; ++n5) {
                        if (nArray2[n5] != n8 + n7) continue;
                        n6 = 1;
                        break;
                    }
                    if (n6 != 0) continue;
                    return null;
                }
                n12 = n8;
            }
        } else {
            if (n9 == -1 || n10 == 0 || n12 == 0) {
                return null;
            }
            if (list.size() > 7) {
                return null;
            }
            n8 = n9;
            int n13 = nArray.length - 3;
            n7 = 31;
            for (n6 = 0; n6 < n13; ++n6) {
                n5 = nArray[3 + n6];
                n5 = n5 > 0 ? n5 : MONTHLENGTH[n9] + n5 + 1;
                n7 = n5 < n7 ? n5 : n7;
            }
            n6 = -1;
            for (n5 = 1; n5 < list.size(); ++n5) {
                int n14;
                string2 = list.get(n5);
                long[] lArray2 = new long[1];
                int[] nArray3 = VTimeZone.parseRRULE(string2, lArray2);
                if (lArray2[0] > lArray[0]) {
                    lArray = lArray2;
                }
                if (nArray3[0] == -1 || nArray3[1] == 0 || nArray3[3] == 0) {
                    return null;
                }
                int n15 = nArray3.length - 3;
                if (n13 + n15 > 7) {
                    return null;
                }
                if (nArray3[1] != n10) {
                    return null;
                }
                if (nArray3[0] != n9) {
                    if (n6 == -1) {
                        n14 = nArray3[0] - n9;
                        if (n14 == -11 || n14 == -1) {
                            n8 = n6 = nArray3[0];
                            n7 = 31;
                        } else {
                            if (n14 != 11 && n14 != 1) return null;
                            n6 = nArray3[0];
                        }
                    } else if (nArray3[0] != n9 && nArray3[0] != n6) {
                        return null;
                    }
                }
                if (nArray3[0] == n8) {
                    for (n14 = 0; n14 < n15; ++n14) {
                        int n16 = nArray3[3 + n14];
                        n16 = n16 > 0 ? n16 : MONTHLENGTH[nArray3[0]] + n16 + 1;
                        n7 = n16 < n7 ? n16 : n7;
                    }
                }
                n13 += n15;
            }
            if (n13 != 7) {
                return null;
            }
            n9 = n8;
            n12 = n7;
        }
        int[] nArray4 = Grego.timeToFields(l2 + (long)n4, null);
        int n17 = nArray4[0];
        if (n9 == -1) {
            n9 = nArray4[1];
        }
        if (n10 == 0 && n11 == 0 && n12 == 0) {
            n12 = nArray4[2];
        }
        n7 = nArray4[5];
        n6 = Integer.MAX_VALUE;
        if (lArray[0] != Long.MIN_VALUE) {
            Grego.timeToFields(lArray[0], nArray4);
            n6 = nArray4[0];
        }
        DateTimeRule dateTimeRule = null;
        if (n10 == 0 && n11 == 0 && n12 != 0) {
            dateTimeRule = new DateTimeRule(n9, n12, n7, 0);
            return new AnnualTimeZoneRule(string, n2, n3, dateTimeRule, n17, n6);
        } else if (n10 != 0 && n11 != 0 && n12 == 0) {
            dateTimeRule = new DateTimeRule(n9, n11, n10, n7, 0);
            return new AnnualTimeZoneRule(string, n2, n3, dateTimeRule, n17, n6);
        } else {
            if (n10 == 0 || n11 != 0 || n12 == 0) return null;
            dateTimeRule = new DateTimeRule(n9, n12, n10, true, n7, 0);
        }
        return new AnnualTimeZoneRule(string, n2, n3, dateTimeRule, n17, n6);
    }

    private static int[] parseRRULE(String string, long[] lArray) {
        Object object;
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        int[] nArray = null;
        long l2 = Long.MIN_VALUE;
        boolean bl2 = false;
        boolean bl3 = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, SEMICOLON);
        block8: while (stringTokenizer.hasMoreTokens()) {
            int n5;
            int n6;
            String string2 = stringTokenizer.nextToken();
            int n7 = string2.indexOf(EQUALS_SIGN);
            if (n7 == -1) {
                bl3 = true;
                break;
            }
            object = string2.substring(0, n7);
            String string3 = string2.substring(n7 + 1);
            if (((String)object).equals(ICAL_FREQ)) {
                if (string3.equals(ICAL_YEARLY)) {
                    bl2 = true;
                    continue;
                }
                bl3 = true;
                break;
            }
            if (((String)object).equals(ICAL_UNTIL)) {
                try {
                    l2 = VTimeZone.parseDateTimeString(string3, 0);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    bl3 = true;
                    break;
                }
            }
            if (((String)object).equals(ICAL_BYMONTH)) {
                if (string3.length() > 2) {
                    bl3 = true;
                    break;
                }
                try {
                    n2 = Integer.parseInt(string3) - 1;
                    if (n2 >= 0 && n2 < 12) continue;
                    bl3 = true;
                }
                catch (NumberFormatException numberFormatException) {
                    bl3 = true;
                }
                break;
            }
            if (((String)object).equals(ICAL_BYDAY)) {
                int n8 = string3.length();
                if (n8 < 2 || n8 > 4) {
                    bl3 = true;
                    break;
                }
                if (n8 > 2) {
                    n6 = 1;
                    if (string3.charAt(0) == '+') {
                        n6 = 1;
                    } else if (string3.charAt(0) == '-') {
                        n6 = -1;
                    } else if (n8 == 4) {
                        bl3 = true;
                        break;
                    }
                    try {
                        n5 = Integer.parseInt(string3.substring(n8 - 3, n8 - 2));
                        if (n5 == 0 || n5 > 4) {
                            bl3 = true;
                            break;
                        }
                        n4 = n5 * n6;
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl3 = true;
                        break;
                    }
                    string3 = string3.substring(n8 - 2);
                }
                for (n6 = 0; n6 < ICAL_DOW_NAMES.length && !string3.equals(ICAL_DOW_NAMES[n6]); ++n6) {
                }
                if (n6 < ICAL_DOW_NAMES.length) {
                    n3 = n6 + 1;
                    continue;
                }
                bl3 = true;
                break;
            }
            if (!((String)object).equals(ICAL_BYMONTHDAY)) continue;
            StringTokenizer stringTokenizer2 = new StringTokenizer(string3, COMMA);
            n6 = stringTokenizer2.countTokens();
            nArray = new int[n6];
            n5 = 0;
            while (stringTokenizer2.hasMoreTokens()) {
                try {
                    nArray[n5++] = Integer.parseInt(stringTokenizer2.nextToken());
                }
                catch (NumberFormatException numberFormatException) {
                    bl3 = true;
                    continue block8;
                }
            }
        }
        if (bl3) {
            return null;
        }
        if (!bl2) {
            return null;
        }
        lArray[0] = l2;
        if (nArray == null) {
            object = new int[4];
            object[3] = 0;
        } else {
            object = new int[3 + nArray.length];
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                object[3 + i2] = nArray[i2];
            }
        }
        object[0] = n2;
        object[1] = n3;
        object[2] = n4;
        return object;
    }

    private static TimeZoneRule createRuleByRDATE(String string, int n2, int n3, long l2, List<String> list, int n4) {
        long[] lArray;
        if (list == null || list.size() == 0) {
            lArray = new long[]{l2};
        } else {
            lArray = new long[list.size()];
            int n5 = 0;
            try {
                for (String string2 : list) {
                    lArray[n5++] = VTimeZone.parseDateTimeString(string2, n4);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
        return new TimeArrayTimeZoneRule(string, n2, n3, lArray, 2);
    }

    private void writeZone(Writer writer, BasicTimeZone basicTimeZone, String[] stringArray) throws IOException {
        Object object;
        this.writeHeader(writer);
        if (stringArray != null && stringArray.length > 0) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2] == null) continue;
                writer.write(stringArray[i2]);
                writer.write(NEWLINE);
            }
        }
        long l2 = Long.MIN_VALUE;
        String string = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        long l3 = 0L;
        long l4 = 0L;
        int n10 = 0;
        AnnualTimeZoneRule annualTimeZoneRule = null;
        String string2 = null;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        long l5 = 0L;
        long l6 = 0L;
        int n19 = 0;
        AnnualTimeZoneRule annualTimeZoneRule2 = null;
        int[] nArray = new int[6];
        boolean bl2 = false;
        while ((object = basicTimeZone.getNextTransition(l2, false)) != null) {
            bl2 = true;
            l2 = ((TimeZoneTransition)object).getTime();
            String string3 = ((TimeZoneTransition)object).getTo().getName();
            boolean bl3 = ((TimeZoneTransition)object).getTo().getDSTSavings() != 0;
            int n20 = ((TimeZoneTransition)object).getFrom().getRawOffset() + ((TimeZoneTransition)object).getFrom().getDSTSavings();
            int n21 = ((TimeZoneTransition)object).getFrom().getDSTSavings();
            int n22 = ((TimeZoneTransition)object).getTo().getRawOffset() + ((TimeZoneTransition)object).getTo().getDSTSavings();
            Grego.timeToFields(((TimeZoneTransition)object).getTime() + (long)n20, nArray);
            int n23 = Grego.getDayOfWeekInMonth(nArray[0], nArray[1], nArray[2]);
            int n24 = nArray[0];
            boolean bl4 = false;
            if (bl3) {
                if (annualTimeZoneRule == null && ((TimeZoneTransition)object).getTo() instanceof AnnualTimeZoneRule && ((AnnualTimeZoneRule)((TimeZoneTransition)object).getTo()).getEndYear() == Integer.MAX_VALUE) {
                    annualTimeZoneRule = (AnnualTimeZoneRule)((TimeZoneTransition)object).getTo();
                }
                if (n10 > 0) {
                    if (n24 == n5 + n10 && string3.equals(string) && n2 == n20 && n4 == n22 && n6 == nArray[1] && n7 == nArray[3] && n8 == n23 && n9 == nArray[5]) {
                        l4 = l2;
                        ++n10;
                        bl4 = true;
                    }
                    if (!bl4) {
                        if (n10 == 1) {
                            VTimeZone.writeZonePropsByTime(writer, true, string, n2, n4, l3, true);
                        } else {
                            VTimeZone.writeZonePropsByDOW(writer, true, string, n2, n4, n6, n8, n7, l3, l4);
                        }
                    }
                }
                if (!bl4) {
                    string = string3;
                    n2 = n20;
                    n3 = n21;
                    n4 = n22;
                    n5 = n24;
                    n6 = nArray[1];
                    n7 = nArray[3];
                    n8 = n23;
                    n9 = nArray[5];
                    l3 = l4 = l2;
                    n10 = 1;
                }
                if (annualTimeZoneRule2 == null || annualTimeZoneRule == null) continue;
                break;
            }
            if (annualTimeZoneRule2 == null && ((TimeZoneTransition)object).getTo() instanceof AnnualTimeZoneRule && ((AnnualTimeZoneRule)((TimeZoneTransition)object).getTo()).getEndYear() == Integer.MAX_VALUE) {
                annualTimeZoneRule2 = (AnnualTimeZoneRule)((TimeZoneTransition)object).getTo();
            }
            if (n19 > 0) {
                if (n24 == n14 + n19 && string3.equals(string2) && n11 == n20 && n13 == n22 && n15 == nArray[1] && n16 == nArray[3] && n17 == n23 && n18 == nArray[5]) {
                    l6 = l2;
                    ++n19;
                    bl4 = true;
                }
                if (!bl4) {
                    if (n19 == 1) {
                        VTimeZone.writeZonePropsByTime(writer, false, string2, n11, n13, l5, true);
                    } else {
                        VTimeZone.writeZonePropsByDOW(writer, false, string2, n11, n13, n15, n17, n16, l5, l6);
                    }
                }
            }
            if (!bl4) {
                string2 = string3;
                n11 = n20;
                n12 = n21;
                n13 = n22;
                n14 = n24;
                n15 = nArray[1];
                n16 = nArray[3];
                n17 = n23;
                n18 = nArray[5];
                l5 = l6 = l2;
                n19 = 1;
            }
            if (annualTimeZoneRule2 == null || annualTimeZoneRule == null) continue;
            break;
        }
        if (!bl2) {
            int n25 = basicTimeZone.getOffset(0L);
            boolean bl5 = n25 != basicTimeZone.getRawOffset();
            VTimeZone.writeZonePropsByTime(writer, bl5, VTimeZone.getDefaultTZName(basicTimeZone.getID(), bl5), n25, n25, 0L - (long)n25, false);
        } else {
            if (n10 > 0) {
                if (annualTimeZoneRule == null) {
                    if (n10 == 1) {
                        VTimeZone.writeZonePropsByTime(writer, true, string, n2, n4, l3, true);
                    } else {
                        VTimeZone.writeZonePropsByDOW(writer, true, string, n2, n4, n6, n8, n7, l3, l4);
                    }
                } else if (n10 == 1) {
                    VTimeZone.writeFinalRule(writer, true, annualTimeZoneRule, n2 - n3, n3, l3);
                } else if (VTimeZone.isEquivalentDateRule(n6, n8, n7, annualTimeZoneRule.getRule())) {
                    VTimeZone.writeZonePropsByDOW(writer, true, string, n2, n4, n6, n8, n7, l3, Long.MAX_VALUE);
                } else {
                    VTimeZone.writeZonePropsByDOW(writer, true, string, n2, n4, n6, n8, n7, l3, l4);
                    object = annualTimeZoneRule.getNextStart(l4, n2 - n3, n3, false);
                    assert (object != null);
                    if (object != null) {
                        VTimeZone.writeFinalRule(writer, true, annualTimeZoneRule, n2 - n3, n3, ((Date)object).getTime());
                    }
                }
            }
            if (n19 > 0) {
                if (annualTimeZoneRule2 == null) {
                    if (n19 == 1) {
                        VTimeZone.writeZonePropsByTime(writer, false, string2, n11, n13, l5, true);
                    } else {
                        VTimeZone.writeZonePropsByDOW(writer, false, string2, n11, n13, n15, n17, n16, l5, l6);
                    }
                } else if (n19 == 1) {
                    VTimeZone.writeFinalRule(writer, false, annualTimeZoneRule2, n11 - n12, n12, l5);
                } else if (VTimeZone.isEquivalentDateRule(n15, n17, n16, annualTimeZoneRule2.getRule())) {
                    VTimeZone.writeZonePropsByDOW(writer, false, string2, n11, n13, n15, n17, n16, l5, Long.MAX_VALUE);
                } else {
                    VTimeZone.writeZonePropsByDOW(writer, false, string2, n11, n13, n15, n17, n16, l5, l6);
                    object = annualTimeZoneRule2.getNextStart(l6, n11 - n12, n12, false);
                    assert (object != null);
                    if (object != null) {
                        VTimeZone.writeFinalRule(writer, false, annualTimeZoneRule2, n11 - n12, n12, ((Date)object).getTime());
                    }
                }
            }
        }
        VTimeZone.writeFooter(writer);
    }

    private static boolean isEquivalentDateRule(int n2, int n3, int n4, DateTimeRule dateTimeRule) {
        if (n2 != dateTimeRule.getRuleMonth() || n4 != dateTimeRule.getRuleDayOfWeek()) {
            return false;
        }
        if (dateTimeRule.getTimeRuleType() != 0) {
            return false;
        }
        if (dateTimeRule.getDateRuleType() == 1 && dateTimeRule.getRuleWeekInMonth() == n3) {
            return true;
        }
        int n5 = dateTimeRule.getRuleDayOfMonth();
        if (dateTimeRule.getDateRuleType() == 2) {
            if (n5 % 7 == 1 && (n5 + 6) / 7 == n3) {
                return true;
            }
            if (n2 != 1 && (MONTHLENGTH[n2] - n5) % 7 == 6 && n3 == -1 * ((MONTHLENGTH[n2] - n5 + 1) / 7)) {
                return true;
            }
        }
        if (dateTimeRule.getDateRuleType() == 3) {
            if (n5 % 7 == 0 && n5 / 7 == n3) {
                return true;
            }
            if (n2 != 1 && (MONTHLENGTH[n2] - n5) % 7 == 0 && n3 == -1 * ((MONTHLENGTH[n2] - n5) / 7 + 1)) {
                return true;
            }
        }
        return false;
    }

    private static void writeZonePropsByTime(Writer writer, boolean bl2, String string, int n2, int n3, long l2, boolean bl3) throws IOException {
        VTimeZone.beginZoneProps(writer, bl2, string, n2, n3, l2);
        if (bl3) {
            writer.write(ICAL_RDATE);
            writer.write(COLON);
            writer.write(VTimeZone.getDateTimeString(l2 + (long)n2));
            writer.write(NEWLINE);
        }
        VTimeZone.endZoneProps(writer, bl2);
    }

    private static void writeZonePropsByDOM(Writer writer, boolean bl2, String string, int n2, int n3, int n4, int n5, long l2, long l3) throws IOException {
        VTimeZone.beginZoneProps(writer, bl2, string, n2, n3, l2);
        VTimeZone.beginRRULE(writer, n4);
        writer.write(ICAL_BYMONTHDAY);
        writer.write(EQUALS_SIGN);
        writer.write(Integer.toString(n5));
        if (l3 != Long.MAX_VALUE) {
            VTimeZone.appendUNTIL(writer, VTimeZone.getDateTimeString(l3 + (long)n2));
        }
        writer.write(NEWLINE);
        VTimeZone.endZoneProps(writer, bl2);
    }

    private static void writeZonePropsByDOW(Writer writer, boolean bl2, String string, int n2, int n3, int n4, int n5, int n6, long l2, long l3) throws IOException {
        VTimeZone.beginZoneProps(writer, bl2, string, n2, n3, l2);
        VTimeZone.beginRRULE(writer, n4);
        writer.write(ICAL_BYDAY);
        writer.write(EQUALS_SIGN);
        writer.write(Integer.toString(n5));
        writer.write(ICAL_DOW_NAMES[n6 - 1]);
        if (l3 != Long.MAX_VALUE) {
            VTimeZone.appendUNTIL(writer, VTimeZone.getDateTimeString(l3 + (long)n2));
        }
        writer.write(NEWLINE);
        VTimeZone.endZoneProps(writer, bl2);
    }

    private static void writeZonePropsByDOW_GEQ_DOM(Writer writer, boolean bl2, String string, int n2, int n3, int n4, int n5, int n6, long l2, long l3) throws IOException {
        if (n5 % 7 == 1) {
            VTimeZone.writeZonePropsByDOW(writer, bl2, string, n2, n3, n4, (n5 + 6) / 7, n6, l2, l3);
        } else if (n4 != 1 && (MONTHLENGTH[n4] - n5) % 7 == 6) {
            VTimeZone.writeZonePropsByDOW(writer, bl2, string, n2, n3, n4, -1 * ((MONTHLENGTH[n4] - n5 + 1) / 7), n6, l2, l3);
        } else {
            VTimeZone.beginZoneProps(writer, bl2, string, n2, n3, l2);
            int n7 = n5;
            int n8 = 7;
            if (n5 <= 0) {
                int n9 = 1 - n5;
                n8 -= n9;
                int n10 = n4 - 1 < 0 ? 11 : n4 - 1;
                VTimeZone.writeZonePropsByDOW_GEQ_DOM_sub(writer, n10, -n9, n6, n9, Long.MAX_VALUE, n2);
                n7 = 1;
            } else if (n5 + 6 > MONTHLENGTH[n4]) {
                int n11 = n5 + 6 - MONTHLENGTH[n4];
                n8 -= n11;
                int n12 = n4 + 1 > 11 ? 0 : n4 + 1;
                VTimeZone.writeZonePropsByDOW_GEQ_DOM_sub(writer, n12, 1, n6, n11, Long.MAX_VALUE, n2);
            }
            VTimeZone.writeZonePropsByDOW_GEQ_DOM_sub(writer, n4, n7, n6, n8, l3, n2);
            VTimeZone.endZoneProps(writer, bl2);
        }
    }

    private static void writeZonePropsByDOW_GEQ_DOM_sub(Writer writer, int n2, int n3, int n4, int n5, long l2, int n6) throws IOException {
        boolean bl2;
        int n7 = n3;
        boolean bl3 = bl2 = n2 == 1;
        if (n3 < 0 && !bl2) {
            n7 = MONTHLENGTH[n2] + n3 + 1;
        }
        VTimeZone.beginRRULE(writer, n2);
        writer.write(ICAL_BYDAY);
        writer.write(EQUALS_SIGN);
        writer.write(ICAL_DOW_NAMES[n4 - 1]);
        writer.write(SEMICOLON);
        writer.write(ICAL_BYMONTHDAY);
        writer.write(EQUALS_SIGN);
        writer.write(Integer.toString(n7));
        for (int i2 = 1; i2 < n5; ++i2) {
            writer.write(COMMA);
            writer.write(Integer.toString(n7 + i2));
        }
        if (l2 != Long.MAX_VALUE) {
            VTimeZone.appendUNTIL(writer, VTimeZone.getDateTimeString(l2 + (long)n6));
        }
        writer.write(NEWLINE);
    }

    private static void writeZonePropsByDOW_LEQ_DOM(Writer writer, boolean bl2, String string, int n2, int n3, int n4, int n5, int n6, long l2, long l3) throws IOException {
        if (n5 % 7 == 0) {
            VTimeZone.writeZonePropsByDOW(writer, bl2, string, n2, n3, n4, n5 / 7, n6, l2, l3);
        } else if (n4 != 1 && (MONTHLENGTH[n4] - n5) % 7 == 0) {
            VTimeZone.writeZonePropsByDOW(writer, bl2, string, n2, n3, n4, -1 * ((MONTHLENGTH[n4] - n5) / 7 + 1), n6, l2, l3);
        } else if (n4 == 1 && n5 == 29) {
            VTimeZone.writeZonePropsByDOW(writer, bl2, string, n2, n3, 1, -1, n6, l2, l3);
        } else {
            VTimeZone.writeZonePropsByDOW_GEQ_DOM(writer, bl2, string, n2, n3, n4, n5 - 6, n6, l2, l3);
        }
    }

    private static void writeFinalRule(Writer writer, boolean bl2, AnnualTimeZoneRule annualTimeZoneRule, int n2, int n3, long l2) throws IOException {
        DateTimeRule dateTimeRule = VTimeZone.toWallTimeRule(annualTimeZoneRule.getRule(), n2, n3);
        int n4 = dateTimeRule.getRuleMillisInDay();
        if (n4 < 0) {
            l2 += (long)(0 - n4);
        } else if (n4 >= 86400000) {
            l2 -= (long)(n4 - 86399999);
        }
        int n5 = annualTimeZoneRule.getRawOffset() + annualTimeZoneRule.getDSTSavings();
        switch (dateTimeRule.getDateRuleType()) {
            case 0: {
                VTimeZone.writeZonePropsByDOM(writer, bl2, annualTimeZoneRule.getName(), n2 + n3, n5, dateTimeRule.getRuleMonth(), dateTimeRule.getRuleDayOfMonth(), l2, Long.MAX_VALUE);
                break;
            }
            case 1: {
                VTimeZone.writeZonePropsByDOW(writer, bl2, annualTimeZoneRule.getName(), n2 + n3, n5, dateTimeRule.getRuleMonth(), dateTimeRule.getRuleWeekInMonth(), dateTimeRule.getRuleDayOfWeek(), l2, Long.MAX_VALUE);
                break;
            }
            case 2: {
                VTimeZone.writeZonePropsByDOW_GEQ_DOM(writer, bl2, annualTimeZoneRule.getName(), n2 + n3, n5, dateTimeRule.getRuleMonth(), dateTimeRule.getRuleDayOfMonth(), dateTimeRule.getRuleDayOfWeek(), l2, Long.MAX_VALUE);
                break;
            }
            case 3: {
                VTimeZone.writeZonePropsByDOW_LEQ_DOM(writer, bl2, annualTimeZoneRule.getName(), n2 + n3, n5, dateTimeRule.getRuleMonth(), dateTimeRule.getRuleDayOfMonth(), dateTimeRule.getRuleDayOfWeek(), l2, Long.MAX_VALUE);
            }
        }
    }

    private static DateTimeRule toWallTimeRule(DateTimeRule dateTimeRule, int n2, int n3) {
        if (dateTimeRule.getTimeRuleType() == 0) {
            return dateTimeRule;
        }
        int n4 = dateTimeRule.getRuleMillisInDay();
        if (dateTimeRule.getTimeRuleType() == 2) {
            n4 += n2 + n3;
        } else if (dateTimeRule.getTimeRuleType() == 1) {
            n4 += n3;
        }
        int n5 = -1;
        int n6 = 0;
        int n7 = 0;
        int n8 = -1;
        int n9 = 0;
        if (n4 < 0) {
            n9 = -1;
            n4 += 86400000;
        } else if (n4 >= 86400000) {
            n9 = 1;
            n4 -= 86400000;
        }
        n5 = dateTimeRule.getRuleMonth();
        n6 = dateTimeRule.getRuleDayOfMonth();
        n7 = dateTimeRule.getRuleDayOfWeek();
        n8 = dateTimeRule.getDateRuleType();
        if (n9 != 0) {
            if (n8 == 1) {
                int n10 = dateTimeRule.getRuleWeekInMonth();
                if (n10 > 0) {
                    n8 = 2;
                    n6 = 7 * (n10 - 1) + 1;
                } else {
                    n8 = 3;
                    n6 = MONTHLENGTH[n5] + 7 * (n10 + 1);
                }
            }
            if ((n6 += n9) == 0) {
                n5 = --n5 < 0 ? 11 : n5;
                n6 = MONTHLENGTH[n5];
            } else if (n6 > MONTHLENGTH[n5]) {
                n5 = ++n5 > 11 ? 0 : n5;
                n6 = 1;
            }
            if (n8 != 0) {
                if ((n7 += n9) < 1) {
                    n7 = 7;
                } else if (n7 > 7) {
                    n7 = 1;
                }
            }
        }
        DateTimeRule dateTimeRule2 = n8 == 0 ? new DateTimeRule(n5, n6, n4, 0) : new DateTimeRule(n5, n6, n7, n8 == 2, n4, 0);
        return dateTimeRule2;
    }

    private static void beginZoneProps(Writer writer, boolean bl2, String string, int n2, int n3, long l2) throws IOException {
        writer.write(ICAL_BEGIN);
        writer.write(COLON);
        if (bl2) {
            writer.write(ICAL_DAYLIGHT);
        } else {
            writer.write(ICAL_STANDARD);
        }
        writer.write(NEWLINE);
        writer.write(ICAL_TZOFFSETTO);
        writer.write(COLON);
        writer.write(VTimeZone.millisToOffset(n3));
        writer.write(NEWLINE);
        writer.write(ICAL_TZOFFSETFROM);
        writer.write(COLON);
        writer.write(VTimeZone.millisToOffset(n2));
        writer.write(NEWLINE);
        writer.write(ICAL_TZNAME);
        writer.write(COLON);
        writer.write(string);
        writer.write(NEWLINE);
        writer.write(ICAL_DTSTART);
        writer.write(COLON);
        writer.write(VTimeZone.getDateTimeString(l2 + (long)n2));
        writer.write(NEWLINE);
    }

    private static void endZoneProps(Writer writer, boolean bl2) throws IOException {
        writer.write(ICAL_END);
        writer.write(COLON);
        if (bl2) {
            writer.write(ICAL_DAYLIGHT);
        } else {
            writer.write(ICAL_STANDARD);
        }
        writer.write(NEWLINE);
    }

    private static void beginRRULE(Writer writer, int n2) throws IOException {
        writer.write(ICAL_RRULE);
        writer.write(COLON);
        writer.write(ICAL_FREQ);
        writer.write(EQUALS_SIGN);
        writer.write(ICAL_YEARLY);
        writer.write(SEMICOLON);
        writer.write(ICAL_BYMONTH);
        writer.write(EQUALS_SIGN);
        writer.write(Integer.toString(n2 + 1));
        writer.write(SEMICOLON);
    }

    private static void appendUNTIL(Writer writer, String string) throws IOException {
        if (string != null) {
            writer.write(SEMICOLON);
            writer.write(ICAL_UNTIL);
            writer.write(EQUALS_SIGN);
            writer.write(string);
        }
    }

    private void writeHeader(Writer writer) throws IOException {
        writer.write(ICAL_BEGIN);
        writer.write(COLON);
        writer.write(ICAL_VTIMEZONE);
        writer.write(NEWLINE);
        writer.write(ICAL_TZID);
        writer.write(COLON);
        writer.write(this.tz.getID());
        writer.write(NEWLINE);
        if (this.tzurl != null) {
            writer.write(ICAL_TZURL);
            writer.write(COLON);
            writer.write(this.tzurl);
            writer.write(NEWLINE);
        }
        if (this.lastmod != null) {
            writer.write(ICAL_LASTMOD);
            writer.write(COLON);
            writer.write(VTimeZone.getUTCDateTimeString(this.lastmod.getTime()));
            writer.write(NEWLINE);
        }
    }

    private static void writeFooter(Writer writer) throws IOException {
        writer.write(ICAL_END);
        writer.write(COLON);
        writer.write(ICAL_VTIMEZONE);
        writer.write(NEWLINE);
    }

    private static String getDateTimeString(long l2) {
        int[] nArray = Grego.timeToFields(l2, null);
        StringBuilder stringBuilder = new StringBuilder(15);
        stringBuilder.append(VTimeZone.numToString(nArray[0], 4));
        stringBuilder.append(VTimeZone.numToString(nArray[1] + 1, 2));
        stringBuilder.append(VTimeZone.numToString(nArray[2], 2));
        stringBuilder.append('T');
        int n2 = nArray[5];
        int n3 = n2 / 3600000;
        int n4 = (n2 %= 3600000) / 60000;
        int n5 = (n2 %= 60000) / 1000;
        stringBuilder.append(VTimeZone.numToString(n3, 2));
        stringBuilder.append(VTimeZone.numToString(n4, 2));
        stringBuilder.append(VTimeZone.numToString(n5, 2));
        return stringBuilder.toString();
    }

    private static String getUTCDateTimeString(long l2) {
        return VTimeZone.getDateTimeString(l2) + "Z";
    }

    private static long parseDateTimeString(String string, int n2) {
        boolean bl2;
        boolean bl3;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        block6: {
            block7: {
                int n9;
                n8 = 0;
                n7 = 0;
                n6 = 0;
                n5 = 0;
                n4 = 0;
                n3 = 0;
                bl3 = false;
                bl2 = false;
                if (string == null || (n9 = string.length()) != 15 && n9 != 16 || string.charAt(8) != 'T') break block6;
                if (n9 != 16) break block7;
                if (string.charAt(15) != 'Z') break block6;
                bl3 = true;
            }
            try {
                n8 = Integer.parseInt(string.substring(0, 4));
                n7 = Integer.parseInt(string.substring(4, 6)) - 1;
                n6 = Integer.parseInt(string.substring(6, 8));
                n5 = Integer.parseInt(string.substring(9, 11));
                n4 = Integer.parseInt(string.substring(11, 13));
                n3 = Integer.parseInt(string.substring(13, 15));
            }
            catch (NumberFormatException numberFormatException) {
                break block6;
            }
            int n10 = Grego.monthLength(n8, n7);
            if (n8 >= 0 && n7 >= 0 && n7 <= 11 && n6 >= 1 && n6 <= n10 && n5 >= 0 && n5 < 24 && n4 >= 0 && n4 < 60 && n3 >= 0 && n3 < 60) {
                bl2 = true;
            }
        }
        if (!bl2) {
            throw new IllegalArgumentException("Invalid date time string format");
        }
        long l2 = Grego.fieldsToDay(n8, n7, n6) * 86400000L;
        l2 += (long)(n5 * 3600000 + n4 * 60000 + n3 * 1000);
        if (!bl3) {
            l2 -= (long)n2;
        }
        return l2;
    }

    private static int offsetStrToMillis(String string) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        boolean bl2;
        block5: {
            block4: {
                block7: {
                    char c2;
                    block6: {
                        bl2 = false;
                        n6 = 0;
                        n5 = 0;
                        n4 = 0;
                        n3 = 0;
                        if (string == null || (n2 = string.length()) != 5 && n2 != 7) break block5;
                        c2 = string.charAt(0);
                        if (c2 != '+') break block6;
                        n6 = 1;
                        break block7;
                    }
                    if (c2 != '-') break block5;
                    n6 = -1;
                }
                try {
                    n5 = Integer.parseInt(string.substring(1, 3));
                    n4 = Integer.parseInt(string.substring(3, 5));
                    if (n2 != 7) break block4;
                    n3 = Integer.parseInt(string.substring(5, 7));
                }
                catch (NumberFormatException numberFormatException) {
                    break block5;
                }
            }
            bl2 = true;
        }
        if (!bl2) {
            throw new IllegalArgumentException("Bad offset string");
        }
        n2 = n6 * ((n5 * 60 + n4) * 60 + n3) * 1000;
        return n2;
    }

    private static String millisToOffset(int n2) {
        StringBuilder stringBuilder = new StringBuilder(7);
        if (n2 >= 0) {
            stringBuilder.append('+');
        } else {
            stringBuilder.append('-');
            n2 = -n2;
        }
        int n3 = n2 / 1000;
        int n4 = n3 % 60;
        n3 = (n3 - n4) / 60;
        int n5 = n3 % 60;
        int n6 = n3 / 60;
        stringBuilder.append(VTimeZone.numToString(n6, 2));
        stringBuilder.append(VTimeZone.numToString(n5, 2));
        stringBuilder.append(VTimeZone.numToString(n4, 2));
        return stringBuilder.toString();
    }

    private static String numToString(int n2, int n3) {
        String string = Integer.toString(n2);
        int n4 = string.length();
        if (n4 >= n3) {
            return string.substring(n4 - n3, n4);
        }
        StringBuilder stringBuilder = new StringBuilder(n3);
        for (int i2 = n4; i2 < n3; ++i2) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    @Override
    public boolean isFrozen() {
        return this.isFrozen;
    }

    @Override
    public TimeZone freeze() {
        this.isFrozen = true;
        return this;
    }

    @Override
    public TimeZone cloneAsThawed() {
        VTimeZone vTimeZone = (VTimeZone)super.cloneAsThawed();
        vTimeZone.tz = (BasicTimeZone)this.tz.cloneAsThawed();
        vTimeZone.isFrozen = false;
        return vTimeZone;
    }

    static {
        ICAL_DOW_NAMES = new String[]{"SU", "MO", "TU", "WE", "TH", "FR", "SA"};
        MONTHLENGTH = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        try {
            ICU_TZVERSION = TimeZone.getTZDataVersion();
        }
        catch (MissingResourceException missingResourceException) {
            ICU_TZVERSION = null;
        }
    }
}

