/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.util;

import java.util.Arrays;
import java.util.Date;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.TimeZoneRule;

public class TimeArrayTimeZoneRule
extends TimeZoneRule {
    private static final long serialVersionUID = -1117109130077415245L;
    private final long[] startTimes;
    private final int timeType;

    public TimeArrayTimeZoneRule(String string, int n2, int n3, long[] lArray, int n4) {
        super(string, n2, n3);
        if (lArray == null || lArray.length == 0) {
            throw new IllegalArgumentException("No start times are specified.");
        }
        this.startTimes = (long[])lArray.clone();
        Arrays.sort(this.startTimes);
        this.timeType = n4;
    }

    public long[] getStartTimes() {
        return (long[])this.startTimes.clone();
    }

    public int getTimeType() {
        return this.timeType;
    }

    @Override
    public Date getFirstStart(int n2, int n3) {
        return new Date(this.getUTC(this.startTimes[0], n2, n3));
    }

    @Override
    public Date getFinalStart(int n2, int n3) {
        return new Date(this.getUTC(this.startTimes[this.startTimes.length - 1], n2, n3));
    }

    @Override
    public Date getNextStart(long l2, int n2, int n3, boolean bl2) {
        long l3;
        int n4;
        for (n4 = this.startTimes.length - 1; n4 >= 0 && (l3 = this.getUTC(this.startTimes[n4], n2, n3)) >= l2 && (bl2 || l3 != l2); --n4) {
        }
        if (n4 == this.startTimes.length - 1) {
            return null;
        }
        return new Date(this.getUTC(this.startTimes[n4 + 1], n2, n3));
    }

    @Override
    public Date getPreviousStart(long l2, int n2, int n3, boolean bl2) {
        for (int i2 = this.startTimes.length - 1; i2 >= 0; --i2) {
            long l3 = this.getUTC(this.startTimes[i2], n2, n3);
            if (l3 >= l2 && (!bl2 || l3 != l2)) continue;
            return new Date(l3);
        }
        return null;
    }

    @Override
    public boolean isEquivalentTo(TimeZoneRule timeZoneRule) {
        if (!(timeZoneRule instanceof TimeArrayTimeZoneRule)) {
            return false;
        }
        if (this.timeType == ((TimeArrayTimeZoneRule)timeZoneRule).timeType && Arrays.equals(this.startTimes, ((TimeArrayTimeZoneRule)timeZoneRule).startTimes)) {
            return super.isEquivalentTo(timeZoneRule);
        }
        return false;
    }

    @Override
    public boolean isTransitionRule() {
        return true;
    }

    private long getUTC(long l2, int n2, int n3) {
        if (this.timeType != 2) {
            l2 -= (long)n2;
        }
        if (this.timeType == 0) {
            l2 -= (long)n3;
        }
        return l2;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append(", timeType=");
        stringBuilder.append(this.timeType);
        stringBuilder.append(", startTimes=[");
        for (int i2 = 0; i2 < this.startTimes.length; ++i2) {
            if (i2 != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(Long.toString(this.startTimes[i2]));
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

