/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;

public final class StringTokenizer
implements Enumeration<Object> {
    private int m_tokenOffset_;
    private int m_tokenSize_;
    private int[] m_tokenStart_;
    private int[] m_tokenLimit_;
    private UnicodeSet m_delimiters_;
    private String m_source_;
    private int m_length_;
    private int m_nextOffset_;
    private boolean m_returnDelimiters_;
    private boolean m_coalesceDelimiters_;
    private static final UnicodeSet DEFAULT_DELIMITERS_ = new UnicodeSet(9, 10, 12, 13, 32, 32);
    private static final int TOKEN_SIZE_ = 100;
    private static final UnicodeSet EMPTY_DELIMITER_ = UnicodeSet.EMPTY;
    private boolean[] delims;

    public StringTokenizer(String string, UnicodeSet unicodeSet, boolean bl2) {
        this(string, unicodeSet, bl2, false);
    }

    @Deprecated
    public StringTokenizer(String string, UnicodeSet unicodeSet, boolean bl2, boolean bl3) {
        this.m_source_ = string;
        this.m_length_ = string.length();
        this.m_delimiters_ = unicodeSet == null ? EMPTY_DELIMITER_ : unicodeSet;
        this.m_returnDelimiters_ = bl2;
        this.m_coalesceDelimiters_ = bl3;
        this.m_tokenOffset_ = -1;
        this.m_tokenSize_ = -1;
        if (this.m_length_ == 0) {
            this.m_nextOffset_ = -1;
        } else {
            this.m_nextOffset_ = 0;
            if (!bl2) {
                this.m_nextOffset_ = this.getNextNonDelimiter(0);
            }
        }
    }

    public StringTokenizer(String string, UnicodeSet unicodeSet) {
        this(string, unicodeSet, false, false);
    }

    public StringTokenizer(String string, String string2, boolean bl2) {
        this(string, string2, bl2, false);
    }

    @Deprecated
    public StringTokenizer(String string, String string2, boolean bl2, boolean bl3) {
        this.m_delimiters_ = EMPTY_DELIMITER_;
        if (string2 != null && string2.length() > 0) {
            this.m_delimiters_ = new UnicodeSet();
            this.m_delimiters_.addAll(string2);
            this.checkDelimiters();
        }
        this.m_coalesceDelimiters_ = bl3;
        this.m_source_ = string;
        this.m_length_ = string.length();
        this.m_returnDelimiters_ = bl2;
        this.m_tokenOffset_ = -1;
        this.m_tokenSize_ = -1;
        if (this.m_length_ == 0) {
            this.m_nextOffset_ = -1;
        } else {
            this.m_nextOffset_ = 0;
            if (!bl2) {
                this.m_nextOffset_ = this.getNextNonDelimiter(0);
            }
        }
    }

    public StringTokenizer(String string, String string2) {
        this(string, string2, false, false);
    }

    public StringTokenizer(String string) {
        this(string, DEFAULT_DELIMITERS_, false, false);
    }

    public boolean hasMoreTokens() {
        return this.m_nextOffset_ >= 0;
    }

    public String nextToken() {
        if (this.m_tokenOffset_ < 0) {
            String string;
            if (this.m_nextOffset_ < 0) {
                throw new NoSuchElementException("No more tokens in String");
            }
            if (this.m_returnDelimiters_) {
                boolean bl2;
                int n2 = 0;
                int n3 = UTF16.charAt(this.m_source_, this.m_nextOffset_);
                boolean bl3 = this.delims == null ? this.m_delimiters_.contains(n3) : (bl2 = n3 < this.delims.length && this.delims[n3]);
                if (bl2) {
                    if (this.m_coalesceDelimiters_) {
                        n2 = this.getNextNonDelimiter(this.m_nextOffset_);
                    } else {
                        n2 = this.m_nextOffset_ + UTF16.getCharCount(n3);
                        if (n2 == this.m_length_) {
                            n2 = -1;
                        }
                    }
                } else {
                    n2 = this.getNextDelimiter(this.m_nextOffset_);
                }
                String string2 = n2 < 0 ? this.m_source_.substring(this.m_nextOffset_) : this.m_source_.substring(this.m_nextOffset_, n2);
                this.m_nextOffset_ = n2;
                return string2;
            }
            int n4 = this.getNextDelimiter(this.m_nextOffset_);
            if (n4 < 0) {
                string = this.m_source_.substring(this.m_nextOffset_);
                this.m_nextOffset_ = n4;
            } else {
                string = this.m_source_.substring(this.m_nextOffset_, n4);
                this.m_nextOffset_ = this.getNextNonDelimiter(n4);
            }
            return string;
        }
        if (this.m_tokenOffset_ >= this.m_tokenSize_) {
            throw new NoSuchElementException("No more tokens in String");
        }
        String string = this.m_tokenLimit_[this.m_tokenOffset_] >= 0 ? this.m_source_.substring(this.m_tokenStart_[this.m_tokenOffset_], this.m_tokenLimit_[this.m_tokenOffset_]) : this.m_source_.substring(this.m_tokenStart_[this.m_tokenOffset_]);
        ++this.m_tokenOffset_;
        this.m_nextOffset_ = -1;
        if (this.m_tokenOffset_ < this.m_tokenSize_) {
            this.m_nextOffset_ = this.m_tokenStart_[this.m_tokenOffset_];
        }
        return string;
    }

    public String nextToken(String string) {
        this.m_delimiters_ = EMPTY_DELIMITER_;
        if (string != null && string.length() > 0) {
            this.m_delimiters_ = new UnicodeSet();
            this.m_delimiters_.addAll(string);
        }
        return this.nextToken(this.m_delimiters_);
    }

    public String nextToken(UnicodeSet unicodeSet) {
        this.m_delimiters_ = unicodeSet;
        this.checkDelimiters();
        this.m_tokenOffset_ = -1;
        this.m_tokenSize_ = -1;
        if (!this.m_returnDelimiters_) {
            this.m_nextOffset_ = this.getNextNonDelimiter(this.m_nextOffset_);
        }
        return this.nextToken();
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    @Override
    public Object nextElement() {
        return this.nextToken();
    }

    public int countTokens() {
        int n2 = 0;
        if (this.hasMoreTokens()) {
            if (this.m_tokenOffset_ >= 0) {
                return this.m_tokenSize_ - this.m_tokenOffset_;
            }
            if (this.m_tokenStart_ == null) {
                this.m_tokenStart_ = new int[100];
                this.m_tokenLimit_ = new int[100];
            }
            do {
                int n3;
                if (this.m_tokenStart_.length == n2) {
                    int[] nArray = this.m_tokenStart_;
                    int[] nArray2 = this.m_tokenLimit_;
                    n3 = nArray.length;
                    int n4 = n3 + 100;
                    this.m_tokenStart_ = new int[n4];
                    this.m_tokenLimit_ = new int[n4];
                    System.arraycopy(nArray, 0, this.m_tokenStart_, 0, n3);
                    System.arraycopy(nArray2, 0, this.m_tokenLimit_, 0, n3);
                }
                this.m_tokenStart_[n2] = this.m_nextOffset_;
                if (this.m_returnDelimiters_) {
                    boolean bl2;
                    int n5 = UTF16.charAt(this.m_source_, this.m_nextOffset_);
                    boolean bl3 = this.delims == null ? this.m_delimiters_.contains(n5) : (bl2 = n5 < this.delims.length && this.delims[n5]);
                    if (bl2) {
                        if (this.m_coalesceDelimiters_) {
                            this.m_tokenLimit_[n2] = this.getNextNonDelimiter(this.m_nextOffset_);
                        } else {
                            n3 = this.m_nextOffset_ + 1;
                            if (n3 == this.m_length_) {
                                n3 = -1;
                            }
                            this.m_tokenLimit_[n2] = n3;
                        }
                    } else {
                        this.m_tokenLimit_[n2] = this.getNextDelimiter(this.m_nextOffset_);
                    }
                    this.m_nextOffset_ = this.m_tokenLimit_[n2];
                } else {
                    this.m_tokenLimit_[n2] = this.getNextDelimiter(this.m_nextOffset_);
                    this.m_nextOffset_ = this.getNextNonDelimiter(this.m_tokenLimit_[n2]);
                }
                ++n2;
            } while (this.m_nextOffset_ >= 0);
            this.m_tokenOffset_ = 0;
            this.m_tokenSize_ = n2;
            this.m_nextOffset_ = this.m_tokenStart_[0];
        }
        return n2;
    }

    private int getNextDelimiter(int n2) {
        if (n2 >= 0) {
            int n3 = n2;
            int n4 = 0;
            if (this.delims == null) {
                while (!this.m_delimiters_.contains(n4 = UTF16.charAt(this.m_source_, n3)) && ++n3 < this.m_length_) {
                }
            } else {
                while (!((n4 = UTF16.charAt(this.m_source_, n3)) < this.delims.length && this.delims[n4] || ++n3 >= this.m_length_)) {
                }
            }
            if (n3 < this.m_length_) {
                return n3;
            }
        }
        return -1 - this.m_length_;
    }

    private int getNextNonDelimiter(int n2) {
        if (n2 >= 0) {
            int n3 = n2;
            int n4 = 0;
            if (this.delims == null) {
                while (this.m_delimiters_.contains(n4 = UTF16.charAt(this.m_source_, n3)) && ++n3 < this.m_length_) {
                }
            } else {
                while ((n4 = UTF16.charAt(this.m_source_, n3)) < this.delims.length && this.delims[n4] && ++n3 < this.m_length_) {
                }
            }
            if (n3 < this.m_length_) {
                return n3;
            }
        }
        return -1 - this.m_length_;
    }

    void checkDelimiters() {
        if (this.m_delimiters_ == null || this.m_delimiters_.size() == 0) {
            this.delims = new boolean[0];
        } else {
            int n2 = this.m_delimiters_.getRangeEnd(this.m_delimiters_.getRangeCount() - 1);
            if (n2 < 127) {
                int n3;
                this.delims = new boolean[n2 + 1];
                int n4 = 0;
                while (-1 != (n3 = this.m_delimiters_.charAt(n4))) {
                    this.delims[n3] = true;
                    ++n4;
                }
            } else {
                this.delims = null;
            }
        }
    }
}

