/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.DateRule;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.Range;

public class RangeDateRule
implements DateRule {
    List<Range> ranges = new ArrayList<Range>(2);

    public void add(DateRule dateRule) {
        this.add(new Date(Long.MIN_VALUE), dateRule);
    }

    public void add(Date date, DateRule dateRule) {
        this.ranges.add(new Range(date, dateRule));
    }

    @Override
    public Date firstAfter(Date date) {
        int n2 = this.startIndex(date);
        if (n2 == this.ranges.size()) {
            n2 = 0;
        }
        Date date2 = null;
        Range range = this.rangeAt(n2);
        Range range2 = this.rangeAt(n2 + 1);
        if (range != null && range.rule != null) {
            date2 = range2 != null ? range.rule.firstBetween(date, range2.start) : range.rule.firstAfter(date);
        }
        return date2;
    }

    @Override
    public Date firstBetween(Date date, Date date2) {
        if (date2 == null) {
            return this.firstAfter(date);
        }
        int n2 = this.startIndex(date);
        Date date3 = null;
        Range range = this.rangeAt(n2);
        while (date3 == null && range != null && !range.start.after(date2)) {
            Range range2 = range;
            range = this.rangeAt(n2 + 1);
            if (range2.rule == null) continue;
            Date date4 = range != null && !range.start.after(date2) ? range.start : date2;
            date3 = range2.rule.firstBetween(date, date4);
        }
        return date3;
    }

    @Override
    public boolean isOn(Date date) {
        Range range = this.rangeAt(this.startIndex(date));
        return range != null && range.rule != null && range.rule.isOn(date);
    }

    @Override
    public boolean isBetween(Date date, Date date2) {
        return this.firstBetween(date, date2) == null;
    }

    private int startIndex(Date date) {
        int n2 = this.ranges.size();
        int n3 = 0;
        while (n3 < this.ranges.size()) {
            Range range = this.ranges.get(n3);
            if (date.before(range.start)) break;
            n2 = n3++;
        }
        return n2;
    }

    private Range rangeAt(int n2) {
        return n2 < this.ranges.size() ? this.ranges.get(n2) : null;
    }
}

