/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.CalType;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.CalendarUtil;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUCache;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUResourceBundle;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.SimpleCache;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.SimpleFormatterImpl;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.SoftCache;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.DateFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.DateFormatSymbols;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.DateTimePatternGenerator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.SimpleDateFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.BasicTimeZone;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.BuddhistCalendar;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ChineseCalendar;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.CopticCalendar;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.DangiCalendar;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.EthiopicCalendar;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.GregorianCalendar;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.HebrewCalendar;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ICUCloneNotSupportedException;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.IndianCalendar;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.IslamicCalendar;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.JapaneseCalendar;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.PersianCalendar;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.TaiwanCalendar;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.TimeZone;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.TimeZoneTransition;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.UResourceBundle;

public abstract class Calendar
implements Serializable,
Cloneable,
Comparable<Calendar> {
    public static final int ERA = 0;
    public static final int YEAR = 1;
    public static final int MONTH = 2;
    public static final int WEEK_OF_YEAR = 3;
    public static final int WEEK_OF_MONTH = 4;
    public static final int DATE = 5;
    public static final int DAY_OF_MONTH = 5;
    public static final int DAY_OF_YEAR = 6;
    public static final int DAY_OF_WEEK = 7;
    public static final int DAY_OF_WEEK_IN_MONTH = 8;
    public static final int AM_PM = 9;
    public static final int HOUR = 10;
    public static final int HOUR_OF_DAY = 11;
    public static final int MINUTE = 12;
    public static final int SECOND = 13;
    public static final int MILLISECOND = 14;
    public static final int ZONE_OFFSET = 15;
    public static final int DST_OFFSET = 16;
    public static final int YEAR_WOY = 17;
    public static final int DOW_LOCAL = 18;
    public static final int EXTENDED_YEAR = 19;
    public static final int JULIAN_DAY = 20;
    public static final int MILLISECONDS_IN_DAY = 21;
    public static final int IS_LEAP_MONTH = 22;
    public static final int ORDINAL_MONTH = 23;
    @Deprecated
    protected static final int BASE_FIELD_COUNT = 24;
    @Deprecated
    protected static final int MAX_FIELD_COUNT = 32;
    public static final int SUNDAY = 1;
    public static final int MONDAY = 2;
    public static final int TUESDAY = 3;
    public static final int WEDNESDAY = 4;
    public static final int THURSDAY = 5;
    public static final int FRIDAY = 6;
    public static final int SATURDAY = 7;
    public static final int JANUARY = 0;
    public static final int FEBRUARY = 1;
    public static final int MARCH = 2;
    public static final int APRIL = 3;
    public static final int MAY = 4;
    public static final int JUNE = 5;
    public static final int JULY = 6;
    public static final int AUGUST = 7;
    public static final int SEPTEMBER = 8;
    public static final int OCTOBER = 9;
    public static final int NOVEMBER = 10;
    public static final int DECEMBER = 11;
    public static final int UNDECIMBER = 12;
    public static final int AM = 0;
    public static final int PM = 1;
    @Deprecated
    public static final int WEEKDAY = 0;
    @Deprecated
    public static final int WEEKEND = 1;
    @Deprecated
    public static final int WEEKEND_ONSET = 2;
    @Deprecated
    public static final int WEEKEND_CEASE = 3;
    public static final int WALLTIME_LAST = 0;
    public static final int WALLTIME_FIRST = 1;
    public static final int WALLTIME_NEXT_VALID = 2;
    protected static final int ONE_SECOND = 1000;
    protected static final int ONE_MINUTE = 60000;
    protected static final int ONE_HOUR = 3600000;
    protected static final long ONE_DAY = 86400000L;
    protected static final long ONE_WEEK = 604800000L;
    protected static final int JAN_1_1_JULIAN_DAY = 1721426;
    protected static final int EPOCH_JULIAN_DAY = 2440588;
    protected static final int MIN_JULIAN = -2130706432;
    protected static final long MIN_MILLIS = -184303902528000000L;
    protected static final Date MIN_DATE = new Date(-184303902528000000L);
    protected static final int MAX_JULIAN = 0x7F000000;
    protected static final long MAX_MILLIS = 183882168921600000L;
    protected static final Date MAX_DATE = new Date(183882168921600000L);
    private static final int MAX_HOURS = 548;
    private transient int[] fields;
    private transient int[] stamp;
    private long time;
    private transient boolean isTimeSet;
    private transient boolean areFieldsSet;
    private transient boolean areAllFieldsSet;
    private transient boolean areFieldsVirtuallySet;
    private boolean lenient = true;
    private TimeZone zone;
    private int firstDayOfWeek;
    private int minimalDaysInFirstWeek;
    private int weekendOnset;
    private int weekendOnsetMillis;
    private int weekendCease;
    private int weekendCeaseMillis;
    private int repeatedWallTime = 0;
    private int skippedWallTime = 0;
    protected static final int UNSET = 0;
    protected static final int INTERNALLY_SET = 1;
    protected static final int MINIMUM_USER_STAMP = 2;
    private transient int nextStamp = 2;
    private static int STAMP_MAX = 10000;
    private static final long serialVersionUID = 6222646104888790989L;
    private transient int internalSetMask;
    private transient int gregorianYear;
    private transient int gregorianMonth;
    private transient int gregorianDayOfYear;
    private transient int gregorianDayOfMonth;
    private static String[] gTemporalMonthCodes = new String[]{"M01", "M02", "M03", "M04", "M05", "M06", "M07", "M08", "M09", "M10", "M11", "M12"};
    private static final ICUCache<String, PatternData> PATTERN_CACHE = new SimpleCache<String, PatternData>();
    private static final String[] DEFAULT_PATTERNS = new String[]{"HH:mm:ss z", "HH:mm:ss z", "HH:mm:ss", "HH:mm", "y MMMM d, EEEE", "y MMMM d", "y MMM d", "y-MM-dd", "{1} {0}", "{1} {0}", "{1} {0}", "{1} {0}", "{1} {0}"};
    private static final String[] DEFAULT_ATTIME_PATTERNS = new String[]{"{1} {0}", "{1} {0}", "{1} {0}", "{1} {0}"};
    private static final String[] TIME_SKELETONS = new String[]{"jmmsszzzz", "jmmssz", "jmmss", "jmm"};
    private static final char QUOTE = '\'';
    private static final int FIELD_DIFF_MAX_INT = Integer.MAX_VALUE;
    private static final int[][] LIMITS = new int[][]{new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], {1, 1, 7, 7}, new int[0], {0, 0, 1, 1}, {0, 0, 11, 11}, {0, 0, 23, 23}, {0, 0, 59, 59}, {0, 0, 59, 59}, {0, 0, 999, 999}, {-86400000, -57600000, 43200000, 108000000}, {0, 0, 0x6DDD00, 0x6DDD00}, new int[0], {1, 1, 7, 7}, new int[0], {-2130706432, -2130706432, 0x7F000000, 0x7F000000}, {0, 0, 86399999, 86399999}, {0, 0, 1, 1}, {0, 0, 12, 12}};
    protected static final int MINIMUM = 0;
    protected static final int GREATEST_MINIMUM = 1;
    protected static final int LEAST_MAXIMUM = 2;
    protected static final int MAXIMUM = 3;
    private static final WeekDataCache WEEK_DATA_CACHE = new WeekDataCache();
    protected static final int RESOLVE_REMAP = 32;
    static final int[][][] DATE_PRECEDENCE = new int[][][]{new int[][]{{5}, {3, 7}, {4, 7}, {8, 7}, {3, 18}, {4, 18}, {8, 18}, {6}, {37, 1}, {35, 17}}, new int[][]{{3}, {4}, {8}, {40, 7}, {40, 18}}};
    static final int[][][] DOW_PRECEDENCE = new int[][][]{new int[][]{{7}, {18}}};
    static final int[][][] MONTH_PRECEDENCE = new int[][][]{new int[][]{{2}, {23}}};
    private static final int[] FIND_ZONE_TRANSITION_TIME_UNITS = new int[]{3600000, 1800000, 60000, 1000};
    private static final int[][] GREGORIAN_MONTH_COUNT = new int[][]{{31, 31, 0, 0}, {28, 29, 31, 31}, {31, 31, 59, 60}, {30, 30, 90, 91}, {31, 31, 120, 121}, {30, 30, 151, 152}, {31, 31, 181, 182}, {31, 31, 212, 213}, {30, 30, 243, 244}, {31, 31, 273, 274}, {30, 30, 304, 305}, {31, 31, 334, 335}};
    private static final String[] FIELD_NAME = new String[]{"ERA", "YEAR", "MONTH", "WEEK_OF_YEAR", "WEEK_OF_MONTH", "DAY_OF_MONTH", "DAY_OF_YEAR", "DAY_OF_WEEK", "DAY_OF_WEEK_IN_MONTH", "AM_PM", "HOUR", "HOUR_OF_DAY", "MINUTE", "SECOND", "MILLISECOND", "ZONE_OFFSET", "DST_OFFSET", "YEAR_WOY", "DOW_LOCAL", "EXTENDED_YEAR", "JULIAN_DAY", "MILLISECONDS_IN_DAY", "IS_LEAP_MONTH", "ORDINAL_MONTH"};
    private ULocale validLocale;
    private ULocale actualLocale;

    protected Calendar() {
        this(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT));
    }

    protected Calendar(TimeZone timeZone, Locale locale) {
        this(timeZone, ULocale.forLocale(locale));
    }

    protected Calendar(TimeZone timeZone, ULocale uLocale) {
        this.zone = timeZone;
        this.setWeekData(Calendar.getRegionForCalendar(uLocale));
        String string = uLocale.getKeywordValue("fw");
        if (string != null) {
            int n2;
            switch (string) {
                case "sun": {
                    n2 = 1;
                    break;
                }
                case "mon": {
                    n2 = 2;
                    break;
                }
                case "tue": {
                    n2 = 3;
                    break;
                }
                case "wed": {
                    n2 = 4;
                    break;
                }
                case "thu": {
                    n2 = 5;
                    break;
                }
                case "fri": {
                    n2 = 6;
                    break;
                }
                case "sat": {
                    n2 = 7;
                    break;
                }
                default: {
                    n2 = -1;
                }
            }
            if (n2 != -1) {
                this.setFirstDayOfWeek(n2);
            }
        }
        this.setCalendarLocale(uLocale);
        this.initInternal();
    }

    private void setCalendarLocale(ULocale uLocale) {
        ULocale uLocale2 = uLocale;
        if (uLocale.getVariant().length() != 0 || uLocale.getKeywords() != null) {
            String string;
            String string2;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(uLocale.getLanguage());
            String string3 = uLocale.getScript();
            if (string3.length() > 0) {
                stringBuilder.append("_").append(string3);
            }
            if ((string2 = uLocale.getCountry()).length() > 0) {
                stringBuilder.append("_").append(string2);
            }
            if ((string = uLocale.getKeywordValue("calendar")) != null) {
                stringBuilder.append("@calendar=").append(string);
            }
            uLocale2 = new ULocale(stringBuilder.toString());
        }
        this.setLocale(uLocale2, uLocale2);
    }

    private void recalculateStamp() {
        this.nextStamp = 1;
        for (int i2 = 0; i2 < this.stamp.length; ++i2) {
            int n2 = STAMP_MAX;
            int n3 = -1;
            for (int i3 = 0; i3 < this.stamp.length; ++i3) {
                if (this.stamp[i3] <= this.nextStamp || this.stamp[i3] >= n2) continue;
                n2 = this.stamp[i3];
                n3 = i3;
            }
            if (n3 < 0) break;
            this.stamp[n3] = ++this.nextStamp;
        }
        ++this.nextStamp;
    }

    private void initInternal() {
        this.fields = this.handleCreateFields();
        if (this.fields == null || this.fields.length < 24 || this.fields.length > 32) {
            throw new IllegalStateException("Invalid fields[]");
        }
        this.stamp = new int[this.fields.length];
        int n2 = 13107303;
        for (int i2 = 24; i2 < this.fields.length; ++i2) {
            n2 |= 1 << i2;
        }
        this.internalSetMask = n2;
    }

    public static Calendar getInstance() {
        return Calendar.getInstanceInternal(null, null);
    }

    public static Calendar getInstance(TimeZone timeZone) {
        return Calendar.getInstanceInternal(timeZone, null);
    }

    public static Calendar getInstance(Locale locale) {
        return Calendar.getInstanceInternal(null, ULocale.forLocale(locale));
    }

    public static Calendar getInstance(ULocale uLocale) {
        return Calendar.getInstanceInternal(null, uLocale);
    }

    public static Calendar getInstance(TimeZone timeZone, Locale locale) {
        return Calendar.getInstanceInternal(timeZone, ULocale.forLocale(locale));
    }

    public static Calendar getInstance(TimeZone timeZone, ULocale uLocale) {
        return Calendar.getInstanceInternal(timeZone, uLocale);
    }

    private static Calendar getInstanceInternal(TimeZone timeZone, ULocale uLocale) {
        if (uLocale == null) {
            uLocale = ULocale.getDefault(ULocale.Category.FORMAT);
        }
        if (timeZone == null) {
            timeZone = TimeZone.forULocaleOrDefault(uLocale);
        }
        Calendar calendar = Calendar.createInstance(uLocale);
        calendar.setTimeZone(timeZone);
        calendar.setTimeInMillis(System.currentTimeMillis());
        return calendar;
    }

    private static String getRegionForCalendar(ULocale uLocale) {
        String string = ULocale.getRegionForSupplementalData(uLocale, true);
        if (string.length() == 0) {
            string = "001";
        }
        return string;
    }

    private static CalType getCalendarTypeForLocale(ULocale uLocale) {
        String string = CalendarUtil.getCalendarType(uLocale);
        if (string != null) {
            string = string.toLowerCase(Locale.ENGLISH);
            for (CalType calType : CalType.values()) {
                if (!string.equals(calType.getId())) continue;
                return calType;
            }
        }
        return null;
    }

    private static Calendar createInstance(ULocale uLocale) {
        Calendar calendar = null;
        TimeZone timeZone = TimeZone.forULocaleOrDefault(uLocale);
        CalType calType = Calendar.getCalendarTypeForLocale(uLocale);
        if (calType == null) {
            calType = CalType.GREGORIAN;
        }
        switch (calType) {
            case GREGORIAN: {
                calendar = new GregorianCalendar(timeZone, uLocale);
                break;
            }
            case ISO8601: {
                calendar = new GregorianCalendar(timeZone, uLocale);
                if (uLocale.getUnicodeLocaleType("fw") == null && uLocale.getUnicodeLocaleType("rg") == null) {
                    calendar.setFirstDayOfWeek(2);
                }
                calendar.setMinimalDaysInFirstWeek(4);
                break;
            }
            case BUDDHIST: {
                calendar = new BuddhistCalendar(timeZone, uLocale);
                break;
            }
            case CHINESE: {
                calendar = new ChineseCalendar(timeZone, uLocale);
                break;
            }
            case COPTIC: {
                calendar = new CopticCalendar(timeZone, uLocale);
                break;
            }
            case DANGI: {
                calendar = new DangiCalendar(timeZone, uLocale);
                break;
            }
            case ETHIOPIC: {
                calendar = new EthiopicCalendar(timeZone, uLocale);
                break;
            }
            case ETHIOPIC_AMETE_ALEM: {
                calendar = new EthiopicCalendar(timeZone, uLocale);
                ((EthiopicCalendar)calendar).setAmeteAlemEra(true);
                break;
            }
            case HEBREW: {
                calendar = new HebrewCalendar(timeZone, uLocale);
                break;
            }
            case INDIAN: {
                calendar = new IndianCalendar(timeZone, uLocale);
                break;
            }
            case ISLAMIC_CIVIL: 
            case ISLAMIC_UMALQURA: 
            case ISLAMIC_TBLA: 
            case ISLAMIC_RGSA: 
            case ISLAMIC: {
                calendar = new IslamicCalendar(timeZone, uLocale);
                break;
            }
            case JAPANESE: {
                calendar = new JapaneseCalendar(timeZone, uLocale);
                break;
            }
            case PERSIAN: {
                calendar = new PersianCalendar(timeZone, uLocale);
                break;
            }
            case ROC: {
                calendar = new TaiwanCalendar(timeZone, uLocale);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown calendar type");
            }
        }
        return calendar;
    }

    public static Locale[] getAvailableLocales() {
        return ICUResourceBundle.getAvailableLocales();
    }

    public static ULocale[] getAvailableULocales() {
        return ICUResourceBundle.getAvailableULocales();
    }

    public static final String[] getKeywordValuesForLocale(String string, ULocale uLocale, boolean bl2) {
        String string2 = ULocale.getRegionForSupplementalData(uLocale, true);
        ArrayList<String> arrayList = new ArrayList<String>();
        UResourceBundle uResourceBundle = UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b", "supplementalData", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        UResourceBundle uResourceBundle2 = uResourceBundle.get("calendarPreferenceData");
        UResourceBundle uResourceBundle3 = null;
        try {
            uResourceBundle3 = uResourceBundle2.get(string2);
        }
        catch (MissingResourceException missingResourceException) {
            uResourceBundle3 = uResourceBundle2.get("001");
        }
        String[] stringArray = uResourceBundle3.getStringArray();
        if (bl2) {
            return stringArray;
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            arrayList.add(stringArray[i2]);
        }
        for (CalType calType : CalType.values()) {
            if (arrayList.contains(calType.getId())) continue;
            arrayList.add(calType.getId());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public final Date getTime() {
        return new Date(this.getTimeInMillis());
    }

    public final void setTime(Date date) {
        this.setTimeInMillis(date.getTime());
    }

    public long getTimeInMillis() {
        if (!this.isTimeSet) {
            this.updateTime();
        }
        return this.time;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTimeInMillis(long l2) {
        if (l2 > 183882168921600000L) {
            if (!this.isLenient()) throw new IllegalArgumentException("millis value greater than upper bounds for a Calendar : " + l2);
            l2 = 183882168921600000L;
        } else if (l2 < -184303902528000000L) {
            if (!this.isLenient()) throw new IllegalArgumentException("millis value less than lower bounds for a Calendar : " + l2);
            l2 = -184303902528000000L;
        }
        this.time = l2;
        this.areAllFieldsSet = false;
        this.areFieldsSet = false;
        this.areFieldsVirtuallySet = true;
        this.isTimeSet = true;
        for (int i2 = 0; i2 < this.fields.length; ++i2) {
            this.stamp[i2] = 0;
            this.fields[i2] = 0;
        }
    }

    public boolean inTemporalLeapYear() {
        return this.getActualMaximum(6) == 366;
    }

    public String getTemporalMonthCode() {
        int n2 = this.get(2);
        assert (n2 < 12);
        assert (this.internalGet(22) == 0);
        return gTemporalMonthCodes[n2];
    }

    public void setTemporalMonthCode(String string) {
        if (string.length() == 3 && string.charAt(0) == 'M') {
            for (int i2 = 0; i2 < gTemporalMonthCodes.length; ++i2) {
                if (!string.equals(gTemporalMonthCodes[i2])) continue;
                this.set(2, i2);
                this.set(22, 0);
                return;
            }
        }
        throw new IllegalArgumentException("Incorrect temporal Month code: " + string);
    }

    public final int get(int n2) {
        this.complete();
        return this.fields[n2];
    }

    protected final int internalGet(int n2) {
        return this.fields[n2];
    }

    protected final int internalGet(int n2, int n3) {
        return this.stamp[n2] > 0 ? this.fields[n2] : n3;
    }

    @Deprecated
    protected int internalGetMonth() {
        if (this.resolveFields(MONTH_PRECEDENCE) == 2) {
            return this.internalGet(2);
        }
        return this.internalGet(23);
    }

    @Deprecated
    protected int internalGetMonth(int n2) {
        if (this.resolveFields(MONTH_PRECEDENCE) == 2) {
            return this.internalGet(2, n2);
        }
        return this.internalGet(23, n2);
    }

    public final void set(int n2, int n3) {
        if (this.areFieldsVirtuallySet) {
            this.computeFields();
        }
        this.fields[n2] = n3;
        if (this.nextStamp == STAMP_MAX) {
            this.recalculateStamp();
        }
        ++this.nextStamp;
        this.areFieldsVirtuallySet = false;
        this.areFieldsSet = false;
        this.isTimeSet = false;
    }

    public final void set(int n2, int n3, int n4) {
        this.set(1, n2);
        this.set(2, n3);
        this.set(5, n4);
    }

    public final void set(int n2, int n3, int n4, int n5, int n6) {
        this.set(1, n2);
        this.set(2, n3);
        this.set(5, n4);
        this.set(11, n5);
        this.set(12, n6);
    }

    public final void set(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.set(1, n2);
        this.set(2, n3);
        this.set(5, n4);
        this.set(11, n5);
        this.set(12, n6);
        this.set(13, n7);
    }

    private static int gregoYearFromIslamicStart(int n2) {
        int n3 = 0;
        if (n2 >= 1397) {
            int n4 = (n2 - 1397) / 67;
            int n5 = (n2 - 1397) % 67;
            n3 = 2 * n4 + (n5 >= 33 ? 1 : 0);
        } else {
            int n6 = (n2 - 1396) / 67 - 1;
            int n7 = -(n2 - 1396) % 67;
            n3 = 2 * n6 + (n7 <= 33 ? 1 : 0);
        }
        return n2 + 579 - n3;
    }

    @Deprecated
    public final int getRelatedYear() {
        int n2 = this.get(19);
        CalType calType = CalType.GREGORIAN;
        String string = this.getType();
        for (CalType calType2 : CalType.values()) {
            if (!string.equals(calType2.getId())) continue;
            calType = calType2;
            break;
        }
        switch (calType) {
            case PERSIAN: {
                n2 += 622;
                break;
            }
            case HEBREW: {
                n2 -= 3760;
                break;
            }
            case CHINESE: {
                n2 -= 2637;
                break;
            }
            case INDIAN: {
                n2 += 79;
                break;
            }
            case COPTIC: {
                n2 += 284;
                break;
            }
            case ETHIOPIC: {
                n2 += 8;
                break;
            }
            case ETHIOPIC_AMETE_ALEM: {
                n2 -= 5492;
                break;
            }
            case DANGI: {
                n2 -= 2333;
                break;
            }
            case ISLAMIC_CIVIL: 
            case ISLAMIC_UMALQURA: 
            case ISLAMIC_TBLA: 
            case ISLAMIC_RGSA: 
            case ISLAMIC: {
                n2 = Calendar.gregoYearFromIslamicStart(n2);
                break;
            }
        }
        return n2;
    }

    private static int firstIslamicStartYearFromGrego(int n2) {
        int n3 = 0;
        if (n2 >= 1977) {
            int n4 = (n2 - 1977) / 65;
            int n5 = (n2 - 1977) % 65;
            n3 = 2 * n4 + (n5 >= 32 ? 1 : 0);
        } else {
            int n6 = (n2 - 1976) / 65 - 1;
            int n7 = -(n2 - 1976) % 65;
            n3 = 2 * n6 + (n7 <= 32 ? 1 : 0);
        }
        return n2 - 579 + n3;
    }

    @Deprecated
    public final void setRelatedYear(int n2) {
        CalType calType = CalType.GREGORIAN;
        String string = this.getType();
        for (CalType calType2 : CalType.values()) {
            if (!string.equals(calType2.getId())) continue;
            calType = calType2;
            break;
        }
        switch (calType) {
            case PERSIAN: {
                n2 -= 622;
                break;
            }
            case HEBREW: {
                n2 += 3760;
                break;
            }
            case CHINESE: {
                n2 += 2637;
                break;
            }
            case INDIAN: {
                n2 -= 79;
                break;
            }
            case COPTIC: {
                n2 -= 284;
                break;
            }
            case ETHIOPIC: {
                n2 -= 8;
                break;
            }
            case ETHIOPIC_AMETE_ALEM: {
                n2 += 5492;
                break;
            }
            case DANGI: {
                n2 += 2333;
                break;
            }
            case ISLAMIC_CIVIL: 
            case ISLAMIC_UMALQURA: 
            case ISLAMIC_TBLA: 
            case ISLAMIC_RGSA: 
            case ISLAMIC: {
                n2 = Calendar.firstIslamicStartYearFromGrego(n2);
                break;
            }
        }
        this.set(19, n2);
    }

    public final void clear() {
        for (int i2 = 0; i2 < this.fields.length; ++i2) {
            this.stamp[i2] = 0;
            this.fields[i2] = 0;
        }
        this.areFieldsVirtuallySet = false;
        this.areAllFieldsSet = false;
        this.areFieldsSet = false;
        this.isTimeSet = false;
    }

    public final void clear(int n2) {
        if (this.areFieldsVirtuallySet) {
            this.computeFields();
        }
        this.fields[n2] = 0;
        this.stamp[n2] = 0;
        if (n2 == 2) {
            this.fields[23] = 0;
            this.stamp[23] = 0;
        }
        if (n2 == 23) {
            this.fields[2] = 0;
            this.stamp[2] = 0;
        }
        this.areFieldsVirtuallySet = false;
        this.areAllFieldsSet = false;
        this.areFieldsSet = false;
        this.isTimeSet = false;
    }

    public final boolean isSet(int n2) {
        return this.areFieldsVirtuallySet || this.stamp[n2] != 0;
    }

    protected void complete() {
        if (!this.isTimeSet) {
            this.updateTime();
        }
        if (!this.areFieldsSet) {
            this.computeFields();
            this.areFieldsSet = true;
            this.areAllFieldsSet = true;
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Calendar calendar = (Calendar)object;
        return this.isEquivalentTo(calendar) && this.getTimeInMillis() == calendar.getTime().getTime();
    }

    public boolean isEquivalentTo(Calendar calendar) {
        return this.getClass() == calendar.getClass() && this.isLenient() == calendar.isLenient() && this.getFirstDayOfWeek() == calendar.getFirstDayOfWeek() && this.getMinimalDaysInFirstWeek() == calendar.getMinimalDaysInFirstWeek() && this.getTimeZone().equals(calendar.getTimeZone()) && this.getRepeatedWallTimeOption() == calendar.getRepeatedWallTimeOption() && this.getSkippedWallTimeOption() == calendar.getSkippedWallTimeOption();
    }

    public int hashCode() {
        return (this.lenient ? 1 : 0) | this.firstDayOfWeek << 1 | this.minimalDaysInFirstWeek << 4 | this.repeatedWallTime << 7 | this.skippedWallTime << 9 | this.zone.hashCode() << 11;
    }

    private long compare(Object object) {
        long l2;
        if (object instanceof Calendar) {
            l2 = ((Calendar)object).getTimeInMillis();
        } else if (object instanceof Date) {
            l2 = ((Date)object).getTime();
        } else {
            throw new IllegalArgumentException(object + "is not a Calendar or Date");
        }
        return this.getTimeInMillis() - l2;
    }

    public boolean before(Object object) {
        return this.compare(object) < 0L;
    }

    public boolean after(Object object) {
        return this.compare(object) > 0L;
    }

    public int getActualMaximum(int n2) {
        int n3;
        switch (n2) {
            case 5: {
                Calendar calendar = (Calendar)this.clone();
                calendar.setLenient(true);
                calendar.prepareGetActual(n2, false);
                n3 = this.handleGetMonthLength(calendar.get(19), calendar.get(2));
                break;
            }
            case 6: {
                Calendar calendar = (Calendar)this.clone();
                calendar.setLenient(true);
                calendar.prepareGetActual(n2, false);
                n3 = this.handleGetYearLength(calendar.get(19));
                break;
            }
            case 0: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 21: {
                n3 = this.getMaximum(n2);
                break;
            }
            case 23: {
                n3 = this.inTemporalLeapYear() ? this.getMaximum(23) : this.getLeastMaximum(23);
                break;
            }
            default: {
                n3 = this.getActualHelper(n2, this.getLeastMaximum(n2), this.getMaximum(n2));
            }
        }
        return n3;
    }

    public int getActualMinimum(int n2) {
        int n3;
        switch (n2) {
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 21: {
                n3 = this.getMinimum(n2);
                break;
            }
            default: {
                n3 = this.getActualHelper(n2, this.getGreatestMinimum(n2), this.getMinimum(n2));
            }
        }
        return n3;
    }

    protected void prepareGetActual(int n2, boolean bl2) {
        this.set(21, 0);
        switch (n2) {
            case 1: 
            case 19: {
                this.set(6, this.getGreatestMinimum(6));
                break;
            }
            case 17: {
                this.set(3, this.getGreatestMinimum(3));
                break;
            }
            case 2: {
                this.set(5, this.getGreatestMinimum(5));
                break;
            }
            case 8: {
                this.set(5, 1);
                this.set(7, this.get(7));
                break;
            }
            case 3: 
            case 4: {
                int n3 = this.firstDayOfWeek;
                if (bl2 && (n3 = (n3 + 6) % 7) < 1) {
                    n3 += 7;
                }
                this.set(7, n3);
            }
        }
        this.set(n2, this.getGreatestMinimum(n2));
    }

    private int getActualHelper(int n2, int n3, int n4) {
        if (n3 == n4) {
            return n3;
        }
        int n5 = n4 > n3 ? 1 : -1;
        Calendar calendar = (Calendar)this.clone();
        calendar.complete();
        calendar.setLenient(true);
        calendar.prepareGetActual(n2, n5 < 0);
        calendar.set(n2, n3);
        if (calendar.get(n2) != n3 && n2 != 4 && n5 > 0) {
            return n3;
        }
        int n6 = n3;
        do {
            calendar.add(n2, n5);
            if (calendar.get(n2) != (n3 += n5)) break;
            n6 = n3;
        } while (n3 != n4);
        return n6;
    }

    public final void roll(int n2, boolean bl2) {
        this.roll(n2, bl2 ? 1 : -1);
    }

    public void roll(int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        this.complete();
        switch (n2) {
            case 0: 
            case 5: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 21: {
                int n4 = this.getActualMinimum(n2);
                int n5 = this.getActualMaximum(n2);
                int n6 = n5 - n4 + 1;
                int n7 = this.internalGet(n2) + n3;
                n7 = (n7 - n4) % n6;
                if (n7 < 0) {
                    n7 += n6;
                }
                this.set(n2, n7 += n4);
                return;
            }
            case 10: 
            case 11: {
                long l2 = this.getTimeInMillis();
                int n8 = this.internalGet(n2);
                int n9 = this.getMaximum(n2);
                int n10 = (n8 + n3) % (n9 + 1);
                if (n10 < 0) {
                    n10 += n9 + 1;
                }
                this.setTimeInMillis(l2 + 3600000L * ((long)n10 - (long)n8));
                return;
            }
            case 2: 
            case 23: {
                int n11 = this.getActualMaximum(2);
                int n12 = (this.internalGetMonth() + n3) % (n11 + 1);
                if (n12 < 0) {
                    n12 += n11 + 1;
                }
                this.set(2, n12);
                this.pinField(5);
                return;
            }
            case 1: 
            case 17: {
                int n13 = this.get(0);
                if (n13 == 0 && this.isEra0CountingBackward()) {
                    n3 = -n3;
                }
                int n14 = this.internalGet(n2) + n3;
                if (n13 > 0 || n14 >= 1) {
                    int n15 = this.getActualMaximum(n2);
                    if (n15 < 32768) {
                        if (n14 < 1) {
                            n14 = n15 - -n14 % n15;
                        } else if (n14 > n15) {
                            n14 = (n14 - 1) % n15 + 1;
                        }
                    } else if (n14 < 1) {
                        n14 = 1;
                    }
                } else if (n13 == 0 && this.isEra0CountingBackward()) {
                    n14 = 1;
                }
                this.set(n2, n14);
                this.pinField(2);
                this.pinField(5);
                return;
            }
            case 19: {
                this.set(n2, this.internalGet(n2) + n3);
                this.pinField(2);
                this.pinField(5);
                return;
            }
            case 4: {
                int n16;
                int n17 = this.internalGet(7) - this.getFirstDayOfWeek();
                if (n17 < 0) {
                    n17 += 7;
                }
                if ((n16 = (n17 - this.internalGet(5) + 1) % 7) < 0) {
                    n16 += 7;
                }
                int n18 = 7 - n16 < this.getMinimalDaysInFirstWeek() ? 8 - n16 : 1 - n16;
                int n19 = this.getActualMaximum(5);
                int n20 = (n19 - this.internalGet(5) + n17) % 7;
                int n21 = n19 + 7 - n20;
                int n22 = n21 - n18;
                int n23 = (this.internalGet(5) + n3 * 7 - n18) % n22;
                if (n23 < 0) {
                    n23 += n22;
                }
                if ((n23 += n18) < 1) {
                    n23 = 1;
                }
                if (n23 > n19) {
                    n23 = n19;
                }
                this.set(5, n23);
                return;
            }
            case 3: {
                int n24;
                int n25 = this.internalGet(7) - this.getFirstDayOfWeek();
                if (n25 < 0) {
                    n25 += 7;
                }
                if ((n24 = (n25 - this.internalGet(6) + 1) % 7) < 0) {
                    n24 += 7;
                }
                int n26 = 7 - n24 < this.getMinimalDaysInFirstWeek() ? 8 - n24 : 1 - n24;
                int n27 = this.getActualMaximum(6);
                int n28 = (n27 - this.internalGet(6) + n25) % 7;
                int n29 = n27 + 7 - n28;
                int n30 = n29 - n26;
                int n31 = (this.internalGet(6) + n3 * 7 - n26) % n30;
                if (n31 < 0) {
                    n31 += n30;
                }
                if ((n31 += n26) < 1) {
                    n31 = 1;
                }
                if (n31 > n27) {
                    n31 = n27;
                }
                this.set(6, n31);
                this.clear(2);
                this.clear(23);
                return;
            }
            case 6: {
                long l3 = (long)n3 * 86400000L;
                long l4 = this.time - (long)(this.internalGet(6) - 1) * 86400000L;
                int n32 = this.getActualMaximum(6);
                this.time = (this.time + l3 - l4) % ((long)n32 * 86400000L);
                if (this.time < 0L) {
                    this.time += (long)n32 * 86400000L;
                }
                this.setTimeInMillis(this.time + l4);
                return;
            }
            case 7: 
            case 18: {
                long l5 = (long)n3 * 86400000L;
                int n33 = this.internalGet(n2);
                if ((n33 -= n2 == 7 ? this.getFirstDayOfWeek() : 1) < 0) {
                    n33 += 7;
                }
                long l6 = this.time - (long)n33 * 86400000L;
                this.time = (this.time + l5 - l6) % 604800000L;
                if (this.time < 0L) {
                    this.time += 604800000L;
                }
                this.setTimeInMillis(this.time + l6);
                return;
            }
            case 8: {
                long l7 = (long)n3 * 604800000L;
                int n34 = (this.internalGet(5) - 1) / 7;
                int n35 = (this.getActualMaximum(5) - this.internalGet(5)) / 7;
                long l8 = this.time - (long)n34 * 604800000L;
                long l9 = 604800000L * (long)(n34 + n35 + 1);
                this.time = (this.time + l7 - l8) % l9;
                if (this.time < 0L) {
                    this.time += l9;
                }
                this.setTimeInMillis(this.time + l8);
                return;
            }
            case 20: {
                this.set(n2, this.internalGet(n2) + n3);
                return;
            }
        }
        throw new IllegalArgumentException("Calendar.roll(" + this.fieldName(n2) + ") not supported");
    }

    public void add(int n2, int n3) {
        int n4;
        int n5;
        if (n3 == 0) {
            return;
        }
        long l2 = n3;
        boolean bl2 = true;
        switch (n2) {
            case 0: {
                this.set(n2, this.get(n2) + n3);
                this.pinField(0);
                return;
            }
            case 1: 
            case 17: {
                int bl3 = this.get(0);
                if (bl3 == 0 && this.isEra0CountingBackward()) {
                    n3 = -n3;
                }
            }
            case 2: 
            case 19: 
            case 23: {
                boolean n52 = this.isLenient();
                this.setLenient(true);
                this.set(n2, this.get(n2) + n3);
                this.pinField(5);
                if (!n52) {
                    this.complete();
                    this.setLenient(n52);
                }
                return;
            }
            case 3: 
            case 4: 
            case 8: {
                l2 *= 604800000L;
                break;
            }
            case 9: {
                l2 *= 43200000L;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 18: 
            case 20: {
                l2 *= 86400000L;
                break;
            }
            case 10: 
            case 11: {
                l2 *= 3600000L;
                bl2 = false;
                break;
            }
            case 12: {
                l2 *= 60000L;
                bl2 = false;
                break;
            }
            case 13: {
                l2 *= 1000L;
                bl2 = false;
                break;
            }
            case 14: 
            case 21: {
                bl2 = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Calendar.add(" + this.fieldName(n2) + ") not supported");
            }
        }
        boolean bl3 = false;
        int n6 = 0;
        if (bl2) {
            n5 = this.get(16) + this.get(15);
            n6 = this.get(21);
        }
        this.setTimeInMillis(this.getTimeInMillis() + l2);
        if (bl2 && (n4 = this.get(21)) != n6) {
            long l3 = this.internalGetTimeInMillis();
            int n7 = this.get(16) + this.get(15);
            if (n7 != n5) {
                long l4 = (long)(n5 - n7) % 86400000L;
                if (l4 != 0L) {
                    this.setTimeInMillis(l3 + l4);
                    n4 = this.get(21);
                }
                if (n4 != n6) {
                    switch (this.skippedWallTime) {
                        case 1: {
                            if (l4 <= 0L) break;
                            this.setTimeInMillis(l3);
                            break;
                        }
                        case 0: {
                            if (l4 >= 0L) break;
                            this.setTimeInMillis(l3);
                            break;
                        }
                        case 2: {
                            long l5 = l4 > 0L ? this.internalGetTimeInMillis() : l3;
                            Long l6 = this.getImmediatePreviousZoneTransition(l5);
                            if (l6 != null) {
                                this.setTimeInMillis(l6);
                                break;
                            }
                            throw new RuntimeException("Could not locate a time zone transition before " + l5);
                        }
                    }
                }
            }
        }
    }

    public String getDisplayName(Locale locale) {
        return this.getClass().getName();
    }

    public String getDisplayName(ULocale uLocale) {
        return this.getClass().getName();
    }

    @Override
    public int compareTo(Calendar calendar) {
        long l2 = this.getTimeInMillis() - calendar.getTimeInMillis();
        return l2 < 0L ? -1 : (l2 > 0L ? 1 : 0);
    }

    public DateFormat getDateTimeFormat(int n2, int n3, Locale locale) {
        return Calendar.formatHelper(this, ULocale.forLocale(locale), n2, n3);
    }

    public DateFormat getDateTimeFormat(int n2, int n3, ULocale uLocale) {
        return Calendar.formatHelper(this, uLocale, n2, n3);
    }

    protected DateFormat handleGetDateFormat(String string, Locale locale) {
        return this.handleGetDateFormat(string, null, ULocale.forLocale(locale));
    }

    protected DateFormat handleGetDateFormat(String string, String string2, Locale locale) {
        return this.handleGetDateFormat(string, string2, ULocale.forLocale(locale));
    }

    protected DateFormat handleGetDateFormat(String string, ULocale uLocale) {
        return this.handleGetDateFormat(string, null, uLocale);
    }

    protected DateFormat handleGetDateFormat(String string, String string2, ULocale uLocale) {
        FormatConfiguration formatConfiguration = new FormatConfiguration();
        formatConfiguration.pattern = string;
        formatConfiguration.override = string2;
        formatConfiguration.formatData = new DateFormatSymbols(this, uLocale);
        formatConfiguration.loc = uLocale;
        formatConfiguration.cal = this;
        return SimpleDateFormat.getInstance(formatConfiguration);
    }

    private static DateFormat formatHelper(Calendar calendar, ULocale uLocale, int n2, int n3) {
        Object object;
        if (n3 < -1 || n3 > 3) {
            throw new IllegalArgumentException("Illegal time style " + n3);
        }
        if (n2 < -1 || n2 > 3) {
            throw new IllegalArgumentException("Illegal date style " + n2);
        }
        PatternData patternData = PatternData.make(calendar, uLocale);
        String string = null;
        String string2 = null;
        if (n3 >= 0 && n2 >= 0) {
            string2 = SimpleFormatterImpl.formatRawPattern(patternData.getDateAtTimePattern(n2), 2, 2, patternData.patterns[n3], patternData.patterns[n2 + 4]);
            if (patternData.overrides != null) {
                object = patternData.overrides[n2 + 4];
                String string3 = patternData.overrides[n3];
                string = Calendar.mergeOverrideStrings(patternData.patterns[n2 + 4], patternData.patterns[n3], (String)object, string3);
            }
        } else if (n3 >= 0) {
            string2 = patternData.patterns[n3];
            if (patternData.overrides != null) {
                string = patternData.overrides[n3];
            }
        } else if (n2 >= 0) {
            string2 = patternData.patterns[n2 + 4];
            if (patternData.overrides != null) {
                string = patternData.overrides[n2 + 4];
            }
        } else {
            throw new IllegalArgumentException("No date or time style specified");
        }
        object = calendar.handleGetDateFormat(string2, string, uLocale);
        ((DateFormat)object).setCalendar(calendar);
        return object;
    }

    private static PatternData getPatternData(ULocale uLocale, String string) {
        Object object;
        Object object2;
        ICUResourceBundle iCUResourceBundle = (ICUResourceBundle)UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b", uLocale);
        ICUResourceBundle iCUResourceBundle2 = iCUResourceBundle.findWithFallback("calendar/" + string + "/DateTimePatterns");
        if (iCUResourceBundle2 == null) {
            iCUResourceBundle2 = iCUResourceBundle.getWithFallback("calendar/gregorian/DateTimePatterns");
        }
        int n2 = iCUResourceBundle2.getSize();
        String[] stringArray = new String[n2];
        String[] stringArray2 = new String[n2];
        int n3 = 0;
        boolean bl2 = false;
        if (uLocale.getKeywordValue("rg") != null || uLocale.getKeywordValue("hours") != null) {
            bl2 = true;
        } else {
            object2 = uLocale.getBaseName();
            if (!object2.isEmpty() && !object2.equals("und")) {
                String string2;
                object = new ULocale((String)object2);
                ULocale uLocale2 = ULocale.addLikelySubtags(iCUResourceBundle2.getULocale());
                if (!(uLocale2 == object || ((string2 = ((ULocale)object).getCountry()).isEmpty() || string2.equals(uLocale2.getCountry())) && ((ULocale)object).getLanguage().equals(uLocale2.getLanguage()))) {
                    bl2 = true;
                }
            }
        }
        if (bl2) {
            object2 = DateTimePatternGenerator.getInstanceNoStdPat(uLocale);
            while (n3 < TIME_SKELETONS.length) {
                stringArray[n3] = object2.getBestPattern(TIME_SKELETONS[n3]);
                ++n3;
            }
        }
        while (n3 < n2) {
            object2 = (ICUResourceBundle)iCUResourceBundle2.get(n3);
            switch (object2.getType()) {
                case 0: {
                    stringArray[n3] = object2.getString();
                    break;
                }
                case 8: {
                    stringArray[n3] = object2.getString(0);
                    stringArray2[n3] = object2.getString(1);
                }
            }
            ++n3;
        }
        iCUResourceBundle2 = iCUResourceBundle.findWithFallback("calendar/" + string + "/DateTimePatterns%atTime");
        if (iCUResourceBundle2 == null) {
            iCUResourceBundle2 = iCUResourceBundle.findWithFallback("calendar/gregorian/DateTimePatterns%atTime");
        }
        object2 = null;
        if (iCUResourceBundle2 != null) {
            n2 = iCUResourceBundle2.getSize();
            object2 = new String[n2];
            if (n2 >= 4) {
                for (n3 = 0; n3 < 4; ++n3) {
                    object = (ICUResourceBundle)iCUResourceBundle2.get(n3);
                    if (((UResourceBundle)object).getType() != 0) continue;
                    object2[n3] = ((UResourceBundle)object).getString();
                }
            }
        }
        return new PatternData(stringArray, stringArray2, (String[])object2);
    }

    @Deprecated
    public static String getDateTimePattern(Calendar calendar, ULocale uLocale, int n2) {
        PatternData patternData = PatternData.make(calendar, uLocale);
        return patternData.getDateTimePattern(n2);
    }

    @Deprecated
    public static String getDateAtTimePattern(Calendar calendar, ULocale uLocale, int n2) {
        PatternData patternData = PatternData.make(calendar, uLocale);
        return patternData.getDateAtTimePattern(n2);
    }

    private static String mergeOverrideStrings(String string, String string2, String string3, String string4) {
        if (string3 == null && string4 == null) {
            return null;
        }
        if (string3 == null) {
            return Calendar.expandOverride(string2, string4);
        }
        if (string4 == null) {
            return Calendar.expandOverride(string, string3);
        }
        if (string3.equals(string4)) {
            return string3;
        }
        return Calendar.expandOverride(string, string3) + ";" + Calendar.expandOverride(string2, string4);
    }

    private static String expandOverride(String string, String string2) {
        if (string2.indexOf(61) >= 0) {
            return string2;
        }
        boolean bl2 = false;
        char c2 = ' ';
        StringBuilder stringBuilder = new StringBuilder();
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c3 = stringCharacterIterator.first();
        while (c3 != '\uffff') {
            if (c3 == '\'') {
                bl2 = !bl2;
                c2 = c3;
            } else {
                if (!bl2 && c3 != c2) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(";");
                    }
                    stringBuilder.append(c3);
                    stringBuilder.append("=");
                    stringBuilder.append(string2);
                }
                c2 = c3;
            }
            c3 = stringCharacterIterator.next();
        }
        return stringBuilder.toString();
    }

    protected void pinField(int n2) {
        int n3 = this.getActualMaximum(n2);
        int n4 = this.getActualMinimum(n2);
        if (this.fields[n2] > n3) {
            this.set(n2, n3);
        } else if (this.fields[n2] < n4) {
            this.set(n2, n4);
        }
    }

    @Deprecated
    protected boolean isEra0CountingBackward() {
        return false;
    }

    protected int weekNumber(int n2, int n3, int n4) {
        int n5 = (n4 - this.getFirstDayOfWeek() - n3 + 1) % 7;
        if (n5 < 0) {
            n5 += 7;
        }
        int n6 = (n2 + n5 - 1) / 7;
        if (7 - n5 >= this.getMinimalDaysInFirstWeek()) {
            ++n6;
        }
        return n6;
    }

    protected final int weekNumber(int n2, int n3) {
        return this.weekNumber(n2, n2, n3);
    }

    public int fieldDifference(Date date, int n2) {
        long l2;
        int n3 = 0;
        long l3 = this.getTimeInMillis();
        if (l3 < (l2 = date.getTime())) {
            int n4;
            block13: {
                n4 = 1;
                while (true) {
                    this.setTimeInMillis(l3);
                    this.add(n2, n4);
                    long l4 = this.getTimeInMillis();
                    if (l4 == l2) {
                        return n4;
                    }
                    if (l4 > l2) break block13;
                    if (n4 >= Integer.MAX_VALUE) break;
                    n3 = n4;
                    if ((n4 <<= 1) >= 0) continue;
                    n4 = Integer.MAX_VALUE;
                }
                throw new RuntimeException();
            }
            while (n4 - n3 > 1) {
                int n5 = n3 + (n4 - n3) / 2;
                this.setTimeInMillis(l3);
                this.add(n2, n5);
                long l5 = this.getTimeInMillis();
                if (l5 == l2) {
                    return n5;
                }
                if (l5 > l2) {
                    n4 = n5;
                    continue;
                }
                n3 = n5;
            }
        } else if (l3 > l2) {
            int n6;
            block14: {
                n6 = -1;
                do {
                    this.setTimeInMillis(l3);
                    this.add(n2, n6);
                    long l6 = this.getTimeInMillis();
                    if (l6 == l2) {
                        return n6;
                    }
                    if (l6 < l2) break block14;
                    n3 = n6;
                } while ((n6 <<= 1) != 0);
                throw new RuntimeException();
            }
            while (n3 - n6 > 1) {
                int n7 = n3 + (n6 - n3) / 2;
                this.setTimeInMillis(l3);
                this.add(n2, n7);
                long l7 = this.getTimeInMillis();
                if (l7 == l2) {
                    return n7;
                }
                if (l7 < l2) {
                    n6 = n7;
                    continue;
                }
                n3 = n7;
            }
        }
        this.setTimeInMillis(l3);
        this.add(n2, n3);
        return n3;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.zone = timeZone;
        this.areFieldsSet = false;
    }

    public TimeZone getTimeZone() {
        return this.zone;
    }

    public void setLenient(boolean bl2) {
        this.lenient = bl2;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public void setRepeatedWallTimeOption(int n2) {
        if (n2 != 0 && n2 != 1) {
            throw new IllegalArgumentException("Illegal repeated wall time option - " + n2);
        }
        this.repeatedWallTime = n2;
    }

    public int getRepeatedWallTimeOption() {
        return this.repeatedWallTime;
    }

    public void setSkippedWallTimeOption(int n2) {
        if (n2 != 0 && n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException("Illegal skipped wall time option - " + n2);
        }
        this.skippedWallTime = n2;
    }

    public int getSkippedWallTimeOption() {
        return this.skippedWallTime;
    }

    public void setFirstDayOfWeek(int n2) {
        if (this.firstDayOfWeek != n2) {
            if (n2 < 1 || n2 > 7) {
                throw new IllegalArgumentException("Invalid day of week");
            }
            this.firstDayOfWeek = n2;
            this.areFieldsSet = false;
        }
    }

    public int getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    public void setMinimalDaysInFirstWeek(int n2) {
        if (n2 < 1) {
            n2 = 1;
        } else if (n2 > 7) {
            n2 = 7;
        }
        if (this.minimalDaysInFirstWeek != n2) {
            this.minimalDaysInFirstWeek = n2;
            this.areFieldsSet = false;
        }
    }

    public int getMinimalDaysInFirstWeek() {
        return this.minimalDaysInFirstWeek;
    }

    protected abstract int handleGetLimit(int var1, int var2);

    protected int getLimit(int n2, int n3) {
        switch (n2) {
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: {
                return LIMITS[n2][n3];
            }
            case 4: {
                int n4;
                if (n3 == 0) {
                    n4 = this.getMinimalDaysInFirstWeek() == 1 ? 1 : 0;
                } else if (n3 == 1) {
                    n4 = 1;
                } else {
                    int n5 = this.getMinimalDaysInFirstWeek();
                    int n6 = this.handleGetLimit(5, n3);
                    n4 = n3 == 2 ? (n6 + (7 - n5)) / 7 : (n6 + 6 + (7 - n5)) / 7;
                }
                return n4;
            }
        }
        return this.handleGetLimit(n2, n3);
    }

    public final int getMinimum(int n2) {
        return this.getLimit(n2, 0);
    }

    public final int getMaximum(int n2) {
        return this.getLimit(n2, 3);
    }

    public final int getGreatestMinimum(int n2) {
        return this.getLimit(n2, 1);
    }

    public final int getLeastMaximum(int n2) {
        return this.getLimit(n2, 2);
    }

    @Deprecated
    public int getDayOfWeekType(int n2) {
        if (n2 < 1 || n2 > 7) {
            throw new IllegalArgumentException("Invalid day of week");
        }
        if (this.weekendOnset == this.weekendCease) {
            if (n2 != this.weekendOnset) {
                return 0;
            }
            return this.weekendOnsetMillis == 0 ? 1 : 2;
        }
        if (this.weekendOnset < this.weekendCease ? n2 < this.weekendOnset || n2 > this.weekendCease : n2 > this.weekendCease && n2 < this.weekendOnset) {
            return 0;
        }
        if (n2 == this.weekendOnset) {
            return this.weekendOnsetMillis == 0 ? 1 : 2;
        }
        if (n2 == this.weekendCease) {
            return this.weekendCeaseMillis >= 86400000 ? 1 : 3;
        }
        return 1;
    }

    @Deprecated
    public int getWeekendTransition(int n2) {
        if (n2 == this.weekendOnset) {
            return this.weekendOnsetMillis;
        }
        if (n2 == this.weekendCease) {
            return this.weekendCeaseMillis;
        }
        throw new IllegalArgumentException("Not weekend transition day");
    }

    public boolean isWeekend(Date date) {
        this.setTime(date);
        return this.isWeekend();
    }

    public boolean isWeekend() {
        int n2 = this.get(7);
        int n3 = this.getDayOfWeekType(n2);
        switch (n3) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        int n4 = this.internalGet(14) + 1000 * (this.internalGet(13) + 60 * (this.internalGet(12) + 60 * this.internalGet(11)));
        int n5 = this.getWeekendTransition(n2);
        return n3 == 2 ? n4 >= n5 : n4 < n5;
    }

    public Object clone() {
        try {
            Calendar calendar = (Calendar)super.clone();
            calendar.fields = new int[this.fields.length];
            calendar.stamp = new int[this.fields.length];
            System.arraycopy(this.fields, 0, calendar.fields, 0, this.fields.length);
            System.arraycopy(this.stamp, 0, calendar.stamp, 0, this.fields.length);
            calendar.zone = (TimeZone)this.zone.clone();
            return calendar;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ICUCloneNotSupportedException(cloneNotSupportedException);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[time=");
        stringBuilder.append(this.isTimeSet ? String.valueOf(this.time) : "?");
        stringBuilder.append(",areFieldsSet=");
        stringBuilder.append(this.areFieldsSet);
        stringBuilder.append(",areAllFieldsSet=");
        stringBuilder.append(this.areAllFieldsSet);
        stringBuilder.append(",lenient=");
        stringBuilder.append(this.lenient);
        stringBuilder.append(",zone=");
        stringBuilder.append(this.zone);
        stringBuilder.append(",firstDayOfWeek=");
        stringBuilder.append(this.firstDayOfWeek);
        stringBuilder.append(",minimalDaysInFirstWeek=");
        stringBuilder.append(this.minimalDaysInFirstWeek);
        stringBuilder.append(",repeatedWallTime=");
        stringBuilder.append(this.repeatedWallTime);
        stringBuilder.append(",skippedWallTime=");
        stringBuilder.append(this.skippedWallTime);
        for (int i2 = 0; i2 < this.fields.length; ++i2) {
            stringBuilder.append(',').append(this.fieldName(i2)).append('=');
            stringBuilder.append(this.isSet(i2) ? String.valueOf(this.fields[i2]) : "?");
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static WeekData getWeekDataForRegion(String string) {
        return WEEK_DATA_CACHE.createInstance(string, string);
    }

    public WeekData getWeekData() {
        return new WeekData(this.firstDayOfWeek, this.minimalDaysInFirstWeek, this.weekendOnset, this.weekendOnsetMillis, this.weekendCease, this.weekendCeaseMillis);
    }

    public Calendar setWeekData(WeekData weekData) {
        this.setFirstDayOfWeek(weekData.firstDayOfWeek);
        this.setMinimalDaysInFirstWeek(weekData.minimalDaysInFirstWeek);
        this.weekendOnset = weekData.weekendOnset;
        this.weekendOnsetMillis = weekData.weekendOnsetMillis;
        this.weekendCease = weekData.weekendCease;
        this.weekendCeaseMillis = weekData.weekendCeaseMillis;
        return this;
    }

    private static WeekData getWeekDataForRegionInternal(String string) {
        if (string == null) {
            string = "001";
        }
        UResourceBundle uResourceBundle = UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b", "supplementalData", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        UResourceBundle uResourceBundle2 = uResourceBundle.get("weekData");
        UResourceBundle uResourceBundle3 = null;
        try {
            uResourceBundle3 = uResourceBundle2.get(string);
        }
        catch (MissingResourceException missingResourceException) {
            if (!string.equals("001")) {
                uResourceBundle3 = uResourceBundle2.get("001");
            }
            throw missingResourceException;
        }
        int[] nArray = uResourceBundle3.getIntVector();
        return new WeekData(nArray[0], nArray[1], nArray[2], nArray[3], nArray[4], nArray[5]);
    }

    private void setWeekData(String string) {
        if (string == null) {
            string = "001";
        }
        WeekData weekData = (WeekData)WEEK_DATA_CACHE.getInstance(string, string);
        this.setWeekData(weekData);
    }

    private void updateTime() {
        this.computeTime();
        if (this.isLenient() || !this.areAllFieldsSet) {
            this.areFieldsSet = false;
        }
        this.isTimeSet = true;
        this.areFieldsVirtuallySet = false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (!this.isTimeSet) {
            try {
                this.updateTime();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initInternal();
        this.isTimeSet = true;
        this.areAllFieldsSet = false;
        this.areFieldsSet = false;
        this.areFieldsVirtuallySet = true;
        this.nextStamp = 2;
    }

    protected void computeFields() {
        int n2;
        int[] nArray = new int[2];
        this.getTimeZone().getOffset(this.time, false, nArray);
        long l2 = this.time + (long)nArray[0] + (long)nArray[1];
        int n3 = this.internalSetMask;
        for (int i2 = 0; i2 < this.fields.length; ++i2) {
            this.stamp[i2] = (n3 & 1) == 0 ? 1 : 0;
            n3 >>= 1;
        }
        long l3 = Calendar.floorDivide(l2, 86400000L);
        this.fields[20] = (int)l3 + 2440588;
        this.computeGregorianAndDOWFields(this.fields[20]);
        this.handleComputeFields(this.fields[20]);
        this.computeWeekFields();
        this.fields[21] = n2 = (int)(l2 - l3 * 86400000L);
        this.fields[14] = n2 % 1000;
        this.fields[13] = (n2 /= 1000) % 60;
        this.fields[12] = (n2 /= 60) % 60;
        this.fields[11] = n2 /= 60;
        this.fields[9] = n2 / 12;
        this.fields[10] = n2 % 12;
        this.fields[15] = nArray[0];
        this.fields[16] = nArray[1];
    }

    private final void computeGregorianAndDOWFields(int n2) {
        this.computeGregorianFields(n2);
        int n3 = this.fields[7] = Calendar.julianDayToDayOfWeek(n2);
        int n4 = n3 - this.getFirstDayOfWeek() + 1;
        if (n4 < 1) {
            n4 += 7;
        }
        this.fields[18] = n4;
    }

    protected final void computeGregorianFields(int n2) {
        int n3;
        long l2 = n2 - 1721426;
        int[] nArray = new int[1];
        int n4 = Calendar.floorDivide(l2, 146097, nArray);
        int n5 = Calendar.floorDivide(nArray[0], 36524, nArray);
        int n6 = Calendar.floorDivide(nArray[0], 1461, nArray);
        int n7 = Calendar.floorDivide(nArray[0], 365, nArray);
        int n8 = 400 * n4 + 100 * n5 + 4 * n6 + n7;
        int n9 = nArray[0];
        if (n5 == 4 || n7 == 4) {
            n9 = 365;
        } else {
            ++n8;
        }
        boolean bl2 = (n8 & 3) == 0 && (n8 % 100 != 0 || n8 % 400 == 0);
        int n10 = 0;
        int n11 = n3 = bl2 ? 60 : 59;
        if (n9 >= n3) {
            n10 = bl2 ? 1 : 2;
        }
        int n12 = (12 * (n9 + n10) + 6) / 367;
        int n13 = n9 - GREGORIAN_MONTH_COUNT[n12][bl2 ? 3 : 2] + 1;
        this.gregorianYear = n8;
        this.gregorianMonth = n12;
        this.gregorianDayOfMonth = n13;
        this.gregorianDayOfYear = n9 + 1;
    }

    private final void computeWeekFields() {
        int n2;
        int n3 = this.fields[19];
        int n4 = this.fields[7];
        int n5 = this.fields[6];
        int n6 = n3;
        int n7 = (n4 + 7 - this.getFirstDayOfWeek()) % 7;
        int n8 = (n4 - n5 + 7001 - this.getFirstDayOfWeek()) % 7;
        int n9 = (n5 - 1 + n8) / 7;
        if (7 - n8 >= this.getMinimalDaysInFirstWeek()) {
            ++n9;
        }
        if (n9 == 0) {
            n2 = n5 + this.handleGetYearLength(n3 - 1);
            n9 = this.weekNumber(n2, n4);
        } else {
            n2 = this.handleGetYearLength(n3);
            if (n5 >= n2 - 5) {
                int n10 = (n7 + n2 - n5) % 7;
                if (n10 < 0) {
                    n10 += 7;
                }
                if (6 - n10 >= this.getMinimalDaysInFirstWeek() && n5 + 7 - n7 > n2) {
                    n9 = 1;
                    ++n6;
                }
            }
        }
        this.fields[3] = n9;
        this.fields[17] = --n6;
        n2 = this.fields[5];
        this.fields[4] = this.weekNumber(n2, n4);
        this.fields[8] = (n2 - 1) / 7 + 1;
    }

    protected int resolveFields(int[][][] nArray) {
        int n2 = -1;
        for (int i2 = 0; i2 < nArray.length && n2 < 0; ++i2) {
            int[][] nArray2 = nArray[i2];
            int n3 = 0;
            block1: for (int i3 = 0; i3 < nArray2.length; ++i3) {
                int n4;
                int[] nArray3 = nArray2[i3];
                int n5 = 0;
                int n6 = n4 = nArray3[0] >= 32 ? 1 : 0;
                while (n4 < nArray3.length) {
                    int n7 = this.stamp[nArray3[n4]];
                    if (n7 == 0) continue block1;
                    n5 = Math.max(n5, n7);
                    ++n4;
                }
                if (n5 <= n3) continue;
                int n8 = nArray3[0];
                if (n8 >= 32) {
                    if ((n8 &= 0x1F) != 5 || this.stamp[4] < this.stamp[n8]) {
                        n2 = n8;
                    }
                } else {
                    n2 = n8;
                }
                if (n2 != n8) continue;
                n3 = n5;
            }
        }
        return n2 >= 32 ? n2 & 0x1F : n2;
    }

    protected int newestStamp(int n2, int n3, int n4) {
        int n5 = n4;
        for (int i2 = n2; i2 <= n3; ++i2) {
            if (this.stamp[i2] <= n5) continue;
            n5 = this.stamp[i2];
        }
        return n5;
    }

    protected final int getStamp(int n2) {
        return this.stamp[n2];
    }

    protected int newerField(int n2, int n3) {
        if (this.stamp[n3] > this.stamp[n2]) {
            return n3;
        }
        return n2;
    }

    protected void validateFields() {
        for (int i2 = 0; i2 < this.fields.length; ++i2) {
            if (this.stamp[i2] < 2) continue;
            this.validateField(i2);
        }
    }

    protected void validateField(int n2) {
        switch (n2) {
            case 5: {
                int n3 = this.handleGetExtendedYear();
                this.validateField(n2, 1, this.handleGetMonthLength(n3, this.internalGetMonth()));
                break;
            }
            case 6: {
                int n4 = this.handleGetExtendedYear();
                this.validateField(n2, 1, this.handleGetYearLength(n4));
                break;
            }
            case 8: {
                if (this.internalGet(n2) == 0) {
                    throw new IllegalArgumentException("DAY_OF_WEEK_IN_MONTH cannot be zero");
                }
                this.validateField(n2, this.getMinimum(n2), this.getMaximum(n2));
                break;
            }
            default: {
                this.validateField(n2, this.getMinimum(n2), this.getMaximum(n2));
            }
        }
    }

    protected final void validateField(int n2, int n3, int n4) {
        int n5 = this.fields[n2];
        if (n5 < n3 || n5 > n4) {
            throw new IllegalArgumentException(this.fieldName(n2) + '=' + n5 + ", valid range=" + n3 + ".." + n4);
        }
    }

    protected void computeTime() {
        int n2;
        long l2;
        if (!this.isLenient()) {
            this.validateFields();
        }
        int n3 = this.computeJulianDay();
        long l3 = Calendar.julianDayToMillis(n3);
        if (this.stamp[21] >= 2 && this.newestStamp(9, 14, 0) <= this.stamp[21]) {
            l2 = this.internalGet(21);
        } else {
            n2 = Math.abs(this.internalGet(11));
            l2 = (n2 = Math.max(n2, Math.abs(this.internalGet(10)))) > 548 ? this.computeMillisInDayLong() : (long)this.computeMillisInDay();
        }
        if (this.stamp[15] >= 2 || this.stamp[16] >= 2) {
            this.time = l3 + l2 - (long)(this.internalGet(15) + this.internalGet(16));
        } else if (!this.lenient || this.skippedWallTime == 2) {
            long l4;
            int n4;
            n2 = this.computeZoneOffset(l3, l2);
            if (n2 != (n4 = this.zone.getOffset(l4 = l3 + l2 - (long)n2))) {
                if (!this.lenient) {
                    throw new IllegalArgumentException("The specified wall time does not exist due to time zone offset transition.");
                }
                assert (this.skippedWallTime == 2) : this.skippedWallTime;
                Long l5 = this.getImmediatePreviousZoneTransition(l4);
                if (l5 == null) {
                    throw new RuntimeException("Could not locate a time zone transition before " + l4);
                }
                this.time = l5;
            } else {
                this.time = l4;
            }
        } else {
            this.time = l3 + l2 - (long)this.computeZoneOffset(l3, l2);
        }
    }

    private Long getImmediatePreviousZoneTransition(long l2) {
        Long l3 = null;
        if (this.zone instanceof BasicTimeZone) {
            TimeZoneTransition timeZoneTransition = ((BasicTimeZone)this.zone).getPreviousTransition(l2, true);
            if (timeZoneTransition != null) {
                l3 = timeZoneTransition.getTime();
            }
        } else {
            l3 = Calendar.getPreviousZoneTransitionTime(this.zone, l2, 0x6DDD00L);
            if (l3 == null) {
                l3 = Calendar.getPreviousZoneTransitionTime(this.zone, l2, 108000000L);
            }
        }
        return l3;
    }

    private static Long getPreviousZoneTransitionTime(TimeZone timeZone, long l2, long l3) {
        int n2;
        assert (l3 > 0L);
        long l4 = l2;
        long l5 = l2 - l3 - 1L;
        int n3 = timeZone.getOffset(l4);
        if (n3 == (n2 = timeZone.getOffset(l5))) {
            return null;
        }
        return Calendar.findPreviousZoneTransitionTime(timeZone, n3, l4, l5);
    }

    private static Long findPreviousZoneTransitionTime(TimeZone timeZone, int n2, long l2, long l3) {
        boolean bl2 = false;
        long l4 = 0L;
        for (int n3 : FIND_ZONE_TRANSITION_TIME_UNITS) {
            long l5 = l2 / (long)n3;
            long l6 = l3 / (long)n3;
            if (l5 <= l6) continue;
            l4 = (l6 + l5 + 1L >>> 1) * (long)n3;
            bl2 = true;
            break;
        }
        if (!bl2) {
            l4 = l2 + l3 >>> 1;
        }
        if (bl2) {
            if (l4 != l2) {
                int n4 = timeZone.getOffset(l4);
                if (n4 != n2) {
                    return Calendar.findPreviousZoneTransitionTime(timeZone, n2, l2, l4);
                }
                l2 = l4;
            }
            --l4;
        } else {
            l4 = l2 + l3 >>> 1;
        }
        if (l4 == l3) {
            return l2;
        }
        int n5 = timeZone.getOffset(l4);
        if (n5 != n2) {
            if (bl2) {
                return l2;
            }
            return Calendar.findPreviousZoneTransitionTime(timeZone, n2, l2, l4);
        }
        return Calendar.findPreviousZoneTransitionTime(timeZone, n2, l4, l3);
    }

    @Deprecated
    protected int computeMillisInDay() {
        int n2;
        int n3 = 0;
        int n4 = this.stamp[11];
        int n5 = Math.max(this.stamp[10], this.stamp[9]);
        int n6 = n2 = n5 > n4 ? n5 : n4;
        if (n2 != 0) {
            if (n2 == n4) {
                n3 += this.internalGet(11);
            } else {
                n3 += this.internalGet(10);
                n3 += 12 * this.internalGet(9);
            }
        }
        n3 *= 60;
        n3 += this.internalGet(12);
        n3 *= 60;
        n3 += this.internalGet(13);
        n3 *= 1000;
        return n3 += this.internalGet(14);
    }

    @Deprecated
    protected long computeMillisInDayLong() {
        int n2;
        long l2 = 0L;
        int n3 = this.stamp[11];
        int n4 = Math.max(this.stamp[10], this.stamp[9]);
        int n5 = n2 = n4 > n3 ? n4 : n3;
        if (n2 != 0) {
            if (n2 == n3) {
                l2 += (long)this.internalGet(11);
            } else {
                l2 += (long)this.internalGet(10);
                l2 += (long)(12 * this.internalGet(9));
            }
        }
        l2 *= 60L;
        l2 += (long)this.internalGet(12);
        l2 *= 60L;
        l2 += (long)this.internalGet(13);
        l2 *= 1000L;
        return l2 += (long)this.internalGet(14);
    }

    @Deprecated
    protected int computeZoneOffset(long l2, int n2) {
        int[] nArray = new int[2];
        long l3 = l2 + (long)n2;
        if (this.zone instanceof BasicTimeZone) {
            BasicTimeZone.LocalOption localOption = this.skippedWallTime == 1 ? BasicTimeZone.LocalOption.LATTER : BasicTimeZone.LocalOption.FORMER;
            BasicTimeZone.LocalOption localOption2 = this.repeatedWallTime == 1 ? BasicTimeZone.LocalOption.FORMER : BasicTimeZone.LocalOption.LATTER;
            ((BasicTimeZone)this.zone).getOffsetFromLocal(l3, localOption, localOption2, nArray);
        } else {
            long l4;
            this.zone.getOffset(l3, true, nArray);
            boolean bl2 = false;
            if (this.repeatedWallTime == 1) {
                l4 = l3 - (long)(nArray[0] + nArray[1]);
                int n3 = this.zone.getOffset(l4 - 21600000L);
                int n4 = nArray[0] + nArray[1] - n3;
                assert (n4 > -21600000) : n4;
                if (n4 < 0) {
                    bl2 = true;
                    this.zone.getOffset(l3 + (long)n4, true, nArray);
                }
            }
            if (!bl2 && this.skippedWallTime == 1) {
                l4 = l3 - (long)(nArray[0] + nArray[1]);
                this.zone.getOffset(l4, false, nArray);
            }
        }
        return nArray[0] + nArray[1];
    }

    @Deprecated
    protected int computeZoneOffset(long l2, long l3) {
        int[] nArray = new int[2];
        long l4 = l2 + l3;
        if (this.zone instanceof BasicTimeZone) {
            BasicTimeZone.LocalOption localOption = this.skippedWallTime == 1 ? BasicTimeZone.LocalOption.LATTER : BasicTimeZone.LocalOption.FORMER;
            BasicTimeZone.LocalOption localOption2 = this.repeatedWallTime == 1 ? BasicTimeZone.LocalOption.FORMER : BasicTimeZone.LocalOption.LATTER;
            ((BasicTimeZone)this.zone).getOffsetFromLocal(l4, localOption, localOption2, nArray);
        } else {
            long l5;
            this.zone.getOffset(l4, true, nArray);
            boolean bl2 = false;
            if (this.repeatedWallTime == 1) {
                l5 = l4 - (long)(nArray[0] + nArray[1]);
                int n2 = this.zone.getOffset(l5 - 21600000L);
                int n3 = nArray[0] + nArray[1] - n2;
                assert (n3 > -21600000) : n3;
                if (n3 < 0) {
                    bl2 = true;
                    this.zone.getOffset(l4 + (long)n3, true, nArray);
                }
            }
            if (!bl2 && this.skippedWallTime == 1) {
                l5 = l4 - (long)(nArray[0] + nArray[1]);
                this.zone.getOffset(l5, false, nArray);
            }
        }
        return nArray[0] + nArray[1];
    }

    protected int computeJulianDay() {
        int n2;
        if (this.stamp[20] >= 2) {
            n2 = this.newestStamp(0, 8, 0);
            n2 = this.newestStamp(17, 19, n2);
            if ((n2 = this.newestStamp(23, 23, n2)) <= this.stamp[20]) {
                return this.internalGet(20);
            }
        }
        if ((n2 = this.resolveFields(this.getFieldResolutionTable())) < 0) {
            n2 = 5;
        }
        return this.handleComputeJulianDay(n2);
    }

    protected int[][][] getFieldResolutionTable() {
        return DATE_PRECEDENCE;
    }

    protected abstract int handleComputeMonthStart(int var1, int var2, boolean var3);

    protected abstract int handleGetExtendedYear();

    protected int handleGetMonthLength(int n2, int n3) {
        return this.handleComputeMonthStart(n2, n3 + 1, true) - this.handleComputeMonthStart(n2, n3, true);
    }

    protected int handleGetYearLength(int n2) {
        return this.handleComputeMonthStart(n2 + 1, 0, false) - this.handleComputeMonthStart(n2, 0, false);
    }

    protected int[] handleCreateFields() {
        return new int[24];
    }

    protected int getDefaultMonthInYear(int n2) {
        return 0;
    }

    protected int getDefaultDayInMonth(int n2, int n3) {
        return 1;
    }

    protected int handleComputeJulianDay(int n2) {
        boolean bl2 = n2 == 5 || n2 == 4 || n2 == 8;
        int n3 = n2 == 3 && this.newerField(17, 1) == 17 ? this.internalGet(17) : this.handleGetExtendedYear();
        this.internalSet(19, n3);
        if ((long)n3 > 23058430092136939L) {
            throw new IllegalArgumentException("year is too large");
        }
        int n4 = bl2 ? this.internalGetMonth(this.getDefaultMonthInYear(n3)) : 0;
        int n5 = this.handleComputeMonthStart(n3, n4, bl2);
        if (n2 == 5) {
            if (this.isSet(5)) {
                return n5 + this.internalGet(5, this.getDefaultDayInMonth(n3, n4));
            }
            return n5 + this.getDefaultDayInMonth(n3, n4);
        }
        if (n2 == 6) {
            return n5 + this.internalGet(6);
        }
        int n6 = this.getFirstDayOfWeek();
        int n7 = Calendar.julianDayToDayOfWeek(n5 + 1) - n6;
        if (n7 < 0) {
            n7 += 7;
        }
        int n8 = 0;
        switch (this.resolveFields(DOW_PRECEDENCE)) {
            case 7: {
                n8 = this.internalGet(7) - n6;
                break;
            }
            case 18: {
                n8 = this.internalGet(18) - 1;
            }
        }
        if ((n8 %= 7) < 0) {
            n8 += 7;
        }
        int n9 = 1 - n7 + n8;
        if (n2 == 8) {
            int n10;
            if (n9 < 1) {
                n9 += 7;
            }
            if ((n10 = this.internalGet(8, 1)) >= 0) {
                n9 += 7 * (n10 - 1);
            } else {
                int n11 = this.internalGetMonth(0);
                int n12 = this.handleGetMonthLength(n3, n11);
                n9 += ((n12 - n9) / 7 + n10 + 1) * 7;
            }
        } else {
            if (7 - n7 < this.getMinimalDaysInFirstWeek()) {
                n9 += 7;
            }
            n9 += 7 * (this.internalGet(n2) - 1);
        }
        return n5 + n9;
    }

    protected int computeGregorianMonthStart(int n2, int n3) {
        if (n3 < 0 || n3 > 11) {
            int[] nArray = new int[1];
            n2 += Calendar.floorDivide(n3, 12, nArray);
            n3 = nArray[0];
        }
        boolean bl2 = n2 % 4 == 0 && (n2 % 100 != 0 || n2 % 400 == 0);
        int n4 = n2 - 1;
        int n5 = 365 * n4 + Calendar.floorDivide(n4, 4) - Calendar.floorDivide(n4, 100) + Calendar.floorDivide(n4, 400) + 1721426 - 1;
        if (n3 != 0) {
            n5 += GREGORIAN_MONTH_COUNT[n3][bl2 ? 3 : 2];
        }
        return n5;
    }

    protected void handleComputeFields(int n2) {
        int n3 = this.getGregorianMonth();
        this.internalSet(2, n3);
        this.internalSet(23, n3);
        this.internalSet(5, this.getGregorianDayOfMonth());
        this.internalSet(6, this.getGregorianDayOfYear());
        int n4 = this.getGregorianYear();
        this.internalSet(19, n4);
        int n5 = 1;
        if (n4 < 1) {
            n5 = 0;
            n4 = 1 - n4;
        }
        this.internalSet(0, n5);
        this.internalSet(1, n4);
    }

    protected final int getGregorianYear() {
        return this.gregorianYear;
    }

    protected final int getGregorianMonth() {
        return this.gregorianMonth;
    }

    protected final int getGregorianDayOfYear() {
        return this.gregorianDayOfYear;
    }

    protected final int getGregorianDayOfMonth() {
        return this.gregorianDayOfMonth;
    }

    public final int getFieldCount() {
        return this.fields.length;
    }

    protected final void internalSet(int n2, int n3) {
        if ((1 << n2 & this.internalSetMask) == 0) {
            throw new IllegalStateException("Subclass cannot set " + this.fieldName(n2));
        }
        this.fields[n2] = n3;
        this.stamp[n2] = 1;
    }

    protected static final boolean isGregorianLeapYear(int n2) {
        return n2 % 4 == 0 && (n2 % 100 != 0 || n2 % 400 == 0);
    }

    protected static final int gregorianMonthLength(int n2, int n3) {
        return GREGORIAN_MONTH_COUNT[n3][Calendar.isGregorianLeapYear(n2) ? 1 : 0];
    }

    protected static final int gregorianPreviousMonthLength(int n2, int n3) {
        return n3 > 0 ? Calendar.gregorianMonthLength(n2, n3 - 1) : 31;
    }

    protected static final long floorDivide(long l2, long l3) {
        return l2 >= 0L ? l2 / l3 : (l2 + 1L) / l3 - 1L;
    }

    protected static final int floorDivide(int n2, int n3) {
        return n2 >= 0 ? n2 / n3 : (n2 + 1) / n3 - 1;
    }

    protected static final int floorDivide(int n2, int n3, int[] nArray) {
        if (n2 >= 0) {
            nArray[0] = n2 % n3;
            return n2 / n3;
        }
        int n4 = (n2 + 1) / n3 - 1;
        nArray[0] = n2 - n4 * n3;
        return n4;
    }

    protected static final int floorDivide(long l2, int n2, int[] nArray) {
        if (l2 >= 0L) {
            nArray[0] = (int)(l2 % (long)n2);
            return (int)(l2 / (long)n2);
        }
        int n3 = (int)((l2 + 1L) / (long)n2 - 1L);
        nArray[0] = (int)(l2 - (long)n3 * (long)n2);
        return n3;
    }

    protected String fieldName(int n2) {
        try {
            return FIELD_NAME[n2];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return "Field " + n2;
        }
    }

    protected static final int millisToJulianDay(long l2) {
        return (int)(2440588L + Calendar.floorDivide(l2, 86400000L));
    }

    protected static final long julianDayToMillis(int n2) {
        return (long)(n2 - 2440588) * 86400000L;
    }

    protected static final int julianDayToDayOfWeek(int n2) {
        int n3 = (n2 + 2) % 7;
        if (n3 < 1) {
            n3 += 7;
        }
        return n3;
    }

    protected final long internalGetTimeInMillis() {
        return this.time;
    }

    public String getType() {
        return "unknown";
    }

    @Deprecated
    public boolean haveDefaultCentury() {
        return true;
    }

    public final ULocale getLocale(ULocale.Type type) {
        return type == ULocale.ACTUAL_LOCALE ? this.actualLocale : this.validLocale;
    }

    final void setLocale(ULocale uLocale, ULocale uLocale2) {
        if (uLocale == null != (uLocale2 == null)) {
            throw new IllegalArgumentException();
        }
        this.validLocale = uLocale;
        this.actualLocale = uLocale2;
    }

    private static class WeekDataCache
    extends SoftCache<String, WeekData, String> {
        private WeekDataCache() {
        }

        @Override
        protected WeekData createInstance(String string, String string2) {
            return Calendar.getWeekDataForRegionInternal(string);
        }
    }

    public static final class WeekData {
        public final int firstDayOfWeek;
        public final int minimalDaysInFirstWeek;
        public final int weekendOnset;
        public final int weekendOnsetMillis;
        public final int weekendCease;
        public final int weekendCeaseMillis;

        public WeekData(int n2, int n3, int n4, int n5, int n6, int n7) {
            this.firstDayOfWeek = n2;
            this.minimalDaysInFirstWeek = n3;
            this.weekendOnset = n4;
            this.weekendOnsetMillis = n5;
            this.weekendCease = n6;
            this.weekendCeaseMillis = n7;
        }

        public int hashCode() {
            return ((((this.firstDayOfWeek * 37 + this.minimalDaysInFirstWeek) * 37 + this.weekendOnset) * 37 + this.weekendOnsetMillis) * 37 + this.weekendCease) * 37 + this.weekendCeaseMillis;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof WeekData)) {
                return false;
            }
            WeekData weekData = (WeekData)object;
            return this.firstDayOfWeek == weekData.firstDayOfWeek && this.minimalDaysInFirstWeek == weekData.minimalDaysInFirstWeek && this.weekendOnset == weekData.weekendOnset && this.weekendOnsetMillis == weekData.weekendOnsetMillis && this.weekendCease == weekData.weekendCease && this.weekendCeaseMillis == weekData.weekendCeaseMillis;
        }

        public String toString() {
            return "{" + this.firstDayOfWeek + ", " + this.minimalDaysInFirstWeek + ", " + this.weekendOnset + ", " + this.weekendOnsetMillis + ", " + this.weekendCease + ", " + this.weekendCeaseMillis + "}";
        }
    }

    @Deprecated
    public static class FormatConfiguration {
        private String pattern;
        private String override;
        private DateFormatSymbols formatData;
        private Calendar cal;
        private ULocale loc;

        private FormatConfiguration() {
        }

        @Deprecated
        public String getPatternString() {
            return this.pattern;
        }

        @Deprecated
        public String getOverrideString() {
            return this.override;
        }

        @Deprecated
        public Calendar getCalendar() {
            return this.cal;
        }

        @Deprecated
        public ULocale getLocale() {
            return this.loc;
        }

        @Deprecated
        public DateFormatSymbols getDateFormatSymbols() {
            return this.formatData;
        }
    }

    static class PatternData {
        private String[] patterns;
        private String[] overrides;
        private String[] atTimePatterns;

        public PatternData(String[] stringArray, String[] stringArray2, String[] stringArray3) {
            this.patterns = stringArray;
            this.overrides = stringArray2;
            this.atTimePatterns = stringArray3;
        }

        private String getDateTimePattern(int n2) {
            int n3 = 8;
            if (this.patterns.length >= 13) {
                n3 += n2 + 1;
            }
            String string = this.patterns[n3];
            return string;
        }

        private String getDateAtTimePattern(int n2) {
            if (this.atTimePatterns != null && this.atTimePatterns.length >= 4) {
                String string = this.atTimePatterns[n2];
                return string;
            }
            return this.getDateTimePattern(n2);
        }

        private static PatternData make(Calendar calendar, ULocale uLocale) {
            boolean bl2;
            String string = calendar.getType();
            String string2 = uLocale.getBaseName() + "+" + string;
            PatternData patternData = null;
            boolean bl3 = bl2 = uLocale.getKeywordValue("rg") != null || uLocale.getKeywordValue("hours") != null;
            if (!bl2) {
                patternData = (PatternData)PATTERN_CACHE.get(string2);
            }
            if (patternData == null) {
                try {
                    patternData = Calendar.getPatternData(uLocale, string);
                }
                catch (MissingResourceException missingResourceException) {
                    patternData = new PatternData(DEFAULT_PATTERNS, null, DEFAULT_ATTIME_PATTERNS);
                }
                if (!bl2) {
                    PATTERN_CACHE.put(string2, patternData);
                }
            }
            return patternData;
        }
    }
}

