/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.util;

import java.util.Date;
import java.util.Locale;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.Calendar;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.TimeZone;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;

abstract class CECalendar
extends Calendar {
    private static final long serialVersionUID = -999547623066414271L;
    private static final int[][] LIMITS = new int[][]{{0, 0, 1, 1}, {1, 1, 5000000, 5000000}, {0, 0, 12, 12}, {1, 1, 52, 53}, new int[0], {1, 1, 5, 30}, {1, 1, 365, 366}, new int[0], {-1, -1, 1, 5}, new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], {-5000000, -5000000, 5000000, 5000000}, new int[0], {-5000000, -5000000, 5000000, 5000000}, new int[0], new int[0], new int[0], {0, 0, 12, 12}};

    protected CECalendar() {
        this(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT));
    }

    protected CECalendar(TimeZone timeZone) {
        this(timeZone, ULocale.getDefault(ULocale.Category.FORMAT));
    }

    protected CECalendar(Locale locale) {
        this(TimeZone.forLocaleOrDefault(locale), locale);
    }

    protected CECalendar(ULocale uLocale) {
        this(TimeZone.forULocaleOrDefault(uLocale), uLocale);
    }

    protected CECalendar(TimeZone timeZone, Locale locale) {
        super(timeZone, locale);
        this.setTimeInMillis(System.currentTimeMillis());
    }

    protected CECalendar(TimeZone timeZone, ULocale uLocale) {
        super(timeZone, uLocale);
        this.setTimeInMillis(System.currentTimeMillis());
    }

    protected CECalendar(int n2, int n3, int n4) {
        super(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT));
        this.set(n2, n3, n4);
    }

    protected CECalendar(Date date) {
        super(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT));
        this.setTime(date);
    }

    protected CECalendar(int n2, int n3, int n4, int n5, int n6, int n7) {
        super(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT));
        this.set(n2, n3, n4, n5, n6, n7);
    }

    protected abstract int getJDEpochOffset();

    @Override
    protected int handleComputeMonthStart(int n2, int n3, boolean bl2) {
        return CECalendar.ceToJD(n2, n3, 0, this.getJDEpochOffset());
    }

    @Override
    protected int handleGetLimit(int n2, int n3) {
        return LIMITS[n2][n3];
    }

    @Override
    protected int handleGetMonthLength(int n2, int n3) {
        if ((n3 + 1) % 13 != 0) {
            return 30;
        }
        return n2 % 4 / 3 + 5;
    }

    public static int ceToJD(long l2, int n2, int n3, int n4) {
        if (n2 >= 0) {
            l2 += (long)(n2 / 13);
            n2 %= 13;
        } else {
            l2 += (long)(++n2 / 13 - 1);
            n2 = n2 % 13 + 12;
        }
        return (int)((long)n4 + 365L * l2 + CECalendar.floorDivide(l2, 4L) + (long)(30 * n2) + (long)n3 - 1L);
    }

    public static void jdToCE(int n2, int n3, int[] nArray) {
        int[] nArray2 = new int[1];
        int n4 = CECalendar.floorDivide(n2 - n3, 1461, nArray2);
        nArray[0] = 4 * n4 + (nArray2[0] / 365 - nArray2[0] / 1460);
        int n5 = nArray2[0] == 1460 ? 365 : nArray2[0] % 365;
        nArray[1] = n5 / 30;
        nArray[2] = n5 % 30 + 1;
    }

    @Override
    public String getTemporalMonthCode() {
        if (this.get(2) == 12) {
            return "M13";
        }
        return super.getTemporalMonthCode();
    }

    @Override
    public void setTemporalMonthCode(String string) {
        if (string.equals("M13")) {
            this.set(2, 12);
            this.set(22, 0);
            return;
        }
        super.setTemporalMonthCode(string);
    }
}

