/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.OutputInt;

public class UnicodeSetSpanner {
    private final UnicodeSet unicodeSet;

    public UnicodeSetSpanner(UnicodeSet unicodeSet) {
        this.unicodeSet = unicodeSet;
    }

    public UnicodeSet getUnicodeSet() {
        return this.unicodeSet;
    }

    public boolean equals(Object object) {
        return object instanceof UnicodeSetSpanner && this.unicodeSet.equals(((UnicodeSetSpanner)object).unicodeSet);
    }

    public int hashCode() {
        return this.unicodeSet.hashCode();
    }

    public int countIn(CharSequence charSequence) {
        return this.countIn(charSequence, CountMethod.MIN_ELEMENTS, UnicodeSet.SpanCondition.SIMPLE);
    }

    public int countIn(CharSequence charSequence, CountMethod countMethod) {
        return this.countIn(charSequence, countMethod, UnicodeSet.SpanCondition.SIMPLE);
    }

    public int countIn(CharSequence charSequence, CountMethod countMethod, UnicodeSet.SpanCondition spanCondition) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        UnicodeSet.SpanCondition spanCondition2 = spanCondition == UnicodeSet.SpanCondition.NOT_CONTAINED ? UnicodeSet.SpanCondition.SIMPLE : UnicodeSet.SpanCondition.NOT_CONTAINED;
        int n5 = charSequence.length();
        OutputInt outputInt = null;
        while (n4 != n5 && (n2 = this.unicodeSet.span(charSequence, n4, spanCondition2)) != n5) {
            if (countMethod == CountMethod.WHOLE_SPAN) {
                n4 = this.unicodeSet.span(charSequence, n2, spanCondition);
                ++n3;
                continue;
            }
            if (outputInt == null) {
                outputInt = new OutputInt();
            }
            n4 = this.unicodeSet.spanAndCount(charSequence, n2, spanCondition, outputInt);
            n3 += outputInt.value;
        }
        return n3;
    }

    public String deleteFrom(CharSequence charSequence) {
        return this.replaceFrom(charSequence, "", CountMethod.WHOLE_SPAN, UnicodeSet.SpanCondition.SIMPLE);
    }

    public String deleteFrom(CharSequence charSequence, UnicodeSet.SpanCondition spanCondition) {
        return this.replaceFrom(charSequence, "", CountMethod.WHOLE_SPAN, spanCondition);
    }

    public String replaceFrom(CharSequence charSequence, CharSequence charSequence2) {
        return this.replaceFrom(charSequence, charSequence2, CountMethod.MIN_ELEMENTS, UnicodeSet.SpanCondition.SIMPLE);
    }

    public String replaceFrom(CharSequence charSequence, CharSequence charSequence2, CountMethod countMethod) {
        return this.replaceFrom(charSequence, charSequence2, countMethod, UnicodeSet.SpanCondition.SIMPLE);
    }

    public String replaceFrom(CharSequence charSequence, CharSequence charSequence2, CountMethod countMethod, UnicodeSet.SpanCondition spanCondition) {
        UnicodeSet.SpanCondition spanCondition2 = spanCondition == UnicodeSet.SpanCondition.NOT_CONTAINED ? UnicodeSet.SpanCondition.SIMPLE : UnicodeSet.SpanCondition.NOT_CONTAINED;
        boolean bl2 = charSequence2.length() == 0;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = charSequence.length();
        OutputInt outputInt = null;
        int n3 = 0;
        while (n3 != n2) {
            int n4;
            if (countMethod == CountMethod.WHOLE_SPAN) {
                n4 = this.unicodeSet.span(charSequence, n3, spanCondition);
            } else {
                if (outputInt == null) {
                    outputInt = new OutputInt();
                }
                n4 = this.unicodeSet.spanAndCount(charSequence, n3, spanCondition, outputInt);
            }
            if (!bl2 && n4 != 0) {
                if (countMethod == CountMethod.WHOLE_SPAN) {
                    stringBuilder.append(charSequence2);
                } else {
                    for (int i2 = outputInt.value; i2 > 0; --i2) {
                        stringBuilder.append(charSequence2);
                    }
                }
            }
            if (n4 == n2) break;
            n3 = this.unicodeSet.span(charSequence, n4, spanCondition2);
            stringBuilder.append(charSequence.subSequence(n4, n3));
        }
        return stringBuilder.toString();
    }

    public CharSequence trim(CharSequence charSequence) {
        return this.trim(charSequence, TrimOption.BOTH, UnicodeSet.SpanCondition.SIMPLE);
    }

    public CharSequence trim(CharSequence charSequence, TrimOption trimOption) {
        return this.trim(charSequence, trimOption, UnicodeSet.SpanCondition.SIMPLE);
    }

    public CharSequence trim(CharSequence charSequence, TrimOption trimOption, UnicodeSet.SpanCondition spanCondition) {
        int n2;
        int n3 = charSequence.length();
        if (trimOption != TrimOption.TRAILING) {
            n2 = this.unicodeSet.span(charSequence, spanCondition);
            if (n2 == n3) {
                return "";
            }
        } else {
            n2 = 0;
        }
        int n4 = trimOption != TrimOption.LEADING ? this.unicodeSet.spanBack(charSequence, spanCondition) : n3;
        return n2 == 0 && n4 == n3 ? charSequence : charSequence.subSequence(n2, n4);
    }

    public static enum TrimOption {
        LEADING,
        BOTH,
        TRAILING;

    }

    public static enum CountMethod {
        WHOLE_SPAN,
        MIN_ELEMENTS;

    }
}

