/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.io.IOException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.BMPSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.CharacterPropertiesImpl;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.PatternProps;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.RuleCharacterIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.SortedSetRelation;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.StringRange;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.UCaseProps;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.UCharacterProperty;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.UPropertyAliases;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.UnicodeSetStringSpan;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Utility;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.CharSequences;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.CharacterProperties;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UCharacter;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UScript;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.BreakIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Replaceable;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.SymbolTable;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeFilter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeMatcher;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSetIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.Freezable;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ICUUncheckedIOException;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.OutputInt;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.VersionInfo;

public class UnicodeSet
extends UnicodeFilter
implements Freezable<UnicodeSet>,
Comparable<UnicodeSet>,
Iterable<String> {
    private static final SortedSet<String> EMPTY_STRINGS = Collections.unmodifiableSortedSet(new TreeSet());
    public static final UnicodeSet EMPTY = new UnicodeSet().freeze();
    public static final UnicodeSet ALL_CODE_POINTS = new UnicodeSet(0, 0x10FFFF).freeze();
    private static XSymbolTable XSYMBOL_TABLE = null;
    private static final int LOW = 0;
    private static final int HIGH = 0x110000;
    private static final int INITIAL_CAPACITY = 25;
    private static final int MAX_LENGTH = 0x110001;
    public static final int MIN_VALUE = 0;
    public static final int MAX_VALUE = 0x10FFFF;
    private int len;
    private int[] list;
    private int[] rangeList;
    private int[] buffer;
    SortedSet<String> strings = EMPTY_STRINGS;
    private String pat = null;
    private static final String ANY_ID = "ANY";
    private static final String ASCII_ID = "ASCII";
    private static final String ASSIGNED = "Assigned";
    private volatile BMPSet bmpSet;
    private volatile UnicodeSetStringSpan stringSpan;
    private static final int LAST0_START = 0;
    private static final int LAST1_RANGE = 1;
    private static final int LAST2_SET = 2;
    private static final int MODE0_NONE = 0;
    private static final int MODE1_INBRACKET = 1;
    private static final int MODE2_OUTBRACKET = 2;
    private static final int SETMODE0_NONE = 0;
    private static final int SETMODE1_UNICODESET = 1;
    private static final int SETMODE2_PROPERTYPAT = 2;
    private static final int SETMODE3_PREPARSED = 3;
    private static final int MAX_DEPTH = 100;
    private static final VersionInfo NO_VERSION = VersionInfo.getInstance(0, 0, 0, 0);
    public static final int IGNORE_SPACE = 1;
    @Deprecated
    public static final int CASE = 2;
    public static final int CASE_INSENSITIVE = 2;
    public static final int ADD_CASE_MAPPINGS = 4;
    public static final int SIMPLE_CASE_INSENSITIVE = 6;
    private static final int CASE_MASK = 6;

    public UnicodeSet() {
        this.list = new int[25];
        this.list[0] = 0x110000;
        this.len = 1;
    }

    public UnicodeSet(UnicodeSet unicodeSet) {
        this.set(unicodeSet);
    }

    public UnicodeSet(int n2, int n3) {
        this();
        this.add(n2, n3);
    }

    public UnicodeSet(int ... nArray) {
        if ((nArray.length & 1) != 0) {
            throw new IllegalArgumentException("Must have even number of integers");
        }
        this.list = new int[nArray.length + 1];
        this.len = this.list.length;
        int n2 = -1;
        int n3 = 0;
        while (n3 < nArray.length) {
            int n4 = nArray[n3];
            if (n2 >= n4) {
                throw new IllegalArgumentException("Must be monotonically increasing.");
            }
            this.list[n3++] = n4;
            int n5 = nArray[n3] + 1;
            if (n4 >= n5) {
                throw new IllegalArgumentException("Must be monotonically increasing.");
            }
            this.list[n3++] = n2 = n5;
        }
        this.list[n3] = 0x110000;
    }

    public UnicodeSet(String string) {
        this();
        this.applyPattern(string, null, null, 1);
    }

    public UnicodeSet(String string, boolean bl2) {
        this();
        this.applyPattern(string, null, null, bl2 ? 1 : 0);
    }

    public UnicodeSet(String string, int n2) {
        this();
        this.applyPattern(string, null, null, n2);
    }

    public UnicodeSet(String string, ParsePosition parsePosition, SymbolTable symbolTable) {
        this();
        this.applyPattern(string, parsePosition, symbolTable, 1);
    }

    public UnicodeSet(String string, ParsePosition parsePosition, SymbolTable symbolTable, int n2) {
        this();
        this.applyPattern(string, parsePosition, symbolTable, n2);
    }

    public Object clone() {
        if (this.isFrozen()) {
            return this;
        }
        return new UnicodeSet(this);
    }

    public UnicodeSet set(int n2, int n3) {
        this.checkFrozen();
        this.clear();
        this.complement(n2, n3);
        return this;
    }

    public UnicodeSet set(UnicodeSet unicodeSet) {
        this.checkFrozen();
        this.list = Arrays.copyOf(unicodeSet.list, unicodeSet.len);
        this.len = unicodeSet.len;
        this.pat = unicodeSet.pat;
        this.strings = unicodeSet.hasStrings() ? new TreeSet<String>(unicodeSet.strings) : EMPTY_STRINGS;
        return this;
    }

    public final UnicodeSet applyPattern(String string) {
        this.checkFrozen();
        return this.applyPattern(string, null, null, 1);
    }

    public UnicodeSet applyPattern(String string, boolean bl2) {
        this.checkFrozen();
        return this.applyPattern(string, null, null, bl2 ? 1 : 0);
    }

    public UnicodeSet applyPattern(String string, int n2) {
        this.checkFrozen();
        return this.applyPattern(string, null, null, n2);
    }

    public static boolean resemblesPattern(String string, int n2) {
        return n2 + 1 < string.length() && string.charAt(n2) == '[' || UnicodeSet.resemblesPropertyPattern(string, n2);
    }

    private static void appendCodePoint(Appendable appendable, int n2) {
        assert (0 <= n2 && n2 <= 0x10FFFF);
        try {
            if (n2 <= 65535) {
                appendable.append((char)n2);
            } else {
                appendable.append(UTF16.getLeadSurrogate(n2)).append(UTF16.getTrailSurrogate(n2));
            }
        }
        catch (IOException iOException) {
            throw new ICUUncheckedIOException(iOException);
        }
    }

    private static void append(Appendable appendable, CharSequence charSequence) {
        try {
            appendable.append(charSequence);
        }
        catch (IOException iOException) {
            throw new ICUUncheckedIOException(iOException);
        }
    }

    private static <T extends Appendable> T _appendToPat(T t2, String string, boolean bl2) {
        int n2;
        for (int i2 = 0; i2 < string.length(); i2 += Character.charCount(n2)) {
            n2 = string.codePointAt(i2);
            UnicodeSet._appendToPat(t2, n2, bl2);
        }
        return t2;
    }

    private static <T extends Appendable> T _appendToPat(T t2, int n2, boolean bl2) {
        try {
            if (bl2 ? Utility.isUnprintable(n2) : Utility.shouldAlwaysBeEscaped(n2)) {
                return Utility.escape(t2, n2);
            }
            switch (n2) {
                case 36: 
                case 38: 
                case 45: 
                case 58: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 123: 
                case 125: {
                    t2.append('\\');
                    break;
                }
                default: {
                    if (!PatternProps.isWhiteSpace(n2)) break;
                    t2.append('\\');
                }
            }
            UnicodeSet.appendCodePoint(t2, n2);
            return t2;
        }
        catch (IOException iOException) {
            throw new ICUUncheckedIOException(iOException);
        }
    }

    private static <T extends Appendable> T _appendToPat(T t2, int n2, int n3, boolean bl2) {
        UnicodeSet._appendToPat(t2, n2, bl2);
        if (n2 != n3) {
            if (n2 + 1 != n3 || n2 == 56319) {
                try {
                    t2.append('-');
                }
                catch (IOException iOException) {
                    throw new ICUUncheckedIOException(iOException);
                }
            }
            UnicodeSet._appendToPat(t2, n3, bl2);
        }
        return t2;
    }

    @Override
    public String toPattern(boolean bl2) {
        if (this.pat != null && !bl2) {
            return this.pat;
        }
        StringBuilder stringBuilder = new StringBuilder();
        return this._toPattern(stringBuilder, bl2).toString();
    }

    private <T extends Appendable> T _toPattern(T t2, boolean bl2) {
        if (this.pat == null) {
            return this.appendNewPattern(t2, bl2, true);
        }
        try {
            if (!bl2) {
                t2.append(this.pat);
                return t2;
            }
            boolean bl3 = false;
            int n2 = 0;
            while (n2 < this.pat.length()) {
                int n3 = this.pat.codePointAt(n2);
                n2 += Character.charCount(n3);
                if (Utility.isUnprintable(n3)) {
                    Utility.escape(t2, n3);
                    bl3 = false;
                    continue;
                }
                if (!bl3 && n3 == 92) {
                    bl3 = true;
                    continue;
                }
                if (bl3) {
                    t2.append('\\');
                }
                UnicodeSet.appendCodePoint(t2, n3);
                bl3 = false;
            }
            if (bl3) {
                t2.append('\\');
            }
            return t2;
        }
        catch (IOException iOException) {
            throw new ICUUncheckedIOException(iOException);
        }
    }

    public StringBuffer _generatePattern(StringBuffer stringBuffer, boolean bl2) {
        return this._generatePattern(stringBuffer, bl2, true);
    }

    public StringBuffer _generatePattern(StringBuffer stringBuffer, boolean bl2, boolean bl3) {
        return this.appendNewPattern(stringBuffer, bl2, bl3);
    }

    private <T extends Appendable> T appendNewPattern(T t2, boolean bl2, boolean bl3) {
        try {
            t2.append('[');
            int n2 = 0;
            int n3 = this.len & 0xFFFFFFFE;
            if (this.len >= 4 && this.list[0] == 0 && n3 == this.len && !this.hasStrings()) {
                t2.append('^');
                n2 = 1;
                --n3;
            }
            while (n2 < n3) {
                int n4 = this.list[n2];
                int n5 = this.list[n2 + 1] - 1;
                if (55296 > n5 || n5 > 56319) {
                    UnicodeSet._appendToPat(t2, n4, n5, bl2);
                    n2 += 2;
                    continue;
                }
                int n6 = n2;
                while ((n2 += 2) < n3 && this.list[n2] <= 56319) {
                }
                int n7 = n2;
                while (n2 < n3 && (n4 = this.list[n2]) <= 57343) {
                    UnicodeSet._appendToPat(t2, n4, this.list[n2 + 1] - 1, bl2);
                    n2 += 2;
                }
                for (int i2 = n6; i2 < n7; i2 += 2) {
                    UnicodeSet._appendToPat(t2, this.list[i2], this.list[i2 + 1] - 1, bl2);
                }
            }
            if (bl3 && this.hasStrings()) {
                for (String string : this.strings) {
                    t2.append('{');
                    UnicodeSet._appendToPat(t2, string, bl2);
                    t2.append('}');
                }
            }
            t2.append(']');
            return t2;
        }
        catch (IOException iOException) {
            throw new ICUUncheckedIOException(iOException);
        }
    }

    public int size() {
        int n2 = 0;
        int n3 = this.getRangeCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 += this.getRangeEnd(i2) - this.getRangeStart(i2) + 1;
        }
        return n2 + this.strings.size();
    }

    public boolean isEmpty() {
        return this.len == 1 && !this.hasStrings();
    }

    public boolean hasStrings() {
        return !this.strings.isEmpty();
    }

    @Override
    public boolean matchesIndexValue(int n2) {
        int n3;
        for (int i2 = 0; i2 < this.getRangeCount(); ++i2) {
            int n4 = this.getRangeStart(i2);
            if (!((n4 & 0xFFFFFF00) == ((n3 = this.getRangeEnd(i2)) & 0xFFFFFF00) ? (n4 & 0xFF) <= n2 && n2 <= (n3 & 0xFF) : (n4 & 0xFF) <= n2 || n2 <= (n3 & 0xFF))) continue;
            return true;
        }
        if (this.hasStrings()) {
            for (String string : this.strings) {
                if (string.isEmpty() || ((n3 = UTF16.charAt(string, 0)) & 0xFF) != n2) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int matches(Replaceable replaceable, int[] nArray, int n2, boolean bl2) {
        if (nArray[0] == n2) {
            if (this.contains(65535)) {
                return bl2 ? 1 : 2;
            }
            return 0;
        }
        if (this.hasStrings()) {
            boolean bl3 = nArray[0] < n2;
            char c2 = replaceable.charAt(nArray[0]);
            int n3 = 0;
            for (String string : this.strings) {
                if (string.isEmpty()) continue;
                char c3 = string.charAt(bl3 ? 0 : string.length() - 1);
                if (bl3 && c3 > c2) break;
                if (c3 != c2) continue;
                int n4 = UnicodeSet.matchRest(replaceable, nArray[0], n2, string);
                if (bl2) {
                    int n5;
                    int n6 = n5 = bl3 ? n2 - nArray[0] : nArray[0] - n2;
                    if (n4 == n5) {
                        return 1;
                    }
                }
                if (n4 != string.length()) continue;
                if (n4 > n3) {
                    n3 = n4;
                }
                if (!bl3 || n4 >= n3) continue;
                break;
            }
            if (n3 != 0) {
                nArray[0] = nArray[0] + (bl3 ? n3 : -n3);
                return 2;
            }
        }
        return super.matches(replaceable, nArray, n2, bl2);
    }

    private static int matchRest(Replaceable replaceable, int n2, int n3, String string) {
        int n4;
        int n5 = string.length();
        if (n2 < n3) {
            n4 = n3 - n2;
            if (n4 > n5) {
                n4 = n5;
            }
            for (int i2 = 1; i2 < n4; ++i2) {
                if (replaceable.charAt(n2 + i2) == string.charAt(i2)) continue;
                return 0;
            }
        } else {
            n4 = n2 - n3;
            if (n4 > n5) {
                n4 = n5;
            }
            --n5;
            for (int i3 = 1; i3 < n4; ++i3) {
                if (replaceable.charAt(n2 - i3) == string.charAt(n5 - i3)) continue;
                return 0;
            }
        }
        return n4;
    }

    @Deprecated
    public int matchesAt(CharSequence charSequence, int n2) {
        int n3;
        int n4;
        block4: {
            n4 = -1;
            if (this.hasStrings()) {
                int n5;
                n3 = charSequence.charAt(n2);
                String string = null;
                Iterator iterator = this.strings.iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    n5 = string.charAt(0);
                    if (n5 < n3 || n5 <= n3) continue;
                    break block4;
                }
                while (n4 <= (n5 = UnicodeSet.matchesAt(charSequence, n2, string))) {
                    n4 = n5;
                    if (!iterator.hasNext()) break;
                    string = (String)iterator.next();
                }
            }
        }
        if (n4 < 2 && this.contains(n3 = UTF16.charAt(charSequence, n2))) {
            n4 = UTF16.getCharCount(n3);
        }
        return n2 + n4;
    }

    private static int matchesAt(CharSequence charSequence, int n2, CharSequence charSequence2) {
        int n3 = charSequence2.length();
        int n4 = charSequence.length();
        if (n4 + n2 > n3) {
            return -1;
        }
        int n5 = 0;
        int n6 = n2;
        while (n5 < n3) {
            char c2;
            char c3 = charSequence2.charAt(n5);
            if (c3 != (c2 = charSequence.charAt(n6))) {
                return -1;
            }
            ++n5;
            ++n6;
        }
        return n5;
    }

    @Override
    public void addMatchSetTo(UnicodeSet unicodeSet) {
        unicodeSet.addAll(this);
    }

    public int indexOf(int n2) {
        if (n2 < 0 || n2 > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(n2, 6));
        }
        int n3 = 0;
        int n4 = 0;
        int n5;
        while (n2 >= (n5 = this.list[n3++])) {
            int n6;
            if (n2 < (n6 = this.list[n3++])) {
                return n4 + n2 - n5;
            }
            n4 += n6 - n5;
        }
        return -1;
    }

    public int charAt(int n2) {
        if (n2 >= 0) {
            int n3 = this.len & 0xFFFFFFFE;
            int n4 = 0;
            while (n4 < n3) {
                int n5;
                int n6;
                if (n2 < (n6 = this.list[n4++] - (n5 = this.list[n4++]))) {
                    return n5 + n2;
                }
                n2 -= n6;
            }
        }
        return -1;
    }

    public UnicodeSet add(int n2, int n3) {
        this.checkFrozen();
        return this.add_unchecked(n2, n3);
    }

    public UnicodeSet addAll(int n2, int n3) {
        this.checkFrozen();
        return this.add_unchecked(n2, n3);
    }

    private UnicodeSet add_unchecked(int n2, int n3) {
        if (n2 < 0 || n2 > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(n2, 6));
        }
        if (n3 < 0 || n3 > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(n3, 6));
        }
        if (n2 < n3) {
            int n4 = n3 + 1;
            if ((this.len & 1) != 0) {
                int n5;
                int n6 = n5 = this.len == 1 ? -2 : this.list[this.len - 2];
                if (n5 <= n2) {
                    this.checkFrozen();
                    if (n5 == n2) {
                        this.list[this.len - 2] = n4;
                        if (n4 == 0x110000) {
                            --this.len;
                        }
                    } else {
                        this.list[this.len - 1] = n2;
                        if (n4 < 0x110000) {
                            this.ensureCapacity(this.len + 2);
                            this.list[this.len++] = n4;
                            this.list[this.len++] = 0x110000;
                        } else {
                            this.ensureCapacity(this.len + 1);
                            this.list[this.len++] = 0x110000;
                        }
                    }
                    this.pat = null;
                    return this;
                }
            }
            this.add(this.range(n2, n3), 2, 0);
        } else if (n2 == n3) {
            this.add(n2);
        }
        return this;
    }

    public final UnicodeSet add(int n2) {
        this.checkFrozen();
        return this.add_unchecked(n2);
    }

    private final UnicodeSet add_unchecked(int n2) {
        if (n2 < 0 || n2 > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(n2, 6));
        }
        int n3 = this.findCodePoint(n2);
        if ((n3 & 1) != 0) {
            return this;
        }
        if (n2 == this.list[n3] - 1) {
            this.list[n3] = n2;
            if (n2 == 0x10FFFF) {
                this.ensureCapacity(this.len + 1);
                this.list[this.len++] = 0x110000;
            }
            if (n3 > 0 && n2 == this.list[n3 - 1]) {
                System.arraycopy(this.list, n3 + 1, this.list, n3 - 1, this.len - n3 - 1);
                this.len -= 2;
            }
        } else if (n3 > 0 && n2 == this.list[n3 - 1]) {
            int n4 = n3 - 1;
            this.list[n4] = this.list[n4] + 1;
        } else {
            if (this.len + 2 > this.list.length) {
                int[] nArray = new int[this.nextCapacity(this.len + 2)];
                if (n3 != 0) {
                    System.arraycopy(this.list, 0, nArray, 0, n3);
                }
                System.arraycopy(this.list, n3, nArray, n3 + 2, this.len - n3);
                this.list = nArray;
            } else {
                System.arraycopy(this.list, n3, this.list, n3 + 2, this.len - n3);
            }
            this.list[n3] = n2;
            this.list[n3 + 1] = n2 + 1;
            this.len += 2;
        }
        this.pat = null;
        return this;
    }

    public final UnicodeSet add(CharSequence charSequence) {
        this.checkFrozen();
        int n2 = UnicodeSet.getSingleCP(charSequence);
        if (n2 < 0) {
            String string = charSequence.toString();
            if (!this.strings.contains(string)) {
                this.addString(string);
                this.pat = null;
            }
        } else {
            this.add_unchecked(n2, n2);
        }
        return this;
    }

    private void addString(CharSequence charSequence) {
        if (this.strings == EMPTY_STRINGS) {
            this.strings = new TreeSet<String>();
        }
        this.strings.add(charSequence.toString());
    }

    private static int getSingleCP(CharSequence charSequence) {
        int n2;
        if (charSequence.length() == 1) {
            return charSequence.charAt(0);
        }
        if (charSequence.length() == 2 && (n2 = Character.codePointAt(charSequence, 0)) > 65535) {
            return n2;
        }
        return -1;
    }

    public final UnicodeSet addAll(CharSequence charSequence) {
        int n2;
        this.checkFrozen();
        for (int i2 = 0; i2 < charSequence.length(); i2 += UTF16.getCharCount(n2)) {
            n2 = UTF16.charAt(charSequence, i2);
            this.add_unchecked(n2, n2);
        }
        return this;
    }

    public final UnicodeSet retainAll(CharSequence charSequence) {
        return this.retainAll(UnicodeSet.fromAll(charSequence));
    }

    public final UnicodeSet complementAll(CharSequence charSequence) {
        return this.complementAll(UnicodeSet.fromAll(charSequence));
    }

    public final UnicodeSet removeAll(CharSequence charSequence) {
        return this.removeAll(UnicodeSet.fromAll(charSequence));
    }

    public final UnicodeSet removeAllStrings() {
        this.checkFrozen();
        if (this.hasStrings()) {
            this.strings.clear();
            this.pat = null;
        }
        return this;
    }

    public static UnicodeSet from(CharSequence charSequence) {
        return new UnicodeSet().add(charSequence);
    }

    public static UnicodeSet fromAll(CharSequence charSequence) {
        return new UnicodeSet().addAll(charSequence);
    }

    public UnicodeSet retain(int n2, int n3) {
        this.checkFrozen();
        if (n2 < 0 || n2 > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(n2, 6));
        }
        if (n3 < 0 || n3 > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(n3, 6));
        }
        if (n2 <= n3) {
            this.retain(this.range(n2, n3), 2, 0);
        } else {
            this.clear();
        }
        return this;
    }

    public final UnicodeSet retain(int n2) {
        return this.retain(n2, n2);
    }

    public final UnicodeSet retain(CharSequence charSequence) {
        int n2 = UnicodeSet.getSingleCP(charSequence);
        if (n2 < 0) {
            this.checkFrozen();
            String string = charSequence.toString();
            boolean bl2 = this.strings.contains(string);
            if (bl2 && this.getRangeCount() == 0 && this.size() == 1) {
                return this;
            }
            this.clear();
            if (bl2) {
                this.addString(string);
            }
            this.pat = null;
        } else {
            this.retain(n2, n2);
        }
        return this;
    }

    public UnicodeSet remove(int n2, int n3) {
        this.checkFrozen();
        if (n2 < 0 || n2 > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(n2, 6));
        }
        if (n3 < 0 || n3 > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(n3, 6));
        }
        if (n2 <= n3) {
            this.retain(this.range(n2, n3), 2, 2);
        }
        return this;
    }

    public final UnicodeSet remove(int n2) {
        return this.remove(n2, n2);
    }

    public final UnicodeSet remove(CharSequence charSequence) {
        int n2 = UnicodeSet.getSingleCP(charSequence);
        if (n2 < 0) {
            this.checkFrozen();
            String string = charSequence.toString();
            if (this.strings.contains(string)) {
                this.strings.remove(string);
                this.pat = null;
            }
        } else {
            this.remove(n2, n2);
        }
        return this;
    }

    public UnicodeSet complement(int n2, int n3) {
        this.checkFrozen();
        if (n2 < 0 || n2 > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(n2, 6));
        }
        if (n3 < 0 || n3 > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(n3, 6));
        }
        if (n2 <= n3) {
            this.xor(this.range(n2, n3), 2, 0);
        }
        this.pat = null;
        return this;
    }

    public final UnicodeSet complement(int n2) {
        return this.complement(n2, n2);
    }

    public UnicodeSet complement() {
        this.checkFrozen();
        if (this.list[0] == 0) {
            System.arraycopy(this.list, 1, this.list, 0, this.len - 1);
            --this.len;
        } else {
            this.ensureCapacity(this.len + 1);
            System.arraycopy(this.list, 0, this.list, 1, this.len);
            this.list[0] = 0;
            ++this.len;
        }
        this.pat = null;
        return this;
    }

    public final UnicodeSet complement(CharSequence charSequence) {
        this.checkFrozen();
        int n2 = UnicodeSet.getSingleCP(charSequence);
        if (n2 < 0) {
            String string = charSequence.toString();
            if (this.strings.contains(string)) {
                this.strings.remove(string);
            } else {
                this.addString(string);
            }
            this.pat = null;
        } else {
            this.complement(n2, n2);
        }
        return this;
    }

    @Override
    public boolean contains(int n2) {
        if (n2 < 0 || n2 > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(n2, 6));
        }
        if (this.bmpSet != null) {
            return this.bmpSet.contains(n2);
        }
        if (this.stringSpan != null) {
            return this.stringSpan.contains(n2);
        }
        int n3 = this.findCodePoint(n2);
        return (n3 & 1) != 0;
    }

    private final int findCodePoint(int n2) {
        if (n2 < this.list[0]) {
            return 0;
        }
        if (this.len >= 2 && n2 >= this.list[this.len - 2]) {
            return this.len - 1;
        }
        int n3 = 0;
        int n4 = this.len - 1;
        int n5;
        while ((n5 = n3 + n4 >>> 1) != n3) {
            if (n2 < this.list[n5]) {
                n4 = n5;
                continue;
            }
            n3 = n5;
        }
        return n4;
    }

    public boolean contains(int n2, int n3) {
        if (n2 < 0 || n2 > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(n2, 6));
        }
        if (n3 < 0 || n3 > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(n3, 6));
        }
        int n4 = this.findCodePoint(n2);
        return (n4 & 1) != 0 && n3 < this.list[n4];
    }

    public final boolean contains(CharSequence charSequence) {
        int n2 = UnicodeSet.getSingleCP(charSequence);
        if (n2 < 0) {
            return this.strings.contains(charSequence.toString());
        }
        return this.contains(n2);
    }

    public boolean containsAll(UnicodeSet unicodeSet) {
        block6: {
            int[] nArray = unicodeSet.list;
            boolean bl2 = true;
            boolean bl3 = true;
            int n2 = 0;
            int n3 = 0;
            int n4 = this.len - 1;
            int n5 = unicodeSet.len - 1;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            while (true) {
                if (bl2) {
                    if (n2 >= n4) {
                        if (!bl3 || n3 < n5) {
                            return false;
                        }
                        break block6;
                    }
                    n6 = this.list[n2++];
                    n8 = this.list[n2++];
                }
                if (bl3) {
                    if (n3 >= n5) break block6;
                    n7 = nArray[n3++];
                    n9 = nArray[n3++];
                }
                if (n7 >= n8) {
                    bl2 = true;
                    bl3 = false;
                    continue;
                }
                if (n7 < n6 || n9 > n8) break;
                bl2 = false;
                bl3 = true;
            }
            return false;
        }
        return this.strings.containsAll(unicodeSet.strings);
    }

    public boolean containsAll(String string) {
        int n2;
        for (int i2 = 0; i2 < string.length(); i2 += UTF16.getCharCount(n2)) {
            n2 = UTF16.charAt(string, i2);
            if (this.contains(n2)) continue;
            if (!this.hasStrings()) {
                return false;
            }
            return this.containsAll(string, 0);
        }
        return true;
    }

    private boolean containsAll(String string, int n2) {
        if (n2 >= string.length()) {
            return true;
        }
        int n3 = UTF16.charAt(string, n2);
        if (this.contains(n3) && this.containsAll(string, n2 + UTF16.getCharCount(n3))) {
            return true;
        }
        for (String string2 : this.strings) {
            if (string2.isEmpty() || !string.startsWith(string2, n2) || !this.containsAll(string, n2 + string2.length())) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public String getRegexEquivalent() {
        if (!this.hasStrings()) {
            return this.toString();
        }
        StringBuilder stringBuilder = new StringBuilder("(?:");
        this.appendNewPattern(stringBuilder, true, false);
        for (String string : this.strings) {
            stringBuilder.append('|');
            UnicodeSet._appendToPat(stringBuilder, string, true);
        }
        return stringBuilder.append(")").toString();
    }

    public boolean containsNone(int n2, int n3) {
        if (n2 < 0 || n2 > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(n2, 6));
        }
        if (n3 < 0 || n3 > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(n3, 6));
        }
        int n4 = -1;
        while (n2 >= this.list[++n4]) {
        }
        return (n4 & 1) == 0 && n3 < this.list[n4];
    }

    public boolean containsNone(UnicodeSet unicodeSet) {
        block4: {
            int[] nArray = unicodeSet.list;
            boolean bl2 = true;
            boolean bl3 = true;
            int n2 = 0;
            int n3 = 0;
            int n4 = this.len - 1;
            int n5 = unicodeSet.len - 1;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            while (true) {
                if (bl2) {
                    if (n2 >= n4) break block4;
                    n6 = this.list[n2++];
                    n8 = this.list[n2++];
                }
                if (bl3) {
                    if (n3 >= n5) break block4;
                    n7 = nArray[n3++];
                    n9 = nArray[n3++];
                }
                if (n7 >= n8) {
                    bl2 = true;
                    bl3 = false;
                    continue;
                }
                if (n6 < n9) break;
                bl2 = false;
                bl3 = true;
            }
            return false;
        }
        return SortedSetRelation.hasRelation(this.strings, 5, unicodeSet.strings);
    }

    public boolean containsNone(CharSequence charSequence) {
        return this.span(charSequence, SpanCondition.NOT_CONTAINED) == charSequence.length();
    }

    public final boolean containsSome(int n2, int n3) {
        return !this.containsNone(n2, n3);
    }

    public final boolean containsSome(UnicodeSet unicodeSet) {
        return !this.containsNone(unicodeSet);
    }

    public final boolean containsSome(CharSequence charSequence) {
        return !this.containsNone(charSequence);
    }

    public UnicodeSet addAll(UnicodeSet unicodeSet) {
        this.checkFrozen();
        this.add(unicodeSet.list, unicodeSet.len, 0);
        if (unicodeSet.hasStrings()) {
            if (this.strings == EMPTY_STRINGS) {
                this.strings = new TreeSet<String>(unicodeSet.strings);
            } else {
                this.strings.addAll(unicodeSet.strings);
            }
        }
        return this;
    }

    public UnicodeSet retainAll(UnicodeSet unicodeSet) {
        this.checkFrozen();
        this.retain(unicodeSet.list, unicodeSet.len, 0);
        if (this.hasStrings()) {
            if (!unicodeSet.hasStrings()) {
                this.strings.clear();
            } else {
                this.strings.retainAll(unicodeSet.strings);
            }
        }
        return this;
    }

    public UnicodeSet removeAll(UnicodeSet unicodeSet) {
        this.checkFrozen();
        this.retain(unicodeSet.list, unicodeSet.len, 2);
        if (this.hasStrings() && unicodeSet.hasStrings()) {
            this.strings.removeAll(unicodeSet.strings);
        }
        return this;
    }

    public UnicodeSet complementAll(UnicodeSet unicodeSet) {
        this.checkFrozen();
        this.xor(unicodeSet.list, unicodeSet.len, 0);
        if (unicodeSet.hasStrings()) {
            if (this.strings == EMPTY_STRINGS) {
                this.strings = new TreeSet<String>(unicodeSet.strings);
            } else {
                SortedSetRelation.doOperation(this.strings, 5, unicodeSet.strings);
            }
        }
        return this;
    }

    public UnicodeSet clear() {
        this.checkFrozen();
        this.list[0] = 0x110000;
        this.len = 1;
        this.pat = null;
        if (this.hasStrings()) {
            this.strings.clear();
        }
        return this;
    }

    public int getRangeCount() {
        return this.len / 2;
    }

    public int getRangeStart(int n2) {
        return this.list[n2 * 2];
    }

    public int getRangeEnd(int n2) {
        return this.list[n2 * 2 + 1] - 1;
    }

    public UnicodeSet compact() {
        this.checkFrozen();
        if (this.len + 7 < this.list.length) {
            this.list = Arrays.copyOf(this.list, this.len);
        }
        this.rangeList = null;
        this.buffer = null;
        if (this.strings != EMPTY_STRINGS && this.strings.isEmpty()) {
            this.strings = EMPTY_STRINGS;
        }
        return this;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        try {
            UnicodeSet unicodeSet = (UnicodeSet)object;
            if (this.len != unicodeSet.len) {
                return false;
            }
            for (int i2 = 0; i2 < this.len; ++i2) {
                if (this.list[i2] == unicodeSet.list[i2]) continue;
                return false;
            }
            if (!this.strings.equals(unicodeSet.strings)) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n2 = this.len;
        for (int i2 = 0; i2 < this.len; ++i2) {
            n2 *= 1000003;
            n2 += this.list[i2];
        }
        return n2;
    }

    public String toString() {
        return this.toPattern(true);
    }

    @Deprecated
    public UnicodeSet applyPattern(String string, ParsePosition parsePosition, SymbolTable symbolTable, int n2) {
        boolean bl2;
        boolean bl3 = bl2 = parsePosition == null;
        if (bl2) {
            parsePosition = new ParsePosition(0);
        }
        StringBuilder stringBuilder = new StringBuilder();
        RuleCharacterIterator ruleCharacterIterator = new RuleCharacterIterator(string, symbolTable, parsePosition);
        this.applyPattern(ruleCharacterIterator, symbolTable, stringBuilder, n2, 0);
        if (ruleCharacterIterator.inVariable()) {
            UnicodeSet.syntaxError(ruleCharacterIterator, "Extra chars in variable value");
        }
        this.pat = stringBuilder.toString();
        if (bl2) {
            int n3 = parsePosition.getIndex();
            if ((n2 & 1) != 0) {
                n3 = PatternProps.skipWhiteSpace(string, n3);
            }
            if (n3 != string.length()) {
                throw new IllegalArgumentException("Parse of \"" + string + "\" failed at " + n3);
            }
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void applyPattern(RuleCharacterIterator ruleCharacterIterator, SymbolTable symbolTable, Appendable appendable, int n2, int n3) {
        if (n3 > 100) {
            UnicodeSet.syntaxError(ruleCharacterIterator, "Pattern nested too deeply");
        }
        int n4 = 3;
        if ((n2 & 1) != 0) {
            n4 |= 4;
        }
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = null;
        boolean bl2 = false;
        UnicodeSet unicodeSet = null;
        RuleCharacterIterator.Position position = null;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        char c2 = '\u0000';
        boolean bl3 = false;
        this.clear();
        String string = null;
        block27: while (n7 != 2 && !ruleCharacterIterator.atEnd()) {
            int n8;
            UnicodeSet unicodeSet2;
            boolean bl4;
            int n9;
            block78: {
                UnicodeMatcher unicodeMatcher;
                block80: {
                    block79: {
                        n9 = 0;
                        bl4 = false;
                        unicodeSet2 = null;
                        n8 = 0;
                        if (!UnicodeSet.resemblesPropertyPattern(ruleCharacterIterator, n4)) break block79;
                        n8 = 2;
                        break block78;
                    }
                    position = ruleCharacterIterator.getPos(position);
                    n9 = ruleCharacterIterator.next(n4);
                    bl4 = ruleCharacterIterator.isEscaped();
                    if (n9 != 91 || bl4) break block80;
                    if (n7 == 1) {
                        ruleCharacterIterator.setPos(position);
                        n8 = 1;
                        break block78;
                    } else {
                        n7 = 1;
                        stringBuilder.append('[');
                        position = ruleCharacterIterator.getPos(position);
                        n9 = ruleCharacterIterator.next(n4);
                        bl4 = ruleCharacterIterator.isEscaped();
                        if (n9 == 94 && !bl4) {
                            bl3 = true;
                            stringBuilder.append('^');
                            position = ruleCharacterIterator.getPos(position);
                            n9 = ruleCharacterIterator.next(n4);
                            bl4 = ruleCharacterIterator.isEscaped();
                        }
                        if (n9 == 45) {
                            bl4 = true;
                            break block78;
                        } else {
                            ruleCharacterIterator.setPos(position);
                            continue;
                        }
                    }
                }
                if (symbolTable != null && (unicodeMatcher = symbolTable.lookupMatcher(n9)) != null) {
                    try {
                        unicodeSet2 = (UnicodeSet)unicodeMatcher;
                        n8 = 3;
                    }
                    catch (ClassCastException classCastException) {
                        UnicodeSet.syntaxError(ruleCharacterIterator, "Syntax error");
                    }
                }
            }
            if (n8 != 0) {
                if (n5 == 1) {
                    if (c2 != '\u0000') {
                        UnicodeSet.syntaxError(ruleCharacterIterator, "Char expected after operator");
                    }
                    this.add_unchecked(n6, n6);
                    UnicodeSet._appendToPat(stringBuilder, n6, false);
                    n5 = 0;
                    c2 = '\u0000';
                }
                if (c2 == '-' || c2 == '&') {
                    stringBuilder.append(c2);
                }
                if (unicodeSet2 == null) {
                    if (unicodeSet == null) {
                        unicodeSet = new UnicodeSet();
                    }
                    unicodeSet2 = unicodeSet;
                }
                switch (n8) {
                    case 1: {
                        unicodeSet2.applyPattern(ruleCharacterIterator, symbolTable, stringBuilder, n2, n3 + 1);
                        break;
                    }
                    case 2: {
                        ruleCharacterIterator.skipIgnored(n4);
                        unicodeSet2.applyPropertyPattern(ruleCharacterIterator, stringBuilder, symbolTable);
                        break;
                    }
                    case 3: {
                        unicodeSet2._toPattern(stringBuilder, false);
                        break;
                    }
                }
                bl2 = true;
                if (n7 == 0) {
                    this.set(unicodeSet2);
                    n7 = 2;
                    break;
                }
                switch (c2) {
                    case '-': {
                        this.removeAll(unicodeSet2);
                        break;
                    }
                    case '&': {
                        this.retainAll(unicodeSet2);
                        break;
                    }
                    case '\u0000': {
                        this.addAll(unicodeSet2);
                        break;
                    }
                }
                c2 = '\u0000';
                n5 = 2;
                continue;
            }
            if (n7 == 0) {
                UnicodeSet.syntaxError(ruleCharacterIterator, "Missing '['");
            }
            if (!bl4) {
                switch (n9) {
                    case 93: {
                        if (n5 == 1) {
                            this.add_unchecked(n6, n6);
                            UnicodeSet._appendToPat(stringBuilder, n6, false);
                        }
                        if (c2 == '-') {
                            this.add_unchecked(c2, c2);
                            stringBuilder.append(c2);
                        } else if (c2 == '&') {
                            UnicodeSet.syntaxError(ruleCharacterIterator, "Trailing '&'");
                        }
                        stringBuilder.append(']');
                        n7 = 2;
                        continue block27;
                    }
                    case 45: {
                        if (c2 == '\u0000') {
                            if (n5 != 0) {
                                c2 = (char)n9;
                                continue block27;
                            }
                            if (string != null) {
                                c2 = (char)n9;
                                continue block27;
                            }
                            this.add_unchecked(n9, n9);
                            n9 = ruleCharacterIterator.next(n4);
                            bl4 = ruleCharacterIterator.isEscaped();
                            if (n9 == 93 && !bl4) {
                                stringBuilder.append("-]");
                                n7 = 2;
                                continue block27;
                            }
                        }
                        UnicodeSet.syntaxError(ruleCharacterIterator, "'-' not after char, string, or set");
                        break;
                    }
                    case 38: {
                        if (n5 == 2 && c2 == '\u0000') {
                            c2 = (char)n9;
                            continue block27;
                        }
                        UnicodeSet.syntaxError(ruleCharacterIterator, "'&' not after set");
                        break;
                    }
                    case 94: {
                        UnicodeSet.syntaxError(ruleCharacterIterator, "'^' not after '['");
                        break;
                    }
                    case 123: {
                        int n10;
                        if (c2 != '\u0000' && c2 != '-') {
                            UnicodeSet.syntaxError(ruleCharacterIterator, "Missing operand after operator");
                        }
                        if (n5 == 1) {
                            this.add_unchecked(n6, n6);
                            UnicodeSet._appendToPat(stringBuilder, n6, false);
                        }
                        n5 = 0;
                        if (stringBuilder2 == null) {
                            stringBuilder2 = new StringBuilder();
                        } else {
                            stringBuilder2.setLength(0);
                        }
                        boolean bl5 = false;
                        while (!ruleCharacterIterator.atEnd()) {
                            n9 = ruleCharacterIterator.next(n4);
                            bl4 = ruleCharacterIterator.isEscaped();
                            if (n9 == 125 && !bl4) {
                                bl5 = true;
                                break;
                            }
                            UnicodeSet.appendCodePoint(stringBuilder2, n9);
                        }
                        if (!bl5) {
                            UnicodeSet.syntaxError(ruleCharacterIterator, "Invalid multicharacter string");
                        }
                        String string2 = stringBuilder2.toString();
                        if (c2 == '-') {
                            n10 = CharSequences.getSingleCodePoint(string == null ? "" : string);
                            int n11 = CharSequences.getSingleCodePoint(string2);
                            if (n10 != Integer.MAX_VALUE && n11 != Integer.MAX_VALUE) {
                                this.add(n10, n11);
                            } else {
                                if (this.strings == EMPTY_STRINGS) {
                                    this.strings = new TreeSet<String>();
                                }
                                try {
                                    StringRange.expand(string, string2, true, this.strings);
                                }
                                catch (Exception exception) {
                                    UnicodeSet.syntaxError(ruleCharacterIterator, exception.getMessage());
                                }
                            }
                            string = null;
                            c2 = '\u0000';
                        } else {
                            this.add(string2);
                            string = string2;
                        }
                        stringBuilder.append('{');
                        UnicodeSet._appendToPat(stringBuilder, string2, false);
                        stringBuilder.append('}');
                        continue block27;
                    }
                    case 36: {
                        int n10;
                        position = ruleCharacterIterator.getPos(position);
                        n9 = ruleCharacterIterator.next(n4);
                        bl4 = ruleCharacterIterator.isEscaped();
                        int n12 = n10 = n9 == 93 && !bl4 ? 1 : 0;
                        if (symbolTable == null && n10 == 0) {
                            n9 = 36;
                            ruleCharacterIterator.setPos(position);
                            break;
                        }
                        if (n10 != 0 && c2 == '\u0000') {
                            if (n5 == 1) {
                                this.add_unchecked(n6, n6);
                                UnicodeSet._appendToPat(stringBuilder, n6, false);
                            }
                            this.add_unchecked(65535);
                            bl2 = true;
                            stringBuilder.append('$').append(']');
                            n7 = 2;
                            continue block27;
                        }
                        UnicodeSet.syntaxError(ruleCharacterIterator, "Unquoted '$'");
                        break;
                    }
                }
            }
            switch (n5) {
                case 0: {
                    if (c2 == '-' && string != null) {
                        UnicodeSet.syntaxError(ruleCharacterIterator, "Invalid range");
                    }
                    n5 = 1;
                    n6 = n9;
                    string = null;
                    break;
                }
                case 1: {
                    if (c2 == '-') {
                        if (string != null) {
                            UnicodeSet.syntaxError(ruleCharacterIterator, "Invalid range");
                        }
                        if (n6 >= n9) {
                            UnicodeSet.syntaxError(ruleCharacterIterator, "Invalid range");
                        }
                        this.add_unchecked(n6, n9);
                        UnicodeSet._appendToPat(stringBuilder, n6, false);
                        stringBuilder.append(c2);
                        UnicodeSet._appendToPat(stringBuilder, n9, false);
                        n5 = 0;
                        c2 = '\u0000';
                        break;
                    }
                    this.add_unchecked(n6, n6);
                    UnicodeSet._appendToPat(stringBuilder, n6, false);
                    n6 = n9;
                    break;
                }
                case 2: {
                    if (c2 != '\u0000') {
                        UnicodeSet.syntaxError(ruleCharacterIterator, "Set expected after operator");
                    }
                    n6 = n9;
                    n5 = 1;
                    continue block27;
                }
            }
        }
        if (n7 != 2) {
            UnicodeSet.syntaxError(ruleCharacterIterator, "Missing ']'");
        }
        ruleCharacterIterator.skipIgnored(n4);
        if ((n2 & 6) != 0) {
            this.closeOver(n2);
        }
        if (bl3) {
            this.complement().removeAllStrings();
        }
        if (bl2) {
            UnicodeSet.append(appendable, stringBuilder.toString());
            return;
        }
        this.appendNewPattern(appendable, false, true);
    }

    private static void syntaxError(RuleCharacterIterator ruleCharacterIterator, String string) {
        throw new IllegalArgumentException("Error: " + string + " at \"" + Utility.escape(ruleCharacterIterator.toString()) + '\"');
    }

    public <T extends Collection<String>> T addAllTo(T t2) {
        return UnicodeSet.addAllTo(this, t2);
    }

    public String[] addAllTo(String[] stringArray) {
        return UnicodeSet.addAllTo(this, stringArray);
    }

    public static String[] toArray(UnicodeSet unicodeSet) {
        return UnicodeSet.addAllTo(unicodeSet, new String[unicodeSet.size()]);
    }

    public UnicodeSet add(Iterable<?> iterable) {
        return this.addAll(iterable);
    }

    public UnicodeSet addAll(Iterable<?> iterable) {
        this.checkFrozen();
        for (Object obj : iterable) {
            this.add(obj.toString());
        }
        return this;
    }

    private int nextCapacity(int n2) {
        if (n2 < 25) {
            return n2 + 25;
        }
        if (n2 <= 2500) {
            return 5 * n2;
        }
        int n3 = 2 * n2;
        if (n3 > 0x110001) {
            n3 = 0x110001;
        }
        return n3;
    }

    private void ensureCapacity(int n2) {
        if (n2 > 0x110001) {
            n2 = 0x110001;
        }
        if (n2 <= this.list.length) {
            return;
        }
        int n3 = this.nextCapacity(n2);
        int[] nArray = new int[n3];
        System.arraycopy(this.list, 0, nArray, 0, this.len);
        this.list = nArray;
    }

    private void ensureBufferCapacity(int n2) {
        if (n2 > 0x110001) {
            n2 = 0x110001;
        }
        if (this.buffer != null && n2 <= this.buffer.length) {
            return;
        }
        int n3 = this.nextCapacity(n2);
        this.buffer = new int[n3];
    }

    private int[] range(int n2, int n3) {
        if (this.rangeList == null) {
            this.rangeList = new int[]{n2, n3 + 1, 0x110000};
        } else {
            this.rangeList[0] = n2;
            this.rangeList[1] = n3 + 1;
        }
        return this.rangeList;
    }

    private UnicodeSet xor(int[] nArray, int n2, int n3) {
        int n4;
        this.ensureBufferCapacity(this.len + n2);
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = this.list[n5++];
        if (n3 == 1 || n3 == 2) {
            n4 = 0;
            if (nArray[n6] == 0) {
                n4 = nArray[++n6];
            }
        } else {
            n4 = nArray[n6++];
        }
        while (true) {
            if (n8 < n4) {
                this.buffer[n7++] = n8;
                n8 = this.list[n5++];
                continue;
            }
            if (n4 < n8) {
                this.buffer[n7++] = n4;
                n4 = nArray[n6++];
                continue;
            }
            if (n8 == 0x110000) break;
            n8 = this.list[n5++];
            n4 = nArray[n6++];
        }
        this.buffer[n7++] = 0x110000;
        this.len = n7;
        int[] nArray2 = this.list;
        this.list = this.buffer;
        this.buffer = nArray2;
        this.pat = null;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    private UnicodeSet add(int[] nArray, int n2, int n3) {
        this.ensureBufferCapacity(this.len + n2);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = this.list[n4++];
        int n8 = nArray[n5++];
        block6: while (true) {
            switch (n3) {
                case 0: {
                    if (n7 < n8) {
                        if (n6 > 0 && n7 <= this.buffer[n6 - 1]) {
                            n7 = UnicodeSet.max(this.list[n4], this.buffer[--n6]);
                        } else {
                            this.buffer[n6++] = n7;
                            n7 = this.list[n4];
                        }
                        ++n4;
                        n3 ^= 1;
                        break;
                    }
                    if (n8 < n7) {
                        if (n6 > 0 && n8 <= this.buffer[n6 - 1]) {
                            n8 = UnicodeSet.max(nArray[n5], this.buffer[--n6]);
                        } else {
                            this.buffer[n6++] = n8;
                            n8 = nArray[n5];
                        }
                        ++n5;
                        n3 ^= 2;
                        break;
                    }
                    if (n7 == 0x110000) break block6;
                    if (n6 > 0 && n7 <= this.buffer[n6 - 1]) {
                        n7 = UnicodeSet.max(this.list[n4], this.buffer[--n6]);
                    } else {
                        this.buffer[n6++] = n7;
                        n7 = this.list[n4];
                    }
                    ++n4;
                    n3 ^= 1;
                    n8 = nArray[n5++];
                    n3 ^= 2;
                    break;
                }
                case 3: {
                    if (n8 <= n7) {
                        if (n7 == 0x110000) break block6;
                        this.buffer[n6++] = n7;
                    } else {
                        if (n8 == 0x110000) break block6;
                        this.buffer[n6++] = n8;
                    }
                    n7 = this.list[n4++];
                    n3 ^= 1;
                    n8 = nArray[n5++];
                    n3 ^= 2;
                    break;
                }
                case 1: {
                    if (n7 < n8) {
                        this.buffer[n6++] = n7;
                        n7 = this.list[n4++];
                        n3 ^= 1;
                        break;
                    }
                    if (n8 < n7) {
                        n8 = nArray[n5++];
                        n3 ^= 2;
                        break;
                    }
                    if (n7 == 0x110000) break block6;
                    n7 = this.list[n4++];
                    n3 ^= 1;
                    n8 = nArray[n5++];
                    n3 ^= 2;
                    break;
                }
                case 2: {
                    if (n8 < n7) {
                        this.buffer[n6++] = n8;
                        n8 = nArray[n5++];
                        n3 ^= 2;
                        break;
                    }
                    if (n7 < n8) {
                        n7 = this.list[n4++];
                        n3 ^= 1;
                        break;
                    }
                    if (n7 == 0x110000) break block6;
                    n7 = this.list[n4++];
                    n3 ^= 1;
                    n8 = nArray[n5++];
                    n3 ^= 2;
                }
            }
        }
        this.buffer[n6++] = 0x110000;
        this.len = n6;
        int[] nArray2 = this.list;
        this.list = this.buffer;
        this.buffer = nArray2;
        this.pat = null;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    private UnicodeSet retain(int[] nArray, int n2, int n3) {
        this.ensureBufferCapacity(this.len + n2);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = this.list[n4++];
        int n8 = nArray[n5++];
        block6: while (true) {
            switch (n3) {
                case 0: {
                    if (n7 < n8) {
                        n7 = this.list[n4++];
                        n3 ^= 1;
                        break;
                    }
                    if (n8 < n7) {
                        n8 = nArray[n5++];
                        n3 ^= 2;
                        break;
                    }
                    if (n7 == 0x110000) break block6;
                    this.buffer[n6++] = n7;
                    n7 = this.list[n4++];
                    n3 ^= 1;
                    n8 = nArray[n5++];
                    n3 ^= 2;
                    break;
                }
                case 3: {
                    if (n7 < n8) {
                        this.buffer[n6++] = n7;
                        n7 = this.list[n4++];
                        n3 ^= 1;
                        break;
                    }
                    if (n8 < n7) {
                        this.buffer[n6++] = n8;
                        n8 = nArray[n5++];
                        n3 ^= 2;
                        break;
                    }
                    if (n7 == 0x110000) break block6;
                    this.buffer[n6++] = n7;
                    n7 = this.list[n4++];
                    n3 ^= 1;
                    n8 = nArray[n5++];
                    n3 ^= 2;
                    break;
                }
                case 1: {
                    if (n7 < n8) {
                        n7 = this.list[n4++];
                        n3 ^= 1;
                        break;
                    }
                    if (n8 < n7) {
                        this.buffer[n6++] = n8;
                        n8 = nArray[n5++];
                        n3 ^= 2;
                        break;
                    }
                    if (n7 == 0x110000) break block6;
                    n7 = this.list[n4++];
                    n3 ^= 1;
                    n8 = nArray[n5++];
                    n3 ^= 2;
                    break;
                }
                case 2: {
                    if (n8 < n7) {
                        n8 = nArray[n5++];
                        n3 ^= 2;
                        break;
                    }
                    if (n7 < n8) {
                        this.buffer[n6++] = n7;
                        n7 = this.list[n4++];
                        n3 ^= 1;
                        break;
                    }
                    if (n7 == 0x110000) break block6;
                    n7 = this.list[n4++];
                    n3 ^= 1;
                    n8 = nArray[n5++];
                    n3 ^= 2;
                }
            }
        }
        this.buffer[n6++] = 0x110000;
        this.len = n6;
        int[] nArray2 = this.list;
        this.list = this.buffer;
        this.buffer = nArray2;
        this.pat = null;
        return this;
    }

    private static final int max(int n2, int n3) {
        return n2 > n3 ? n2 : n3;
    }

    private void applyFilter(Filter filter, UnicodeSet unicodeSet) {
        this.clear();
        int n2 = -1;
        int n3 = unicodeSet.getRangeCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = unicodeSet.getRangeStart(i2);
            int n5 = unicodeSet.getRangeEnd(i2);
            for (int i3 = n4; i3 <= n5; ++i3) {
                if (filter.contains(i3)) {
                    if (n2 >= 0) continue;
                    n2 = i3;
                    continue;
                }
                if (n2 < 0) continue;
                this.add_unchecked(n2, i3 - 1);
                n2 = -1;
            }
        }
        if (n2 >= 0) {
            this.add_unchecked(n2, 0x10FFFF);
        }
    }

    private static String mungeCharName(String string) {
        string = PatternProps.trimWhiteSpace(string);
        StringBuilder stringBuilder = null;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            int n2 = string.charAt(i2);
            if (PatternProps.isWhiteSpace(n2)) {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder().append(string, 0, i2);
                } else if (stringBuilder.charAt(stringBuilder.length() - 1) == ' ') continue;
                n2 = 32;
            }
            if (stringBuilder == null) continue;
            stringBuilder.append((char)n2);
        }
        return stringBuilder == null ? string : stringBuilder.toString();
    }

    public UnicodeSet applyIntPropertyValue(int n2, int n3) {
        if (n2 == 8192) {
            UnicodeSet unicodeSet = CharacterPropertiesImpl.getInclusionsForProperty(n2);
            this.applyFilter(new GeneralCategoryMaskFilter(n3), unicodeSet);
        } else if (n2 == 28672) {
            UnicodeSet unicodeSet = CharacterPropertiesImpl.getInclusionsForProperty(n2);
            this.applyFilter(new ScriptExtensionsFilter(n3), unicodeSet);
        } else if (n2 == 28673) {
            UnicodeSet unicodeSet = CharacterPropertiesImpl.getInclusionsForProperty(n2);
            this.applyFilter(new IdentifierTypeFilter(n3), unicodeSet);
        } else if (0 <= n2 && n2 < 75) {
            if (n3 == 0 || n3 == 1) {
                this.set(CharacterProperties.getBinaryPropertySet(n2));
                if (n3 == 0) {
                    this.complement().removeAllStrings();
                }
            } else {
                this.clear();
            }
        } else if (4096 <= n2 && n2 < 4122) {
            UnicodeSet unicodeSet = CharacterPropertiesImpl.getInclusionsForProperty(n2);
            this.applyFilter(new IntPropertyFilter(n2, n3), unicodeSet);
        } else {
            throw new IllegalArgumentException("unsupported property " + n2);
        }
        return this;
    }

    public UnicodeSet applyPropertyAlias(String string, String string2) {
        return this.applyPropertyAlias(string, string2, null);
    }

    /*
     * Unable to fully structure code
     */
    public UnicodeSet applyPropertyAlias(String var1_1, String var2_2, SymbolTable var3_3) {
        block23: {
            block24: {
                block21: {
                    block22: {
                        this.checkFrozen();
                        var6_4 = false;
                        if (var3_3 != null && var3_3 instanceof XSymbolTable && ((XSymbolTable)var3_3).applyPropertyAlias(var1_1, var2_2, this)) {
                            return this;
                        }
                        if (UnicodeSet.XSYMBOL_TABLE != null && UnicodeSet.XSYMBOL_TABLE.applyPropertyAlias(var1_1, var2_2, this)) {
                            return this;
                        }
                        if (var2_2.length() <= 0) break block21;
                        var4_5 = UCharacter.getPropertyEnum(var1_1);
                        if (var4_5 == 4101) {
                            var4_5 = 8192;
                        }
                        if (!(var4_5 >= 0 && var4_5 < 75 || var4_5 >= 4096 && var4_5 < 4122) && (var4_5 < 8192 || var4_5 >= 8193)) break block22;
                        try {
                            var5_6 = UCharacter.getPropertyValueEnum(var4_5, var2_2);
                        }
                        catch (IllegalArgumentException var7_7) {
                            if (var4_5 == 4098 || var4_5 == 4112 || var4_5 == 4113) {
                                var5_6 = Integer.parseInt(PatternProps.trimWhiteSpace(var2_2));
                                if (var5_6 >= 0 && var5_6 <= 255) ** GOTO lbl79
                                throw var7_7;
                            }
                            throw var7_7;
                        }
                    }
                    switch (var4_5) {
                        case 12288: {
                            var7_8 = Double.parseDouble(PatternProps.trimWhiteSpace(var2_2));
                            this.applyFilter(new NumericValueFilter(var7_8), CharacterPropertiesImpl.getInclusionsForProperty(var4_5));
                            return this;
                        }
                        case 16389: {
                            var7_9 = UnicodeSet.mungeCharName(var2_2);
                            var8_12 = UCharacter.getCharFromExtendedName(var7_9);
                            if (var8_12 == -1) {
                                throw new IllegalArgumentException("Invalid character name");
                            }
                            this.clear();
                            this.add_unchecked(var8_12);
                            return this;
                        }
                        case 16395: {
                            throw new IllegalArgumentException("Unicode_1_Name (na1) not supported");
                        }
                        case 16384: {
                            var7_10 = VersionInfo.getInstance(UnicodeSet.mungeCharName(var2_2));
                            this.applyFilter(new VersionFilter(var7_10), CharacterPropertiesImpl.getInclusionsForProperty(var4_5));
                            return this;
                        }
                        case 28672: {
                            var5_6 = UCharacter.getPropertyValueEnum(4106, var2_2);
                            break block23;
                        }
                        case 28673: {
                            var5_6 = UCharacter.getPropertyValueEnum(var4_5, var2_2);
                            break block23;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported property");
                        }
                    }
                }
                var7_11 = UPropertyAliases.INSTANCE;
                var4_5 = 8192;
                var5_6 = var7_11.getPropertyValueEnum(var4_5, var1_1);
                if (var5_6 != -1 || (var5_6 = var7_11.getPropertyValueEnum(var4_5 = 4106, var1_1)) != -1) break block23;
                var4_5 = var7_11.getPropertyEnum(var1_1);
                if (var4_5 == -1) {
                    var4_5 = -1;
                }
                if (var4_5 < 0 || var4_5 >= 75) break block24;
                var5_6 = 1;
                break block23;
            }
            if (var4_5 != -1) ** GOTO lbl78
            if (0 == UPropertyAliases.compare("ANY", var1_1)) {
                this.set(0, 0x10FFFF);
                return this;
            }
            if (0 == UPropertyAliases.compare("ASCII", var1_1)) {
                this.set(0, 127);
                return this;
            }
            if (0 == UPropertyAliases.compare("Assigned", var1_1)) {
                var4_5 = 8192;
                var5_6 = 1;
                var6_4 = true;
            } else {
                throw new IllegalArgumentException("Invalid property alias: " + var1_1 + "=" + var2_2);
lbl78:
                // 1 sources

                throw new IllegalArgumentException("Missing property value");
            }
        }
        this.applyIntPropertyValue(var4_5, var5_6);
        if (var6_4) {
            this.complement().removeAllStrings();
        }
        return this;
    }

    private static boolean resemblesPropertyPattern(String string, int n2) {
        if (n2 + 5 > string.length()) {
            return false;
        }
        return string.regionMatches(n2, "[:", 0, 2) || string.regionMatches(true, n2, "\\p", 0, 2) || string.regionMatches(n2, "\\N", 0, 2);
    }

    private static boolean resemblesPropertyPattern(RuleCharacterIterator ruleCharacterIterator, int n2) {
        boolean bl2 = false;
        RuleCharacterIterator.Position position = ruleCharacterIterator.getPos(null);
        int n3 = ruleCharacterIterator.next(n2 &= 0xFFFFFFFD);
        if (n3 == 91 || n3 == 92) {
            int n4 = ruleCharacterIterator.next(n2 & 0xFFFFFFFB);
            bl2 = n3 == 91 ? n4 == 58 : n4 == 78 || n4 == 112 || n4 == 80;
        }
        ruleCharacterIterator.setPos(position);
        return bl2;
    }

    private UnicodeSet applyPropertyPattern(String string, ParsePosition parsePosition, SymbolTable symbolTable) {
        String string2;
        String string3;
        int n2;
        int n3 = parsePosition.getIndex();
        if (n3 + 5 > string.length()) {
            return null;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (string.regionMatches(n3, "[:", 0, 2)) {
            bl2 = true;
            if ((n3 = PatternProps.skipWhiteSpace(string, n3 + 2)) < string.length() && string.charAt(n3) == '^') {
                ++n3;
                bl4 = true;
            }
        } else if (string.regionMatches(true, n3, "\\p", 0, 2) || string.regionMatches(n3, "\\N", 0, 2)) {
            n2 = string.charAt(n3 + 1);
            bl4 = n2 == 80;
            bl3 = n2 == 78;
            n3 = PatternProps.skipWhiteSpace(string, n3 + 2);
            if (n3 == string.length() || string.charAt(n3++) != '{') {
                return null;
            }
        } else {
            return null;
        }
        if ((n2 = string.indexOf(bl2 ? ":]" : "}", n3)) < 0) {
            return null;
        }
        int n4 = string.indexOf(61, n3);
        if (n4 >= 0 && n4 < n2 && !bl3) {
            string3 = string.substring(n3, n4);
            string2 = string.substring(n4 + 1, n2);
        } else {
            string3 = string.substring(n3, n2);
            string2 = "";
            if (bl3) {
                string2 = string3;
                string3 = "na";
            }
        }
        this.applyPropertyAlias(string3, string2, symbolTable);
        if (bl4) {
            this.complement().removeAllStrings();
        }
        parsePosition.setIndex(n2 + (bl2 ? 2 : 1));
        return this;
    }

    private void applyPropertyPattern(RuleCharacterIterator ruleCharacterIterator, Appendable appendable, SymbolTable symbolTable) {
        String string = ruleCharacterIterator.getCurrentBuffer();
        int n2 = ruleCharacterIterator.getCurrentBufferPos();
        ParsePosition parsePosition = new ParsePosition(n2);
        this.applyPropertyPattern(string, parsePosition, symbolTable);
        int n3 = parsePosition.getIndex() - n2;
        if (n3 == 0) {
            UnicodeSet.syntaxError(ruleCharacterIterator, "Invalid property pattern");
        }
        ruleCharacterIterator.jumpahead(n3);
        UnicodeSet.append(appendable, string.substring(n2, parsePosition.getIndex()));
    }

    private static final void addCaseMapping(UnicodeSet unicodeSet, int n2, StringBuilder stringBuilder) {
        if (n2 >= 0) {
            if (n2 > 31) {
                unicodeSet.add(n2);
            } else {
                unicodeSet.add(stringBuilder.toString());
                stringBuilder.setLength(0);
            }
        }
    }

    UnicodeSet maybeOnlyCaseSensitive(UnicodeSet unicodeSet) {
        if (unicodeSet.size() < 30) {
            return unicodeSet;
        }
        UnicodeSet unicodeSet2 = CharacterProperties.getBinaryPropertySet(34);
        if (unicodeSet.hasStrings() || unicodeSet.getRangeCount() > unicodeSet2.getRangeCount()) {
            return unicodeSet2.cloneAsThawed().retainAll(unicodeSet);
        }
        return ((UnicodeSet)unicodeSet.clone()).retainAll(unicodeSet2);
    }

    private static final boolean scfString(CharSequence charSequence, StringBuilder stringBuilder) {
        int n2;
        int n3 = charSequence.length();
        for (int i2 = 0; i2 < n3; i2 += Character.charCount(n2)) {
            n2 = Character.codePointAt(charSequence, i2);
            int n4 = UCharacter.foldCase(n2, 0);
            if (n4 == n2) continue;
            stringBuilder.setLength(0);
            stringBuilder.append(charSequence, 0, i2);
            while (true) {
                stringBuilder.appendCodePoint(n4);
                if ((i2 += Character.charCount(n2)) == n3) {
                    return true;
                }
                n2 = Character.codePointAt(charSequence, i2);
                n4 = UCharacter.foldCase(n2, 0);
            }
        }
        return false;
    }

    public UnicodeSet closeOver(int n2) {
        this.checkFrozen();
        switch (n2 & 6) {
            case 0: {
                break;
            }
            case 2: {
                this.closeOverCaseInsensitive(false);
                break;
            }
            case 4: {
                this.closeOverAddCaseMappings();
                break;
            }
            case 6: {
                this.closeOverCaseInsensitive(true);
                break;
            }
        }
        return this;
    }

    private void closeOverCaseInsensitive(boolean bl2) {
        UCaseProps uCaseProps = UCaseProps.INSTANCE;
        UnicodeSet unicodeSet = new UnicodeSet(this);
        if (!bl2 && unicodeSet.hasStrings()) {
            unicodeSet.strings.clear();
        }
        UnicodeSet unicodeSet2 = this.maybeOnlyCaseSensitive(this);
        int n2 = unicodeSet2.getRangeCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3;
            int n4 = unicodeSet2.getRangeStart(i2);
            int n5 = unicodeSet2.getRangeEnd(i2);
            if (bl2) {
                for (n3 = n4; n3 <= n5; ++n3) {
                    uCaseProps.addSimpleCaseClosure(n3, unicodeSet);
                }
                continue;
            }
            for (n3 = n4; n3 <= n5; ++n3) {
                uCaseProps.addCaseClosure(n3, unicodeSet);
            }
        }
        if (this.hasStrings()) {
            StringBuilder stringBuilder = bl2 ? new StringBuilder() : null;
            for (String string : this.strings) {
                if (bl2) {
                    if (!UnicodeSet.scfString(string, stringBuilder)) continue;
                    unicodeSet.remove(string).add(stringBuilder);
                    continue;
                }
                String string2 = UCharacter.foldCase(string, 0);
                if (uCaseProps.addStringCaseClosure(string2, unicodeSet)) continue;
                unicodeSet.add(string2);
            }
        }
        this.set(unicodeSet);
    }

    private void closeOverAddCaseMappings() {
        UCaseProps uCaseProps = UCaseProps.INSTANCE;
        UnicodeSet unicodeSet = new UnicodeSet(this);
        UnicodeSet unicodeSet2 = this.maybeOnlyCaseSensitive(this);
        int n2 = unicodeSet2.getRangeCount();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = unicodeSet2.getRangeStart(i2);
            int n4 = unicodeSet2.getRangeEnd(i2);
            for (int i3 = n3; i3 <= n4; ++i3) {
                int n5 = uCaseProps.toFullLower(i3, null, stringBuilder, 1);
                UnicodeSet.addCaseMapping(unicodeSet, n5, stringBuilder);
                n5 = uCaseProps.toFullTitle(i3, null, stringBuilder, 1);
                UnicodeSet.addCaseMapping(unicodeSet, n5, stringBuilder);
                n5 = uCaseProps.toFullUpper(i3, null, stringBuilder, 1);
                UnicodeSet.addCaseMapping(unicodeSet, n5, stringBuilder);
                n5 = uCaseProps.toFullFolding(i3, stringBuilder, 0);
                UnicodeSet.addCaseMapping(unicodeSet, n5, stringBuilder);
            }
        }
        if (this.hasStrings()) {
            ULocale uLocale = ULocale.ROOT;
            BreakIterator breakIterator = BreakIterator.getWordInstance(uLocale);
            for (String string : this.strings) {
                unicodeSet.add(UCharacter.toLowerCase(uLocale, string));
                unicodeSet.add(UCharacter.toTitleCase(uLocale, string, breakIterator));
                unicodeSet.add(UCharacter.toUpperCase(uLocale, string));
                unicodeSet.add(UCharacter.foldCase(string, 0));
            }
        }
        this.set(unicodeSet);
    }

    @Override
    public boolean isFrozen() {
        return this.bmpSet != null || this.stringSpan != null;
    }

    @Override
    public UnicodeSet freeze() {
        if (!this.isFrozen()) {
            this.compact();
            if (this.hasStrings()) {
                this.stringSpan = new UnicodeSetStringSpan(this, new ArrayList<String>(this.strings), 127);
            }
            if (this.stringSpan == null || !this.stringSpan.needsStringSpanUTF16()) {
                this.bmpSet = new BMPSet(this.list, this.len);
            }
        }
        return this;
    }

    public int span(CharSequence charSequence, SpanCondition spanCondition) {
        return this.span(charSequence, 0, spanCondition);
    }

    public int span(CharSequence charSequence, int n2, SpanCondition spanCondition) {
        int n3;
        UnicodeSetStringSpan unicodeSetStringSpan;
        int n4 = charSequence.length();
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= n4) {
            return n4;
        }
        if (this.bmpSet != null) {
            return this.bmpSet.span(charSequence, n2, spanCondition, null);
        }
        if (this.stringSpan != null) {
            return this.stringSpan.span(charSequence, n2, spanCondition);
        }
        if (this.hasStrings() && (unicodeSetStringSpan = new UnicodeSetStringSpan(this, new ArrayList<String>(this.strings), n3 = spanCondition == SpanCondition.NOT_CONTAINED ? 33 : 34)).needsStringSpanUTF16()) {
            return unicodeSetStringSpan.span(charSequence, n2, spanCondition);
        }
        return this.spanCodePointsAndCount(charSequence, n2, spanCondition, null);
    }

    @Deprecated
    public int spanAndCount(CharSequence charSequence, int n2, SpanCondition spanCondition, OutputInt outputInt) {
        if (outputInt == null) {
            throw new IllegalArgumentException("outCount must not be null");
        }
        int n3 = charSequence.length();
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= n3) {
            return n3;
        }
        if (this.stringSpan != null) {
            return this.stringSpan.spanAndCount(charSequence, n2, spanCondition, outputInt);
        }
        if (this.bmpSet != null) {
            return this.bmpSet.span(charSequence, n2, spanCondition, outputInt);
        }
        if (this.hasStrings()) {
            int n4 = spanCondition == SpanCondition.NOT_CONTAINED ? 33 : 34;
            UnicodeSetStringSpan unicodeSetStringSpan = new UnicodeSetStringSpan(this, new ArrayList<String>(this.strings), n4 |= 0x40);
            return unicodeSetStringSpan.spanAndCount(charSequence, n2, spanCondition, outputInt);
        }
        return this.spanCodePointsAndCount(charSequence, n2, spanCondition, outputInt);
    }

    private int spanCodePointsAndCount(CharSequence charSequence, int n2, SpanCondition spanCondition, OutputInt outputInt) {
        int n3;
        boolean bl2 = spanCondition != SpanCondition.NOT_CONTAINED;
        int n4 = n2;
        int n5 = charSequence.length();
        int n6 = 0;
        while (bl2 == this.contains(n3 = Character.codePointAt(charSequence, n4))) {
            ++n6;
            if ((n4 += Character.charCount(n3)) < n5) continue;
        }
        if (outputInt != null) {
            outputInt.value = n6;
        }
        return n4;
    }

    public int spanBack(CharSequence charSequence, SpanCondition spanCondition) {
        return this.spanBack(charSequence, charSequence.length(), spanCondition);
    }

    public int spanBack(CharSequence charSequence, int n2, SpanCondition spanCondition) {
        int n3;
        int n4;
        UnicodeSetStringSpan unicodeSetStringSpan;
        if (n2 <= 0) {
            return 0;
        }
        if (n2 > charSequence.length()) {
            n2 = charSequence.length();
        }
        if (this.bmpSet != null) {
            return this.bmpSet.spanBack(charSequence, n2, spanCondition);
        }
        if (this.stringSpan != null) {
            return this.stringSpan.spanBack(charSequence, n2, spanCondition);
        }
        if (this.hasStrings() && (unicodeSetStringSpan = new UnicodeSetStringSpan(this, new ArrayList<String>(this.strings), n4 = spanCondition == SpanCondition.NOT_CONTAINED ? 17 : 18)).needsStringSpanUTF16()) {
            return unicodeSetStringSpan.spanBack(charSequence, n2, spanCondition);
        }
        n4 = spanCondition != SpanCondition.NOT_CONTAINED ? 1 : 0;
        int n5 = n2;
        while (n4 == this.contains(n3 = Character.codePointBefore(charSequence, n5)) && (n5 -= Character.charCount(n3)) > 0) {
        }
        return n5;
    }

    @Override
    public UnicodeSet cloneAsThawed() {
        UnicodeSet unicodeSet = new UnicodeSet(this);
        assert (!unicodeSet.isFrozen());
        return unicodeSet;
    }

    private void checkFrozen() {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify frozen object");
        }
    }

    public Iterable<EntryRange> ranges() {
        return new EntryRangeIterable();
    }

    @Override
    public Iterator<String> iterator() {
        return new UnicodeSetIterator2(this);
    }

    public <T extends CharSequence> boolean containsAll(Iterable<T> iterable) {
        for (CharSequence charSequence : iterable) {
            if (this.contains(charSequence)) continue;
            return false;
        }
        return true;
    }

    public <T extends CharSequence> boolean containsNone(Iterable<T> iterable) {
        for (CharSequence charSequence : iterable) {
            if (!this.contains(charSequence)) continue;
            return false;
        }
        return true;
    }

    public final <T extends CharSequence> boolean containsSome(Iterable<T> iterable) {
        return !this.containsNone(iterable);
    }

    public <T extends CharSequence> UnicodeSet addAll(T ... TArray) {
        this.checkFrozen();
        for (T t2 : TArray) {
            this.add((CharSequence)t2);
        }
        return this;
    }

    public <T extends CharSequence> UnicodeSet removeAll(Iterable<T> iterable) {
        this.checkFrozen();
        for (CharSequence charSequence : iterable) {
            this.remove(charSequence);
        }
        return this;
    }

    public <T extends CharSequence> UnicodeSet retainAll(Iterable<T> iterable) {
        this.checkFrozen();
        UnicodeSet unicodeSet = new UnicodeSet();
        unicodeSet.addAll(iterable);
        this.retainAll(unicodeSet);
        return this;
    }

    @Override
    public int compareTo(UnicodeSet unicodeSet) {
        return this.compareTo(unicodeSet, ComparisonStyle.SHORTER_FIRST);
    }

    public int compareTo(UnicodeSet unicodeSet, ComparisonStyle comparisonStyle) {
        int n2;
        if (comparisonStyle != ComparisonStyle.LEXICOGRAPHIC && (n2 = this.size() - unicodeSet.size()) != 0) {
            return n2 < 0 == (comparisonStyle == ComparisonStyle.SHORTER_FIRST) ? -1 : 1;
        }
        int n3 = 0;
        while (true) {
            if (0 != (n2 = this.list[n3] - unicodeSet.list[n3])) {
                if (this.list[n3] == 0x110000) {
                    if (!this.hasStrings()) {
                        return 1;
                    }
                    String string = this.strings.first();
                    return UnicodeSet.compare(string, unicodeSet.list[n3]);
                }
                if (unicodeSet.list[n3] == 0x110000) {
                    if (!unicodeSet.hasStrings()) {
                        return -1;
                    }
                    String string = unicodeSet.strings.first();
                    int n4 = UnicodeSet.compare(string, this.list[n3]);
                    return n4 > 0 ? -1 : (n4 < 0 ? 1 : 0);
                }
                return (n3 & 1) == 0 ? n2 : -n2;
            }
            if (this.list[n3] == 0x110000) break;
            ++n3;
        }
        return UnicodeSet.compare(this.strings, unicodeSet.strings);
    }

    @Override
    public int compareTo(Iterable<String> iterable) {
        return UnicodeSet.compare(this, iterable);
    }

    public static int compare(CharSequence charSequence, int n2) {
        return CharSequences.compare(charSequence, n2);
    }

    public static int compare(int n2, CharSequence charSequence) {
        return -CharSequences.compare(charSequence, n2);
    }

    public static <T extends Comparable<T>> int compare(Iterable<T> iterable, Iterable<T> iterable2) {
        return UnicodeSet.compare(iterable.iterator(), iterable2.iterator());
    }

    @Deprecated
    public static <T extends Comparable<T>> int compare(Iterator<T> iterator, Iterator<T> iterator2) {
        Comparable comparable;
        Comparable comparable2;
        int n2;
        do {
            if (!iterator.hasNext()) {
                return iterator2.hasNext() ? -1 : 0;
            }
            if (iterator2.hasNext()) continue;
            return 1;
        } while ((n2 = (comparable2 = (Comparable)iterator.next()).compareTo(comparable = (Comparable)iterator2.next())) == 0);
        return n2;
    }

    public static <T extends Comparable<T>> int compare(Collection<T> collection, Collection<T> collection2, ComparisonStyle comparisonStyle) {
        int n2;
        if (comparisonStyle != ComparisonStyle.LEXICOGRAPHIC && (n2 = collection.size() - collection2.size()) != 0) {
            return n2 < 0 == (comparisonStyle == ComparisonStyle.SHORTER_FIRST) ? -1 : 1;
        }
        return UnicodeSet.compare(collection, collection2);
    }

    public static <T, U extends Collection<T>> U addAllTo(Iterable<T> iterable, U u2) {
        for (T t2 : iterable) {
            u2.add(t2);
        }
        return u2;
    }

    public static <T> T[] addAllTo(Iterable<T> iterable, T[] TArray) {
        int n2 = 0;
        for (T t2 : iterable) {
            TArray[n2++] = t2;
        }
        return TArray;
    }

    public Collection<String> strings() {
        if (this.hasStrings()) {
            return Collections.unmodifiableSortedSet(this.strings);
        }
        return EMPTY_STRINGS;
    }

    @Deprecated
    public static int getSingleCodePoint(CharSequence charSequence) {
        return CharSequences.getSingleCodePoint(charSequence);
    }

    @Deprecated
    public UnicodeSet addBridges(UnicodeSet unicodeSet) {
        UnicodeSet unicodeSet2 = new UnicodeSet(this).complement().removeAllStrings();
        UnicodeSetIterator unicodeSetIterator = new UnicodeSetIterator(unicodeSet2);
        while (unicodeSetIterator.nextRange()) {
            if (unicodeSetIterator.codepoint == 0 || unicodeSetIterator.codepointEnd == 0x10FFFF || !unicodeSet.contains(unicodeSetIterator.codepoint, unicodeSetIterator.codepointEnd)) continue;
            this.add(unicodeSetIterator.codepoint, unicodeSetIterator.codepointEnd);
        }
        return this;
    }

    @Deprecated
    public int findIn(CharSequence charSequence, int n2, boolean bl2) {
        int n3;
        while (n2 < charSequence.length() && this.contains(n3 = UTF16.charAt(charSequence, n2)) == bl2) {
            n2 += UTF16.getCharCount(n3);
        }
        return n2;
    }

    @Deprecated
    public int findLastIn(CharSequence charSequence, int n2, boolean bl2) {
        int n3;
        --n2;
        while (n2 >= 0 && this.contains(n3 = UTF16.charAt(charSequence, n2)) == bl2) {
            n2 -= UTF16.getCharCount(n3);
        }
        return n2 < 0 ? -1 : n2;
    }

    @Deprecated
    public String stripFrom(CharSequence charSequence, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while (n2 < charSequence.length()) {
            int n3 = this.findIn(charSequence, n2, !bl2);
            stringBuilder.append(charSequence.subSequence(n2, n3));
            n2 = this.findIn(charSequence, n3, bl2);
        }
        return stringBuilder.toString();
    }

    @Deprecated
    public static XSymbolTable getDefaultXSymbolTable() {
        return XSYMBOL_TABLE;
    }

    @Deprecated
    public static void setDefaultXSymbolTable(XSymbolTable xSymbolTable) {
        CharacterPropertiesImpl.clear();
        XSYMBOL_TABLE = xSymbolTable;
    }

    public static enum SpanCondition {
        NOT_CONTAINED,
        CONTAINED,
        SIMPLE,
        CONDITION_COUNT;

    }

    public static enum ComparisonStyle {
        SHORTER_FIRST,
        LEXICOGRAPHIC,
        LONGER_FIRST;

    }

    private static class UnicodeSetIterator2
    implements Iterator<String> {
        private int[] sourceList;
        private int len;
        private int item;
        private int current;
        private int limit;
        private SortedSet<String> sourceStrings;
        private Iterator<String> stringIterator;
        private char[] buffer;

        UnicodeSetIterator2(UnicodeSet unicodeSet) {
            this.len = unicodeSet.len - 1;
            if (this.len > 0) {
                this.sourceStrings = unicodeSet.strings;
                this.sourceList = unicodeSet.list;
                this.current = this.sourceList[this.item++];
                this.limit = this.sourceList[this.item++];
            } else {
                this.stringIterator = unicodeSet.strings.iterator();
                this.sourceList = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.sourceList != null || this.stringIterator.hasNext();
        }

        @Override
        public String next() {
            if (this.sourceList == null) {
                return this.stringIterator.next();
            }
            int n2 = this.current++;
            if (this.current >= this.limit) {
                if (this.item >= this.len) {
                    this.stringIterator = this.sourceStrings.iterator();
                    this.sourceList = null;
                } else {
                    this.current = this.sourceList[this.item++];
                    this.limit = this.sourceList[this.item++];
                }
            }
            if (n2 <= 65535) {
                return String.valueOf((char)n2);
            }
            if (this.buffer == null) {
                this.buffer = new char[2];
            }
            int n3 = n2 - 65536;
            this.buffer[0] = (char)((n3 >>> 10) + 55296);
            this.buffer[1] = (char)((n3 & 0x3FF) + 56320);
            return String.valueOf(this.buffer);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class EntryRangeIterator
    implements Iterator<EntryRange> {
        int pos;
        EntryRange result = new EntryRange();

        private EntryRangeIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pos < UnicodeSet.this.len - 1;
        }

        @Override
        public EntryRange next() {
            if (this.pos >= UnicodeSet.this.len - 1) {
                throw new NoSuchElementException();
            }
            this.result.codepoint = UnicodeSet.this.list[this.pos++];
            this.result.codepointEnd = UnicodeSet.this.list[this.pos++] - 1;
            return this.result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class EntryRangeIterable
    implements Iterable<EntryRange> {
        private EntryRangeIterable() {
        }

        @Override
        public Iterator<EntryRange> iterator() {
            return new EntryRangeIterator();
        }
    }

    public static class EntryRange {
        public int codepoint;
        public int codepointEnd;

        EntryRange() {
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            return (this.codepoint == this.codepointEnd ? (StringBuilder)UnicodeSet._appendToPat(stringBuilder, this.codepoint, false) : (StringBuilder)UnicodeSet._appendToPat(((StringBuilder)UnicodeSet._appendToPat(stringBuilder, this.codepoint, false)).append('-'), this.codepointEnd, false)).toString();
        }
    }

    public static abstract class XSymbolTable
    implements SymbolTable {
        @Override
        public UnicodeMatcher lookupMatcher(int n2) {
            return null;
        }

        public boolean applyPropertyAlias(String string, String string2, UnicodeSet unicodeSet) {
            return false;
        }

        @Override
        public char[] lookup(String string) {
            return null;
        }

        @Override
        public String parseReference(String string, ParsePosition parsePosition, int n2) {
            return null;
        }
    }

    private static final class VersionFilter
    implements Filter {
        VersionInfo version;

        VersionFilter(VersionInfo versionInfo) {
            this.version = versionInfo;
        }

        @Override
        public boolean contains(int n2) {
            VersionInfo versionInfo = UCharacter.getAge(n2);
            return !Utility.sameObjects(versionInfo, NO_VERSION) && versionInfo.compareTo(this.version) <= 0;
        }
    }

    private static final class IdentifierTypeFilter
    implements Filter {
        int idType;

        IdentifierTypeFilter(int n2) {
            this.idType = n2;
        }

        @Override
        public boolean contains(int n2) {
            return UCharacterProperty.INSTANCE.hasIDType(n2, this.idType);
        }
    }

    private static final class ScriptExtensionsFilter
    implements Filter {
        int script;

        ScriptExtensionsFilter(int n2) {
            this.script = n2;
        }

        @Override
        public boolean contains(int n2) {
            return UScript.hasScript(n2, this.script);
        }
    }

    private static final class IntPropertyFilter
    implements Filter {
        int prop;
        int value;

        IntPropertyFilter(int n2, int n3) {
            this.prop = n2;
            this.value = n3;
        }

        @Override
        public boolean contains(int n2) {
            return UCharacter.getIntPropertyValue(n2, this.prop) == this.value;
        }
    }

    private static final class GeneralCategoryMaskFilter
    implements Filter {
        int mask;

        GeneralCategoryMaskFilter(int n2) {
            this.mask = n2;
        }

        @Override
        public boolean contains(int n2) {
            return (1 << UCharacter.getType(n2) & this.mask) != 0;
        }
    }

    private static final class NumericValueFilter
    implements Filter {
        double value;

        NumericValueFilter(double d2) {
            this.value = d2;
        }

        @Override
        public boolean contains(int n2) {
            return UCharacter.getUnicodeNumericValue(n2) == this.value;
        }
    }

    private static interface Filter {
        public boolean contains(int var1);
    }
}

