/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.text.CharacterIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.CharacterIteratorWrapper;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ReplaceableUCharacterIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.UCharArrayIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.UCharacterIteratorWrapper;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Replaceable;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UForwardCharacterIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;

public abstract class UCharacterIterator
implements UForwardCharacterIterator,
Cloneable {
    protected UCharacterIterator() {
    }

    public static final UCharacterIterator getInstance(Replaceable replaceable) {
        return new ReplaceableUCharacterIterator(replaceable);
    }

    public static final UCharacterIterator getInstance(String string) {
        return new ReplaceableUCharacterIterator(string);
    }

    public static final UCharacterIterator getInstance(char[] cArray) {
        return UCharacterIterator.getInstance(cArray, 0, cArray.length);
    }

    public static final UCharacterIterator getInstance(char[] cArray, int n2, int n3) {
        return new UCharArrayIterator(cArray, n2, n3);
    }

    public static final UCharacterIterator getInstance(StringBuffer stringBuffer) {
        return new ReplaceableUCharacterIterator(stringBuffer);
    }

    public static final UCharacterIterator getInstance(CharacterIterator characterIterator) {
        return new CharacterIteratorWrapper(characterIterator);
    }

    public CharacterIterator getCharacterIterator() {
        return new UCharacterIteratorWrapper(this);
    }

    public abstract int current();

    public int currentCodePoint() {
        int n2 = this.current();
        if (UTF16.isLeadSurrogate(n2)) {
            this.next();
            int n3 = this.current();
            this.previous();
            if (UTF16.isTrailSurrogate(n3)) {
                return Character.toCodePoint((char)n2, (char)n3);
            }
        }
        return n2;
    }

    public abstract int getLength();

    public abstract int getIndex();

    @Override
    public abstract int next();

    @Override
    public int nextCodePoint() {
        int n2 = this.next();
        if (UTF16.isLeadSurrogate(n2)) {
            int n3 = this.next();
            if (UTF16.isTrailSurrogate(n3)) {
                return Character.toCodePoint((char)n2, (char)n3);
            }
            if (n3 != -1) {
                this.previous();
            }
        }
        return n2;
    }

    public abstract int previous();

    public int previousCodePoint() {
        int n2 = this.previous();
        if (UTF16.isTrailSurrogate(n2)) {
            int n3 = this.previous();
            if (UTF16.isLeadSurrogate(n3)) {
                return Character.toCodePoint((char)n3, (char)n2);
            }
            if (n3 != -1) {
                this.next();
            }
        }
        return n2;
    }

    public abstract void setIndex(int var1);

    public void setToLimit() {
        this.setIndex(this.getLength());
    }

    public void setToStart() {
        this.setIndex(0);
    }

    public abstract int getText(char[] var1, int var2);

    public final int getText(char[] cArray) {
        return this.getText(cArray, 0);
    }

    public String getText() {
        char[] cArray = new char[this.getLength()];
        this.getText(cArray);
        return new String(cArray);
    }

    public int moveIndex(int n2) {
        int n3 = Math.max(0, Math.min(this.getIndex() + n2, this.getLength()));
        this.setIndex(n3);
        return n3;
    }

    public int moveCodePointIndex(int n2) {
        if (n2 > 0) {
            while (n2 > 0 && this.nextCodePoint() != -1) {
                --n2;
            }
        } else {
            while (n2 < 0 && this.previousCodePoint() != -1) {
                ++n2;
            }
        }
        if (n2 != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.getIndex();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

