/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.IllegalIcuArgumentException;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.PatternProps;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Utility;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UCharacter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.FunctionReplacer;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Normalizer;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Quantifier;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.RuleBasedTransliterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.StringMatcher;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.StringReplacer;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.SymbolTable;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.TransliterationRule;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Transliterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.TransliteratorIDParser;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeMatcher;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeReplacer;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;

class TransliteratorParser {
    public List<RuleBasedTransliterator.Data> dataVector;
    public List<String> idBlockVector;
    private RuleBasedTransliterator.Data curData;
    public UnicodeSet compoundFilter;
    private int direction;
    private ParseData parseData;
    private List<Object> variablesVector;
    private Map<String, char[]> variableNames;
    private StringBuffer segmentStandins;
    private List<StringMatcher> segmentObjects;
    private char variableNext;
    private char variableLimit;
    private String undefinedVariableName;
    private int dotStandIn = -1;
    private static final String ID_TOKEN = "::";
    private static final int ID_TOKEN_LEN = 2;
    private static final char VARIABLE_DEF_OP = '=';
    private static final char FORWARD_RULE_OP = '>';
    private static final char REVERSE_RULE_OP = '<';
    private static final char FWDREV_RULE_OP = '~';
    private static final String OPERATORS = "=><\u2190\u2192\u2194";
    private static final String HALF_ENDERS = "=><\u2190\u2192\u2194;";
    private static final char QUOTE = '\'';
    private static final char ESCAPE = '\\';
    private static final char END_OF_RULE = ';';
    private static final char RULE_COMMENT_CHAR = '#';
    private static final char CONTEXT_ANTE = '{';
    private static final char CONTEXT_POST = '}';
    private static final char CURSOR_POS = '|';
    private static final char CURSOR_OFFSET = '@';
    private static final char ANCHOR_START = '^';
    private static final char KLEENE_STAR = '*';
    private static final char ONE_OR_MORE = '+';
    private static final char ZERO_OR_ONE = '?';
    private static final char DOT = '.';
    private static final String DOT_SET = "[^[:Zp:][:Zl:]\\r\\n$]";
    private static final char SEGMENT_OPEN = '(';
    private static final char SEGMENT_CLOSE = ')';
    private static final char FUNCTION = '&';
    private static final char ALT_REVERSE_RULE_OP = '\u2190';
    private static final char ALT_FORWARD_RULE_OP = '\u2192';
    private static final char ALT_FWDREV_RULE_OP = '\u2194';
    private static final char ALT_FUNCTION = '\u2206';
    private static UnicodeSet ILLEGAL_TOP = new UnicodeSet("[\\)]");
    private static UnicodeSet ILLEGAL_SEG = new UnicodeSet("[\\{\\}\\|\\@]");
    private static UnicodeSet ILLEGAL_FUNC = new UnicodeSet("[\\^\\(\\.\\*\\+\\?\\{\\}\\|\\@]");

    public void parse(String string, int n2) {
        this.parseRules(new RuleArray(new String[]{string}), n2);
    }

    void parseRules(RuleBody ruleBody, int n2) {
        int n3;
        String string;
        boolean bl2 = true;
        int n4 = 0;
        this.dataVector = new ArrayList<RuleBasedTransliterator.Data>();
        this.idBlockVector = new ArrayList<String>();
        this.curData = null;
        this.direction = n2;
        this.compoundFilter = null;
        this.variablesVector = new ArrayList<Object>();
        this.variableNames = new HashMap<String, char[]>();
        this.parseData = new ParseData();
        ArrayList<IllegalArgumentException> arrayList = new ArrayList<IllegalArgumentException>();
        int n5 = 0;
        ruleBody.reset();
        StringBuilder stringBuilder = new StringBuilder();
        this.compoundFilter = null;
        int n6 = -1;
        block4: while ((string = ruleBody.nextLine()) != null) {
            int n7 = 0;
            int n8 = string.length();
            while (n7 < n8) {
                Object object;
                char c2;
                if (PatternProps.isWhiteSpace(c2 = string.charAt(n7++))) continue;
                if (c2 == '#') {
                    if ((n7 = string.indexOf("\n", n7) + 1) != 0) continue;
                    continue block4;
                }
                if (c2 == ';') continue;
                try {
                    ++n4;
                    if (--n7 + 2 + 1 <= n8 && string.regionMatches(n7, ID_TOKEN, 0, 2)) {
                        c2 = string.charAt(n7 += 2);
                        while (PatternProps.isWhiteSpace(c2) && n7 < n8) {
                            c2 = string.charAt(++n7);
                        }
                        int[] nArray = new int[]{n7};
                        if (!bl2) {
                            if (this.curData != null) {
                                if (this.direction == 0) {
                                    this.dataVector.add(this.curData);
                                } else {
                                    this.dataVector.add(0, this.curData);
                                }
                                this.curData = null;
                            }
                            bl2 = true;
                        }
                        object = TransliteratorIDParser.parseSingleID(string, nArray, this.direction);
                        if (nArray[0] != n7 && Utility.parseChar(string, nArray, ';')) {
                            if (this.direction == 0) {
                                stringBuilder.append(((TransliteratorIDParser.SingleID)object).canonID).append(';');
                            } else {
                                stringBuilder.insert(0, ((TransliteratorIDParser.SingleID)object).canonID + ';');
                            }
                        } else {
                            int[] nArray2 = new int[]{-1};
                            UnicodeSet unicodeSet = TransliteratorIDParser.parseGlobalFilter(string, nArray, this.direction, nArray2, null);
                            if (unicodeSet != null && Utility.parseChar(string, nArray, ';')) {
                                if (this.direction == 0 == (nArray2[0] == 0)) {
                                    if (this.compoundFilter != null) {
                                        TransliteratorParser.syntaxError("Multiple global filters", string, n7);
                                    }
                                    this.compoundFilter = unicodeSet;
                                    n6 = n4;
                                }
                            } else {
                                TransliteratorParser.syntaxError("Invalid ::ID", string, n7);
                            }
                        }
                        n7 = nArray[0];
                        continue;
                    }
                    if (bl2) {
                        if (this.direction == 0) {
                            this.idBlockVector.add(stringBuilder.toString());
                        } else {
                            this.idBlockVector.add(0, stringBuilder.toString());
                        }
                        stringBuilder.delete(0, stringBuilder.length());
                        bl2 = false;
                        this.curData = new RuleBasedTransliterator.Data();
                        this.setVariableRange(61440, 63743);
                    }
                    if (TransliteratorParser.resemblesPragma(string, n7, n8)) {
                        int n9 = this.parsePragma(string, n7, n8);
                        if (n9 < 0) {
                            TransliteratorParser.syntaxError("Unrecognized pragma", string, n7);
                        }
                        n7 = n9;
                        continue;
                    }
                    n7 = this.parseRule(string, n7, n8);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (n5 == 30) {
                        object = new IllegalIcuArgumentException("\nMore than 30 errors; further messages squelched");
                        ((IllegalIcuArgumentException)object).initCause(illegalArgumentException);
                        arrayList.add((IllegalArgumentException)object);
                        break block4;
                    }
                    illegalArgumentException.fillInStackTrace();
                    arrayList.add(illegalArgumentException);
                    ++n5;
                    n7 = TransliteratorParser.ruleEnd(string, n7, n8) + 1;
                }
            }
        }
        if (bl2 && stringBuilder.length() > 0) {
            if (this.direction == 0) {
                this.idBlockVector.add(stringBuilder.toString());
            } else {
                this.idBlockVector.add(0, stringBuilder.toString());
            }
        } else if (!bl2 && this.curData != null) {
            if (this.direction == 0) {
                this.dataVector.add(this.curData);
            } else {
                this.dataVector.add(0, this.curData);
            }
        }
        for (n3 = 0; n3 < this.dataVector.size(); ++n3) {
            RuleBasedTransliterator.Data data = this.dataVector.get(n3);
            data.variables = new Object[this.variablesVector.size()];
            this.variablesVector.toArray(data.variables);
            data.variableNames = new HashMap<String, char[]>();
            data.variableNames.putAll(this.variableNames);
        }
        this.variablesVector = null;
        try {
            if (this.compoundFilter != null && (this.direction == 0 && n6 != 1 || this.direction == 1 && n6 != n4)) {
                throw new IllegalIcuArgumentException("Compound filters misplaced");
            }
            for (n3 = 0; n3 < this.dataVector.size(); ++n3) {
                RuleBasedTransliterator.Data data = this.dataVector.get(n3);
                data.ruleSet.freeze();
            }
            if (this.idBlockVector.size() == 1 && this.idBlockVector.get(0).length() == 0) {
                this.idBlockVector.remove(0);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.fillInStackTrace();
            arrayList.add(illegalArgumentException);
        }
        if (arrayList.size() != 0) {
            for (int i2 = arrayList.size() - 1; i2 > 0; --i2) {
                RuntimeException runtimeException = (RuntimeException)arrayList.get(i2 - 1);
                while (runtimeException.getCause() != null) {
                    runtimeException = (RuntimeException)runtimeException.getCause();
                }
                runtimeException.initCause((Throwable)arrayList.get(i2));
            }
            throw (RuntimeException)arrayList.get(0);
        }
    }

    private int parseRule(String string, int n2, int n3) {
        int n4;
        int n5 = n2;
        int n6 = 0;
        this.segmentStandins = new StringBuffer();
        this.segmentObjects = new ArrayList<StringMatcher>();
        RuleHalf ruleHalf = new RuleHalf();
        RuleHalf ruleHalf2 = new RuleHalf();
        this.undefinedVariableName = null;
        if ((n2 = ruleHalf.parse(string, n2, n3, this)) == n3 || OPERATORS.indexOf(n6 = string.charAt(--n2)) < 0) {
            TransliteratorParser.syntaxError("No operator pos=" + n2, string, n5);
        }
        if (n6 == 60 && ++n2 < n3 && string.charAt(n2) == '>') {
            ++n2;
            n6 = 126;
        }
        switch (n6) {
            case 8594: {
                n6 = 62;
                break;
            }
            case 8592: {
                n6 = 60;
                break;
            }
            case 8596: {
                n6 = 126;
            }
        }
        n2 = ruleHalf2.parse(string, n2, n3, this);
        if (n2 < n3) {
            if (string.charAt(--n2) == ';') {
                ++n2;
            } else {
                TransliteratorParser.syntaxError("Unquoted operator", string, n5);
            }
        }
        if (n6 == 61) {
            if (this.undefinedVariableName == null) {
                TransliteratorParser.syntaxError("Missing '$' or duplicate definition", string, n5);
            }
            if (ruleHalf.text.length() != 1 || ruleHalf.text.charAt(0) != this.variableLimit) {
                TransliteratorParser.syntaxError("Malformed LHS", string, n5);
            }
            if (ruleHalf.anchorStart || ruleHalf.anchorEnd || ruleHalf2.anchorStart || ruleHalf2.anchorEnd) {
                TransliteratorParser.syntaxError("Malformed variable def", string, n5);
            }
            int n7 = ruleHalf2.text.length();
            char[] cArray = new char[n7];
            ruleHalf2.text.getChars(0, n7, cArray, 0);
            this.variableNames.put(this.undefinedVariableName, cArray);
            this.variableLimit = (char)(this.variableLimit + '\u0001');
            return n2;
        }
        if (this.undefinedVariableName != null) {
            TransliteratorParser.syntaxError("Undefined variable $" + this.undefinedVariableName, string, n5);
        }
        if (this.segmentStandins.length() > this.segmentObjects.size()) {
            TransliteratorParser.syntaxError("Undefined segment reference", string, n5);
        }
        for (n4 = 0; n4 < this.segmentStandins.length(); ++n4) {
            if (this.segmentStandins.charAt(n4) != '\u0000') continue;
            TransliteratorParser.syntaxError("Internal error", string, n5);
        }
        for (n4 = 0; n4 < this.segmentObjects.size(); ++n4) {
            if (this.segmentObjects.get(n4) != null) continue;
            TransliteratorParser.syntaxError("Internal error", string, n5);
        }
        if (n6 != 126 && this.direction == 0 != (n6 == 62)) {
            return n2;
        }
        if (this.direction == 1) {
            RuleHalf ruleHalf3 = ruleHalf;
            ruleHalf = ruleHalf2;
            ruleHalf2 = ruleHalf3;
        }
        if (n6 == 126) {
            ruleHalf2.removeContext();
            ruleHalf.cursor = -1;
            ruleHalf.cursorOffset = 0;
        }
        if (ruleHalf.ante < 0) {
            ruleHalf.ante = 0;
        }
        if (ruleHalf.post < 0) {
            ruleHalf.post = ruleHalf.text.length();
        }
        if (ruleHalf2.ante >= 0 || ruleHalf2.post >= 0 || ruleHalf.cursor >= 0 || ruleHalf2.cursorOffset != 0 && ruleHalf2.cursor < 0 || ruleHalf2.anchorStart || ruleHalf2.anchorEnd || !ruleHalf.isValidInput(this) || !ruleHalf2.isValidOutput(this) || ruleHalf.ante > ruleHalf.post) {
            TransliteratorParser.syntaxError("Malformed rule", string, n5);
        }
        UnicodeMatcher[] unicodeMatcherArray = null;
        if (this.segmentObjects.size() > 0) {
            unicodeMatcherArray = new UnicodeMatcher[this.segmentObjects.size()];
            this.segmentObjects.toArray(unicodeMatcherArray);
        }
        this.curData.ruleSet.addRule(new TransliterationRule(ruleHalf.text, ruleHalf.ante, ruleHalf.post, ruleHalf2.text, ruleHalf2.cursor, ruleHalf2.cursorOffset, unicodeMatcherArray, ruleHalf.anchorStart, ruleHalf.anchorEnd, this.curData));
        return n2;
    }

    private void setVariableRange(int n2, int n3) {
        if (n2 > n3 || n2 < 0 || n3 > 65535) {
            throw new IllegalIcuArgumentException("Invalid variable range " + n2 + ", " + n3);
        }
        this.curData.variablesBase = (char)n2;
        if (this.dataVector.size() == 0) {
            this.variableNext = (char)n2;
            this.variableLimit = (char)(n3 + 1);
        }
    }

    private void checkVariableRange(int n2, String string, int n3) {
        if (n2 >= this.curData.variablesBase && n2 < this.variableLimit) {
            TransliteratorParser.syntaxError("Variable range character in rule", string, n3);
        }
    }

    private void pragmaMaximumBackup(int n2) {
        throw new IllegalIcuArgumentException("use maximum backup pragma not implemented yet");
    }

    private void pragmaNormalizeRules(Normalizer.Mode mode) {
        throw new IllegalIcuArgumentException("use normalize rules pragma not implemented yet");
    }

    static boolean resemblesPragma(String string, int n2, int n3) {
        return Utility.parsePattern(string, n2, n3, "use ", null) >= 0;
    }

    private int parsePragma(String string, int n2, int n3) {
        int[] nArray = new int[2];
        int n4 = Utility.parsePattern(string, n2 += 4, n3, "~variable range # #~;", nArray);
        if (n4 >= 0) {
            this.setVariableRange(nArray[0], nArray[1]);
            return n4;
        }
        n4 = Utility.parsePattern(string, n2, n3, "~maximum backup #~;", nArray);
        if (n4 >= 0) {
            this.pragmaMaximumBackup(nArray[0]);
            return n4;
        }
        n4 = Utility.parsePattern(string, n2, n3, "~nfd rules~;", null);
        if (n4 >= 0) {
            this.pragmaNormalizeRules(Normalizer.NFD);
            return n4;
        }
        n4 = Utility.parsePattern(string, n2, n3, "~nfc rules~;", null);
        if (n4 >= 0) {
            this.pragmaNormalizeRules(Normalizer.NFC);
            return n4;
        }
        return -1;
    }

    static final void syntaxError(String string, String string2, int n2) {
        int n3 = TransliteratorParser.ruleEnd(string2, n2, string2.length());
        throw new IllegalIcuArgumentException(string + " in \"" + Utility.escape(string2.substring(n2, n3)) + '\"');
    }

    static final int ruleEnd(String string, int n2, int n3) {
        int n4 = Utility.quotedIndexOf(string, n2, n3, ";");
        if (n4 < 0) {
            n4 = n3;
        }
        return n4;
    }

    private final char parseSet(String string, ParsePosition parsePosition) {
        UnicodeSet unicodeSet = new UnicodeSet(string, parsePosition, this.parseData);
        if (this.variableNext >= this.variableLimit) {
            throw new RuntimeException("Private use variables exhausted");
        }
        unicodeSet.compact();
        return this.generateStandInFor(unicodeSet);
    }

    char generateStandInFor(Object object) {
        for (int i2 = 0; i2 < this.variablesVector.size(); ++i2) {
            if (this.variablesVector.get(i2) != object) continue;
            return (char)(this.curData.variablesBase + i2);
        }
        if (this.variableNext >= this.variableLimit) {
            throw new RuntimeException("Variable range exhausted");
        }
        this.variablesVector.add(object);
        char c2 = this.variableNext;
        this.variableNext = (char)(c2 + '\u0001');
        return c2;
    }

    public char getSegmentStandin(int n2) {
        char c2;
        if (this.segmentStandins.length() < n2) {
            this.segmentStandins.setLength(n2);
        }
        if ((c2 = this.segmentStandins.charAt(n2 - 1)) == '\u0000') {
            if (this.variableNext >= this.variableLimit) {
                throw new RuntimeException("Variable range exhausted");
            }
            char c3 = this.variableNext;
            this.variableNext = (char)(c3 + '\u0001');
            c2 = c3;
            this.variablesVector.add(null);
            this.segmentStandins.setCharAt(n2 - 1, c2);
        }
        return c2;
    }

    public void setSegmentObject(int n2, StringMatcher stringMatcher) {
        while (this.segmentObjects.size() < n2) {
            this.segmentObjects.add(null);
        }
        int n3 = this.getSegmentStandin(n2) - this.curData.variablesBase;
        if (this.segmentObjects.get(n2 - 1) != null || this.variablesVector.get(n3) != null) {
            throw new RuntimeException();
        }
        this.segmentObjects.set(n2 - 1, stringMatcher);
        this.variablesVector.set(n3, stringMatcher);
    }

    char getDotStandIn() {
        if (this.dotStandIn == -1) {
            this.dotStandIn = this.generateStandInFor(new UnicodeSet(DOT_SET));
        }
        return (char)this.dotStandIn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void appendVariableDef(String string, StringBuffer stringBuffer) {
        char[] cArray = this.variableNames.get(string);
        if (cArray == null) {
            if (this.undefinedVariableName != null) throw new IllegalIcuArgumentException("Undefined variable $" + string);
            this.undefinedVariableName = string;
            if (this.variableNext >= this.variableLimit) {
                throw new RuntimeException("Private use variables exhausted");
            }
            this.variableLimit = (char)(this.variableLimit - '\u0001');
            stringBuffer.append(this.variableLimit);
            return;
        } else {
            stringBuffer.append(cArray);
        }
    }

    private static class RuleHalf {
        public String text;
        public int cursor = -1;
        public int ante = -1;
        public int post = -1;
        public int cursorOffset = 0;
        private int cursorOffsetPos = 0;
        public boolean anchorStart = false;
        public boolean anchorEnd = false;
        private int nextSegmentNumber = 1;

        private RuleHalf() {
        }

        public int parse(String string, int n2, int n3, TransliteratorParser transliteratorParser) {
            int n4 = n2;
            StringBuffer stringBuffer = new StringBuffer();
            n2 = this.parseSection(string, n2, n3, transliteratorParser, stringBuffer, ILLEGAL_TOP, false);
            this.text = stringBuffer.toString();
            if (this.cursorOffset > 0 && this.cursor != this.cursorOffsetPos) {
                TransliteratorParser.syntaxError("Misplaced |", string, n4);
            }
            return n2;
        }

        private int parseSection(String string, int n2, int n3, TransliteratorParser transliteratorParser, StringBuffer stringBuffer, UnicodeSet unicodeSet, boolean bl2) {
            int n4 = n2;
            ParsePosition parsePosition = null;
            int n5 = -1;
            int n6 = -1;
            int n7 = -1;
            int n8 = -1;
            int[] nArray = new int[1];
            int n9 = stringBuffer.length();
            block19: while (n2 < n3) {
                int n10;
                char c2;
                if (PatternProps.isWhiteSpace(c2 = string.charAt(n2++))) continue;
                if (TransliteratorParser.HALF_ENDERS.indexOf(c2) >= 0) {
                    if (!bl2) break;
                    TransliteratorParser.syntaxError("Unclosed segment", string, n4);
                    break;
                }
                if (this.anchorEnd) {
                    TransliteratorParser.syntaxError("Malformed variable reference", string, n4);
                }
                if (UnicodeSet.resemblesPattern(string, n2 - 1)) {
                    if (parsePosition == null) {
                        parsePosition = new ParsePosition(0);
                    }
                    parsePosition.setIndex(n2 - 1);
                    stringBuffer.append(transliteratorParser.parseSet(string, parsePosition));
                    n2 = parsePosition.getIndex();
                    continue;
                }
                if (c2 == '\\') {
                    int n11;
                    if (n2 == n3) {
                        TransliteratorParser.syntaxError("Trailing backslash", string, n4);
                    }
                    if ((n11 = Utility.unescapeAndLengthAt(string, n2)) < 0) {
                        TransliteratorParser.syntaxError("Malformed escape", string, n4);
                    }
                    n10 = Utility.cpFromCodePointAndLength(n11);
                    n2 += Utility.lengthFromCodePointAndLength(n11);
                    transliteratorParser.checkVariableRange(n10, string, n4);
                    UTF16.append(stringBuffer, n10);
                    continue;
                }
                if (c2 == '\'') {
                    int n12 = string.indexOf(39, n2);
                    if (n12 == n2) {
                        stringBuffer.append(c2);
                        ++n2;
                        continue;
                    }
                    n5 = stringBuffer.length();
                    while (true) {
                        if (n12 < 0) {
                            TransliteratorParser.syntaxError("Unterminated quote", string, n4);
                        }
                        stringBuffer.append(string.substring(n2, n12));
                        n2 = n12 + 1;
                        if (n2 >= n3 || string.charAt(n2) != '\'') break;
                        n12 = string.indexOf(39, n2 + 1);
                    }
                    n6 = stringBuffer.length();
                    for (n12 = n5; n12 < n6; ++n12) {
                        transliteratorParser.checkVariableRange(stringBuffer.charAt(n12), string, n4);
                    }
                    continue;
                }
                transliteratorParser.checkVariableRange(c2, string, n4);
                if (unicodeSet.contains(c2)) {
                    TransliteratorParser.syntaxError("Illegal character '" + c2 + '\'', string, n4);
                }
                switch (c2) {
                    case '^': {
                        if (stringBuffer.length() == 0 && !this.anchorStart) {
                            this.anchorStart = true;
                            break;
                        }
                        TransliteratorParser.syntaxError("Misplaced anchor start", string, n4);
                        break;
                    }
                    case '(': {
                        int n13 = stringBuffer.length();
                        ++this.nextSegmentNumber;
                        n2 = this.parseSection(string, n2, n3, transliteratorParser, stringBuffer, ILLEGAL_SEG, true);
                        UnicodeMatcher unicodeMatcher = new StringMatcher(stringBuffer.substring(n13), n10, transliteratorParser.curData);
                        transliteratorParser.setSegmentObject(n10, (StringMatcher)unicodeMatcher);
                        stringBuffer.setLength(n13);
                        stringBuffer.append(transliteratorParser.getSegmentStandin(n10));
                        break;
                    }
                    case '&': 
                    case '\u2206': {
                        Transliterator transliterator;
                        nArray[0] = n2;
                        TransliteratorIDParser.SingleID singleID = TransliteratorIDParser.parseFilterID(string, nArray);
                        if (singleID == null || !Utility.parseChar(string, nArray, '(')) {
                            TransliteratorParser.syntaxError("Invalid function", string, n4);
                        }
                        if ((transliterator = singleID.getInstance()) == null) {
                            TransliteratorParser.syntaxError("Invalid function ID", string, n4);
                        }
                        int n14 = stringBuffer.length();
                        n2 = this.parseSection(string, nArray[0], n3, transliteratorParser, stringBuffer, ILLEGAL_FUNC, true);
                        FunctionReplacer functionReplacer = new FunctionReplacer(transliterator, new StringReplacer(stringBuffer.substring(n14), transliteratorParser.curData));
                        stringBuffer.setLength(n14);
                        stringBuffer.append(transliteratorParser.generateStandInFor(functionReplacer));
                        break;
                    }
                    case '$': {
                        if (n2 == n3) {
                            this.anchorEnd = true;
                            break;
                        }
                        c2 = string.charAt(n2);
                        int n15 = UCharacter.digit(c2, 10);
                        if (n15 >= 1 && n15 <= 9) {
                            nArray[0] = n2;
                            n15 = Utility.parseNumber(string, nArray, 10);
                            if (n15 < 0) {
                                TransliteratorParser.syntaxError("Undefined segment reference", string, n4);
                            }
                            n2 = nArray[0];
                            stringBuffer.append(transliteratorParser.getSegmentStandin(n15));
                            break;
                        }
                        if (parsePosition == null) {
                            parsePosition = new ParsePosition(0);
                        }
                        parsePosition.setIndex(n2);
                        String string2 = transliteratorParser.parseData.parseReference(string, parsePosition, n3);
                        if (string2 == null) {
                            this.anchorEnd = true;
                            break;
                        }
                        n2 = parsePosition.getIndex();
                        n7 = stringBuffer.length();
                        transliteratorParser.appendVariableDef(string2, stringBuffer);
                        n8 = stringBuffer.length();
                        break;
                    }
                    case '.': {
                        stringBuffer.append(transliteratorParser.getDotStandIn());
                        break;
                    }
                    case '*': 
                    case '+': 
                    case '?': {
                        int n16;
                        UnicodeMatcher unicodeMatcher;
                        if (bl2 && stringBuffer.length() == n9) {
                            TransliteratorParser.syntaxError("Misplaced quantifier", string, n4);
                            break;
                        }
                        if (stringBuffer.length() == n6) {
                            n16 = n5;
                            n10 = n6;
                        } else if (stringBuffer.length() == n8) {
                            n16 = n7;
                            n10 = n8;
                        } else {
                            n16 = stringBuffer.length() - 1;
                            n10 = n16 + 1;
                        }
                        try {
                            unicodeMatcher = new StringMatcher(stringBuffer.toString(), n16, n10, 0, transliteratorParser.curData);
                        }
                        catch (RuntimeException runtimeException) {
                            String string3 = n2 < 50 ? string.substring(0, n2) : "..." + string.substring(n2 - 50, n2);
                            String string4 = n3 - n2 <= 50 ? string.substring(n2, n3) : string.substring(n2, n2 + 50) + "...";
                            throw new IllegalIcuArgumentException("Failure in rule: " + string3 + "$$$" + string4).initCause(runtimeException);
                        }
                        int n17 = 0;
                        int n18 = Integer.MAX_VALUE;
                        switch (c2) {
                            case '+': {
                                n17 = 1;
                                break;
                            }
                            case '?': {
                                n17 = 0;
                                n18 = 1;
                            }
                        }
                        unicodeMatcher = new Quantifier(unicodeMatcher, n17, n18);
                        stringBuffer.setLength(n16);
                        stringBuffer.append(transliteratorParser.generateStandInFor(unicodeMatcher));
                        break;
                    }
                    case ')': {
                        break block19;
                    }
                    case '{': {
                        if (this.ante >= 0) {
                            TransliteratorParser.syntaxError("Multiple ante contexts", string, n4);
                        }
                        this.ante = stringBuffer.length();
                        break;
                    }
                    case '}': {
                        if (this.post >= 0) {
                            TransliteratorParser.syntaxError("Multiple post contexts", string, n4);
                        }
                        this.post = stringBuffer.length();
                        break;
                    }
                    case '|': {
                        if (this.cursor >= 0) {
                            TransliteratorParser.syntaxError("Multiple cursors", string, n4);
                        }
                        this.cursor = stringBuffer.length();
                        break;
                    }
                    case '@': {
                        if (this.cursorOffset < 0) {
                            if (stringBuffer.length() > 0) {
                                TransliteratorParser.syntaxError("Misplaced " + c2, string, n4);
                            }
                            --this.cursorOffset;
                            break;
                        }
                        if (this.cursorOffset > 0) {
                            if (stringBuffer.length() != this.cursorOffsetPos || this.cursor >= 0) {
                                TransliteratorParser.syntaxError("Misplaced " + c2, string, n4);
                            }
                            ++this.cursorOffset;
                            break;
                        }
                        if (this.cursor == 0 && stringBuffer.length() == 0) {
                            this.cursorOffset = -1;
                            break;
                        }
                        if (this.cursor < 0) {
                            this.cursorOffsetPos = stringBuffer.length();
                            this.cursorOffset = 1;
                            break;
                        }
                        TransliteratorParser.syntaxError("Misplaced " + c2, string, n4);
                        break;
                    }
                    default: {
                        if (!(c2 < '!' || c2 > '~' || c2 >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z')) {
                            TransliteratorParser.syntaxError("Unquoted " + c2, string, n4);
                        }
                        stringBuffer.append(c2);
                    }
                }
            }
            return n2;
        }

        void removeContext() {
            this.text = this.text.substring(this.ante < 0 ? 0 : this.ante, this.post < 0 ? this.text.length() : this.post);
            this.post = -1;
            this.ante = -1;
            this.anchorEnd = false;
            this.anchorStart = false;
        }

        public boolean isValidOutput(TransliteratorParser transliteratorParser) {
            int n2;
            for (int i2 = 0; i2 < this.text.length(); i2 += UTF16.getCharCount(n2)) {
                n2 = UTF16.charAt(this.text, i2);
                if (transliteratorParser.parseData.isReplacer(n2)) continue;
                return false;
            }
            return true;
        }

        public boolean isValidInput(TransliteratorParser transliteratorParser) {
            int n2;
            for (int i2 = 0; i2 < this.text.length(); i2 += UTF16.getCharCount(n2)) {
                n2 = UTF16.charAt(this.text, i2);
                if (transliteratorParser.parseData.isMatcher(n2)) continue;
                return false;
            }
            return true;
        }
    }

    private static class RuleArray
    extends RuleBody {
        String[] array;
        int i;

        public RuleArray(String[] stringArray) {
            this.array = stringArray;
            this.i = 0;
        }

        @Override
        public String handleNextLine() {
            return this.i < this.array.length ? this.array[this.i++] : null;
        }

        @Override
        public void reset() {
            this.i = 0;
        }
    }

    private static abstract class RuleBody {
        private RuleBody() {
        }

        String nextLine() {
            String string = this.handleNextLine();
            if (string != null && string.length() > 0 && string.charAt(string.length() - 1) == '\\') {
                StringBuilder stringBuilder = new StringBuilder(string);
                do {
                    stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                    string = this.handleNextLine();
                    if (string == null) break;
                    stringBuilder.append(string);
                } while (string.length() > 0 && string.charAt(string.length() - 1) == '\\');
                string = stringBuilder.toString();
            }
            return string;
        }

        abstract void reset();

        abstract String handleNextLine();
    }

    private class ParseData
    implements SymbolTable {
        private ParseData() {
        }

        @Override
        public char[] lookup(String string) {
            return (char[])TransliteratorParser.this.variableNames.get(string);
        }

        @Override
        public UnicodeMatcher lookupMatcher(int n2) {
            int n3 = n2 - ((TransliteratorParser)TransliteratorParser.this).curData.variablesBase;
            if (n3 >= 0 && n3 < TransliteratorParser.this.variablesVector.size()) {
                return (UnicodeMatcher)TransliteratorParser.this.variablesVector.get(n3);
            }
            return null;
        }

        @Override
        public String parseReference(String string, ParsePosition parsePosition, int n2) {
            int n3;
            int n4;
            for (n4 = n3 = parsePosition.getIndex(); n4 < n2; ++n4) {
                char c2 = string.charAt(n4);
                if (n4 == n3 && !UCharacter.isUnicodeIdentifierStart(c2) || !UCharacter.isUnicodeIdentifierPart(c2)) break;
            }
            if (n4 == n3) {
                return null;
            }
            parsePosition.setIndex(n4);
            return string.substring(n3, n4);
        }

        public boolean isMatcher(int n2) {
            int n3 = n2 - ((TransliteratorParser)TransliteratorParser.this).curData.variablesBase;
            if (n3 >= 0 && n3 < TransliteratorParser.this.variablesVector.size()) {
                return TransliteratorParser.this.variablesVector.get(n3) instanceof UnicodeMatcher;
            }
            return true;
        }

        public boolean isReplacer(int n2) {
            int n3 = n2 - ((TransliteratorParser)TransliteratorParser.this).curData.variablesBase;
            if (n3 >= 0 && n3 < TransliteratorParser.this.variablesVector.size()) {
                return TransliteratorParser.this.variablesVector.get(n3) instanceof UnicodeReplacer;
            }
            return true;
        }
    }
}

