/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Utility;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Replaceable;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.RuleBasedTransliterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.StringMatcher;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.StringReplacer;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Transliterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeMatcher;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeReplacer;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;

class TransliterationRule {
    private StringMatcher anteContext;
    private StringMatcher key;
    private StringMatcher postContext;
    private UnicodeReplacer output;
    private String pattern;
    UnicodeMatcher[] segments;
    private int anteContextLength;
    private int keyLength;
    byte flags;
    static final int ANCHOR_START = 1;
    static final int ANCHOR_END = 2;
    private final RuleBasedTransliterator.Data data;

    public TransliterationRule(String string, int n2, int n3, String string2, int n4, int n5, UnicodeMatcher[] unicodeMatcherArray, boolean bl2, boolean bl3, RuleBasedTransliterator.Data data) {
        this.data = data;
        if (n2 < 0) {
            this.anteContextLength = 0;
        } else {
            if (n2 > string.length()) {
                throw new IllegalArgumentException("Invalid ante context");
            }
            this.anteContextLength = n2;
        }
        if (n3 < 0) {
            this.keyLength = string.length() - this.anteContextLength;
        } else {
            if (n3 < this.anteContextLength || n3 > string.length()) {
                throw new IllegalArgumentException("Invalid post context");
            }
            this.keyLength = n3 - this.anteContextLength;
        }
        if (n4 < 0) {
            n4 = string2.length();
        } else if (n4 > string2.length()) {
            throw new IllegalArgumentException("Invalid cursor position");
        }
        this.segments = unicodeMatcherArray;
        this.pattern = string;
        this.flags = 0;
        if (bl2) {
            this.flags = (byte)(this.flags | 1);
        }
        if (bl3) {
            this.flags = (byte)(this.flags | 2);
        }
        this.anteContext = null;
        if (this.anteContextLength > 0) {
            this.anteContext = new StringMatcher(this.pattern.substring(0, this.anteContextLength), 0, this.data);
        }
        this.key = null;
        if (this.keyLength > 0) {
            this.key = new StringMatcher(this.pattern.substring(this.anteContextLength, this.anteContextLength + this.keyLength), 0, this.data);
        }
        int n6 = this.pattern.length() - this.keyLength - this.anteContextLength;
        this.postContext = null;
        if (n6 > 0) {
            this.postContext = new StringMatcher(this.pattern.substring(this.anteContextLength + this.keyLength), 0, this.data);
        }
        this.output = new StringReplacer(string2, n4 + n5, this.data);
    }

    public int getAnteContextLength() {
        return this.anteContextLength + ((this.flags & 1) != 0 ? 1 : 0);
    }

    final int getIndexValue() {
        if (this.anteContextLength == this.pattern.length()) {
            return -1;
        }
        int n2 = UTF16.charAt(this.pattern, this.anteContextLength);
        return this.data.lookupMatcher(n2) == null ? n2 & 0xFF : -1;
    }

    final boolean matchesIndexValue(int n2) {
        StringMatcher stringMatcher = this.key != null ? this.key : this.postContext;
        return stringMatcher != null ? stringMatcher.matchesIndexValue(n2) : true;
    }

    public boolean masks(TransliterationRule transliterationRule) {
        int n2 = this.pattern.length();
        int n3 = this.anteContextLength;
        int n4 = transliterationRule.anteContextLength;
        int n5 = this.pattern.length() - n3;
        int n6 = transliterationRule.pattern.length() - n4;
        if (n3 == n4 && n5 == n6 && this.keyLength <= transliterationRule.keyLength && transliterationRule.pattern.regionMatches(0, this.pattern, 0, n2)) {
            return this.flags == transliterationRule.flags || (this.flags & 1) == 0 && (this.flags & 2) == 0 || (transliterationRule.flags & 1) != 0 && (transliterationRule.flags & 2) != 0;
        }
        return n3 <= n4 && (n5 < n6 || n5 == n6 && this.keyLength <= transliterationRule.keyLength) && transliterationRule.pattern.regionMatches(n4 - n3, this.pattern, 0, n2);
    }

    static final int posBefore(Replaceable replaceable, int n2) {
        return n2 > 0 ? n2 - UTF16.getCharCount(replaceable.char32At(n2 - 1)) : n2 - 1;
    }

    static final int posAfter(Replaceable replaceable, int n2) {
        return n2 >= 0 && n2 < replaceable.length() ? n2 + UTF16.getCharCount(replaceable.char32At(n2)) : n2 + 1;
    }

    public int matchAndReplace(Replaceable replaceable, Transliterator.Position position, boolean bl2) {
        int n2;
        int n3;
        if (this.segments != null) {
            for (n3 = 0; n3 < this.segments.length; ++n3) {
                ((StringMatcher)this.segments[n3]).resetMatch();
            }
        }
        int[] nArray = new int[1];
        int n4 = TransliterationRule.posBefore(replaceable, position.contextStart);
        nArray[0] = TransliterationRule.posBefore(replaceable, position.start);
        if (this.anteContext != null && (n2 = this.anteContext.matches(replaceable, nArray, n4, false)) != 2) {
            return 0;
        }
        int n5 = nArray[0];
        int n6 = TransliterationRule.posAfter(replaceable, n5);
        if ((this.flags & 1) != 0 && n5 != n4) {
            return 0;
        }
        nArray[0] = position.start;
        if (this.key != null && (n2 = this.key.matches(replaceable, nArray, position.limit, bl2)) != 2) {
            return n2;
        }
        n3 = nArray[0];
        if (this.postContext != null) {
            if (bl2 && n3 == position.limit) {
                return 1;
            }
            n2 = this.postContext.matches(replaceable, nArray, position.contextLimit, bl2);
            if (n2 != 2) {
                return n2;
            }
        }
        n5 = nArray[0];
        if ((this.flags & 2) != 0) {
            if (n5 != position.contextLimit) {
                return 0;
            }
            if (bl2) {
                return 1;
            }
        }
        int n7 = this.output.replace(replaceable, position.start, n3, nArray);
        int n8 = n7 - (n3 - position.start);
        int n9 = nArray[0];
        position.limit += n8;
        position.contextLimit += n8;
        position.start = Math.max(n6, Math.min(Math.min(n5 += n8, position.limit), n9));
        return 2;
    }

    public String toRule(boolean bl2) {
        boolean bl3;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl4 = bl3 = this.anteContext != null || this.postContext != null;
        if ((this.flags & 1) != 0) {
            stringBuffer.append('^');
        }
        Utility.appendToRule(stringBuffer, this.anteContext, bl2, stringBuffer2);
        if (bl3) {
            Utility.appendToRule(stringBuffer, 123, true, bl2, stringBuffer2);
        }
        Utility.appendToRule(stringBuffer, this.key, bl2, stringBuffer2);
        if (bl3) {
            Utility.appendToRule(stringBuffer, 125, true, bl2, stringBuffer2);
        }
        Utility.appendToRule(stringBuffer, this.postContext, bl2, stringBuffer2);
        if ((this.flags & 2) != 0) {
            stringBuffer.append('$');
        }
        Utility.appendToRule(stringBuffer, " > ", true, bl2, stringBuffer2);
        Utility.appendToRule(stringBuffer, this.output.toReplacerPattern(bl2), true, bl2, stringBuffer2);
        Utility.appendToRule(stringBuffer, 59, true, bl2, stringBuffer2);
        return stringBuffer.toString();
    }

    public String toString() {
        return '{' + this.toRule(true) + '}';
    }

    void addSourceTargetSet(UnicodeSet unicodeSet, UnicodeSet unicodeSet2, UnicodeSet unicodeSet3, UnicodeSet unicodeSet4) {
        int n2 = this.anteContextLength + this.keyLength;
        UnicodeSet unicodeSet5 = new UnicodeSet();
        UnicodeSet unicodeSet6 = new UnicodeSet();
        int n3 = this.anteContextLength;
        while (n3 < n2) {
            int n4 = UTF16.charAt(this.pattern, n3);
            n3 += UTF16.getCharCount(n4);
            UnicodeMatcher unicodeMatcher = this.data.lookupMatcher(n4);
            if (unicodeMatcher == null) {
                if (!unicodeSet.contains(n4)) {
                    return;
                }
                unicodeSet5.add(n4);
                continue;
            }
            try {
                if (!unicodeSet.containsSome((UnicodeSet)unicodeMatcher)) {
                    return;
                }
                unicodeMatcher.addMatchSetTo(unicodeSet5);
            }
            catch (ClassCastException classCastException) {
                unicodeSet6.clear();
                unicodeMatcher.addMatchSetTo(unicodeSet6);
                if (!unicodeSet.containsSome(unicodeSet6)) {
                    return;
                }
                unicodeSet5.addAll(unicodeSet6);
            }
        }
        unicodeSet2.addAll(unicodeSet5);
        this.output.addReplacementSetTo(unicodeSet3);
    }
}

