/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import macromedia.jdbc.db2.externals.com.ibm.icu.impl.UCaseProps;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Replaceable;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;

class ReplaceableContextIterator
implements UCaseProps.ContextIterator {
    protected Replaceable rep = null;
    protected int index = 0;
    protected int limit = 0;
    protected int cpStart = 0;
    protected int cpLimit = 0;
    protected int contextStart = 0;
    protected int contextLimit = 0;
    protected int dir = 0;
    protected boolean reachedLimit = false;

    ReplaceableContextIterator() {
    }

    public void setText(Replaceable replaceable) {
        this.rep = replaceable;
        this.limit = this.contextLimit = replaceable.length();
        this.contextStart = 0;
        this.index = 0;
        this.cpLimit = 0;
        this.cpStart = 0;
        this.dir = 0;
        this.reachedLimit = false;
    }

    public void setIndex(int n2) {
        this.cpStart = this.cpLimit = n2;
        this.index = 0;
        this.dir = 0;
        this.reachedLimit = false;
    }

    public int getCaseMapCPStart() {
        return this.cpStart;
    }

    public void setLimit(int n2) {
        this.limit = 0 <= n2 && n2 <= this.rep.length() ? n2 : this.rep.length();
        this.reachedLimit = false;
    }

    public void setContextLimits(int n2, int n3) {
        this.contextStart = n2 < 0 ? 0 : (n2 <= this.rep.length() ? n2 : this.rep.length());
        this.contextLimit = n3 < this.contextStart ? this.contextStart : (n3 <= this.rep.length() ? n3 : this.rep.length());
        this.reachedLimit = false;
    }

    public int nextCaseMapCP() {
        if (this.cpLimit < this.limit) {
            this.cpStart = this.cpLimit;
            int n2 = this.rep.char32At(this.cpLimit);
            this.cpLimit += UTF16.getCharCount(n2);
            return n2;
        }
        return -1;
    }

    public int replace(String string) {
        int n2 = string.length() - (this.cpLimit - this.cpStart);
        this.rep.replace(this.cpStart, this.cpLimit, string);
        this.cpLimit += n2;
        this.limit += n2;
        this.contextLimit += n2;
        return n2;
    }

    public boolean didReachLimit() {
        return this.reachedLimit;
    }

    @Override
    public void reset(int n2) {
        if (n2 > 0) {
            this.dir = 1;
            this.index = this.cpLimit;
        } else if (n2 < 0) {
            this.dir = -1;
            this.index = this.cpStart;
        } else {
            this.dir = 0;
            this.index = 0;
        }
        this.reachedLimit = false;
    }

    @Override
    public int next() {
        if (this.dir > 0) {
            if (this.index < this.contextLimit) {
                int n2 = this.rep.char32At(this.index);
                this.index += UTF16.getCharCount(n2);
                return n2;
            }
            this.reachedLimit = true;
        } else if (this.dir < 0 && this.index > this.contextStart) {
            int n3 = this.rep.char32At(this.index - 1);
            this.index -= UTF16.getCharCount(n3);
            return n3;
        }
        return -1;
    }
}

