/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.io.InvalidObjectException;
import java.text.AttributedCharacterIterator;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.regex.Pattern;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.FormattedStringBuilder;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.FormattedValueStringBuilderImpl;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUCache;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUResourceBundle;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.SimpleCache;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.SimpleFormatterImpl;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Utility;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.ConstrainedFieldPosition;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.FormattedValue;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.UResourceBundle;

public final class ListFormatter {
    private final String start;
    private final String middle;
    private final ULocale locale;
    private final PatternHandler patternHandler;
    private static final String compiledY = ListFormatter.compilePattern("{0} y {1}", new StringBuilder());
    private static final String compiledE = ListFormatter.compilePattern("{0} e {1}", new StringBuilder());
    private static final String compiledO = ListFormatter.compilePattern("{0} o {1}", new StringBuilder());
    private static final String compiledU = ListFormatter.compilePattern("{0} u {1}", new StringBuilder());
    private static final Pattern changeToE = Pattern.compile("(i.*|hi|hi[^ae].*)", 2);
    private static final Pattern changeToU = Pattern.compile("((o|ho|8).*|11)", 2);
    private static final String compiledVav = ListFormatter.compilePattern("{0} \u05d5{1}", new StringBuilder());
    private static final String compiledVavDash = ListFormatter.compilePattern("{0} \u05d5-{1}", new StringBuilder());
    private static final Pattern changeToVavDash = Pattern.compile("^[\\P{InHebrew}].*$");
    static Cache cache = new Cache();

    @Deprecated
    public ListFormatter(String string, String string2, String string3, String string4) {
        this(ListFormatter.compilePattern(string, new StringBuilder()), ListFormatter.compilePattern(string2, new StringBuilder()), ListFormatter.compilePattern(string3, new StringBuilder()), ListFormatter.compilePattern(string4, new StringBuilder()), null);
    }

    private ListFormatter(String string, String string2, String string3, String string4, ULocale uLocale) {
        this.start = string2;
        this.middle = string3;
        this.locale = uLocale;
        this.patternHandler = this.createPatternHandler(string, string4);
    }

    private static String compilePattern(String string, StringBuilder stringBuilder) {
        return SimpleFormatterImpl.compileToStringMinMaxArguments(string, stringBuilder, 2, 2);
    }

    public static ListFormatter getInstance(ULocale uLocale, Type type, Width width) {
        String string = ListFormatter.typeWidthToStyleString(type, width);
        if (string == null) {
            throw new IllegalArgumentException("Invalid list format type/width");
        }
        return cache.get(uLocale, string);
    }

    public static ListFormatter getInstance(Locale locale, Type type, Width width) {
        return ListFormatter.getInstance(ULocale.forLocale(locale), type, width);
    }

    public static ListFormatter getInstance(ULocale uLocale) {
        return ListFormatter.getInstance(uLocale, Type.AND, Width.WIDE);
    }

    public static ListFormatter getInstance(Locale locale) {
        return ListFormatter.getInstance(ULocale.forLocale(locale), Type.AND, Width.WIDE);
    }

    public static ListFormatter getInstance() {
        return ListFormatter.getInstance(ULocale.getDefault(ULocale.Category.FORMAT));
    }

    public String format(Object ... objectArray) {
        return this.format(Arrays.asList(objectArray));
    }

    public String format(Collection<?> collection) {
        return this.formatImpl(collection, false).toString();
    }

    public FormattedList formatToValue(Object ... objectArray) {
        return this.formatToValue(Arrays.asList(objectArray));
    }

    public FormattedList formatToValue(Collection<?> collection) {
        return this.formatImpl(collection, true).toValue();
    }

    FormattedListBuilder formatImpl(Collection<?> collection, boolean bl2) {
        Iterator<?> iterator = collection.iterator();
        int n2 = collection.size();
        switch (n2) {
            case 0: {
                return new FormattedListBuilder("", bl2);
            }
            case 1: {
                return new FormattedListBuilder(iterator.next(), bl2);
            }
            case 2: {
                Object obj = iterator.next();
                Object obj2 = iterator.next();
                return new FormattedListBuilder(obj, bl2).append(this.patternHandler.getTwoPattern(String.valueOf(obj2)), obj2, 1);
            }
        }
        FormattedListBuilder formattedListBuilder = new FormattedListBuilder(iterator.next(), bl2);
        formattedListBuilder.append(this.start, iterator.next(), 1);
        for (int i2 = 2; i2 < n2 - 1; ++i2) {
            formattedListBuilder.append(this.middle, iterator.next(), i2);
        }
        Object obj = iterator.next();
        return formattedListBuilder.append(this.patternHandler.getEndPattern(String.valueOf(obj)), obj, n2 - 1);
    }

    private PatternHandler createPatternHandler(String string, String string2) {
        if (this.locale != null) {
            String string3 = this.locale.getLanguage();
            if (string3.equals("es")) {
                boolean bl2 = string.equals(compiledY);
                boolean bl3 = string2.equals(compiledY);
                if (bl2 || bl3) {
                    return new ContextualHandler(changeToE, bl2 ? compiledE : string, string, bl3 ? compiledE : string2, string2);
                }
                boolean bl4 = string.equals(compiledO);
                boolean bl5 = string2.equals(compiledO);
                if (bl4 || bl5) {
                    return new ContextualHandler(changeToU, bl4 ? compiledU : string, string, bl5 ? compiledU : string2, string2);
                }
            } else if (string3.equals("he") || string3.equals("iw")) {
                boolean bl6 = string.equals(compiledVav);
                boolean bl7 = string2.equals(compiledVav);
                if (bl6 || bl7) {
                    return new ContextualHandler(changeToVavDash, bl6 ? compiledVavDash : string, string, bl7 ? compiledVavDash : string2, string2);
                }
            }
        }
        return new StaticHandler(string, string2);
    }

    public String getPatternForNumItems(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("count must be > 0");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList.add(String.format("{%d}", i2));
        }
        return this.format(arrayList);
    }

    @Deprecated
    public ULocale getLocale() {
        return this.locale;
    }

    static String typeWidthToStyleString(Type type, Width width) {
        switch (type) {
            case AND: {
                switch (width) {
                    case WIDE: {
                        return "standard";
                    }
                    case SHORT: {
                        return "standard-short";
                    }
                    case NARROW: {
                        return "standard-narrow";
                    }
                }
                break;
            }
            case OR: {
                switch (width) {
                    case WIDE: {
                        return "or";
                    }
                    case SHORT: {
                        return "or-short";
                    }
                    case NARROW: {
                        return "or-narrow";
                    }
                }
                break;
            }
            case UNITS: {
                switch (width) {
                    case WIDE: {
                        return "unit";
                    }
                    case SHORT: {
                        return "unit-short";
                    }
                    case NARROW: {
                        return "unit-narrow";
                    }
                }
            }
        }
        return null;
    }

    private static class Cache {
        private final ICUCache<String, ListFormatter> cache = new SimpleCache<String, ListFormatter>();

        private Cache() {
        }

        public ListFormatter get(ULocale uLocale, String string) {
            String string2 = String.format("%s:%s", uLocale.toString(), string);
            ListFormatter listFormatter = this.cache.get(string2);
            if (listFormatter == null) {
                listFormatter = Cache.load(uLocale, string);
                this.cache.put(string2, listFormatter);
            }
            return listFormatter;
        }

        private static ListFormatter load(ULocale uLocale, String string) {
            ICUResourceBundle iCUResourceBundle = (ICUResourceBundle)UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b", uLocale);
            StringBuilder stringBuilder = new StringBuilder();
            return new ListFormatter(ListFormatter.compilePattern(iCUResourceBundle.getWithFallback("listPattern/" + string + "/2").getString(), stringBuilder), ListFormatter.compilePattern(iCUResourceBundle.getWithFallback("listPattern/" + string + "/start").getString(), stringBuilder), ListFormatter.compilePattern(iCUResourceBundle.getWithFallback("listPattern/" + string + "/middle").getString(), stringBuilder), ListFormatter.compilePattern(iCUResourceBundle.getWithFallback("listPattern/" + string + "/end").getString(), stringBuilder), uLocale);
        }
    }

    static class FormattedListBuilder {
        private FormattedStringBuilder string = new FormattedStringBuilder();
        boolean needsFields;

        public FormattedListBuilder(Object object, boolean bl2) {
            this.needsFields = bl2;
            this.string.setAppendableField(Field.LITERAL);
            this.appendElement(object, 0);
        }

        public FormattedListBuilder append(String string, Object object, int n2) {
            assert (SimpleFormatterImpl.getArgumentLimit(string) == 2);
            this.string.setAppendIndex(0);
            long l2 = 0L;
            while ((l2 = SimpleFormatterImpl.IterInternal.step(l2, string, this.string)) != -1L) {
                int n3 = SimpleFormatterImpl.IterInternal.getArgIndex(l2);
                if (n3 == 0) {
                    this.string.setAppendIndex(this.string.length());
                    continue;
                }
                this.appendElement(object, n2);
            }
            return this;
        }

        private void appendElement(Object object, int n2) {
            String string = object.toString();
            if (this.needsFields) {
                FormattedValueStringBuilderImpl.SpanFieldPlaceholder spanFieldPlaceholder = new FormattedValueStringBuilderImpl.SpanFieldPlaceholder();
                spanFieldPlaceholder.spanField = SpanField.LIST_SPAN;
                spanFieldPlaceholder.normalField = Field.ELEMENT;
                spanFieldPlaceholder.value = n2;
                spanFieldPlaceholder.start = -1;
                spanFieldPlaceholder.length = string.length();
                this.string.append(string, spanFieldPlaceholder);
            } else {
                this.string.append(string, null);
            }
        }

        public void appendTo(Appendable appendable) {
            Utility.appendTo(this.string, appendable);
        }

        public int getOffset(int n2) {
            return FormattedValueStringBuilderImpl.findSpan(this.string, n2);
        }

        public String toString() {
            return this.string.toString();
        }

        public FormattedList toValue() {
            return new FormattedList(this.string);
        }
    }

    private static final class ContextualHandler
    implements PatternHandler {
        private final Pattern regexp;
        private final String thenTwoPattern;
        private final String elseTwoPattern;
        private final String thenEndPattern;
        private final String elseEndPattern;

        ContextualHandler(Pattern pattern, String string, String string2, String string3, String string4) {
            this.regexp = pattern;
            this.thenTwoPattern = string;
            this.elseTwoPattern = string2;
            this.thenEndPattern = string3;
            this.elseEndPattern = string4;
        }

        @Override
        public String getTwoPattern(String string) {
            if (this.regexp.matcher(string).matches()) {
                return this.thenTwoPattern;
            }
            return this.elseTwoPattern;
        }

        @Override
        public String getEndPattern(String string) {
            if (this.regexp.matcher(string).matches()) {
                return this.thenEndPattern;
            }
            return this.elseEndPattern;
        }
    }

    private static final class StaticHandler
    implements PatternHandler {
        private final String twoPattern;
        private final String endPattern;

        StaticHandler(String string, String string2) {
            this.twoPattern = string;
            this.endPattern = string2;
        }

        @Override
        public String getTwoPattern(String string) {
            return this.twoPattern;
        }

        @Override
        public String getEndPattern(String string) {
            return this.endPattern;
        }
    }

    public static final class FormattedList
    implements FormattedValue {
        private final FormattedStringBuilder string;

        FormattedList(FormattedStringBuilder formattedStringBuilder) {
            this.string = formattedStringBuilder;
        }

        @Override
        public String toString() {
            return this.string.toString();
        }

        @Override
        public int length() {
            return this.string.length();
        }

        @Override
        public char charAt(int n2) {
            return this.string.charAt(n2);
        }

        @Override
        public CharSequence subSequence(int n2, int n3) {
            return this.string.subString(n2, n3);
        }

        @Override
        public <A extends Appendable> A appendTo(A a2) {
            return Utility.appendTo(this.string, a2);
        }

        @Override
        public boolean nextPosition(ConstrainedFieldPosition constrainedFieldPosition) {
            return FormattedValueStringBuilderImpl.nextPosition(this.string, constrainedFieldPosition, null);
        }

        @Override
        public AttributedCharacterIterator toCharacterIterator() {
            return FormattedValueStringBuilderImpl.toCharacterIterator(this.string, null);
        }
    }

    public static final class Field
    extends Format.Field {
        private static final long serialVersionUID = -8071145668708265437L;
        public static Field LITERAL = new Field("literal");
        public static Field ELEMENT = new Field("element");

        private Field(String string) {
            super(string);
        }

        @Override
        @Deprecated
        protected Object readResolve() throws InvalidObjectException {
            if (this.getName().equals(LITERAL.getName())) {
                return LITERAL;
            }
            if (this.getName().equals(ELEMENT.getName())) {
                return ELEMENT;
            }
            throw new InvalidObjectException("An invalid object.");
        }
    }

    public static final class SpanField
    extends UFormat.SpanField {
        private static final long serialVersionUID = 3563544214705634403L;
        public static final SpanField LIST_SPAN = new SpanField("list-span");

        private SpanField(String string) {
            super(string);
        }

        @Override
        @Deprecated
        protected Object readResolve() throws InvalidObjectException {
            if (this.getName().equals(LIST_SPAN.getName())) {
                return LIST_SPAN;
            }
            throw new InvalidObjectException("An invalid object.");
        }
    }

    public static enum Width {
        WIDE,
        SHORT,
        NARROW;

    }

    public static enum Type {
        AND,
        OR,
        UNITS;

    }

    private static interface PatternHandler {
        public String getTwoPattern(String var1);

        public String getEndPattern(String var1);
    }
}

