/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Utility;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Replaceable;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Transliterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;

class EscapeTransliterator
extends Transliterator {
    private String prefix;
    private String suffix;
    private int radix;
    private int minDigits;
    private boolean grokSupplementals;
    private EscapeTransliterator supplementalHandler;

    static void register() {
        Transliterator.registerFactory("Any-Hex/Unicode", new Transliterator.Factory(){

            @Override
            public Transliterator getInstance(String string) {
                return new EscapeTransliterator("Any-Hex/Unicode", "U+", "", 16, 4, true, null);
            }
        });
        Transliterator.registerFactory("Any-Hex/Java", new Transliterator.Factory(){

            @Override
            public Transliterator getInstance(String string) {
                return new EscapeTransliterator("Any-Hex/Java", "\\u", "", 16, 4, false, null);
            }
        });
        Transliterator.registerFactory("Any-Hex/C", new Transliterator.Factory(){

            @Override
            public Transliterator getInstance(String string) {
                return new EscapeTransliterator("Any-Hex/C", "\\u", "", 16, 4, true, new EscapeTransliterator("", "\\U", "", 16, 8, true, null));
            }
        });
        Transliterator.registerFactory("Any-Hex/XML", new Transliterator.Factory(){

            @Override
            public Transliterator getInstance(String string) {
                return new EscapeTransliterator("Any-Hex/XML", "&#x", ";", 16, 1, true, null);
            }
        });
        Transliterator.registerFactory("Any-Hex/XML10", new Transliterator.Factory(){

            @Override
            public Transliterator getInstance(String string) {
                return new EscapeTransliterator("Any-Hex/XML10", "&#", ";", 10, 1, true, null);
            }
        });
        Transliterator.registerFactory("Any-Hex/Perl", new Transliterator.Factory(){

            @Override
            public Transliterator getInstance(String string) {
                return new EscapeTransliterator("Any-Hex/Perl", "\\x{", "}", 16, 1, true, null);
            }
        });
        Transliterator.registerFactory("Any-Hex/Plain", new Transliterator.Factory(){

            @Override
            public Transliterator getInstance(String string) {
                return new EscapeTransliterator("Any-Hex/Plain", "", "", 16, 4, true, null);
            }
        });
        Transliterator.registerFactory("Any-Hex", new Transliterator.Factory(){

            @Override
            public Transliterator getInstance(String string) {
                return new EscapeTransliterator("Any-Hex", "\\u", "", 16, 4, false, null);
            }
        });
    }

    EscapeTransliterator(String string, String string2, String string3, int n2, int n3, boolean bl2, EscapeTransliterator escapeTransliterator) {
        super(string, null);
        this.prefix = string2;
        this.suffix = string3;
        this.radix = n2;
        this.minDigits = n3;
        this.grokSupplementals = bl2;
        this.supplementalHandler = escapeTransliterator;
    }

    @Override
    protected void handleTransliterate(Replaceable replaceable, Transliterator.Position position, boolean bl2) {
        int n2;
        int n3;
        int n4 = position.start;
        StringBuilder stringBuilder = new StringBuilder(this.prefix);
        int n5 = this.prefix.length();
        boolean bl3 = false;
        for (n2 = position.limit; n4 < n2; n4 += stringBuilder.length(), n2 += stringBuilder.length() - n3) {
            int n6 = this.grokSupplementals ? replaceable.char32At(n4) : (int)replaceable.charAt(n4);
            int n7 = n3 = this.grokSupplementals ? UTF16.getCharCount(n6) : 1;
            if ((n6 & 0xFFFF0000) != 0 && this.supplementalHandler != null) {
                stringBuilder.setLength(0);
                stringBuilder.append(this.supplementalHandler.prefix);
                Utility.appendNumber(stringBuilder, n6, this.supplementalHandler.radix, this.supplementalHandler.minDigits);
                stringBuilder.append(this.supplementalHandler.suffix);
                bl3 = true;
            } else {
                if (bl3) {
                    stringBuilder.setLength(0);
                    stringBuilder.append(this.prefix);
                    bl3 = false;
                } else {
                    stringBuilder.setLength(n5);
                }
                Utility.appendNumber(stringBuilder, n6, this.radix, this.minDigits);
                stringBuilder.append(this.suffix);
            }
            replaceable.replace(n4, n4 + n3, stringBuilder.toString());
        }
        position.contextLimit += n2 - position.limit;
        position.limit = n2;
        position.start = n4;
    }

    @Override
    public void addSourceTargetSet(UnicodeSet unicodeSet, UnicodeSet unicodeSet2, UnicodeSet unicodeSet3) {
        unicodeSet2.addAll(this.getFilterAsUnicodeSet(unicodeSet));
        EscapeTransliterator escapeTransliterator = this;
        while (escapeTransliterator != null) {
            if (unicodeSet.size() != 0) {
                unicodeSet3.addAll(escapeTransliterator.prefix);
                unicodeSet3.addAll(escapeTransliterator.suffix);
                StringBuilder stringBuilder = new StringBuilder();
                for (int i2 = 0; i2 < escapeTransliterator.radix; ++i2) {
                    Utility.appendNumber(stringBuilder, i2, escapeTransliterator.radix, escapeTransliterator.minDigits);
                }
                unicodeSet3.addAll(stringBuilder.toString());
            }
            escapeTransliterator = escapeTransliterator.supplementalHandler;
        }
    }
}

