/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.nio.BufferOverflowException;
import java.util.Arrays;

public final class Edits {
    private static final int MAX_UNCHANGED_LENGTH = 4096;
    private static final int MAX_UNCHANGED = 4095;
    private static final int MAX_SHORT_CHANGE_OLD_LENGTH = 6;
    private static final int MAX_SHORT_CHANGE_NEW_LENGTH = 7;
    private static final int SHORT_CHANGE_NUM_MASK = 511;
    private static final int MAX_SHORT_CHANGE = 28671;
    private static final int LENGTH_IN_1TRAIL = 61;
    private static final int LENGTH_IN_2TRAIL = 62;
    private static final int STACK_CAPACITY = 100;
    private char[] array = new char[100];
    private int length;
    private int delta;
    private int numChanges;

    public void reset() {
        this.numChanges = 0;
        this.delta = 0;
        this.length = 0;
    }

    private void setLastUnit(int n2) {
        this.array[this.length - 1] = (char)n2;
    }

    private int lastUnit() {
        return this.length > 0 ? this.array[this.length - 1] : 65535;
    }

    public void addUnchanged(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("addUnchanged(" + n2 + "): length must not be negative");
        }
        int n3 = this.lastUnit();
        if (n3 < 4095) {
            int n4 = 4095 - n3;
            if (n4 >= n2) {
                this.setLastUnit(n3 + n2);
                return;
            }
            this.setLastUnit(4095);
            n2 -= n4;
        }
        while (n2 >= 4096) {
            this.append(4095);
            n2 -= 4096;
        }
        if (n2 > 0) {
            this.append(n2 - 1);
        }
    }

    public void addReplace(int n2, int n3) {
        if (n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException("addReplace(" + n2 + ", " + n3 + "): both lengths must be non-negative");
        }
        if (n2 == 0 && n3 == 0) {
            return;
        }
        ++this.numChanges;
        int n4 = n3 - n2;
        if (n4 != 0) {
            if (n4 > 0 && this.delta >= 0 && n4 > Integer.MAX_VALUE - this.delta || n4 < 0 && this.delta < 0 && n4 < Integer.MIN_VALUE - this.delta) {
                throw new IndexOutOfBoundsException();
            }
            this.delta += n4;
        }
        if (0 < n2 && n2 <= 6 && n3 <= 7) {
            int n5 = n2 << 12 | n3 << 9;
            int n6 = this.lastUnit();
            if (4095 < n6 && n6 < 28671 && (n6 & 0xFFFFFE00) == n5 && (n6 & 0x1FF) < 511) {
                this.setLastUnit(n6 + 1);
                return;
            }
            this.append(n5);
            return;
        }
        int n7 = 28672;
        if (n2 < 61 && n3 < 61) {
            n7 |= n2 << 6;
            this.append(n7 |= n3);
        } else if (this.array.length - this.length >= 5 || this.growArray()) {
            int n8 = this.length + 1;
            if (n2 < 61) {
                n7 |= n2 << 6;
            } else if (n2 <= Short.MAX_VALUE) {
                n7 |= 0xF40;
                this.array[n8++] = (char)(0x8000 | n2);
            } else {
                n7 |= 62 + (n2 >> 30) << 6;
                this.array[n8++] = (char)(0x8000 | n2 >> 15);
                this.array[n8++] = (char)(0x8000 | n2);
            }
            if (n3 < 61) {
                n7 |= n3;
            } else if (n3 <= Short.MAX_VALUE) {
                n7 |= 0x3D;
                this.array[n8++] = (char)(0x8000 | n3);
            } else {
                n7 |= 62 + (n3 >> 30);
                this.array[n8++] = (char)(0x8000 | n3 >> 15);
                this.array[n8++] = (char)(0x8000 | n3);
            }
            this.array[this.length] = (char)n7;
            this.length = n8;
        }
    }

    private void append(int n2) {
        if (this.length < this.array.length || this.growArray()) {
            this.array[this.length++] = (char)n2;
        }
    }

    private boolean growArray() {
        int n2;
        if (this.array.length == 100) {
            n2 = 2000;
        } else {
            if (this.array.length == Integer.MAX_VALUE) {
                throw new BufferOverflowException();
            }
            n2 = this.array.length >= 0x3FFFFFFF ? Integer.MAX_VALUE : 2 * this.array.length;
        }
        if (n2 - this.array.length < 5) {
            throw new BufferOverflowException();
        }
        this.array = Arrays.copyOf(this.array, n2);
        return true;
    }

    public int lengthDelta() {
        return this.delta;
    }

    public boolean hasChanges() {
        return this.numChanges != 0;
    }

    public int numberOfChanges() {
        return this.numChanges;
    }

    public Iterator getCoarseChangesIterator() {
        return new Iterator(this.array, this.length, true, true);
    }

    public Iterator getCoarseIterator() {
        return new Iterator(this.array, this.length, false, true);
    }

    public Iterator getFineChangesIterator() {
        return new Iterator(this.array, this.length, true, false);
    }

    public Iterator getFineIterator() {
        return new Iterator(this.array, this.length, false, false);
    }

    public Edits mergeAndAppend(Edits edits, Edits edits2) {
        Iterator iterator = edits.getFineIterator();
        Iterator iterator2 = edits2.getFineIterator();
        boolean bl2 = true;
        boolean bl3 = true;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (true) {
            if (n4 == 0 && bl3 && (bl3 = iterator2.next())) {
                n4 = iterator2.oldLength();
                n5 = iterator2.newLength();
                if (n4 == 0) {
                    if (n3 == 0 || !iterator.hasChange()) {
                        this.addReplace(n6, n7 + n5);
                        n7 = 0;
                        n6 = 0;
                        continue;
                    }
                    n7 += n5;
                    continue;
                }
            }
            if (n3 == 0) {
                if (bl2 && (bl2 = iterator.next())) {
                    n2 = iterator.oldLength();
                    n3 = iterator.newLength();
                    if (n3 == 0) {
                        if (n4 == iterator2.oldLength() || !iterator2.hasChange()) {
                            this.addReplace(n6 + n2, n7);
                            n7 = 0;
                            n6 = 0;
                            continue;
                        }
                        n6 += n2;
                        continue;
                    }
                } else {
                    if (n4 == 0) break;
                    throw new IllegalArgumentException("The ab output string is shorter than the bc input string.");
                }
            }
            if (n4 == 0) {
                throw new IllegalArgumentException("The bc input string is shorter than the ab output string.");
            }
            if (!iterator.hasChange() && !iterator2.hasChange()) {
                if (n6 != 0 || n7 != 0) {
                    this.addReplace(n6, n7);
                    n7 = 0;
                    n6 = 0;
                }
                int n8 = n2 <= n5 ? n2 : n5;
                this.addUnchanged(n8);
                n3 = n2 -= n8;
                n4 = n5 -= n8;
                continue;
            }
            if (!iterator.hasChange() && iterator2.hasChange()) {
                if (n3 >= n4) {
                    this.addReplace(n6 + n4, n7 + n5);
                    n7 = 0;
                    n6 = 0;
                    n2 = n3 -= n4;
                    n4 = 0;
                    continue;
                }
            } else if (iterator.hasChange() && !iterator2.hasChange()) {
                if (n3 <= n4) {
                    this.addReplace(n6 + n2, n7 + n3);
                    n7 = 0;
                    n6 = 0;
                    n5 = n4 -= n3;
                    n3 = 0;
                    continue;
                }
            } else if (n3 == n4) {
                this.addReplace(n6 + n2, n7 + n5);
                n7 = 0;
                n6 = 0;
                n4 = 0;
                n3 = 0;
                continue;
            }
            n6 += n2;
            n7 += n5;
            if (n3 < n4) {
                n4 -= n3;
                n3 = 0;
                n5 = 0;
                continue;
            }
            n3 -= n4;
            n4 = 0;
            n2 = 0;
        }
        if (n6 != 0 || n7 != 0) {
            this.addReplace(n6, n7);
        }
        return this;
    }

    public static final class Iterator {
        private final char[] array;
        private int index;
        private final int length;
        private int remaining;
        private final boolean onlyChanges_;
        private final boolean coarse;
        private int dir;
        private boolean changed;
        private int oldLength_;
        private int newLength_;
        private int srcIndex;
        private int replIndex;
        private int destIndex;

        private Iterator(char[] cArray, int n2, boolean bl2, boolean bl3) {
            this.array = cArray;
            this.length = n2;
            this.onlyChanges_ = bl2;
            this.coarse = bl3;
        }

        private int readLength(int n2) {
            if (n2 < 61) {
                return n2;
            }
            if (n2 < 62) {
                assert (this.index < this.length);
                assert (this.array[this.index] >= '\u8000');
                return this.array[this.index++] & Short.MAX_VALUE;
            }
            assert (this.index + 2 <= this.length);
            assert (this.array[this.index] >= '\u8000');
            assert (this.array[this.index + 1] >= '\u8000');
            int n3 = (n2 & 1) << 30 | (this.array[this.index] & Short.MAX_VALUE) << 15 | this.array[this.index + 1] & Short.MAX_VALUE;
            this.index += 2;
            return n3;
        }

        private void updateNextIndexes() {
            this.srcIndex += this.oldLength_;
            if (this.changed) {
                this.replIndex += this.newLength_;
            }
            this.destIndex += this.newLength_;
        }

        private void updatePreviousIndexes() {
            this.srcIndex -= this.oldLength_;
            if (this.changed) {
                this.replIndex -= this.newLength_;
            }
            this.destIndex -= this.newLength_;
        }

        private boolean noNext() {
            this.dir = 0;
            this.changed = false;
            this.newLength_ = 0;
            this.oldLength_ = 0;
            return false;
        }

        public boolean next() {
            return this.next(this.onlyChanges_);
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean next(boolean bl2) {
            int n2;
            char c2;
            block19: {
                if (this.dir > 0) {
                    this.updateNextIndexes();
                } else {
                    if (this.dir < 0 && this.remaining > 0) {
                        ++this.index;
                        this.dir = 1;
                        return true;
                    }
                    this.dir = 1;
                }
                if (this.remaining >= 1) {
                    if (this.remaining > 1) {
                        --this.remaining;
                        return true;
                    }
                    this.remaining = 0;
                }
                if (this.index >= this.length) {
                    return this.noNext();
                }
                if ((c2 = this.array[this.index++]) <= '\u0fff') {
                    this.changed = false;
                    this.oldLength_ = c2 + '\u0001';
                    while (this.index < this.length && (c2 = this.array[this.index]) <= '\u0fff') {
                        ++this.index;
                        this.oldLength_ += c2 + '\u0001';
                    }
                    this.newLength_ = this.oldLength_;
                    if (!bl2) {
                        return true;
                    }
                    this.updateNextIndexes();
                    if (this.index >= this.length) {
                        return this.noNext();
                    }
                    ++this.index;
                }
                this.changed = true;
                if (c2 <= '\u6fff') {
                    n2 = c2 >> 12;
                    int n3 = c2 >> 9 & 7;
                    int n4 = (c2 & 0x1FF) + 1;
                    if (this.coarse) {
                        this.oldLength_ = n4 * n2;
                        this.newLength_ = n4 * n3;
                        break block19;
                    } else {
                        this.oldLength_ = n2;
                        this.newLength_ = n3;
                        if (n4 > 1) {
                            this.remaining = n4;
                        }
                        return true;
                    }
                }
                assert (c2 <= Short.MAX_VALUE);
                this.oldLength_ = this.readLength(c2 >> 6 & 0x3F);
                this.newLength_ = this.readLength(c2 & 0x3F);
                if (!this.coarse) {
                    return true;
                }
            }
            while (this.index < this.length && (c2 = this.array[this.index]) > '\u0fff') {
                ++this.index;
                if (c2 <= '\u6fff') {
                    n2 = (c2 & 0x1FF) + 1;
                    this.oldLength_ += (c2 >> 12) * n2;
                    this.newLength_ += (c2 >> 9 & 7) * n2;
                    continue;
                }
                assert (c2 <= Short.MAX_VALUE);
                this.oldLength_ += this.readLength(c2 >> 6 & 0x3F);
                this.newLength_ += this.readLength(c2 & 0x3F);
            }
            return true;
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean previous() {
            int n2;
            char c2;
            block21: {
                if (this.dir >= 0) {
                    if (this.dir > 0) {
                        if (this.remaining > 0) {
                            --this.index;
                            this.dir = -1;
                            return true;
                        }
                        this.updateNextIndexes();
                    }
                    this.dir = -1;
                }
                if (this.remaining > 0) {
                    c2 = this.array[this.index];
                    assert ('\u0fff' < c2 && c2 <= '\u6fff');
                    if (this.remaining <= (c2 & 0x1FF)) {
                        ++this.remaining;
                        this.updatePreviousIndexes();
                        return true;
                    }
                    this.remaining = 0;
                }
                if (this.index <= 0) {
                    return this.noNext();
                }
                if ((c2 = this.array[--this.index]) <= '\u0fff') {
                    this.changed = false;
                    this.oldLength_ = c2 + '\u0001';
                    while (this.index > 0 && (c2 = this.array[this.index - 1]) <= '\u0fff') {
                        --this.index;
                        this.oldLength_ += c2 + '\u0001';
                    }
                    this.newLength_ = this.oldLength_;
                    this.updatePreviousIndexes();
                    return true;
                }
                this.changed = true;
                if (c2 <= '\u6fff') {
                    n2 = c2 >> 12;
                    int n3 = c2 >> 9 & 7;
                    int n4 = (c2 & 0x1FF) + 1;
                    if (this.coarse) {
                        this.oldLength_ = n4 * n2;
                        this.newLength_ = n4 * n3;
                        break block21;
                    } else {
                        this.oldLength_ = n2;
                        this.newLength_ = n3;
                        if (n4 > 1) {
                            this.remaining = 1;
                        }
                        this.updatePreviousIndexes();
                        return true;
                    }
                }
                if (c2 <= Short.MAX_VALUE) {
                    this.oldLength_ = this.readLength(c2 >> 6 & 0x3F);
                    this.newLength_ = this.readLength(c2 & 0x3F);
                } else {
                    assert (this.index > 0);
                    while ((c2 = this.array[--this.index]) > Short.MAX_VALUE) {
                    }
                    assert (c2 > '\u6fff');
                    n2 = this.index++;
                    this.oldLength_ = this.readLength(c2 >> 6 & 0x3F);
                    this.newLength_ = this.readLength(c2 & 0x3F);
                    this.index = n2;
                }
                if (!this.coarse) {
                    this.updatePreviousIndexes();
                    return true;
                }
            }
            while (this.index > 0 && (c2 = this.array[this.index - 1]) > '\u0fff') {
                --this.index;
                if (c2 <= '\u6fff') {
                    n2 = (c2 & 0x1FF) + 1;
                    this.oldLength_ += (c2 >> 12) * n2;
                    this.newLength_ += (c2 >> 9 & 7) * n2;
                    continue;
                }
                if (c2 > Short.MAX_VALUE) continue;
                ++this.index;
                this.oldLength_ += this.readLength(c2 >> 6 & 0x3F);
                this.newLength_ += this.readLength(c2 & 0x3F);
                this.index = n2;
            }
            this.updatePreviousIndexes();
            return true;
        }

        public boolean findSourceIndex(int n2) {
            return this.findIndex(n2, true) == 0;
        }

        public boolean findDestinationIndex(int n2) {
            return this.findIndex(n2, false) == 0;
        }

        private int findIndex(int n2, boolean bl2) {
            int n3;
            int n4;
            if (n2 < 0) {
                return -1;
            }
            if (bl2) {
                n4 = this.srcIndex;
                n3 = this.oldLength_;
            } else {
                n4 = this.destIndex;
                n3 = this.newLength_;
            }
            if (n2 < n4) {
                if (n2 >= n4 / 2) {
                    while (true) {
                        boolean bl3 = this.previous();
                        assert (bl3);
                        int n5 = n4 = bl2 ? this.srcIndex : this.destIndex;
                        if (n2 >= n4) {
                            return 0;
                        }
                        if (this.remaining <= 0) continue;
                        n3 = bl2 ? this.oldLength_ : this.newLength_;
                        char c2 = this.array[this.index];
                        assert ('\u0fff' < c2 && c2 <= '\u6fff');
                        int n6 = (c2 & 0x1FF) + 1 - this.remaining;
                        int n7 = n6 * n3;
                        if (n2 >= n4 - n7) {
                            int n8 = (n4 - n2 - 1) / n3 + 1;
                            this.srcIndex -= n8 * this.oldLength_;
                            this.replIndex -= n8 * this.newLength_;
                            this.destIndex -= n8 * this.newLength_;
                            this.remaining += n8;
                            return 0;
                        }
                        this.srcIndex -= n6 * this.oldLength_;
                        this.replIndex -= n6 * this.newLength_;
                        this.destIndex -= n6 * this.newLength_;
                        this.remaining = 0;
                    }
                }
                this.dir = 0;
                this.destIndex = 0;
                this.replIndex = 0;
                this.srcIndex = 0;
                this.newLength_ = 0;
                this.oldLength_ = 0;
                this.remaining = 0;
                this.index = 0;
            } else if (n2 < n4 + n3) {
                return 0;
            }
            while (this.next(false)) {
                if (bl2) {
                    n4 = this.srcIndex;
                    n3 = this.oldLength_;
                } else {
                    n4 = this.destIndex;
                    n3 = this.newLength_;
                }
                if (n2 < n4 + n3) {
                    return 0;
                }
                if (this.remaining <= 1) continue;
                int n9 = this.remaining * n3;
                if (n2 < n4 + n9) {
                    int n10 = (n2 - n4) / n3;
                    this.srcIndex += n10 * this.oldLength_;
                    this.replIndex += n10 * this.newLength_;
                    this.destIndex += n10 * this.newLength_;
                    this.remaining -= n10;
                    return 0;
                }
                this.oldLength_ *= this.remaining;
                this.newLength_ *= this.remaining;
                this.remaining = 0;
            }
            return 1;
        }

        public int destinationIndexFromSourceIndex(int n2) {
            int n3 = this.findIndex(n2, true);
            if (n3 < 0) {
                return 0;
            }
            if (n3 > 0 || n2 == this.srcIndex) {
                return this.destIndex;
            }
            if (this.changed) {
                return this.destIndex + this.newLength_;
            }
            return this.destIndex + (n2 - this.srcIndex);
        }

        public int sourceIndexFromDestinationIndex(int n2) {
            int n3 = this.findIndex(n2, false);
            if (n3 < 0) {
                return 0;
            }
            if (n3 > 0 || n2 == this.destIndex) {
                return this.srcIndex;
            }
            if (this.changed) {
                return this.srcIndex + this.oldLength_;
            }
            return this.srcIndex + (n2 - this.destIndex);
        }

        public boolean hasChange() {
            return this.changed;
        }

        public int oldLength() {
            return this.oldLength_;
        }

        public int newLength() {
            return this.newLength_;
        }

        public int sourceIndex() {
            return this.srcIndex;
        }

        public int replacementIndex() {
            return this.replIndex;
        }

        public int destinationIndex() {
            return this.destIndex;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(super.toString());
            stringBuilder.append("{ src[");
            stringBuilder.append(this.srcIndex);
            stringBuilder.append("..");
            stringBuilder.append(this.srcIndex + this.oldLength_);
            if (this.changed) {
                stringBuilder.append("] \u21dd dest[");
            } else {
                stringBuilder.append("] \u2261 dest[");
            }
            stringBuilder.append(this.destIndex);
            stringBuilder.append("..");
            stringBuilder.append(this.destIndex + this.newLength_);
            if (this.changed) {
                stringBuilder.append("], repl[");
                stringBuilder.append(this.replIndex);
                stringBuilder.append("..");
                stringBuilder.append(this.replIndex + this.newLength_);
                stringBuilder.append("] }");
            } else {
                stringBuilder.append("] (no-change) }");
            }
            return stringBuilder.toString();
        }
    }
}

