/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.text.AttributedCharacterIterator;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.FormattedValueFieldPositionIteratorImpl;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUCache;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUResourceBundle;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.SimpleCache;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.SimpleFormatterImpl;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Utility;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.ConstrainedFieldPosition;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.DateFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.DateIntervalInfo;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.DateTimePatternGenerator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.DisplayContext;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.FormattedValue;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.SimpleDateFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.Calendar;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.DateInterval;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.Output;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.TimeZone;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.UResourceBundle;

public class DateIntervalFormat
extends UFormat {
    private static final long serialVersionUID = 1L;
    private static ICUCache<String, Map<String, DateIntervalInfo.PatternInfo>> LOCAL_PATTERN_CACHE = new SimpleCache<String, Map<String, DateIntervalInfo.PatternInfo>>();
    private DateIntervalInfo fInfo;
    private SimpleDateFormat fDateFormat;
    private Calendar fFromCalendar;
    private Calendar fToCalendar;
    private String fSkeleton = null;
    private boolean isDateIntervalInfoDefault;
    private transient Map<String, DateIntervalInfo.PatternInfo> fIntervalPatterns = null;
    private String fDatePattern = null;
    private String fTimePattern = null;
    private String fDateTimeFormat = null;
    private DisplayContext fCapitalizationSetting = DisplayContext.CAPITALIZATION_NONE;

    private DateIntervalFormat() {
    }

    @Deprecated
    public DateIntervalFormat(String string, DateIntervalInfo dateIntervalInfo, SimpleDateFormat simpleDateFormat) {
        this.fDateFormat = simpleDateFormat;
        dateIntervalInfo.freeze();
        this.fSkeleton = string;
        this.fInfo = dateIntervalInfo;
        this.isDateIntervalInfoDefault = false;
        this.fFromCalendar = (Calendar)this.fDateFormat.getCalendar().clone();
        this.fToCalendar = (Calendar)this.fDateFormat.getCalendar().clone();
        this.initializePattern(null);
    }

    private DateIntervalFormat(String string, ULocale uLocale, SimpleDateFormat simpleDateFormat) {
        this.fDateFormat = simpleDateFormat;
        this.fSkeleton = string;
        this.fInfo = new DateIntervalInfo(uLocale).freeze();
        this.isDateIntervalInfoDefault = true;
        this.fFromCalendar = (Calendar)this.fDateFormat.getCalendar().clone();
        this.fToCalendar = (Calendar)this.fDateFormat.getCalendar().clone();
        this.initializePattern(LOCAL_PATTERN_CACHE);
    }

    public static final DateIntervalFormat getInstance(String string) {
        return DateIntervalFormat.getInstance(string, ULocale.getDefault(ULocale.Category.FORMAT));
    }

    public static final DateIntervalFormat getInstance(String string, Locale locale) {
        return DateIntervalFormat.getInstance(string, ULocale.forLocale(locale));
    }

    public static final DateIntervalFormat getInstance(String string, ULocale uLocale) {
        DateTimePatternGenerator dateTimePatternGenerator = DateTimePatternGenerator.getInstance(uLocale);
        return new DateIntervalFormat(string, uLocale, new SimpleDateFormat(dateTimePatternGenerator.getBestPattern(string), uLocale));
    }

    public static final DateIntervalFormat getInstance(String string, DateIntervalInfo dateIntervalInfo) {
        return DateIntervalFormat.getInstance(string, ULocale.getDefault(ULocale.Category.FORMAT), dateIntervalInfo);
    }

    public static final DateIntervalFormat getInstance(String string, Locale locale, DateIntervalInfo dateIntervalInfo) {
        return DateIntervalFormat.getInstance(string, ULocale.forLocale(locale), dateIntervalInfo);
    }

    public static final DateIntervalFormat getInstance(String string, ULocale uLocale, DateIntervalInfo dateIntervalInfo) {
        dateIntervalInfo = (DateIntervalInfo)dateIntervalInfo.clone();
        DateTimePatternGenerator dateTimePatternGenerator = DateTimePatternGenerator.getInstance(uLocale);
        return new DateIntervalFormat(string, dateIntervalInfo, new SimpleDateFormat(dateTimePatternGenerator.getBestPattern(string), uLocale));
    }

    @Override
    public synchronized Object clone() {
        DateIntervalFormat dateIntervalFormat = (DateIntervalFormat)super.clone();
        dateIntervalFormat.fDateFormat = (SimpleDateFormat)this.fDateFormat.clone();
        dateIntervalFormat.fInfo = (DateIntervalInfo)this.fInfo.clone();
        dateIntervalFormat.fFromCalendar = (Calendar)this.fFromCalendar.clone();
        dateIntervalFormat.fToCalendar = (Calendar)this.fToCalendar.clone();
        dateIntervalFormat.fDatePattern = this.fDatePattern;
        dateIntervalFormat.fTimePattern = this.fTimePattern;
        dateIntervalFormat.fDateTimeFormat = this.fDateTimeFormat;
        dateIntervalFormat.fCapitalizationSetting = this.fCapitalizationSetting;
        return dateIntervalFormat;
    }

    @Override
    public final StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (object instanceof DateInterval) {
            return this.format((DateInterval)object, stringBuffer, fieldPosition);
        }
        throw new IllegalArgumentException("Cannot format given Object (" + object.getClass().getName() + ") as a DateInterval");
    }

    public final StringBuffer format(DateInterval dateInterval, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.formatIntervalImpl(dateInterval, stringBuffer, fieldPosition, null, null);
    }

    public FormattedDateInterval formatToValue(DateInterval dateInterval) {
        StringBuffer stringBuffer = new StringBuffer();
        FieldPosition fieldPosition = new FieldPosition(0);
        FormatOutput formatOutput = new FormatOutput();
        ArrayList<FieldPosition> arrayList = new ArrayList<FieldPosition>();
        this.formatIntervalImpl(dateInterval, stringBuffer, fieldPosition, formatOutput, arrayList);
        if (formatOutput.firstIndex != -1) {
            FormattedValueFieldPositionIteratorImpl.addOverlapSpans(arrayList, SpanField.DATE_INTERVAL_SPAN, formatOutput.firstIndex);
            FormattedValueFieldPositionIteratorImpl.sort(arrayList);
        }
        return new FormattedDateInterval(stringBuffer, arrayList);
    }

    private synchronized StringBuffer formatIntervalImpl(DateInterval dateInterval, StringBuffer stringBuffer, FieldPosition fieldPosition, FormatOutput formatOutput, List<FieldPosition> list) {
        this.fFromCalendar.setTimeInMillis(dateInterval.getFromDate());
        this.fToCalendar.setTimeInMillis(dateInterval.getToDate());
        return this.formatImpl(this.fFromCalendar, this.fToCalendar, stringBuffer, fieldPosition, formatOutput, list);
    }

    @Deprecated
    public String getPatterns(Calendar calendar, Calendar calendar2, Output<String> output) {
        int n2;
        if (calendar.get(0) != calendar2.get(0)) {
            n2 = 0;
        } else if (calendar.get(1) != calendar2.get(1)) {
            n2 = 1;
        } else if (calendar.get(2) != calendar2.get(2)) {
            n2 = 2;
        } else if (calendar.get(5) != calendar2.get(5)) {
            n2 = 5;
        } else if (calendar.get(9) != calendar2.get(9)) {
            n2 = 9;
        } else if (calendar.get(10) != calendar2.get(10)) {
            n2 = 10;
        } else if (calendar.get(12) != calendar2.get(12)) {
            n2 = 12;
        } else if (calendar.get(13) != calendar2.get(13)) {
            n2 = 13;
        } else if (calendar.get(14) != calendar2.get(14)) {
            n2 = 14;
        } else {
            return null;
        }
        DateIntervalInfo.PatternInfo patternInfo = this.fIntervalPatterns.get(DateIntervalInfo.CALENDAR_FIELD_TO_PATTERN_LETTER[n2]);
        output.value = patternInfo.getSecondPart();
        return patternInfo.getFirstPart();
    }

    public final StringBuffer format(Calendar calendar, Calendar calendar2, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.formatImpl(calendar, calendar2, stringBuffer, fieldPosition, null, null);
    }

    public FormattedDateInterval formatToValue(Calendar calendar, Calendar calendar2) {
        StringBuffer stringBuffer = new StringBuffer();
        FieldPosition fieldPosition = new FieldPosition(0);
        FormatOutput formatOutput = new FormatOutput();
        ArrayList<FieldPosition> arrayList = new ArrayList<FieldPosition>();
        this.formatImpl(calendar, calendar2, stringBuffer, fieldPosition, formatOutput, arrayList);
        if (formatOutput.firstIndex != -1) {
            FormattedValueFieldPositionIteratorImpl.addOverlapSpans(arrayList, SpanField.DATE_INTERVAL_SPAN, formatOutput.firstIndex);
            FormattedValueFieldPositionIteratorImpl.sort(arrayList);
        }
        return new FormattedDateInterval(stringBuffer, arrayList);
    }

    private synchronized StringBuffer formatImpl(Calendar calendar, Calendar calendar2, StringBuffer stringBuffer, FieldPosition fieldPosition, FormatOutput formatOutput, List<FieldPosition> list) {
        Calendar calendar3;
        Calendar calendar4;
        if (!calendar.isEquivalentTo(calendar2)) {
            throw new IllegalArgumentException("can not format on two different calendars");
        }
        this.fDateFormat.setContext(this.fCapitalizationSetting);
        int n2 = -1;
        if (calendar.get(0) != calendar2.get(0)) {
            n2 = 0;
        } else if (calendar.get(1) != calendar2.get(1)) {
            n2 = 1;
        } else if (calendar.get(2) != calendar2.get(2)) {
            n2 = 2;
        } else if (calendar.get(5) != calendar2.get(5)) {
            n2 = 5;
        } else if (calendar.get(9) != calendar2.get(9)) {
            n2 = 9;
        } else if (calendar.get(10) != calendar2.get(10)) {
            n2 = 10;
        } else if (calendar.get(12) != calendar2.get(12)) {
            n2 = 12;
        } else if (calendar.get(13) != calendar2.get(13)) {
            n2 = 13;
        } else if (calendar.get(14) != calendar2.get(14)) {
            n2 = 14;
        } else {
            return this.fDateFormat.format(calendar, stringBuffer, fieldPosition, list);
        }
        boolean bl2 = n2 == 9 || n2 == 10 || n2 == 12 || n2 == 13 || n2 == 14;
        DateIntervalInfo.PatternInfo patternInfo = this.fIntervalPatterns.get(DateIntervalInfo.CALENDAR_FIELD_TO_PATTERN_LETTER[n2]);
        if (patternInfo == null) {
            if (this.fDateFormat.isFieldUnitIgnored(n2)) {
                return this.fDateFormat.format(calendar, stringBuffer, fieldPosition, list);
            }
            return this.fallbackFormat(calendar, calendar2, bl2, stringBuffer, fieldPosition, formatOutput, list);
        }
        if (patternInfo.getFirstPart() == null) {
            return this.fallbackFormat(calendar, calendar2, bl2, stringBuffer, fieldPosition, formatOutput, list, patternInfo.getSecondPart());
        }
        if (patternInfo.firstDateInPtnIsLaterDate()) {
            if (formatOutput != null) {
                formatOutput.register(1);
            }
            calendar4 = calendar2;
            calendar3 = calendar;
        } else {
            if (formatOutput != null) {
                formatOutput.register(0);
            }
            calendar4 = calendar;
            calendar3 = calendar2;
        }
        String string = this.fDateFormat.toPattern();
        this.fDateFormat.applyPattern(patternInfo.getFirstPart());
        this.fDateFormat.format(calendar4, stringBuffer, fieldPosition, list);
        if (fieldPosition.getEndIndex() > 0) {
            fieldPosition = new FieldPosition(0);
        }
        if (patternInfo.getSecondPart() != null) {
            this.fDateFormat.applyPattern(patternInfo.getSecondPart());
            this.fDateFormat.setContext(DisplayContext.CAPITALIZATION_NONE);
            this.fDateFormat.format(calendar3, stringBuffer, fieldPosition, list);
        }
        this.fDateFormat.applyPattern(string);
        return stringBuffer;
    }

    private final void fallbackFormatRange(Calendar calendar, Calendar calendar2, StringBuffer stringBuffer, StringBuilder stringBuilder, FieldPosition fieldPosition, FormatOutput formatOutput, List<FieldPosition> list) {
        String string = SimpleFormatterImpl.compileToStringMinMaxArguments(this.fInfo.getFallbackIntervalPattern(), stringBuilder, 2, 2);
        long l2 = 0L;
        while ((l2 = SimpleFormatterImpl.IterInternal.step(l2, string, stringBuffer)) != -1L) {
            if (SimpleFormatterImpl.IterInternal.getArgIndex(l2) == 0) {
                if (formatOutput != null) {
                    formatOutput.register(0);
                }
                this.fDateFormat.format(calendar, stringBuffer, fieldPosition, list);
            } else {
                if (formatOutput != null) {
                    formatOutput.register(1);
                }
                this.fDateFormat.format(calendar2, stringBuffer, fieldPosition, list);
            }
            if (fieldPosition.getEndIndex() > 0) {
                fieldPosition = new FieldPosition(0);
            }
            this.fDateFormat.setContext(DisplayContext.CAPITALIZATION_NONE);
        }
    }

    private final StringBuffer fallbackFormat(Calendar calendar, Calendar calendar2, boolean bl2, StringBuffer stringBuffer, FieldPosition fieldPosition, FormatOutput formatOutput, List<FieldPosition> list) {
        boolean bl3;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl4 = bl3 = bl2 && this.fDatePattern != null && this.fTimePattern != null;
        if (bl3) {
            String string = SimpleFormatterImpl.compileToStringMinMaxArguments(this.fDateTimeFormat, stringBuilder, 2, 2);
            String string2 = this.fDateFormat.toPattern();
            long l2 = 0L;
            while ((l2 = SimpleFormatterImpl.IterInternal.step(l2, string, stringBuffer)) != -1L) {
                if (SimpleFormatterImpl.IterInternal.getArgIndex(l2) == 0) {
                    this.fDateFormat.applyPattern(this.fTimePattern);
                    this.fallbackFormatRange(calendar, calendar2, stringBuffer, stringBuilder, fieldPosition, formatOutput, list);
                } else {
                    this.fDateFormat.applyPattern(this.fDatePattern);
                    this.fDateFormat.format(calendar, stringBuffer, fieldPosition, list);
                }
                if (fieldPosition.getEndIndex() > 0) {
                    fieldPosition = new FieldPosition(0);
                }
                this.fDateFormat.setContext(DisplayContext.CAPITALIZATION_NONE);
            }
            this.fDateFormat.applyPattern(string2);
        } else {
            this.fallbackFormatRange(calendar, calendar2, stringBuffer, stringBuilder, fieldPosition, formatOutput, list);
        }
        return stringBuffer;
    }

    private final StringBuffer fallbackFormat(Calendar calendar, Calendar calendar2, boolean bl2, StringBuffer stringBuffer, FieldPosition fieldPosition, FormatOutput formatOutput, List<FieldPosition> list, String string) {
        String string2 = this.fDateFormat.toPattern();
        this.fDateFormat.applyPattern(string);
        this.fallbackFormat(calendar, calendar2, bl2, stringBuffer, fieldPosition, formatOutput, list);
        this.fDateFormat.applyPattern(string2);
        return stringBuffer;
    }

    @Override
    @Deprecated
    public Object parseObject(String string, ParsePosition parsePosition) {
        throw new UnsupportedOperationException("parsing is not supported");
    }

    public DateIntervalInfo getDateIntervalInfo() {
        return (DateIntervalInfo)this.fInfo.clone();
    }

    public void setDateIntervalInfo(DateIntervalInfo dateIntervalInfo) {
        this.fInfo = (DateIntervalInfo)dateIntervalInfo.clone();
        this.isDateIntervalInfoDefault = false;
        this.fInfo.freeze();
        if (this.fDateFormat != null) {
            this.initializePattern(null);
        }
    }

    public TimeZone getTimeZone() {
        if (this.fDateFormat != null) {
            return (TimeZone)this.fDateFormat.getTimeZone().clone();
        }
        return TimeZone.getDefault();
    }

    public void setTimeZone(TimeZone timeZone) {
        TimeZone timeZone2 = (TimeZone)timeZone.clone();
        if (this.fDateFormat != null) {
            this.fDateFormat.setTimeZone(timeZone2);
        }
        if (this.fFromCalendar != null) {
            this.fFromCalendar.setTimeZone(timeZone2);
        }
        if (this.fToCalendar != null) {
            this.fToCalendar.setTimeZone(timeZone2);
        }
    }

    public void setContext(DisplayContext displayContext) {
        if (displayContext.type() == DisplayContext.Type.CAPITALIZATION) {
            this.fCapitalizationSetting = displayContext;
        }
    }

    public DisplayContext getContext(DisplayContext.Type type) {
        return type == DisplayContext.Type.CAPITALIZATION && this.fCapitalizationSetting != null ? this.fCapitalizationSetting : DisplayContext.CAPITALIZATION_NONE;
    }

    public synchronized DateFormat getDateFormat() {
        return (DateFormat)this.fDateFormat.clone();
    }

    private void initializePattern(ICUCache<String, Map<String, DateIntervalInfo.PatternInfo>> iCUCache) {
        String string = this.fDateFormat.toPattern();
        ULocale uLocale = this.fDateFormat.getLocale();
        String string2 = null;
        Map<String, DateIntervalInfo.PatternInfo> map = null;
        if (iCUCache != null) {
            string2 = this.fSkeleton != null ? uLocale.toString() + "+" + string + "+" + this.fSkeleton : uLocale.toString() + "+" + string;
            map = iCUCache.get(string2);
        }
        if (map == null) {
            Map<String, DateIntervalInfo.PatternInfo> map2 = this.initializeIntervalPattern(string, uLocale);
            map = Collections.unmodifiableMap(map2);
            if (iCUCache != null) {
                iCUCache.put(string2, map);
            }
        }
        this.fIntervalPatterns = map;
    }

    private Map<String, DateIntervalInfo.PatternInfo> initializeIntervalPattern(String string, ULocale uLocale) {
        boolean bl2;
        DateTimePatternGenerator dateTimePatternGenerator = DateTimePatternGenerator.getInstance(uLocale);
        if (this.fSkeleton == null) {
            this.fSkeleton = dateTimePatternGenerator.getSkeleton(string);
        }
        String string2 = this.normalizeHourMetacharacters(this.fSkeleton, uLocale);
        HashMap<String, DateIntervalInfo.PatternInfo> hashMap = new HashMap<String, DateIntervalInfo.PatternInfo>();
        StringBuilder stringBuilder = new StringBuilder(string2.length());
        StringBuilder stringBuilder2 = new StringBuilder(string2.length());
        StringBuilder stringBuilder3 = new StringBuilder(string2.length());
        StringBuilder stringBuilder4 = new StringBuilder(string2.length());
        DateIntervalFormat.getDateTimeSkeleton(string2, stringBuilder, stringBuilder2, stringBuilder3, stringBuilder4);
        String string3 = stringBuilder.toString();
        String string4 = stringBuilder3.toString();
        String string5 = stringBuilder2.toString();
        String string6 = stringBuilder4.toString();
        if (stringBuilder3.length() != 0 && stringBuilder.length() != 0) {
            this.fDateTimeFormat = this.getConcatenationPattern(uLocale);
        }
        if (!(bl2 = this.genSeparateDateTimePtn(string5, string6, hashMap, dateTimePatternGenerator))) {
            if (stringBuilder3.length() != 0 && stringBuilder.length() == 0) {
                string4 = "yMd" + string4;
                String string7 = dateTimePatternGenerator.getBestPattern(string4);
                DateIntervalInfo.PatternInfo patternInfo = new DateIntervalInfo.PatternInfo(null, string7, this.fInfo.getDefaultOrder());
                hashMap.put(DateIntervalInfo.CALENDAR_FIELD_TO_PATTERN_LETTER[5], patternInfo);
                hashMap.put(DateIntervalInfo.CALENDAR_FIELD_TO_PATTERN_LETTER[2], patternInfo);
                hashMap.put(DateIntervalInfo.CALENDAR_FIELD_TO_PATTERN_LETTER[1], patternInfo);
                string7 = dateTimePatternGenerator.getBestPattern(string4 + "G");
                patternInfo = new DateIntervalInfo.PatternInfo(null, string7, this.fInfo.getDefaultOrder());
                hashMap.put(DateIntervalInfo.CALENDAR_FIELD_TO_PATTERN_LETTER[0], patternInfo);
            }
            return hashMap;
        }
        if (stringBuilder3.length() != 0) {
            if (stringBuilder.length() == 0) {
                string4 = "yMd" + string4;
                String string8 = dateTimePatternGenerator.getBestPattern(string4);
                DateIntervalInfo.PatternInfo patternInfo = new DateIntervalInfo.PatternInfo(null, string8, this.fInfo.getDefaultOrder());
                hashMap.put(DateIntervalInfo.CALENDAR_FIELD_TO_PATTERN_LETTER[5], patternInfo);
                hashMap.put(DateIntervalInfo.CALENDAR_FIELD_TO_PATTERN_LETTER[2], patternInfo);
                hashMap.put(DateIntervalInfo.CALENDAR_FIELD_TO_PATTERN_LETTER[1], patternInfo);
                string8 = dateTimePatternGenerator.getBestPattern(string4 + "G");
                patternInfo = new DateIntervalInfo.PatternInfo(null, string8, this.fInfo.getDefaultOrder());
                hashMap.put(DateIntervalInfo.CALENDAR_FIELD_TO_PATTERN_LETTER[0], patternInfo);
            } else {
                if (!DateIntervalFormat.fieldExistsInSkeleton(5, string3)) {
                    string2 = DateIntervalInfo.CALENDAR_FIELD_TO_PATTERN_LETTER[5] + string2;
                    this.genFallbackPattern(5, string2, hashMap, dateTimePatternGenerator);
                }
                if (!DateIntervalFormat.fieldExistsInSkeleton(2, string3)) {
                    string2 = DateIntervalInfo.CALENDAR_FIELD_TO_PATTERN_LETTER[2] + string2;
                    this.genFallbackPattern(2, string2, hashMap, dateTimePatternGenerator);
                }
                if (!DateIntervalFormat.fieldExistsInSkeleton(1, string3)) {
                    string2 = DateIntervalInfo.CALENDAR_FIELD_TO_PATTERN_LETTER[1] + string2;
                    this.genFallbackPattern(1, string2, hashMap, dateTimePatternGenerator);
                }
                if (!DateIntervalFormat.fieldExistsInSkeleton(0, string3)) {
                    string2 = DateIntervalInfo.CALENDAR_FIELD_TO_PATTERN_LETTER[0] + string2;
                    this.genFallbackPattern(0, string2, hashMap, dateTimePatternGenerator);
                }
                if (this.fDateTimeFormat == null) {
                    this.fDateTimeFormat = "{1} {0}";
                }
                String string9 = dateTimePatternGenerator.getBestPattern(string3);
                this.concatSingleDate2TimeInterval(this.fDateTimeFormat, string9, 9, hashMap);
                this.concatSingleDate2TimeInterval(this.fDateTimeFormat, string9, 10, hashMap);
                this.concatSingleDate2TimeInterval(this.fDateTimeFormat, string9, 12, hashMap);
            }
        }
        return hashMap;
    }

    private String getConcatenationPattern(ULocale uLocale) {
        ICUResourceBundle iCUResourceBundle = (ICUResourceBundle)UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b", uLocale);
        ICUResourceBundle iCUResourceBundle2 = iCUResourceBundle.getWithFallback("calendar/gregorian/DateTimePatterns");
        ICUResourceBundle iCUResourceBundle3 = (ICUResourceBundle)iCUResourceBundle2.get(8);
        if (iCUResourceBundle3.getType() == 0) {
            return iCUResourceBundle3.getString();
        }
        return iCUResourceBundle3.getString(0);
    }

    private void genFallbackPattern(int n2, String string, Map<String, DateIntervalInfo.PatternInfo> map, DateTimePatternGenerator dateTimePatternGenerator) {
        String string2 = dateTimePatternGenerator.getBestPattern(string);
        DateIntervalInfo.PatternInfo patternInfo = new DateIntervalInfo.PatternInfo(null, string2, this.fInfo.getDefaultOrder());
        map.put(DateIntervalInfo.CALENDAR_FIELD_TO_PATTERN_LETTER[n2], patternInfo);
    }

    private String normalizeHourMetacharacters(String string, ULocale uLocale) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder(string);
        char c2 = '\u0000';
        char c3 = '\u0000';
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (n2 = 0; n2 < stringBuilder.length(); ++n2) {
            char c4 = stringBuilder.charAt(n2);
            if (c4 == 'j' || c4 == 'J' || c4 == 'C' || c4 == 'h' || c4 == 'H' || c4 == 'k' || c4 == 'K') {
                if (c2 == '\u0000') {
                    c2 = c4;
                    n3 = n2;
                }
                ++n4;
                continue;
            }
            if (c4 == 'a' || c4 == 'b' || c4 == 'B') {
                if (c3 == '\u0000') {
                    c3 = c4;
                    n5 = n2;
                }
                ++n6;
                continue;
            }
            if (c2 != '\u0000' && c3 != '\u0000') break;
        }
        if (c2 != '\u0000') {
            int n7;
            n2 = 72;
            DateTimePatternGenerator dateTimePatternGenerator = DateTimePatternGenerator.getInstance(uLocale);
            String string2 = dateTimePatternGenerator.getBestPattern(String.valueOf(c2));
            while ((n7 = string2.indexOf(39)) != -1) {
                int n8 = string2.indexOf(39, n7 + 1);
                if (n8 == -1) {
                    n8 = n7;
                }
                string2 = string2.substring(0, n7) + string2.substring(n8 + 1);
            }
            if (string2.indexOf(104) != -1) {
                n2 = 104;
            } else if (string2.indexOf(75) != -1) {
                n2 = 75;
            } else if (string2.indexOf(107) != -1) {
                n2 = 107;
            }
            if (string2.indexOf(98) != -1) {
                c3 = 'b';
            } else if (string2.indexOf(66) != -1) {
                c3 = 'B';
            } else if (c3 == '\u0000') {
                c3 = 'a';
            }
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder2.append((char)n2);
            if (n2 != 72 && n2 != 107) {
                int n9 = 0;
                n9 = n6 >= 5 || n4 >= 5 ? 5 : (n6 >= 3 || n4 >= 3 ? 3 : 1);
                for (int i2 = 0; i2 < n9; ++i2) {
                    stringBuilder2.append(c3);
                }
            }
            stringBuilder.replace(n3, n3 + n4, stringBuilder2.toString());
            if (n5 > n3) {
                n5 += stringBuilder2.length() - n4;
            }
            stringBuilder.delete(n5, n5 + n6);
        }
        return stringBuilder.toString();
    }

    private static void getDateTimeSkeleton(String string, StringBuilder stringBuilder, StringBuilder stringBuilder2, StringBuilder stringBuilder3, StringBuilder stringBuilder4) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        char c2 = '\u0000';
        block12: for (n2 = 0; n2 < string.length(); ++n2) {
            char c3 = string.charAt(n2);
            switch (c3) {
                case 'E': {
                    stringBuilder.append(c3);
                    ++n3;
                    continue block12;
                }
                case 'd': {
                    stringBuilder.append(c3);
                    ++n4;
                    continue block12;
                }
                case 'M': {
                    stringBuilder.append(c3);
                    ++n5;
                    continue block12;
                }
                case 'y': {
                    stringBuilder.append(c3);
                    ++n6;
                    continue block12;
                }
                case 'D': 
                case 'F': 
                case 'G': 
                case 'L': 
                case 'Q': 
                case 'U': 
                case 'W': 
                case 'Y': 
                case 'c': 
                case 'e': 
                case 'g': 
                case 'l': 
                case 'q': 
                case 'r': 
                case 'u': 
                case 'w': {
                    stringBuilder2.append(c3);
                    stringBuilder.append(c3);
                    continue block12;
                }
                case 'H': 
                case 'K': 
                case 'h': 
                case 'k': {
                    stringBuilder3.append(c3);
                    if (c2 != '\u0000') continue block12;
                    c2 = c3;
                    continue block12;
                }
                case 'm': {
                    stringBuilder3.append(c3);
                    ++n7;
                    continue block12;
                }
                case 'z': {
                    ++n9;
                    stringBuilder3.append(c3);
                    continue block12;
                }
                case 'v': {
                    ++n8;
                    stringBuilder3.append(c3);
                    continue block12;
                }
                case 'A': 
                case 'B': 
                case 'S': 
                case 'V': 
                case 'Z': 
                case 'a': 
                case 'b': 
                case 'j': 
                case 's': {
                    stringBuilder3.append(c3);
                    stringBuilder4.append(c3);
                }
            }
        }
        if (n6 != 0) {
            for (n2 = 0; n2 < n6; ++n2) {
                stringBuilder2.append('y');
            }
        }
        if (n5 != 0) {
            if (n5 < 3) {
                stringBuilder2.append('M');
            } else {
                for (n2 = 0; n2 < n5 && n2 < 5; ++n2) {
                    stringBuilder2.append('M');
                }
            }
        }
        if (n3 != 0) {
            if (n3 <= 3) {
                stringBuilder2.append('E');
            } else {
                for (n2 = 0; n2 < n3 && n2 < 5; ++n2) {
                    stringBuilder2.append('E');
                }
            }
        }
        if (n4 != 0) {
            stringBuilder2.append('d');
        }
        if (c2 != '\u0000') {
            stringBuilder4.append(c2);
        }
        if (n7 != 0) {
            stringBuilder4.append('m');
        }
        if (n9 != 0) {
            stringBuilder4.append('z');
        }
        if (n8 != 0) {
            stringBuilder4.append('v');
        }
    }

    private boolean genSeparateDateTimePtn(String string, String string2, Map<String, DateIntervalInfo.PatternInfo> map, DateTimePatternGenerator dateTimePatternGenerator) {
        String string3 = string2.length() != 0 ? string2 : string;
        BestMatchInfo bestMatchInfo = this.fInfo.getBestSkeleton(string3);
        String string4 = bestMatchInfo.bestMatchSkeleton;
        int n2 = bestMatchInfo.bestMatchDistanceInfo;
        if (string.length() != 0) {
            this.fDatePattern = dateTimePatternGenerator.getBestPattern(string);
        }
        if (string2.length() != 0) {
            this.fTimePattern = dateTimePatternGenerator.getBestPattern(string2);
        }
        if (n2 == -1) {
            return false;
        }
        if (string2.length() == 0) {
            this.genIntervalPattern(5, string3, string4, n2, map);
            SkeletonAndItsBestMatch skeletonAndItsBestMatch = this.genIntervalPattern(2, string3, string4, n2, map);
            if (skeletonAndItsBestMatch != null) {
                string4 = skeletonAndItsBestMatch.skeleton;
                string3 = skeletonAndItsBestMatch.bestMatchSkeleton;
            }
            this.genIntervalPattern(1, string3, string4, n2, map);
            this.genIntervalPattern(0, string3, string4, n2, map);
        } else {
            this.genIntervalPattern(12, string3, string4, n2, map);
            this.genIntervalPattern(10, string3, string4, n2, map);
            this.genIntervalPattern(9, string3, string4, n2, map);
        }
        return true;
    }

    private SkeletonAndItsBestMatch genIntervalPattern(int n2, String string, String string2, int n3, Map<String, DateIntervalInfo.PatternInfo> map) {
        String string3;
        Object object;
        SkeletonAndItsBestMatch skeletonAndItsBestMatch = null;
        DateIntervalInfo.PatternInfo patternInfo = this.fInfo.getIntervalPattern(string2, n2);
        if (patternInfo == null) {
            if (SimpleDateFormat.isFieldUnitIgnored(string2, n2)) {
                DateIntervalInfo.PatternInfo patternInfo2 = new DateIntervalInfo.PatternInfo(this.fDateFormat.toPattern(), null, this.fInfo.getDefaultOrder());
                map.put(DateIntervalInfo.CALENDAR_FIELD_TO_PATTERN_LETTER[n2], patternInfo2);
                return null;
            }
            if (n2 == 9) {
                patternInfo = this.fInfo.getIntervalPattern(string2, 10);
                if (patternInfo != null) {
                    boolean bl2 = this.fSkeleton.indexOf(74) != -1;
                    String string4 = DateIntervalFormat.adjustFieldWidth(string, string2, patternInfo.getFirstPart(), n3, bl2);
                    String string5 = DateIntervalFormat.adjustFieldWidth(string, string2, patternInfo.getSecondPart(), n3, bl2);
                    patternInfo = new DateIntervalInfo.PatternInfo(string4, string5, patternInfo.firstDateInPtnIsLaterDate());
                    map.put(DateIntervalInfo.CALENDAR_FIELD_TO_PATTERN_LETTER[n2], patternInfo);
                }
                return null;
            }
            String string6 = DateIntervalInfo.CALENDAR_FIELD_TO_PATTERN_LETTER[n2];
            string2 = string6 + string2;
            string = string6 + string;
            patternInfo = this.fInfo.getIntervalPattern(string2, n2);
            if (patternInfo == null && n3 == 0) {
                object = this.fInfo.getBestSkeleton(string);
                string3 = ((BestMatchInfo)object).bestMatchSkeleton;
                n3 = ((BestMatchInfo)object).bestMatchDistanceInfo;
                if (string3.length() != 0 && n3 != -1) {
                    patternInfo = this.fInfo.getIntervalPattern(string3, n2);
                    string2 = string3;
                }
            }
            if (patternInfo != null) {
                skeletonAndItsBestMatch = new SkeletonAndItsBestMatch(string, string2);
            }
        }
        if (patternInfo != null) {
            if (n3 != 0) {
                boolean bl3 = this.fSkeleton.indexOf(74) != -1;
                object = DateIntervalFormat.adjustFieldWidth(string, string2, patternInfo.getFirstPart(), n3, bl3);
                string3 = DateIntervalFormat.adjustFieldWidth(string, string2, patternInfo.getSecondPart(), n3, bl3);
                patternInfo = new DateIntervalInfo.PatternInfo((String)object, string3, patternInfo.firstDateInPtnIsLaterDate());
            }
            map.put(DateIntervalInfo.CALENDAR_FIELD_TO_PATTERN_LETTER[n2], patternInfo);
        }
        return skeletonAndItsBestMatch;
    }

    private static String adjustFieldWidth(String string, String string2, String string3, int n2, boolean bl2) {
        int n3;
        int n4;
        int n5;
        int n6;
        if (string3 == null) {
            return null;
        }
        int[] nArray = new int[58];
        int[] nArray2 = new int[58];
        int n7 = 65;
        DateIntervalInfo.parseSkeleton(string, nArray);
        DateIntervalInfo.parseSkeleton(string2, nArray2);
        if (bl2) {
            if (string3.indexOf(" a") != -1) {
                string3 = DateIntervalFormat.findReplaceInPattern(string3, " a", "");
            } else if (string3.indexOf("\u00a0a") != -1) {
                string3 = DateIntervalFormat.findReplaceInPattern(string3, "\u00a0a", "");
            } else if (string3.indexOf("\u202fa") != -1) {
                string3 = DateIntervalFormat.findReplaceInPattern(string3, "\u202fa", "");
            } else if (string3.indexOf("a ") != -1) {
                string3 = DateIntervalFormat.findReplaceInPattern(string3, "a ", "");
            } else if (string3.indexOf("a\u00a0") != -1) {
                string3 = DateIntervalFormat.findReplaceInPattern(string3, "a\u00a0", "");
            } else if (string3.indexOf("a\u202f") != -1) {
                string3 = DateIntervalFormat.findReplaceInPattern(string3, "a\u202f", "");
            }
            string3 = DateIntervalFormat.findReplaceInPattern(string3, "a", "");
        }
        if (n2 == 2) {
            if (string.indexOf(122) != -1) {
                string3 = DateIntervalFormat.findReplaceInPattern(string3, "v", "z");
            }
            if (string.indexOf(75) != -1) {
                string3 = DateIntervalFormat.findReplaceInPattern(string3, "h", "K");
            }
            if (string.indexOf(107) != -1) {
                string3 = DateIntervalFormat.findReplaceInPattern(string3, "H", "k");
            }
            if (string.indexOf(98) != -1) {
                string3 = DateIntervalFormat.findReplaceInPattern(string3, "a", "b");
            }
        }
        if (string3.indexOf(97) != -1 && nArray2[97 - n7] == 0) {
            nArray2[97 - n7] = 1;
        }
        if (string3.indexOf(98) != -1 && nArray2[98 - n7] == 0) {
            nArray2[98 - n7] = 1;
        }
        StringBuilder stringBuilder = new StringBuilder(string3);
        boolean bl3 = false;
        int n8 = 0;
        int n9 = 0;
        int n10 = stringBuilder.length();
        for (n6 = 0; n6 < n10; ++n6) {
            n5 = stringBuilder.charAt(n6);
            if (n5 != n8 && n9 > 0) {
                n4 = n8;
                if (n4 == 76) {
                    n4 = 77;
                }
                n3 = nArray2[n4 - n7];
                int n11 = nArray[n4 - n7];
                if (n3 == n9 && n11 > n3) {
                    n9 = n11 - n3;
                    for (int i2 = 0; i2 < n9; ++i2) {
                        stringBuilder.insert(n6, (char)n8);
                    }
                    n6 += n9;
                    n10 += n9;
                }
                n9 = 0;
            }
            if (n5 == 39) {
                if (n6 + 1 < stringBuilder.length() && stringBuilder.charAt(n6 + 1) == '\'') {
                    ++n6;
                    continue;
                }
                bl3 = !bl3;
                continue;
            }
            if (bl3 || (n5 < 97 || n5 > 122) && (n5 < 65 || n5 > 90)) continue;
            n8 = n5;
            ++n9;
        }
        if (n9 > 0) {
            n6 = n8;
            if (n6 == 76) {
                n6 = 77;
            }
            n5 = nArray2[n6 - n7];
            n4 = nArray[n6 - n7];
            if (n5 == n9 && n4 > n5) {
                n9 = n4 - n5;
                for (n3 = 0; n3 < n9; ++n3) {
                    stringBuilder.append((char)n8);
                }
            }
        }
        return stringBuilder.toString();
    }

    private static String findReplaceInPattern(String string, String string2, String string3) {
        int n2 = string.indexOf("'");
        if (n2 < 0) {
            return string.replace(string2, string3);
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string4 = string;
        while (n2 >= 0) {
            int n3 = string4.indexOf("'", n2 + 1);
            if (n3 < 0) {
                n3 = string4.length() - 1;
            }
            String string5 = string4.substring(0, n2);
            String string6 = string4.substring(n2, n3 + 1);
            stringBuilder.append(string5.replace(string2, string3));
            stringBuilder.append(string6);
            string4 = string4.substring(n3 + 1);
            n2 = string4.indexOf("'");
        }
        stringBuilder.append(string4.replace(string2, string3));
        return stringBuilder.toString();
    }

    private void concatSingleDate2TimeInterval(String string, String string2, int n2, Map<String, DateIntervalInfo.PatternInfo> map) {
        DateIntervalInfo.PatternInfo patternInfo = map.get(DateIntervalInfo.CALENDAR_FIELD_TO_PATTERN_LETTER[n2]);
        if (patternInfo != null) {
            String string3 = patternInfo.getFirstPart() + patternInfo.getSecondPart();
            String string4 = SimpleFormatterImpl.formatRawPattern(string, 2, 2, string3, string2);
            patternInfo = DateIntervalInfo.genPatternInfo(string4, patternInfo.firstDateInPtnIsLaterDate());
            map.put(DateIntervalInfo.CALENDAR_FIELD_TO_PATTERN_LETTER[n2], patternInfo);
        }
    }

    private static boolean fieldExistsInSkeleton(int n2, String string) {
        String string2 = DateIntervalInfo.CALENDAR_FIELD_TO_PATTERN_LETTER[n2];
        boolean bl2 = string.contains(string2);
        if (!bl2) {
            if (string2.equals("M")) {
                bl2 = string.contains("L");
            } else if (string2.equals("y")) {
                bl2 = string.contains("U") || string.contains("Y") || string.contains("u") || string.contains("r");
            }
        }
        return bl2;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initializePattern(this.isDateIntervalInfoDefault ? LOCAL_PATTERN_CACHE : null);
        if (this.fCapitalizationSetting == null) {
            this.fCapitalizationSetting = DisplayContext.CAPITALIZATION_NONE;
        }
    }

    @Deprecated
    public Map<String, DateIntervalInfo.PatternInfo> getRawPatterns() {
        return this.fIntervalPatterns;
    }

    private static final class FormatOutput {
        int firstIndex = -1;

        private FormatOutput() {
        }

        public void register(int n2) {
            if (this.firstIndex == -1) {
                this.firstIndex = n2;
            }
        }
    }

    private static final class SkeletonAndItsBestMatch {
        final String skeleton;
        final String bestMatchSkeleton;

        SkeletonAndItsBestMatch(String string, String string2) {
            this.skeleton = string;
            this.bestMatchSkeleton = string2;
        }
    }

    static final class BestMatchInfo {
        final String bestMatchSkeleton;
        final int bestMatchDistanceInfo;

        BestMatchInfo(String string, int n2) {
            this.bestMatchSkeleton = string;
            this.bestMatchDistanceInfo = n2;
        }
    }

    public static final class SpanField
    extends UFormat.SpanField {
        private static final long serialVersionUID = -6330879259553618133L;
        public static final SpanField DATE_INTERVAL_SPAN = new SpanField("date-interval-span");

        private SpanField(String string) {
            super(string);
        }

        @Override
        @Deprecated
        protected Object readResolve() throws InvalidObjectException {
            if (this.getName().equals(DATE_INTERVAL_SPAN.getName())) {
                return DATE_INTERVAL_SPAN;
            }
            throw new InvalidObjectException("An invalid object.");
        }
    }

    public static final class FormattedDateInterval
    implements FormattedValue {
        private final String string;
        private final List<FieldPosition> attributes;

        FormattedDateInterval(CharSequence charSequence, List<FieldPosition> list) {
            this.string = charSequence.toString();
            this.attributes = Collections.unmodifiableList(list);
        }

        @Override
        public String toString() {
            return this.string;
        }

        @Override
        public int length() {
            return this.string.length();
        }

        @Override
        public char charAt(int n2) {
            return this.string.charAt(n2);
        }

        @Override
        public CharSequence subSequence(int n2, int n3) {
            return this.string.subSequence(n2, n3);
        }

        @Override
        public <A extends Appendable> A appendTo(A a2) {
            return Utility.appendTo(this.string, a2);
        }

        @Override
        public boolean nextPosition(ConstrainedFieldPosition constrainedFieldPosition) {
            return FormattedValueFieldPositionIteratorImpl.nextPosition(this.attributes, constrainedFieldPosition);
        }

        @Override
        public AttributedCharacterIterator toCharacterIterator() {
            return FormattedValueFieldPositionIteratorImpl.toCharacterIterator(this.string, this.attributes);
        }
    }
}

