/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.StringCharacterIterator;
import java.util.Locale;
import java.util.MissingResourceException;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Assert;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUBinary;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICULocaleService;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUResourceBundle;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUService;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.BreakIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.FilteredBreakIteratorBuilder;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.RuleBasedBreakIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;

final class BreakIteratorFactory
extends BreakIterator.BreakIteratorServiceShim {
    static final ICULocaleService service = new BFService();
    private static final String[] KIND_NAMES = new String[]{"grapheme", "word", "line", "sentence", "title"};

    BreakIteratorFactory() {
    }

    @Override
    public Object registerInstance(BreakIterator breakIterator, ULocale uLocale, int n2) {
        breakIterator.setText(new StringCharacterIterator(""));
        return service.registerObject((Object)breakIterator, uLocale, n2);
    }

    @Override
    public boolean unregister(Object object) {
        if (service.isDefault()) {
            return false;
        }
        return service.unregisterFactory((ICUService.Factory)object);
    }

    @Override
    public Locale[] getAvailableLocales() {
        if (service == null) {
            return ICUResourceBundle.getAvailableLocales();
        }
        return service.getAvailableLocales();
    }

    @Override
    public ULocale[] getAvailableULocales() {
        if (service == null) {
            return ICUResourceBundle.getAvailableULocales();
        }
        return service.getAvailableULocales();
    }

    @Override
    public BreakIterator createBreakIterator(ULocale uLocale, int n2) {
        if (service.isDefault()) {
            return BreakIteratorFactory.createBreakInstance(uLocale, n2);
        }
        ULocale[] uLocaleArray = new ULocale[1];
        BreakIterator breakIterator = (BreakIterator)service.get(uLocale, n2, uLocaleArray);
        breakIterator.setLocale(uLocaleArray[0], uLocaleArray[0]);
        return breakIterator;
    }

    private static BreakIterator createBreakInstance(ULocale uLocale, int n2) {
        String string;
        String string2;
        String string3;
        RuleBasedBreakIterator ruleBasedBreakIterator = null;
        ICUResourceBundle iCUResourceBundle = ICUResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b/brkitr", uLocale, ICUResourceBundle.OpenType.LOCALE_ROOT);
        ByteBuffer byteBuffer = null;
        String string4 = "";
        if (n2 == 2) {
            string3 = uLocale.getKeywordValue("lb");
            if (string3 != null && (string3.equals("strict") || string3.equals("normal") || string3.equals("loose"))) {
                string4 = "_" + string3;
            }
            if ((string2 = uLocale.getLanguage()) != null && (string2.equals("ja") || string2.equals("ko")) && (string3 = uLocale.getKeywordValue("lw")) != null && string3.equals("phrase")) {
                string4 = string4 + "_" + string3;
            }
        }
        try {
            string2 = string4.isEmpty() ? KIND_NAMES[n2] : KIND_NAMES[n2] + string4;
            string3 = iCUResourceBundle.getStringWithFallback("boundaries/" + string2);
            string = "brkitr/" + string3;
            byteBuffer = ICUBinary.getData(string);
        }
        catch (Exception exception) {
            throw new MissingResourceException(exception.toString(), "", "");
        }
        try {
            boolean bl2 = string3 != null && string3.contains("phrase");
            ruleBasedBreakIterator = RuleBasedBreakIterator.getInstanceFromCompiledRules(byteBuffer, bl2);
        }
        catch (IOException iOException) {
            Assert.fail(iOException);
        }
        ULocale uLocale2 = ULocale.forLocale(iCUResourceBundle.getLocale());
        ruleBasedBreakIterator.setLocale(uLocale2, uLocale2);
        if (n2 == 3 && (string = uLocale.getKeywordValue("ss")) != null && string.equals("standard")) {
            ULocale uLocale3 = new ULocale(uLocale.getBaseName());
            return FilteredBreakIteratorBuilder.getInstance(uLocale3).wrapIteratorWithFilter(ruleBasedBreakIterator);
        }
        return ruleBasedBreakIterator;
    }

    private static class BFService
    extends ICULocaleService {
        BFService() {
            super("BreakIterator");
            class RBBreakIteratorFactory
            extends ICULocaleService.ICUResourceBundleFactory {
                RBBreakIteratorFactory() {
                }

                @Override
                protected Object handleCreate(ULocale uLocale, int n2, ICUService iCUService) {
                    return BreakIteratorFactory.createBreakInstance(uLocale, n2);
                }
            }
            this.registerFactory(new RBBreakIteratorFactory());
            this.markDefault();
        }

        @Override
        public String validateFallbackLocale() {
            return "";
        }
    }
}

