/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UCharacter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Collator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Normalizer2;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.RuleBasedCollator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.LocaleData;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;

public final class AlphabeticIndex<V>
implements Iterable<Bucket<V>> {
    private static final String BASE = "\ufdd0";
    private static final char CGJ = '\u034f';
    private static final Comparator<String> binaryCmp = new UTF16.StringComparator(true, false, 0);
    private final RuleBasedCollator collatorOriginal;
    private final RuleBasedCollator collatorPrimaryOnly;
    private RuleBasedCollator collatorExternal;
    private final Comparator<Record<V>> recordComparator = new Comparator<Record<V>>(){

        @Override
        public int compare(Record<V> record, Record<V> record2) {
            return AlphabeticIndex.this.collatorOriginal.compare(record.name, record2.name);
        }
    };
    private final List<String> firstCharsInScripts;
    private final UnicodeSet initialLabels = new UnicodeSet();
    private List<Record<V>> inputList;
    private BucketList<V> buckets;
    private String overflowLabel = "\u2026";
    private String underflowLabel = "\u2026";
    private String inflowLabel = "\u2026";
    private int maxLabelCount = 99;
    private static final int GC_LU_MASK = 2;
    private static final int GC_LL_MASK = 4;
    private static final int GC_LT_MASK = 8;
    private static final int GC_LM_MASK = 16;
    private static final int GC_LO_MASK = 32;
    private static final int GC_L_MASK = 62;
    private static final int GC_CN_MASK = 1;

    public AlphabeticIndex(ULocale uLocale) {
        this(uLocale, null);
    }

    public AlphabeticIndex(Locale locale) {
        this(ULocale.forLocale(locale), null);
    }

    public AlphabeticIndex(RuleBasedCollator ruleBasedCollator) {
        this(null, ruleBasedCollator);
    }

    private AlphabeticIndex(ULocale uLocale, RuleBasedCollator ruleBasedCollator) {
        this.collatorOriginal = ruleBasedCollator != null ? ruleBasedCollator : (RuleBasedCollator)Collator.getInstance(uLocale);
        try {
            this.collatorPrimaryOnly = this.collatorOriginal.cloneAsThawed();
        }
        catch (Exception exception) {
            throw new IllegalStateException("Collator cannot be cloned", exception);
        }
        this.collatorPrimaryOnly.setStrength(0);
        this.collatorPrimaryOnly.freeze();
        this.firstCharsInScripts = this.getFirstCharactersInScripts();
        Collections.sort(this.firstCharsInScripts, this.collatorPrimaryOnly);
        while (true) {
            if (this.firstCharsInScripts.isEmpty()) {
                throw new IllegalArgumentException("AlphabeticIndex requires some non-ignorable script boundary strings");
            }
            if (this.collatorPrimaryOnly.compare(this.firstCharsInScripts.get(0), "") != 0) break;
            this.firstCharsInScripts.remove(0);
        }
        if (!this.addChineseIndexCharacters() && uLocale != null) {
            this.addIndexExemplars(uLocale);
        }
    }

    public AlphabeticIndex<V> addLabels(UnicodeSet unicodeSet) {
        this.initialLabels.addAll(unicodeSet);
        this.buckets = null;
        return this;
    }

    public AlphabeticIndex<V> addLabels(ULocale ... uLocaleArray) {
        for (ULocale uLocale : uLocaleArray) {
            this.addIndexExemplars(uLocale);
        }
        this.buckets = null;
        return this;
    }

    public AlphabeticIndex<V> addLabels(Locale ... localeArray) {
        for (Locale locale : localeArray) {
            this.addIndexExemplars(ULocale.forLocale(locale));
        }
        this.buckets = null;
        return this;
    }

    public AlphabeticIndex<V> setOverflowLabel(String string) {
        this.overflowLabel = string;
        this.buckets = null;
        return this;
    }

    public String getUnderflowLabel() {
        return this.underflowLabel;
    }

    public AlphabeticIndex<V> setUnderflowLabel(String string) {
        this.underflowLabel = string;
        this.buckets = null;
        return this;
    }

    public String getOverflowLabel() {
        return this.overflowLabel;
    }

    public AlphabeticIndex<V> setInflowLabel(String string) {
        this.inflowLabel = string;
        this.buckets = null;
        return this;
    }

    public String getInflowLabel() {
        return this.inflowLabel;
    }

    public int getMaxLabelCount() {
        return this.maxLabelCount;
    }

    public AlphabeticIndex<V> setMaxLabelCount(int n2) {
        this.maxLabelCount = n2;
        this.buckets = null;
        return this;
    }

    private List<String> initLabels() {
        int n2;
        Normalizer2 normalizer2 = Normalizer2.getNFKDInstance();
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.firstCharsInScripts.get(0);
        String string2 = this.firstCharsInScripts.get(this.firstCharsInScripts.size() - 1);
        for (String string3 : this.initialLabels) {
            if (!UTF16.hasMoreCodePointsThan(string3, 1)) {
                n2 = 0;
            } else if (string3.charAt(string3.length() - 1) == '*' && string3.charAt(string3.length() - 2) != '*') {
                string3 = string3.substring(0, string3.length() - 1);
                n2 = 0;
            } else {
                n2 = 1;
            }
            if (this.collatorPrimaryOnly.compare(string3, string) < 0 || this.collatorPrimaryOnly.compare(string3, string2) >= 0 || n2 != 0 && this.collatorPrimaryOnly.compare(string3, this.separated(string3)) == 0) continue;
            int n3 = Collections.binarySearch(arrayList, string3, this.collatorPrimaryOnly);
            if (n3 < 0) {
                arrayList.add(~n3, string3);
                continue;
            }
            String string4 = (String)arrayList.get(n3);
            if (!AlphabeticIndex.isOneLabelBetterThanOther(normalizer2, string3, string4)) continue;
            arrayList.set(n3, string3);
        }
        int n4 = arrayList.size() - 1;
        if (n4 > this.maxLabelCount) {
            int n5 = 0;
            n2 = -1;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                int n6 = ++n5 * this.maxLabelCount / n4;
                if (n6 == n2) {
                    iterator.remove();
                    continue;
                }
                n2 = n6;
            }
        }
        return arrayList;
    }

    private static String fixLabel(String string) {
        if (!string.startsWith(BASE)) {
            return string;
        }
        char c2 = string.charAt(BASE.length());
        if ('\u2800' < c2 && c2 <= '\u28ff') {
            return c2 - 10240 + "\u5283";
        }
        return string.substring(BASE.length());
    }

    private void addIndexExemplars(ULocale uLocale) {
        UnicodeSet unicodeSet = LocaleData.getExemplarSet(uLocale, 0, 2);
        if (unicodeSet != null && !unicodeSet.isEmpty()) {
            this.initialLabels.addAll(unicodeSet);
            return;
        }
        unicodeSet = LocaleData.getExemplarSet(uLocale, 0, 0);
        if ((unicodeSet = unicodeSet.cloneAsThawed()).containsSome(97, 122) || unicodeSet.isEmpty()) {
            unicodeSet.addAll(97, 122);
        }
        if (unicodeSet.containsSome(44032, 55203)) {
            unicodeSet.remove(44032, 55203).add(44032).add(45208).add(45796).add(46972).add(47560).add(48148).add(49324).add(50500).add(51088).add(52264).add(52852).add(53440).add(54028).add(54616);
        }
        if (unicodeSet.containsSome(4608, 4991)) {
            UnicodeSet unicodeSet2 = new UnicodeSet("[\u1200\u1208\u1210\u1218\u1220\u1228\u1230\u1238\u1240\u1248\u1250\u1258\u1260\u1268\u1270\u1278\u1280\u1288\u1290\u1298\u12a0\u12a8\u12b0\u12b8\u12c0\u12c8\u12d0\u12d8\u12e0\u12e8\u12f0\u12f8\u1300\u1308\u1310\u1318\u1320\u1328\u1330\u1338\u1340\u1348\u1350\u1358]");
            unicodeSet2.retainAll(unicodeSet);
            unicodeSet.remove(4608, 4991).addAll(unicodeSet2);
        }
        for (String string : unicodeSet) {
            this.initialLabels.add(UCharacter.toUpperCase(uLocale, string));
        }
    }

    private boolean addChineseIndexCharacters() {
        UnicodeSet unicodeSet = new UnicodeSet();
        try {
            this.collatorPrimaryOnly.internalAddContractions(BASE.charAt(0), unicodeSet);
        }
        catch (Exception exception) {
            return false;
        }
        if (unicodeSet.isEmpty()) {
            return false;
        }
        this.initialLabels.addAll(unicodeSet);
        for (String string : unicodeSet) {
            assert (string.startsWith(BASE));
            char c2 = string.charAt(string.length() - 1);
            if ('A' > c2 || c2 > 'Z') continue;
            this.initialLabels.add(65, 90);
            break;
        }
        return true;
    }

    private String separated(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        char c2 = string.charAt(0);
        stringBuilder.append(c2);
        for (int i2 = 1; i2 < string.length(); ++i2) {
            char c3 = string.charAt(i2);
            if (!UCharacter.isHighSurrogate(c2) || !UCharacter.isLowSurrogate(c3)) {
                stringBuilder.append('\u034f');
            }
            stringBuilder.append(c3);
            c2 = c3;
        }
        return stringBuilder.toString();
    }

    public ImmutableIndex<V> buildImmutableIndex() {
        BucketList<V> bucketList;
        if (this.inputList != null && !this.inputList.isEmpty()) {
            bucketList = this.createBucketList();
        } else {
            if (this.buckets == null) {
                this.buckets = this.createBucketList();
            }
            bucketList = this.buckets;
        }
        return new ImmutableIndex(bucketList, this.collatorPrimaryOnly);
    }

    public List<String> getBucketLabels() {
        this.initBuckets();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Bucket<V> bucket : this.buckets) {
            arrayList.add(bucket.getLabel());
        }
        return arrayList;
    }

    public RuleBasedCollator getCollator() {
        if (this.collatorExternal == null) {
            try {
                this.collatorExternal = (RuleBasedCollator)this.collatorOriginal.clone();
            }
            catch (Exception exception) {
                throw new IllegalStateException("Collator cannot be cloned", exception);
            }
        }
        return this.collatorExternal;
    }

    public AlphabeticIndex<V> addRecord(CharSequence charSequence, V v2) {
        this.buckets = null;
        if (this.inputList == null) {
            this.inputList = new ArrayList<Record<V>>();
        }
        this.inputList.add(new Record(charSequence, v2));
        return this;
    }

    public int getBucketIndex(CharSequence charSequence) {
        this.initBuckets();
        return ((BucketList)this.buckets).getBucketIndex(charSequence, this.collatorPrimaryOnly);
    }

    public AlphabeticIndex<V> clearRecords() {
        if (this.inputList != null && !this.inputList.isEmpty()) {
            this.inputList.clear();
            this.buckets = null;
        }
        return this;
    }

    public int getBucketCount() {
        this.initBuckets();
        return ((BucketList)this.buckets).getBucketCount();
    }

    public int getRecordCount() {
        return this.inputList != null ? this.inputList.size() : 0;
    }

    @Override
    public Iterator<Bucket<V>> iterator() {
        this.initBuckets();
        return this.buckets.iterator();
    }

    private void initBuckets() {
        String string;
        Bucket bucket;
        if (this.buckets != null) {
            return;
        }
        this.buckets = this.createBucketList();
        if (this.inputList == null || this.inputList.isEmpty()) {
            return;
        }
        Collections.sort(this.inputList, this.recordComparator);
        Iterator iterator = ((BucketList)this.buckets).fullIterator();
        Bucket bucket2 = (Bucket)iterator.next();
        if (iterator.hasNext()) {
            bucket = (Bucket)iterator.next();
            string = bucket.lowerBoundary;
        } else {
            bucket = null;
            string = null;
        }
        for (Record<V> record : this.inputList) {
            while (string != null && this.collatorPrimaryOnly.compare(((Record)record).name, (Object)string) >= 0) {
                bucket2 = bucket;
                if (iterator.hasNext()) {
                    bucket = (Bucket)iterator.next();
                    string = bucket.lowerBoundary;
                    continue;
                }
                string = null;
            }
            Bucket bucket3 = bucket2;
            if (bucket3.displayBucket != null) {
                bucket3 = bucket3.displayBucket;
            }
            if (bucket3.records == null) {
                bucket3.records = new ArrayList();
            }
            bucket3.records.add(record);
        }
    }

    private static boolean isOneLabelBetterThanOther(Normalizer2 normalizer2, String string, String string2) {
        String string3 = normalizer2.normalize(string);
        String string4 = normalizer2.normalize(string2);
        int n2 = string3.codePointCount(0, string3.length()) - string4.codePointCount(0, string4.length());
        if (n2 != 0) {
            return n2 < 0;
        }
        n2 = binaryCmp.compare(string3, string4);
        if (n2 != 0) {
            return n2 < 0;
        }
        return binaryCmp.compare(string, string2) < 0;
    }

    private BucketList<V> createBucketList() {
        Iterable<Bucket> iterable;
        List<String> list = this.initLabels();
        long l2 = this.collatorPrimaryOnly.isAlternateHandlingShifted() ? (long)this.collatorPrimaryOnly.getVariableTop() & 0xFFFFFFFFL : 0L;
        boolean bl2 = false;
        Bucket[] bucketArray = new Bucket[26];
        Bucket[] bucketArray2 = new Bucket[26];
        boolean bl3 = false;
        ArrayList<Iterable<Record<Object>>> arrayList = new ArrayList<Iterable<Record<Object>>>();
        arrayList.add(new Bucket(this.getUnderflowLabel(), "", Bucket.LabelType.UNDERFLOW));
        int n2 = -1;
        String string = "";
        block0: for (String string2 : list) {
            Bucket bucket;
            char c2;
            if (this.collatorPrimaryOnly.compare(string2, string) >= 0) {
                iterable = string;
                c2 = '\u0000';
                while (this.collatorPrimaryOnly.compare(string2, string = this.firstCharsInScripts.get(++n2)) >= 0) {
                    c2 = '\u0001';
                }
                if (c2 != '\u0000' && arrayList.size() > 1) {
                    arrayList.add(new Bucket(this.getInflowLabel(), (String)((Object)iterable), Bucket.LabelType.INFLOW));
                }
            }
            iterable = new Bucket(AlphabeticIndex.fixLabel(string2), string2, Bucket.LabelType.NORMAL);
            arrayList.add(iterable);
            if (string2.length() == 1 && 'A' <= (c2 = string2.charAt(0)) && c2 <= 'Z') {
                bucketArray[c2 - 65] = iterable;
            } else if (string2.length() == BASE.length() + 1 && string2.startsWith(BASE) && 'A' <= (c2 = string2.charAt(BASE.length())) && c2 <= 'Z') {
                bucketArray2[c2 - 65] = iterable;
                bl3 = true;
            }
            if (string2.startsWith(BASE) || !AlphabeticIndex.hasMultiplePrimaryWeights(this.collatorPrimaryOnly, l2, string2) || string2.endsWith("\uffff")) continue;
            int n3 = arrayList.size() - 2;
            while ((bucket = (Bucket)arrayList.get(n3)).labelType == Bucket.LabelType.NORMAL) {
                if (bucket.displayBucket == null && !AlphabeticIndex.hasMultiplePrimaryWeights(this.collatorPrimaryOnly, l2, bucket.lowerBoundary)) {
                    iterable = new Bucket("", string2 + "\uffff", Bucket.LabelType.NORMAL);
                    ((Bucket)iterable).displayBucket = bucket;
                    arrayList.add(iterable);
                    bl2 = true;
                    continue block0;
                }
                --n3;
            }
        }
        if (arrayList.size() == 1) {
            return new BucketList(arrayList, arrayList);
        }
        arrayList.add(new Bucket(this.getOverflowLabel(), string, Bucket.LabelType.OVERFLOW));
        if (bl3) {
            Object object = null;
            for (int i2 = 0; i2 < 26; ++i2) {
                if (bucketArray[i2] != null) {
                    object = bucketArray[i2];
                }
                if (bucketArray2[i2] == null || object == null) continue;
                bucketArray2[i2].displayBucket = (Bucket)object;
                bl2 = true;
            }
        }
        if (!bl2) {
            return new BucketList(arrayList, arrayList);
        }
        int n4 = arrayList.size() - 1;
        Iterable<Record<Object>> iterable2 = (Bucket)arrayList.get(n4);
        while (--n4 > 0) {
            iterable = (Bucket)arrayList.get(n4);
            if (((Bucket)iterable).displayBucket != null) continue;
            if (((Bucket)iterable).labelType == Bucket.LabelType.INFLOW && ((Bucket)iterable2).labelType != Bucket.LabelType.NORMAL) {
                ((Bucket)iterable).displayBucket = (Bucket)iterable2;
                continue;
            }
            iterable2 = iterable;
        }
        iterable = new ArrayList();
        for (Bucket bucket : arrayList) {
            if (bucket.displayBucket != null) continue;
            ((ArrayList)iterable).add(bucket);
        }
        return new BucketList(arrayList, (ArrayList)iterable);
    }

    private static boolean hasMultiplePrimaryWeights(RuleBasedCollator ruleBasedCollator, long l2, String string) {
        long[] lArray = ruleBasedCollator.internalGetCEs(string);
        boolean bl2 = false;
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            long l3 = lArray[i2];
            long l4 = l3 >>> 32;
            if (l4 <= l2) continue;
            if (bl2) {
                return true;
            }
            bl2 = true;
        }
        return false;
    }

    @Deprecated
    public List<String> getFirstCharactersInScripts() {
        ArrayList<String> arrayList = new ArrayList<String>(200);
        UnicodeSet unicodeSet = new UnicodeSet();
        this.collatorPrimaryOnly.internalAddContractions(64977, unicodeSet);
        if (unicodeSet.isEmpty()) {
            throw new UnsupportedOperationException("AlphabeticIndex requires script-first-primary contractions");
        }
        for (String string : unicodeSet) {
            int n2 = 1 << UCharacter.getType(string.codePointAt(1));
            if ((n2 & 0x3F) == 0) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private static class BucketList<V>
    implements Iterable<Bucket<V>> {
        private final ArrayList<Bucket<V>> bucketList;
        private final List<Bucket<V>> immutableVisibleList;

        private BucketList(ArrayList<Bucket<V>> arrayList, ArrayList<Bucket<V>> arrayList2) {
            this.bucketList = arrayList;
            int n2 = 0;
            for (Bucket<V> bucket : arrayList2) {
                ((Bucket)bucket).displayIndex = n2++;
            }
            this.immutableVisibleList = Collections.unmodifiableList(arrayList2);
        }

        private int getBucketCount() {
            return this.immutableVisibleList.size();
        }

        private int getBucketIndex(CharSequence charSequence, Collator collator) {
            int n2 = 0;
            int n3 = this.bucketList.size();
            while (n2 + 1 < n3) {
                int n4 = (n2 + n3) / 2;
                Bucket<V> bucket = this.bucketList.get(n4);
                int n5 = collator.compare(charSequence, (Object)((Bucket)bucket).lowerBoundary);
                if (n5 < 0) {
                    n3 = n4;
                    continue;
                }
                n2 = n4;
            }
            Bucket bucket = this.bucketList.get(n2);
            if (bucket.displayBucket != null) {
                bucket = bucket.displayBucket;
            }
            return bucket.displayIndex;
        }

        private Iterator<Bucket<V>> fullIterator() {
            return this.bucketList.iterator();
        }

        @Override
        public Iterator<Bucket<V>> iterator() {
            return this.immutableVisibleList.iterator();
        }
    }

    public static class Bucket<V>
    implements Iterable<Record<V>> {
        private final String label;
        private final String lowerBoundary;
        private final LabelType labelType;
        private Bucket<V> displayBucket;
        private int displayIndex;
        private List<Record<V>> records;

        private Bucket(String string, String string2, LabelType labelType) {
            this.label = string;
            this.lowerBoundary = string2;
            this.labelType = labelType;
        }

        public String getLabel() {
            return this.label;
        }

        public LabelType getLabelType() {
            return this.labelType;
        }

        public int size() {
            return this.records == null ? 0 : this.records.size();
        }

        @Override
        public Iterator<Record<V>> iterator() {
            if (this.records == null) {
                return Collections.emptyList().iterator();
            }
            return this.records.iterator();
        }

        public String toString() {
            return "{labelType=" + (Object)((Object)this.labelType) + ", lowerBoundary=" + this.lowerBoundary + ", label=" + this.label + "}";
        }

        public static enum LabelType {
            NORMAL,
            UNDERFLOW,
            INFLOW,
            OVERFLOW;

        }
    }

    public static class Record<V> {
        private final CharSequence name;
        private final V data;

        private Record(CharSequence charSequence, V v2) {
            this.name = charSequence;
            this.data = v2;
        }

        public CharSequence getName() {
            return this.name;
        }

        public V getData() {
            return this.data;
        }

        public String toString() {
            return this.name + "=" + this.data;
        }
    }

    public static final class ImmutableIndex<V>
    implements Iterable<Bucket<V>> {
        private final BucketList<V> buckets;
        private final Collator collatorPrimaryOnly;

        private ImmutableIndex(BucketList<V> bucketList, Collator collator) {
            this.buckets = bucketList;
            this.collatorPrimaryOnly = collator;
        }

        public int getBucketCount() {
            return ((BucketList)this.buckets).getBucketCount();
        }

        public int getBucketIndex(CharSequence charSequence) {
            return ((BucketList)this.buckets).getBucketIndex(charSequence, this.collatorPrimaryOnly);
        }

        public Bucket<V> getBucket(int n2) {
            if (0 <= n2 && n2 < ((BucketList)this.buckets).getBucketCount()) {
                return (Bucket)((BucketList)this.buckets).immutableVisibleList.get(n2);
            }
            return null;
        }

        @Override
        public Iterator<Bucket<V>> iterator() {
            return this.buckets.iterator();
        }
    }
}

