/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.number;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.DecimalQuantity;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.RoundingUtils;

public class Scale {
    private static final Scale DEFAULT = new Scale(0, null);
    private static final Scale HUNDRED = new Scale(2, null);
    private static final Scale THOUSAND = new Scale(3, null);
    private static final BigDecimal BIG_DECIMAL_100 = BigDecimal.valueOf(100L);
    private static final BigDecimal BIG_DECIMAL_1000 = BigDecimal.valueOf(1000L);
    final int magnitude;
    final BigDecimal arbitrary;
    final BigDecimal reciprocal;
    final MathContext mc;

    private Scale(int n2, BigDecimal bigDecimal) {
        this(n2, bigDecimal, RoundingUtils.DEFAULT_MATH_CONTEXT_34_DIGITS);
    }

    private Scale(int n2, BigDecimal bigDecimal, MathContext mathContext) {
        if (bigDecimal != null) {
            BigDecimal bigDecimal2 = bigDecimal = bigDecimal.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : bigDecimal.stripTrailingZeros();
            if (bigDecimal.precision() == 1 && bigDecimal.unscaledValue().equals(BigInteger.ONE)) {
                n2 -= bigDecimal.scale();
                bigDecimal = null;
            }
        }
        this.magnitude = n2;
        this.arbitrary = bigDecimal;
        this.mc = mathContext;
        this.reciprocal = bigDecimal != null && BigDecimal.ZERO.compareTo(bigDecimal) != 0 ? BigDecimal.ONE.divide(bigDecimal, mathContext) : null;
    }

    public static Scale none() {
        return DEFAULT;
    }

    public static Scale powerOfTen(int n2) {
        if (n2 == 0) {
            return DEFAULT;
        }
        if (n2 == 2) {
            return HUNDRED;
        }
        if (n2 == 3) {
            return THOUSAND;
        }
        return new Scale(n2, null);
    }

    public static Scale byBigDecimal(BigDecimal bigDecimal) {
        if (bigDecimal.compareTo(BigDecimal.ONE) == 0) {
            return DEFAULT;
        }
        if (bigDecimal.compareTo(BIG_DECIMAL_100) == 0) {
            return HUNDRED;
        }
        if (bigDecimal.compareTo(BIG_DECIMAL_1000) == 0) {
            return THOUSAND;
        }
        return new Scale(0, bigDecimal);
    }

    public static Scale byDouble(double d2) {
        if (d2 == 1.0) {
            return DEFAULT;
        }
        if (d2 == 100.0) {
            return HUNDRED;
        }
        if (d2 == 1000.0) {
            return THOUSAND;
        }
        return new Scale(0, BigDecimal.valueOf(d2));
    }

    public static Scale byDoubleAndPowerOfTen(double d2, int n2) {
        return new Scale(n2, BigDecimal.valueOf(d2));
    }

    boolean isValid() {
        return this.magnitude != 0 || this.arbitrary != null;
    }

    @Deprecated
    public Scale withMathContext(MathContext mathContext) {
        if (this.mc.equals(mathContext)) {
            return this;
        }
        return new Scale(this.magnitude, this.arbitrary, mathContext);
    }

    @Deprecated
    public void applyTo(DecimalQuantity decimalQuantity) {
        decimalQuantity.adjustMagnitude(this.magnitude);
        if (this.arbitrary != null) {
            decimalQuantity.multiplyBy(this.arbitrary);
        }
    }

    @Deprecated
    public void applyReciprocalTo(DecimalQuantity decimalQuantity) {
        decimalQuantity.adjustMagnitude(-this.magnitude);
        if (this.reciprocal != null) {
            decimalQuantity.multiplyBy(this.reciprocal);
            decimalQuantity.roundToMagnitude(decimalQuantity.getMagnitude() - this.mc.getPrecision(), this.mc);
        }
    }
}

