/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.number;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.CompactData;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.DecimalQuantity;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.MicroProps;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.MicroPropsGenerator;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.MutablePatternModifier;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.PatternStringParser;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.Notation;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.CompactDecimalFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.NumberFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.PluralRules;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;

public class CompactNotation
extends Notation {
    final CompactDecimalFormat.CompactStyle compactStyle;
    final Map<String, Map<String, String>> compactCustomData;

    @Deprecated
    public static CompactNotation forCustomData(Map<String, Map<String, String>> map) {
        return new CompactNotation(map);
    }

    CompactNotation(CompactDecimalFormat.CompactStyle compactStyle) {
        this.compactCustomData = null;
        this.compactStyle = compactStyle;
    }

    CompactNotation(Map<String, Map<String, String>> map) {
        this.compactStyle = null;
        this.compactCustomData = map;
    }

    MicroPropsGenerator withLocaleData(ULocale uLocale, String string, CompactData.CompactType compactType, PluralRules pluralRules, MutablePatternModifier mutablePatternModifier, boolean bl2, MicroPropsGenerator microPropsGenerator) {
        return new CompactHandler(this, uLocale, string, compactType, pluralRules, mutablePatternModifier, bl2, microPropsGenerator);
    }

    private static class CompactHandler
    implements MicroPropsGenerator {
        final PluralRules rules;
        final MicroPropsGenerator parent;
        final Map<String, MutablePatternModifier.ImmutablePatternModifier> precomputedMods;
        final MutablePatternModifier unsafePatternModifier;
        final CompactData data;

        private CompactHandler(CompactNotation compactNotation, ULocale uLocale, String string, CompactData.CompactType compactType, PluralRules pluralRules, MutablePatternModifier mutablePatternModifier, boolean bl2, MicroPropsGenerator microPropsGenerator) {
            this.rules = pluralRules;
            this.parent = microPropsGenerator;
            this.data = new CompactData();
            if (compactNotation.compactStyle != null) {
                this.data.populate(uLocale, string, compactNotation.compactStyle, compactType);
            } else {
                this.data.populate(compactNotation.compactCustomData);
            }
            if (bl2) {
                this.precomputedMods = new HashMap<String, MutablePatternModifier.ImmutablePatternModifier>();
                this.precomputeAllModifiers(mutablePatternModifier);
                this.unsafePatternModifier = null;
            } else {
                this.precomputedMods = null;
                this.unsafePatternModifier = mutablePatternModifier;
            }
        }

        private void precomputeAllModifiers(MutablePatternModifier mutablePatternModifier) {
            HashSet<String> hashSet = new HashSet<String>();
            this.data.getUniquePatterns(hashSet);
            for (String string : hashSet) {
                PatternStringParser.ParsedPatternInfo parsedPatternInfo = PatternStringParser.parseToPatternInfo(string);
                mutablePatternModifier.setPatternInfo(parsedPatternInfo, NumberFormat.Field.COMPACT);
                this.precomputedMods.put(string, mutablePatternModifier.createImmutable());
            }
        }

        @Override
        public MicroProps processQuantity(DecimalQuantity decimalQuantity) {
            int n2;
            MicroProps microProps = this.parent.processQuantity(decimalQuantity);
            assert (microProps.rounder != null);
            int n3 = 0;
            if (decimalQuantity.isZeroish()) {
                n2 = 0;
                microProps.rounder.apply(decimalQuantity);
            } else {
                n3 = microProps.rounder.chooseMultiplierAndApply(decimalQuantity, this.data);
                n2 = decimalQuantity.isZeroish() ? 0 : decimalQuantity.getMagnitude();
                n2 -= n3;
            }
            String string = this.data.getPattern(n2, this.rules, decimalQuantity);
            if (string != null) {
                if (this.precomputedMods != null) {
                    MutablePatternModifier.ImmutablePatternModifier immutablePatternModifier = this.precomputedMods.get(string);
                    immutablePatternModifier.applyToMicros(microProps, decimalQuantity);
                } else {
                    PatternStringParser.ParsedPatternInfo parsedPatternInfo = PatternStringParser.parseToPatternInfo(string);
                    this.unsafePatternModifier.setPatternInfo(parsedPatternInfo, NumberFormat.Field.COMPACT);
                    this.unsafePatternModifier.setNumberProperties(decimalQuantity.signum(), null);
                    microProps.modMiddle = this.unsafePatternModifier;
                }
            }
            decimalQuantity.adjustExponent(-1 * n3);
            microProps.rounder = null;
            return microProps;
        }
    }
}

