/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.message2;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import macromedia.jdbc.db2.externals.com.ibm.icu.math.BigDecimal;
import macromedia.jdbc.db2.externals.com.ibm.icu.message2.FormattedPlaceholder;
import macromedia.jdbc.db2.externals.com.ibm.icu.message2.Formatter;
import macromedia.jdbc.db2.externals.com.ibm.icu.message2.FormatterFactory;
import macromedia.jdbc.db2.externals.com.ibm.icu.message2.OptUtils;
import macromedia.jdbc.db2.externals.com.ibm.icu.message2.PlainStringFormattedValue;
import macromedia.jdbc.db2.externals.com.ibm.icu.message2.Selector;
import macromedia.jdbc.db2.externals.com.ibm.icu.message2.SelectorFactory;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.FormattedNumber;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.LocalizedNumberFormatter;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.Notation;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.NumberFormatter;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.Precision;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.Scale;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.UnlocalizedNumberFormatter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.FormattedValue;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.NumberingSystem;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.PluralRules;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.CurrencyAmount;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.MeasureUnit;

class NumberFormatterFactory
implements FormatterFactory,
SelectorFactory {
    private final String kind;

    public NumberFormatterFactory(String string) {
        switch (string) {
            case "number": 
            case "integer": {
                break;
            }
            default: {
                string = "number";
            }
        }
        this.kind = string;
    }

    @Override
    public Formatter createFormatter(Locale locale, Map<String, Object> map) {
        return new NumberFormatterImpl(locale, map, this.kind);
    }

    @Override
    public Selector createSelector(Locale locale, Map<String, Object> map) {
        PluralRules.PluralType pluralType;
        String string = OptUtils.getString(map, "select", "");
        switch (string) {
            case "ordinal": {
                pluralType = PluralRules.PluralType.ORDINAL;
                break;
            }
            default: {
                pluralType = PluralRules.PluralType.CARDINAL;
            }
        }
        Object object = PluralRules.forLocale(locale, pluralType);
        return new PluralSelectorImpl(locale, (PluralRules)object, map, this.kind);
    }

    private static LocalizedNumberFormatter formatterForOptions(Locale locale, Map<String, Object> map, String string) {
        Object object;
        Integer n2;
        String string2;
        Object object2;
        String string3 = OptUtils.getString(map, "icu:skeleton");
        if (string3 != null) {
            return NumberFormatter.forSkeleton(string3).locale(locale);
        }
        UnlocalizedNumberFormatter unlocalizedNumberFormatter = NumberFormatter.with();
        if ("number".equals(string)) {
            block6 : switch (OptUtils.getString(map, "notation", "standard")) {
                case "scientific": {
                    object2 = Notation.scientific();
                    break;
                }
                case "engineering": {
                    object2 = Notation.engineering();
                    break;
                }
                case "compact": {
                    switch (OptUtils.getString(map, "compactDisplay", "short")) {
                        case "long": {
                            object2 = Notation.compactLong();
                            break block6;
                        }
                    }
                    object2 = Notation.compactShort();
                    break;
                }
                default: {
                    object2 = Notation.simple();
                }
            }
            unlocalizedNumberFormatter = (UnlocalizedNumberFormatter)unlocalizedNumberFormatter.notation((Notation)object2);
            string2 = OptUtils.getString(map, "style", "decimal");
            if (string2.equals("percent")) {
                unlocalizedNumberFormatter = (UnlocalizedNumberFormatter)((UnlocalizedNumberFormatter)unlocalizedNumberFormatter.unit(MeasureUnit.PERCENT)).scale(Scale.powerOfTen(2));
            }
            if ((n2 = OptUtils.getInteger(map, "minimumFractionDigits")) != null) {
                unlocalizedNumberFormatter = (UnlocalizedNumberFormatter)unlocalizedNumberFormatter.precision(Precision.minFraction(n2));
            }
            if ((n2 = OptUtils.getInteger(map, "maximumFractionDigits")) != null) {
                unlocalizedNumberFormatter = (UnlocalizedNumberFormatter)unlocalizedNumberFormatter.precision(Precision.maxFraction(n2));
            }
            if ((n2 = OptUtils.getInteger(map, "minimumSignificantDigits")) != null) {
                unlocalizedNumberFormatter = (UnlocalizedNumberFormatter)unlocalizedNumberFormatter.precision(Precision.minSignificantDigits(n2));
            }
        }
        if (!(string2 = OptUtils.getString(map, "numberingSystem", "")).isEmpty()) {
            string2 = string2.toLowerCase(Locale.US);
            object2 = NumberingSystem.getInstanceByName(string2);
            unlocalizedNumberFormatter = (UnlocalizedNumberFormatter)unlocalizedNumberFormatter.symbols((NumberingSystem)object2);
        }
        if ((n2 = OptUtils.getInteger(map, "minimumIntegerDigits")) != null) {
            // empty if block
        }
        if ((n2 = OptUtils.getInteger(map, "maximumSignificantDigits")) != null) {
            unlocalizedNumberFormatter = (UnlocalizedNumberFormatter)unlocalizedNumberFormatter.precision(Precision.maxSignificantDigits(n2));
        }
        switch (string2 = OptUtils.getString(map, "signDisplay", "auto")) {
            case "always": {
                object2 = NumberFormatter.SignDisplay.ALWAYS;
                break;
            }
            case "exceptZero": {
                object2 = NumberFormatter.SignDisplay.EXCEPT_ZERO;
                break;
            }
            case "negative": {
                object2 = NumberFormatter.SignDisplay.NEGATIVE;
                break;
            }
            case "never": {
                object2 = NumberFormatter.SignDisplay.NEVER;
                break;
            }
            default: {
                object2 = NumberFormatter.SignDisplay.AUTO;
            }
        }
        unlocalizedNumberFormatter = (UnlocalizedNumberFormatter)unlocalizedNumberFormatter.sign((NumberFormatter.SignDisplay)((Object)object2));
        switch (string2 = OptUtils.getString(map, "useGrouping", "auto")) {
            case "always": {
                object = NumberFormatter.GroupingStrategy.ON_ALIGNED;
                break;
            }
            case "never": {
                object = NumberFormatter.GroupingStrategy.OFF;
                break;
            }
            case "min2": {
                object = NumberFormatter.GroupingStrategy.MIN2;
                break;
            }
            default: {
                object = NumberFormatter.GroupingStrategy.AUTO;
            }
        }
        unlocalizedNumberFormatter = (UnlocalizedNumberFormatter)unlocalizedNumberFormatter.grouping((NumberFormatter.GroupingStrategy)((Object)object));
        if (string.equals("integer")) {
            unlocalizedNumberFormatter = (UnlocalizedNumberFormatter)unlocalizedNumberFormatter.precision(Precision.integer());
        }
        return unlocalizedNumberFormatter.locale(locale);
    }

    private static class PluralSelectorImpl
    implements Selector {
        private static final String NO_MATCH = "\ufffdNO_MATCH\ufffe";
        private final PluralRules rules;
        private Map<String, Object> fixedOptions;
        private LocalizedNumberFormatter icuFormatter;

        private PluralSelectorImpl(Locale locale, PluralRules pluralRules, Map<String, Object> map, String string) {
            this.rules = pluralRules;
            this.fixedOptions = map;
            this.icuFormatter = NumberFormatterFactory.formatterForOptions(locale, map, string);
        }

        @Override
        public List<String> matches(Object object, List<String> list, Map<String, Object> map) {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (object == null) {
                return arrayList;
            }
            for (String string : list) {
                if (this.matches(object, string, map)) {
                    arrayList.add(string);
                    continue;
                }
                arrayList.add(NO_MATCH);
            }
            arrayList.sort(PluralSelectorImpl::pluralComparator);
            return arrayList;
        }

        private static int pluralComparator(String string, String string2) {
            if (string.equals(string2)) {
                return 0;
            }
            if (NO_MATCH.equals(string)) {
                return 1;
            }
            if (NO_MATCH.equals(string2)) {
                return -1;
            }
            if ("*".equals(string)) {
                return 1;
            }
            if ("*".equals(string2)) {
                return -1;
            }
            if (OptUtils.asNumber(string) != null) {
                return -1;
            }
            if (OptUtils.asNumber(string2) != null) {
                return 1;
            }
            return string.compareTo(string2);
        }

        private boolean matches(Object object, String string, Map<String, Object> map) {
            Object object2;
            if ("*".equals(string)) {
                return true;
            }
            Integer n2 = OptUtils.getInteger(map, "icu:offset");
            if (n2 == null && this.fixedOptions != null) {
                n2 = OptUtils.getInteger(this.fixedOptions, "icu:offset");
            }
            if (n2 == null) {
                n2 = 0;
            }
            Double d2 = Double.MIN_VALUE;
            if (object instanceof FormattedPlaceholder) {
                object2 = (FormattedPlaceholder)object;
                object = ((FormattedPlaceholder)object2).getInput();
            }
            if (!(object instanceof Number)) {
                return false;
            }
            d2 = ((Number)object).doubleValue();
            object2 = OptUtils.asNumber(string);
            if (object2 != null && ((Number)d2).doubleValue() == ((Number)object2).doubleValue()) {
                return true;
            }
            FormattedNumber formattedNumber = this.icuFormatter.format(d2 - (double)n2.intValue());
            String string2 = this.rules.select(formattedNumber);
            if (string2.equals("other")) {
                string2 = "*";
            }
            return string2.equals(string);
        }
    }

    static class NumberFormatterImpl
    implements Formatter {
        private final Locale locale;
        private final Map<String, Object> fixedOptions;
        private final LocalizedNumberFormatter icuFormatter;
        private final String kind;
        final boolean advanced;

        NumberFormatterImpl(Locale locale, Map<String, Object> map, String string) {
            this.locale = locale;
            this.fixedOptions = new HashMap<String, Object>(map);
            String string2 = OptUtils.getString(map, "icu:skeleton");
            boolean bl2 = string2 != null;
            this.icuFormatter = NumberFormatterFactory.formatterForOptions(locale, map, string);
            this.advanced = bl2;
            this.kind = string;
        }

        LocalizedNumberFormatter getIcuFormatter() {
            return this.icuFormatter;
        }

        @Override
        public String formatToString(Object object, Map<String, Object> map) {
            return this.format(object, map).toString();
        }

        @Override
        public FormattedPlaceholder format(Object object, Map<String, Object> map) {
            Serializable serializable;
            LocalizedNumberFormatter localizedNumberFormatter;
            if (map.isEmpty()) {
                localizedNumberFormatter = this.icuFormatter;
            } else {
                serializable = new HashMap<String, Object>(this.fixedOptions);
                serializable.putAll(map);
                localizedNumberFormatter = NumberFormatterFactory.formatterForOptions(this.locale, serializable, this.kind);
            }
            serializable = OptUtils.getInteger(map, "icu:offset");
            if (serializable == null && this.fixedOptions != null) {
                serializable = OptUtils.getInteger(this.fixedOptions, "icu:offset");
            }
            if (serializable == null) {
                serializable = Integer.valueOf(0);
            }
            FormattedValue formattedValue = null;
            if (object == null) {
                throw new NullPointerException("Argument to format can't be null");
            }
            if (object instanceof Double) {
                formattedValue = localizedNumberFormatter.format((Double)object - (double)((Integer)serializable).intValue());
            } else if (object instanceof Long) {
                formattedValue = localizedNumberFormatter.format((Long)object - (long)((Integer)serializable).intValue());
            } else if (object instanceof Integer) {
                formattedValue = localizedNumberFormatter.format((Integer)object - (Integer)serializable);
            } else if (object instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)object;
                formattedValue = localizedNumberFormatter.format(bigDecimal.subtract(BigDecimal.valueOf(((Integer)serializable).intValue())));
            } else {
                String string;
                Number number;
                formattedValue = object instanceof Number ? localizedNumberFormatter.format(((Number)object).doubleValue() - (double)((Integer)serializable).intValue()) : (object instanceof CurrencyAmount ? localizedNumberFormatter.format((CurrencyAmount)object) : ((number = OptUtils.asNumber(string = Objects.toString(object))) != null ? localizedNumberFormatter.format(number.doubleValue() - (double)((Integer)serializable).intValue()) : new PlainStringFormattedValue("{|" + string + "|}")));
            }
            return new FormattedPlaceholder(object, formattedValue);
        }
    }
}

