/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.message2;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import macromedia.jdbc.db2.externals.com.ibm.icu.message2.DateTimeFormatterFactory;
import macromedia.jdbc.db2.externals.com.ibm.icu.message2.FormattedPlaceholder;
import macromedia.jdbc.db2.externals.com.ibm.icu.message2.FormatterFactory;
import macromedia.jdbc.db2.externals.com.ibm.icu.message2.IdentityFormatterFactory;
import macromedia.jdbc.db2.externals.com.ibm.icu.message2.MFDataModel;
import macromedia.jdbc.db2.externals.com.ibm.icu.message2.MFFunctionRegistry;
import macromedia.jdbc.db2.externals.com.ibm.icu.message2.NumberFormatterFactory;
import macromedia.jdbc.db2.externals.com.ibm.icu.message2.OptUtils;
import macromedia.jdbc.db2.externals.com.ibm.icu.message2.PlainStringFormattedValue;
import macromedia.jdbc.db2.externals.com.ibm.icu.message2.Selector;
import macromedia.jdbc.db2.externals.com.ibm.icu.message2.TextSelectorFactory;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.CurrencyAmount;

class MFDataModelFormatter {
    private final Locale locale;
    private final MFDataModel.Message dm;
    private final MFFunctionRegistry standardFunctions;
    private final MFFunctionRegistry customFunctions;
    private static final MFFunctionRegistry EMPTY_REGISTY = MFFunctionRegistry.builder().build();

    MFDataModelFormatter(MFDataModel.Message message, Locale locale, MFFunctionRegistry mFFunctionRegistry) {
        this.locale = locale;
        this.dm = message;
        this.customFunctions = mFFunctionRegistry == null ? EMPTY_REGISTY : mFFunctionRegistry;
        this.standardFunctions = MFFunctionRegistry.builder().setFormatter("datetime", new DateTimeFormatterFactory("datetime")).setFormatter("date", new DateTimeFormatterFactory("date")).setFormatter("time", new DateTimeFormatterFactory("time")).setDefaultFormatterNameForType(Date.class, "datetime").setDefaultFormatterNameForType(macromedia.jdbc.db2.externals.com.ibm.icu.util.Calendar.class, "datetime").setDefaultFormatterNameForType(Calendar.class, "datetime").setFormatter("number", new NumberFormatterFactory("number")).setFormatter("integer", new NumberFormatterFactory("integer")).setDefaultFormatterNameForType(Integer.class, "number").setDefaultFormatterNameForType(Double.class, "number").setDefaultFormatterNameForType(Number.class, "number").setDefaultFormatterNameForType(CurrencyAmount.class, "number").setFormatter("string", new IdentityFormatterFactory()).setDefaultFormatterNameForType(String.class, "string").setDefaultFormatterNameForType(CharSequence.class, "string").setSelector("number", new NumberFormatterFactory("number")).setSelector("integer", new NumberFormatterFactory("integer")).setSelector("string", new TextSelectorFactory()).setSelector("icu:gender", new TextSelectorFactory()).build();
    }

    String format(Map<String, Object> map) {
        Map<String, Object> map2;
        Object object;
        MFDataModel.Pattern pattern = null;
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        if (this.dm instanceof MFDataModel.PatternMessage) {
            object = (MFDataModel.PatternMessage)this.dm;
            map2 = this.resolveDeclarations(((MFDataModel.PatternMessage)object).declarations, map);
            pattern = ((MFDataModel.PatternMessage)object).pattern;
        } else if (this.dm instanceof MFDataModel.SelectMessage) {
            object = (MFDataModel.SelectMessage)this.dm;
            map2 = this.resolveDeclarations(((MFDataModel.SelectMessage)object).declarations, map);
            pattern = this.findBestMatchingPattern((MFDataModel.SelectMessage)object, map2, map);
        } else {
            MFDataModelFormatter.formattingError("");
            return "ERROR!";
        }
        if (pattern == null) {
            return "ERROR!";
        }
        object = new StringBuilder();
        for (MFDataModel.PatternPart patternPart : pattern.parts) {
            Object object2;
            if (patternPart instanceof MFDataModel.StringPart) {
                object2 = (MFDataModel.StringPart)patternPart;
                ((StringBuilder)object).append(((MFDataModel.StringPart)object2).value);
                continue;
            }
            if (patternPart instanceof MFDataModel.Expression) {
                object2 = this.formatExpression((MFDataModel.Expression)patternPart, map2, map);
                ((StringBuilder)object).append(((FormattedPlaceholder)object2).getFormattedValue().toString());
                continue;
            }
            if (patternPart instanceof MFDataModel.Markup || patternPart instanceof MFDataModel.UnsupportedExpression) continue;
            MFDataModelFormatter.formattingError("Unknown part type: " + patternPart);
        }
        return ((StringBuilder)object).toString();
    }

    /*
     * WARNING - void declaration
     */
    private MFDataModel.Pattern findBestMatchingPattern(MFDataModel.SelectMessage selectMessage, Map<String, Object> map, Map<String, Object> map2) {
        void var11_37;
        Object object;
        Iterator iterator;
        Object object2;
        Object object3;
        Object object6;
        MFDataModel.Pattern pattern = null;
        List<MFDataModel.Expression> list = selectMessage.selectors;
        ArrayList<ResolvedSelector> arrayList = new ArrayList<ResolvedSelector>(list.size());
        for (MFDataModel.Expression expression : list) {
            void object52;
            object6 = this.formatExpression(expression, map, map2);
            Object n3 = null;
            Object var11_26 = null;
            object3 = new HashMap<String, Object>();
            if (((FormattedPlaceholder)object6).getInput() instanceof ResolvedExpression) {
                object2 = (ResolvedExpression)((FormattedPlaceholder)object6).getInput();
                Object object4 = ((ResolvedExpression)object2).argument;
                String string = ((ResolvedExpression)object2).functionName;
                object3.putAll(((ResolvedExpression)object2).options);
            } else if (((FormattedPlaceholder)object6).getInput() instanceof MFDataModel.VariableExpression) {
                object2 = (MFDataModel.VariableExpression)((FormattedPlaceholder)object6).getInput();
                Object object5 = MFDataModelFormatter.resolveLiteralOrVariable(((MFDataModel.VariableExpression)object2).arg, map, map2);
                if (((MFDataModel.VariableExpression)object2).annotation instanceof MFDataModel.FunctionAnnotation) {
                    String string = ((MFDataModel.FunctionAnnotation)((MFDataModel.VariableExpression)object2).annotation).name;
                }
            } else if (((FormattedPlaceholder)object6).getInput() instanceof MFDataModel.LiteralExpression) {
                object2 = (MFDataModel.LiteralExpression)((FormattedPlaceholder)object6).getInput();
                MFDataModel.Literal literal = ((MFDataModel.LiteralExpression)object2).arg;
                if (((MFDataModel.LiteralExpression)object2).annotation instanceof MFDataModel.FunctionAnnotation) {
                    String string = ((MFDataModel.FunctionAnnotation)((MFDataModel.LiteralExpression)object2).annotation).name;
                }
            }
            object2 = this.standardFunctions.getSelector((String)object52);
            if (object2 == null) {
                object2 = this.customFunctions.getSelector((String)object52);
            }
            if (object2 != null) {
                void var11_25;
                iterator = object2.createSelector(this.locale, (Map<String, Object>)object3);
                object = new ResolvedSelector(var11_25, (Map<String, Object>)object3, (Selector)((Object)iterator));
                arrayList.add((ResolvedSelector)object);
                continue;
            }
            throw new IllegalArgumentException("Unknown selector type: " + (String)object52);
        }
        if (arrayList.size() != list.size()) {
            throw new IllegalArgumentException("Something went wrong, not enough selector functions, " + arrayList.size() + " vs. " + list.size());
        }
        ArrayList arrayList2 = new ArrayList();
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            object6 = new ArrayList();
            for (MFDataModel.Variant variant : selectMessage.variants) {
                object3 = variant.keys.get(i2);
                if (object3 instanceof MFDataModel.CatchallKey) {
                    object6.add("*");
                    continue;
                }
                if (object3 instanceof MFDataModel.Literal) {
                    object2 = ((MFDataModel.Literal)object3).value;
                    object6.add(object2);
                    continue;
                }
                MFDataModelFormatter.formattingError("Literal expected, but got " + object3);
            }
            ResolvedSelector resolvedSelector = (ResolvedSelector)arrayList.get(i2);
            List<String> list2 = this.matchSelectorKeys(resolvedSelector, (List<String>)object6);
            arrayList2.add(list2);
        }
        ArrayList<MFDataModel.Variant> arrayList3 = new ArrayList<MFDataModel.Variant>();
        for (MFDataModel.Variant variant : selectMessage.variants) {
            int n2 = 0;
            for (int i2 = 0; i2 < arrayList2.size(); ++i2) {
                object2 = variant.keys.get(i2);
                if (object2 instanceof MFDataModel.CatchallKey) {
                    ++n2;
                    continue;
                }
                if (!(object2 instanceof MFDataModel.Literal)) {
                    MFDataModelFormatter.formattingError("Literal expected");
                }
                iterator = ((MFDataModel.Literal)object2).value;
                object = (List)arrayList2.get(i2);
                if (!object.contains(iterator)) break;
                ++n2;
            }
            if (n2 != arrayList2.size()) continue;
            arrayList3.add(variant);
        }
        object6 = new ArrayList();
        for (MFDataModel.Variant variant : arrayList3) {
            IntVarTuple intVarTuple = new IntVarTuple(-1, variant);
            object6.add(intVarTuple);
        }
        int n3 = arrayList2.size();
        int n4 = n3 - 1;
        while (var11_37 >= 0) {
            List list3 = (List)arrayList2.get((int)var11_37);
            int n5 = list3.size();
            iterator = object6.iterator();
            while (iterator.hasNext()) {
                object = (IntVarTuple)iterator.next();
                int n6 = n5;
                MFDataModel.LiteralOrCatchallKey literalOrCatchallKey = ((IntVarTuple)object).variant.keys.get((int)var11_37);
                if (!(literalOrCatchallKey instanceof MFDataModel.CatchallKey)) {
                    if (!(literalOrCatchallKey instanceof MFDataModel.Literal)) {
                        MFDataModelFormatter.formattingError("Literal expected");
                    }
                    String string = ((MFDataModel.Literal)literalOrCatchallKey).value;
                    n6 = list3.indexOf(string);
                }
                ((IntVarTuple)object).integer = n6;
            }
            object6.sort(MFDataModelFormatter::sortVariants);
            --var11_37;
        }
        IntVarTuple intVarTuple = (IntVarTuple)object6.get(0);
        pattern = intVarTuple.variant.value;
        if (pattern == null) {
            throw new IllegalArgumentException("The selection went wrong, cannot select any option.");
        }
        return pattern;
    }

    private static int sortVariants(IntVarTuple intVarTuple, IntVarTuple intVarTuple2) {
        int n2 = Integer.compare(intVarTuple.integer, intVarTuple2.integer);
        if (n2 != 0) {
            return n2;
        }
        List<MFDataModel.LiteralOrCatchallKey> list = intVarTuple.variant.keys;
        List<MFDataModel.LiteralOrCatchallKey> list2 = intVarTuple.variant.keys;
        if (list.size() != list2.size()) {
            MFDataModelFormatter.formattingError("The number of keys is not equal.");
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            MFDataModel.LiteralOrCatchallKey literalOrCatchallKey;
            String string;
            MFDataModel.LiteralOrCatchallKey literalOrCatchallKey2 = list.get(i2);
            String string2 = literalOrCatchallKey2 instanceof MFDataModel.Literal ? ((MFDataModel.Literal)literalOrCatchallKey2).value : "*";
            int n3 = string2.compareTo(string = (literalOrCatchallKey = list2.get(i2)) instanceof MFDataModel.Literal ? ((MFDataModel.Literal)literalOrCatchallKey).value : "*");
            if (n3 == 0) continue;
            return n3;
        }
        return 0;
    }

    private List<String> matchSelectorKeys(ResolvedSelector resolvedSelector, List<String> list) {
        return resolvedSelector.selectorFunction.matches(resolvedSelector.argument, list, resolvedSelector.options);
    }

    private static void formattingError(String string) {
        throw new IllegalArgumentException(string);
    }

    private FormatterFactory getFormattingFunctionFactoryByName(Object object, String string) {
        Class<?> clazz;
        if (string == null || string.isEmpty()) {
            if (object == null) {
                return null;
            }
            clazz = object.getClass();
            string = this.standardFunctions.getDefaultFormatterNameForType(clazz);
            if (string == null) {
                string = this.customFunctions.getDefaultFormatterNameForType(clazz);
            }
            if (string == null) {
                throw new IllegalArgumentException("Object to format without a function, and unknown type: " + object.getClass().getName());
            }
        }
        if ((clazz = this.standardFunctions.getFormatter(string)) == null) {
            clazz = this.customFunctions.getFormatter(string);
        }
        return clazz;
    }

    private static Object resolveLiteralOrVariable(MFDataModel.LiteralOrVariableRef literalOrVariableRef, Map<String, Object> map, Map<String, Object> map2) {
        if (literalOrVariableRef instanceof MFDataModel.Literal) {
            String string = ((MFDataModel.Literal)literalOrVariableRef).value;
            Number number = OptUtils.asNumber(string);
            if (number != null) {
                return number;
            }
            return string;
        }
        if (literalOrVariableRef instanceof MFDataModel.VariableRef) {
            String string = ((MFDataModel.VariableRef)literalOrVariableRef).name;
            Object object = map.get(string);
            if (object == null) {
                object = map.get(string);
            }
            if (object == null) {
                object = map2.get(string);
            }
            return object;
        }
        return literalOrVariableRef;
    }

    private static Map<String, Object> convertOptions(Map<String, MFDataModel.Option> map, Map<String, Object> map2, Map<String, Object> map3) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (MFDataModel.Option option : map.values()) {
            hashMap.put(option.name, MFDataModelFormatter.resolveLiteralOrVariable(option.value, map2, map3));
        }
        return hashMap;
    }

    private FormattedPlaceholder formatExpression(MFDataModel.Expression expression, Map<String, Object> map, Map<String, Object> map2) {
        ResolvedExpression resolvedExpression;
        Object object;
        Object object2;
        Object object3;
        MFDataModel.Annotation annotation = null;
        String string = null;
        Object object4 = null;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string2 = "{\ufffd}";
        if (expression instanceof MFDataModel.VariableExpression) {
            object3 = (MFDataModel.VariableExpression)expression;
            string2 = "{$" + ((MFDataModel.VariableExpression)object3).arg.name + "}";
            annotation = ((MFDataModel.VariableExpression)object3).annotation;
            object2 = MFDataModelFormatter.resolveLiteralOrVariable(((MFDataModel.VariableExpression)object3).arg, map, map2);
            if (object2 instanceof FormattedPlaceholder) {
                object = ((FormattedPlaceholder)object2).getInput();
                if (object instanceof ResolvedExpression) {
                    resolvedExpression = (ResolvedExpression)object;
                    object4 = resolvedExpression.argument;
                    string = resolvedExpression.functionName;
                    hashMap.putAll(resolvedExpression.options);
                } else {
                    object4 = object;
                }
            } else {
                object4 = object2;
            }
        } else if (expression instanceof MFDataModel.FunctionExpression) {
            object3 = (MFDataModel.FunctionExpression)expression;
            string2 = "{:" + ((MFDataModel.FunctionExpression)object3).annotation.name + "}";
            annotation = ((MFDataModel.FunctionExpression)object3).annotation;
        } else if (expression instanceof MFDataModel.LiteralExpression) {
            object3 = (MFDataModel.LiteralExpression)expression;
            annotation = ((MFDataModel.LiteralExpression)object3).annotation;
            string2 = "{|" + ((MFDataModel.LiteralExpression)object3).arg.value + "|}";
            object4 = MFDataModelFormatter.resolveLiteralOrVariable(((MFDataModel.LiteralExpression)object3).arg, map, map2);
        } else {
            if (expression instanceof MFDataModel.Markup) {
                return new FormattedPlaceholder(expression, new PlainStringFormattedValue(""));
            }
            MFDataModel.UnsupportedExpression unsupportedExpression = (MFDataModel.UnsupportedExpression)expression;
            char c2 = unsupportedExpression.annotation.source.charAt(0);
            return new FormattedPlaceholder(expression, new PlainStringFormattedValue("{" + c2 + "}"));
        }
        if (annotation instanceof MFDataModel.FunctionAnnotation) {
            object3 = (MFDataModel.FunctionAnnotation)annotation;
            if (string != null && !string.equals(((MFDataModel.FunctionAnnotation)object3).name)) {
                MFDataModelFormatter.formattingError("invalid function overrides, '" + string + "' <> '" + ((MFDataModel.FunctionAnnotation)object3).name + "'");
            }
            string = ((MFDataModel.FunctionAnnotation)object3).name;
            object2 = MFDataModelFormatter.convertOptions(((MFDataModel.FunctionAnnotation)object3).options, map, map2);
            hashMap.putAll((Map<String, Object>)object2);
        } else if (annotation instanceof MFDataModel.UnsupportedAnnotation) {
            return new FormattedPlaceholder(expression, new PlainStringFormattedValue(string2));
        }
        object3 = this.getFormattingFunctionFactoryByName(object4, string);
        if (object3 == null) {
            return new FormattedPlaceholder(expression, new PlainStringFormattedValue(string2));
        }
        object2 = object3.createFormatter(this.locale, hashMap);
        object = object2.formatToString(object4, map2);
        if (object == null) {
            object = string2;
        }
        resolvedExpression = new ResolvedExpression(object4, string, hashMap);
        return new FormattedPlaceholder(resolvedExpression, new PlainStringFormattedValue((String)object));
    }

    private Map<String, Object> resolveDeclarations(List<MFDataModel.Declaration> list, Map<String, Object> map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (list != null) {
            for (MFDataModel.Declaration declaration : list) {
                MFDataModel.Expression expression;
                String string;
                if (declaration instanceof MFDataModel.InputDeclaration) {
                    string = ((MFDataModel.InputDeclaration)declaration).name;
                    expression = ((MFDataModel.InputDeclaration)declaration).value;
                } else {
                    if (!(declaration instanceof MFDataModel.LocalDeclaration)) continue;
                    string = ((MFDataModel.LocalDeclaration)declaration).name;
                    expression = ((MFDataModel.LocalDeclaration)declaration).value;
                }
                try {
                    FormattedPlaceholder formattedPlaceholder = this.formatExpression(expression, hashMap, map);
                    hashMap.put(string, formattedPlaceholder);
                }
                catch (Exception exception) {}
            }
        }
        return hashMap;
    }

    private static class IntVarTuple {
        int integer;
        final MFDataModel.Variant variant;

        public IntVarTuple(int n2, MFDataModel.Variant variant) {
            this.integer = n2;
            this.variant = variant;
        }
    }

    static class ResolvedExpression
    implements MFDataModel.Expression {
        final Object argument;
        final String functionName;
        final Map<String, Object> options;

        public ResolvedExpression(Object object, String string, Map<String, Object> map) {
            this.argument = object;
            this.functionName = string;
            this.options = map;
        }
    }

    private static class ResolvedSelector {
        final Object argument;
        final Map<String, Object> options;
        final Selector selectorFunction;

        public ResolvedSelector(Object object, Map<String, Object> map, Selector selector) {
            this.argument = object;
            this.options = new HashMap<String, Object>(map);
            this.selectorFunction = selector;
        }
    }
}

