/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.message2;

class InputSource {
    final String buffer;
    private int cursor;
    private int lastReadCursor = -1;
    private int lastReadCount = 0;

    InputSource(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Input string should not be null");
        }
        this.buffer = string;
        this.cursor = 0;
    }

    boolean atEnd() {
        return this.cursor >= this.buffer.length();
    }

    int peekChar() {
        if (this.atEnd()) {
            return -1;
        }
        return this.buffer.charAt(this.cursor);
    }

    int readCodePoint() {
        char c2;
        if (this.lastReadCursor != this.cursor) {
            this.lastReadCursor = this.cursor;
            this.lastReadCount = 1;
        } else {
            ++this.lastReadCount;
            if (this.lastReadCount >= 10) {
                throw new RuntimeException("Stuck in a loop!");
            }
        }
        if (this.atEnd()) {
            return -1;
        }
        if (Character.isHighSurrogate(c2 = this.buffer.charAt(this.cursor++)) && !this.atEnd()) {
            char c3;
            if (Character.isLowSurrogate(c3 = this.buffer.charAt(this.cursor++))) {
                return Character.toCodePoint(c2, c3);
            }
            --this.cursor;
            return c2;
        }
        return c2;
    }

    void backup(int n2) {
        this.cursor -= n2;
    }

    int getPosition() {
        return this.cursor;
    }

    void skip(int n2) {
        this.cursor += n2;
    }

    void gotoPosition(int n2) {
        this.cursor = n2;
    }
}

