/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.lang;

import macromedia.jdbc.db2.externals.com.ibm.icu.impl.CharacterPropertiesImpl;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.EmojiProps;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UCharacter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.CodePointMap;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.CodePointTrie;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.MutableCodePointTrie;

public final class CharacterProperties {
    private static final UnicodeSet[] sets = new UnicodeSet[75];
    private static final CodePointMap[] maps = new CodePointMap[26];

    private CharacterProperties() {
    }

    private static UnicodeSet makeSet(int n2) {
        UnicodeSet unicodeSet = new UnicodeSet();
        if (65 <= n2 && n2 <= 71) {
            EmojiProps.INSTANCE.addStrings(n2, unicodeSet);
            if (n2 != 65 && n2 != 71) {
                return unicodeSet.freeze();
            }
        }
        UnicodeSet unicodeSet2 = CharacterPropertiesImpl.getInclusionsForProperty(n2);
        int n3 = unicodeSet2.getRangeCount();
        int n4 = -1;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n5 = unicodeSet2.getRangeEnd(i2);
            for (int i3 = unicodeSet2.getRangeStart(i2); i3 <= n5; ++i3) {
                if (UCharacter.hasBinaryProperty(i3, n2)) {
                    if (n4 >= 0) continue;
                    n4 = i3;
                    continue;
                }
                if (n4 < 0) continue;
                unicodeSet.add(n4, i3 - 1);
                n4 = -1;
            }
        }
        if (n4 >= 0) {
            unicodeSet.add(n4, 0x10FFFF);
        }
        return unicodeSet.freeze();
    }

    private static CodePointMap makeMap(int n2) {
        int n3;
        int n4 = n2 == 4106 ? 103 : 0;
        MutableCodePointTrie mutableCodePointTrie = new MutableCodePointTrie(n4, n4);
        UnicodeSet unicodeSet = CharacterPropertiesImpl.getInclusionsForProperty(n2);
        int n5 = unicodeSet.getRangeCount();
        int n6 = 0;
        int n7 = n4;
        for (int i2 = 0; i2 < n5; ++i2) {
            int n8 = unicodeSet.getRangeEnd(i2);
            for (n3 = unicodeSet.getRangeStart(i2); n3 <= n8; ++n3) {
                int n9 = UCharacter.getIntPropertyValue(n3, n2);
                if (n7 == n9) continue;
                if (n7 != n4) {
                    mutableCodePointTrie.setRange(n6, n3 - 1, n7);
                }
                n6 = n3;
                n7 = n9;
            }
        }
        if (n7 != 0) {
            mutableCodePointTrie.setRange(n6, 0x10FFFF, n7);
        }
        CodePointTrie.Type type = n2 == 4096 || n2 == 4101 ? CodePointTrie.Type.FAST : CodePointTrie.Type.SMALL;
        n3 = UCharacter.getIntPropertyMaxValue(n2);
        CodePointTrie.ValueWidth valueWidth = n3 <= 255 ? CodePointTrie.ValueWidth.BITS_8 : (n3 <= 65535 ? CodePointTrie.ValueWidth.BITS_16 : CodePointTrie.ValueWidth.BITS_32);
        return mutableCodePointTrie.buildImmutable(type, valueWidth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final UnicodeSet getBinaryPropertySet(int n2) {
        if (n2 < 0 || 75 <= n2) {
            throw new IllegalArgumentException("" + n2 + " is not a constant for a UProperty binary property");
        }
        UnicodeSet[] unicodeSetArray = sets;
        synchronized (sets) {
            UnicodeSet unicodeSet = sets[n2];
            if (unicodeSet == null) {
                CharacterProperties.sets[n2] = unicodeSet = CharacterProperties.makeSet(n2);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return unicodeSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final CodePointMap getIntPropertyMap(int n2) {
        if (n2 < 4096 || 4122 <= n2) {
            throw new IllegalArgumentException("" + n2 + " is not a constant for a UProperty int property");
        }
        CodePointMap[] codePointMapArray = maps;
        synchronized (maps) {
            CodePointMap codePointMap = maps[n2 - 4096];
            if (codePointMap == null) {
                CharacterProperties.maps[n2 - 4096] = codePointMap = CharacterProperties.makeMap(n2);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return codePointMap;
        }
    }
}

