/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.units;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.IllegalIcuArgumentException;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.MicroProps;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.units.ComplexUnitsConverter;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.units.ConversionRates;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.units.MeasureUnitImpl;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.units.UnitPreferences;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.units.UnitsData;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.Precision;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.MeasureUnit;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;

public class UnitsRouter {
    private ArrayList<MeasureUnit> outputUnits_ = new ArrayList();
    private ArrayList<ConverterPreference> converterPreferences_ = new ArrayList();

    public UnitsRouter(String string, ULocale uLocale, String string2) {
        this(MeasureUnitImpl.forIdentifier(string), uLocale, string2);
    }

    public UnitsRouter(MeasureUnitImpl measureUnitImpl, ULocale uLocale, String string) {
        UnitsData unitsData = new UnitsData();
        String string2 = unitsData.getCategory(measureUnitImpl);
        UnitPreferences.UnitPreference[] unitPreferenceArray = unitsData.getPreferencesFor(string2, string, uLocale);
        for (int i2 = 0; i2 < unitPreferenceArray.length; ++i2) {
            UnitPreferences.UnitPreference unitPreference = unitPreferenceArray[i2];
            MeasureUnitImpl measureUnitImpl2 = MeasureUnitImpl.UnitsParser.parseForIdentifier(unitPreference.getUnit());
            String string3 = unitPreference.getSkeleton();
            if (!string3.isEmpty() && !string3.startsWith("precision-increment")) {
                throw new AssertionError((Object)"Only `precision-increment` is allowed");
            }
            this.outputUnits_.add(measureUnitImpl2.build());
            this.converterPreferences_.add(new ConverterPreference(measureUnitImpl, measureUnitImpl2, unitPreference.getGeq(), string3, unitsData.getConversionRates()));
        }
    }

    public RouteResult route(BigDecimal bigDecimal, MicroProps microProps) {
        Precision precision = microProps == null ? null : microProps.rounder;
        ConverterPreference converterPreference = null;
        Object object = this.converterPreferences_.iterator();
        while (object.hasNext()) {
            ConverterPreference converterPreference2;
            converterPreference = converterPreference2 = object.next();
            if (!converterPreference.converter.greaterThanOrEqual(bigDecimal.abs(), converterPreference.limit)) continue;
            break;
        }
        assert (converterPreference != null);
        assert (converterPreference.precision != null);
        if (precision != null && precision instanceof Precision.BogusRounder) {
            object = (Precision.BogusRounder)precision;
            precision = converterPreference.precision.length() > 0 ? ((Precision.BogusRounder)object).into(UnitsRouter.parseSkeletonToPrecision(converterPreference.precision)) : ((Precision.BogusRounder)object).into(Precision.integer().withMinDigits(2));
        }
        if (microProps != null) {
            microProps.rounder = precision;
        }
        return new RouteResult(converterPreference.converter.convert(bigDecimal, precision), converterPreference.targetUnit);
    }

    private static Precision parseSkeletonToPrecision(String string) {
        String string2 = "precision-increment/";
        if (!string.startsWith("precision-increment/")) {
            throw new IllegalIcuArgumentException("precisionSkeleton is only precision-increment");
        }
        String string3 = string.substring("precision-increment/".length());
        return Precision.increment(new BigDecimal(string3));
    }

    public List<MeasureUnit> getOutputUnits() {
        return this.outputUnits_;
    }

    public class RouteResult {
        public final ComplexUnitsConverter.ComplexConverterResult complexConverterResult;
        public final MeasureUnitImpl outputUnit;

        RouteResult(ComplexUnitsConverter.ComplexConverterResult complexConverterResult, MeasureUnitImpl measureUnitImpl) {
            this.complexConverterResult = complexConverterResult;
            this.outputUnit = measureUnitImpl;
        }
    }

    public static class ConverterPreference {
        final MeasureUnitImpl targetUnit;
        final ComplexUnitsConverter converter;
        final BigDecimal limit;
        final String precision;

        public ConverterPreference(MeasureUnitImpl measureUnitImpl, MeasureUnitImpl measureUnitImpl2, String string, ConversionRates conversionRates) {
            this(measureUnitImpl, measureUnitImpl2, BigDecimal.valueOf(Double.MIN_VALUE), string, conversionRates);
        }

        public ConverterPreference(MeasureUnitImpl measureUnitImpl, MeasureUnitImpl measureUnitImpl2, BigDecimal bigDecimal, String string, ConversionRates conversionRates) {
            this.converter = new ComplexUnitsConverter(measureUnitImpl, measureUnitImpl2, conversionRates);
            this.limit = bigDecimal;
            this.precision = string;
            this.targetUnit = measureUnitImpl2;
        }
    }
}

