/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.units;

import macromedia.jdbc.db2.externals.com.ibm.icu.impl.units.MeasureUnitImpl;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.units.UnitsData;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.MeasureUnit;

public class SingleUnitImpl {
    private int index = -1;
    private String simpleUnitID = "";
    private int dimensionality = 1;
    private MeasureUnit.MeasurePrefix unitPrefix = MeasureUnit.MeasurePrefix.ONE;

    public SingleUnitImpl copy() {
        SingleUnitImpl singleUnitImpl = new SingleUnitImpl();
        singleUnitImpl.index = this.index;
        singleUnitImpl.dimensionality = this.dimensionality;
        singleUnitImpl.simpleUnitID = this.simpleUnitID;
        singleUnitImpl.unitPrefix = this.unitPrefix;
        return singleUnitImpl;
    }

    public MeasureUnit build() {
        MeasureUnitImpl measureUnitImpl = new MeasureUnitImpl(this);
        return measureUnitImpl.build();
    }

    public String getNeutralIdentifier() {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = Math.abs(this.getDimensionality());
        assert (n2 > 0) : "this function does not support the dimensionless single units";
        if (n2 != 1) {
            if (n2 == 2) {
                stringBuilder.append("square-");
            } else if (n2 == 3) {
                stringBuilder.append("cubic-");
            } else if (n2 <= 15) {
                stringBuilder.append("pow");
                stringBuilder.append(n2);
                stringBuilder.append('-');
            } else {
                throw new IllegalArgumentException("Unit Identifier Syntax Error");
            }
        }
        stringBuilder.append(this.getPrefix().getIdentifier());
        stringBuilder.append(this.getSimpleUnitID());
        return stringBuilder.toString();
    }

    int compareTo(SingleUnitImpl singleUnitImpl) {
        int n2;
        int n3;
        if (this.dimensionality < 0 && singleUnitImpl.dimensionality > 0) {
            return 1;
        }
        if (this.dimensionality > 0 && singleUnitImpl.dimensionality < 0) {
            return -1;
        }
        int n4 = UnitsData.getCategoryIndexOfSimpleUnit(this.index);
        if (n4 < (n3 = UnitsData.getCategoryIndexOfSimpleUnit(singleUnitImpl.index))) {
            return -1;
        }
        if (n4 > n3) {
            return 1;
        }
        if (this.index < singleUnitImpl.index) {
            return -1;
        }
        if (this.index > singleUnitImpl.index) {
            return 1;
        }
        int n5 = this.unitPrefix.getBase();
        int n6 = singleUnitImpl.unitPrefix.getBase();
        int n7 = n5 == 1024 ? this.unitPrefix.getPower() * 3 : this.unitPrefix.getPower();
        int n8 = n2 = n6 == 1024 ? singleUnitImpl.unitPrefix.getPower() * 3 : singleUnitImpl.unitPrefix.getPower();
        if (n7 < n2) {
            return 1;
        }
        if (n7 > n2) {
            return -1;
        }
        if (n5 < n6) {
            return 1;
        }
        if (n5 > n6) {
            return -1;
        }
        return 0;
    }

    boolean isCompatibleWith(SingleUnitImpl singleUnitImpl) {
        return this.compareTo(singleUnitImpl) == 0;
    }

    public String getSimpleUnitID() {
        return this.simpleUnitID;
    }

    public void setSimpleUnit(int n2, String[] stringArray) {
        this.index = n2;
        this.simpleUnitID = stringArray[n2];
    }

    public int getDimensionality() {
        return this.dimensionality;
    }

    public void setDimensionality(int n2) {
        this.dimensionality = n2;
    }

    public MeasureUnit.MeasurePrefix getPrefix() {
        return this.unitPrefix;
    }

    public void setPrefix(MeasureUnit.MeasurePrefix measurePrefix) {
        this.unitPrefix = measurePrefix;
    }

    public int getIndex() {
        return this.index;
    }
}

