/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse;

import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse.ParsedNumber;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse.ValidationMatcher;

public class RequireDecimalSeparatorValidator
extends ValidationMatcher {
    private static final RequireDecimalSeparatorValidator A = new RequireDecimalSeparatorValidator(true);
    private static final RequireDecimalSeparatorValidator B = new RequireDecimalSeparatorValidator(false);
    private final boolean patternHasDecimalSeparator;

    public static RequireDecimalSeparatorValidator getInstance(boolean bl2) {
        return bl2 ? A : B;
    }

    private RequireDecimalSeparatorValidator(boolean bl2) {
        this.patternHasDecimalSeparator = bl2;
    }

    @Override
    public void postProcess(ParsedNumber parsedNumber) {
        boolean bl2;
        boolean bl3 = bl2 = 0 != (parsedNumber.flags & 0x20);
        if (bl2 != this.patternHasDecimalSeparator) {
            parsedNumber.flags |= 0x100;
        }
    }

    public String toString() {
        return "<RequireDecimalSeparator>";
    }
}

