/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse;

import java.util.Iterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.StandardPlural;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.StringSegment;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.TextTrieMap;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse.NumberParseMatcher;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse.ParsedNumber;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.DecimalFormatSymbols;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.Currency;

public class CombinedCurrencyMatcher
implements NumberParseMatcher {
    private final String isoCode;
    private final String currency1;
    private final String currency2;
    private final String[] localLongNames;
    private final String afterPrefixInsert;
    private final String beforeSuffixInsert;
    private final TextTrieMap<Currency.CurrencyStringInfo> longNameTrie;
    private final TextTrieMap<Currency.CurrencyStringInfo> symbolTrie;

    public static CombinedCurrencyMatcher getInstance(Currency currency, DecimalFormatSymbols decimalFormatSymbols, int n2) {
        return new CombinedCurrencyMatcher(currency, decimalFormatSymbols, n2);
    }

    private CombinedCurrencyMatcher(Currency currency, DecimalFormatSymbols decimalFormatSymbols, int n2) {
        this.isoCode = currency.getSubtype();
        this.currency1 = currency.getSymbol(decimalFormatSymbols.getULocale());
        this.currency2 = currency.getCurrencyCode();
        this.afterPrefixInsert = decimalFormatSymbols.getPatternForCurrencySpacing(2, false);
        this.beforeSuffixInsert = decimalFormatSymbols.getPatternForCurrencySpacing(2, true);
        if (0 == (n2 & 0x2000)) {
            this.longNameTrie = Currency.getParsingTrie(decimalFormatSymbols.getULocale(), 1);
            this.symbolTrie = Currency.getParsingTrie(decimalFormatSymbols.getULocale(), 0);
            this.localLongNames = null;
        } else {
            this.longNameTrie = null;
            this.symbolTrie = null;
            this.localLongNames = new String[StandardPlural.COUNT];
            for (int i2 = 0; i2 < StandardPlural.COUNT; ++i2) {
                String string = StandardPlural.VALUES.get(i2).getKeyword();
                this.localLongNames[i2] = currency.getName(decimalFormatSymbols.getLocale(), 2, string, null);
            }
        }
    }

    @Override
    public boolean match(StringSegment stringSegment, ParsedNumber parsedNumber) {
        int n2;
        if (parsedNumber.currencyCode != null) {
            return false;
        }
        int n3 = stringSegment.getOffset();
        boolean bl2 = false;
        if (parsedNumber.seenNumber() && !this.beforeSuffixInsert.isEmpty()) {
            n2 = stringSegment.getCommonPrefixLength(this.beforeSuffixInsert);
            if (n2 == this.beforeSuffixInsert.length()) {
                stringSegment.adjustOffset(n2);
            }
            bl2 = bl2 || n2 == stringSegment.length();
        }
        boolean bl3 = bl2 = bl2 || this.matchCurrency(stringSegment, parsedNumber);
        if (parsedNumber.currencyCode == null) {
            stringSegment.setOffset(n3);
            return bl2;
        }
        if (!parsedNumber.seenNumber() && !this.afterPrefixInsert.isEmpty()) {
            n2 = stringSegment.getCommonPrefixLength(this.afterPrefixInsert);
            if (n2 == this.afterPrefixInsert.length()) {
                stringSegment.adjustOffset(n2);
            }
            bl2 = bl2 || n2 == stringSegment.length();
        }
        return bl2;
    }

    private boolean matchCurrency(StringSegment stringSegment, ParsedNumber parsedNumber) {
        boolean bl2 = false;
        int n2 = !this.currency1.isEmpty() ? stringSegment.getCaseSensitivePrefixLength(this.currency1) : -1;
        boolean bl3 = bl2 = bl2 || n2 == stringSegment.length();
        if (n2 == this.currency1.length()) {
            parsedNumber.currencyCode = this.isoCode;
            stringSegment.adjustOffset(n2);
            parsedNumber.setCharsConsumed(stringSegment);
            return bl2;
        }
        int n3 = !this.currency2.isEmpty() ? stringSegment.getCommonPrefixLength(this.currency2) : -1;
        boolean bl4 = bl2 = bl2 || n3 == stringSegment.length();
        if (n3 == this.currency2.length()) {
            parsedNumber.currencyCode = this.isoCode;
            stringSegment.adjustOffset(n3);
            parsedNumber.setCharsConsumed(stringSegment);
            return bl2;
        }
        if (this.longNameTrie != null) {
            TextTrieMap.Output output = new TextTrieMap.Output();
            Iterator<Currency.CurrencyStringInfo> iterator = this.longNameTrie.get(stringSegment, 0, output);
            boolean bl5 = bl2 = bl2 || output.partialMatch;
            if (iterator == null) {
                iterator = this.symbolTrie.get(stringSegment, 0, output);
                boolean bl6 = bl2 = bl2 || output.partialMatch;
            }
            if (iterator != null) {
                parsedNumber.currencyCode = iterator.next().getISOCode();
                stringSegment.adjustOffset(output.matchLength);
                parsedNumber.setCharsConsumed(stringSegment);
                return bl2;
            }
        } else {
            int n4 = 0;
            for (int i2 = 0; i2 < StandardPlural.COUNT; ++i2) {
                String string = this.localLongNames[i2];
                if (string.isEmpty()) continue;
                int n5 = stringSegment.getCommonPrefixLength(string);
                if (n5 == string.length() && string.length() > n4) {
                    n4 = string.length();
                }
                bl2 = bl2 || n5 > 0;
            }
            if (n4 > 0) {
                parsedNumber.currencyCode = this.isoCode;
                stringSegment.adjustOffset(n4);
                parsedNumber.setCharsConsumed(stringSegment);
                return bl2;
            }
        }
        return bl2;
    }

    @Override
    public boolean smokeTest(StringSegment stringSegment) {
        return true;
    }

    @Override
    public void postProcess(ParsedNumber parsedNumber) {
    }

    public String toString() {
        return "<CombinedCurrencyMatcher " + this.isoCode + ">";
    }
}

