/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.number;

import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.AffixPatternProvider;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.AffixUtils;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.DecimalFormatProperties;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.DecimalQuantity_DualStorageBCD;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.Padder;

public class PatternStringParser {
    public static final int IGNORE_ROUNDING_NEVER = 0;
    public static final int IGNORE_ROUNDING_IF_CURRENCY = 1;
    public static final int IGNORE_ROUNDING_ALWAYS = 2;

    public static ParsedPatternInfo parseToPatternInfo(String string) {
        ParserState parserState = new ParserState(string);
        ParsedPatternInfo parsedPatternInfo = new ParsedPatternInfo(string);
        PatternStringParser.consumePattern(parserState, parsedPatternInfo);
        return parsedPatternInfo;
    }

    public static DecimalFormatProperties parseToProperties(String string, int n2) {
        DecimalFormatProperties decimalFormatProperties = new DecimalFormatProperties();
        PatternStringParser.parseToExistingPropertiesImpl(string, decimalFormatProperties, n2);
        return decimalFormatProperties;
    }

    public static DecimalFormatProperties parseToProperties(String string) {
        return PatternStringParser.parseToProperties(string, 0);
    }

    public static void parseToExistingProperties(String string, DecimalFormatProperties decimalFormatProperties, int n2) {
        PatternStringParser.parseToExistingPropertiesImpl(string, decimalFormatProperties, n2);
    }

    public static void parseToExistingProperties(String string, DecimalFormatProperties decimalFormatProperties) {
        PatternStringParser.parseToExistingProperties(string, decimalFormatProperties, 0);
    }

    private static void consumePattern(ParserState parserState, ParsedPatternInfo parsedPatternInfo) {
        parsedPatternInfo.positive = new ParsedSubpatternInfo();
        PatternStringParser.consumeSubpattern(parserState, parsedPatternInfo.positive);
        if (parserState.peek() == 59) {
            parserState.next();
            if (parserState.peek() != -1) {
                parsedPatternInfo.negative = new ParsedSubpatternInfo();
                PatternStringParser.consumeSubpattern(parserState, parsedPatternInfo.negative);
            }
        }
        if (parserState.peek() != -1) {
            throw parserState.toParseException("Found unquoted special character");
        }
    }

    private static void consumeSubpattern(ParserState parserState, ParsedSubpatternInfo parsedSubpatternInfo) {
        PatternStringParser.consumePadding(parserState, parsedSubpatternInfo, Padder.PadPosition.BEFORE_PREFIX);
        parsedSubpatternInfo.prefixEndpoints = PatternStringParser.consumeAffix(parserState, parsedSubpatternInfo);
        PatternStringParser.consumePadding(parserState, parsedSubpatternInfo, Padder.PadPosition.AFTER_PREFIX);
        PatternStringParser.consumeFormat(parserState, parsedSubpatternInfo);
        PatternStringParser.consumeExponent(parserState, parsedSubpatternInfo);
        PatternStringParser.consumePadding(parserState, parsedSubpatternInfo, Padder.PadPosition.BEFORE_SUFFIX);
        parsedSubpatternInfo.suffixEndpoints = PatternStringParser.consumeAffix(parserState, parsedSubpatternInfo);
        PatternStringParser.consumePadding(parserState, parsedSubpatternInfo, Padder.PadPosition.AFTER_SUFFIX);
    }

    private static void consumePadding(ParserState parserState, ParsedSubpatternInfo parsedSubpatternInfo, Padder.PadPosition padPosition) {
        if (parserState.peek() != 42) {
            return;
        }
        if (parsedSubpatternInfo.paddingLocation != null) {
            throw parserState.toParseException("Cannot have multiple pad specifiers");
        }
        parsedSubpatternInfo.paddingLocation = padPosition;
        parserState.next();
        parsedSubpatternInfo.paddingEndpoints |= (long)parserState.offset;
        PatternStringParser.consumeLiteral(parserState);
        parsedSubpatternInfo.paddingEndpoints |= (long)parserState.offset << 32;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static long consumeAffix(ParserState parserState, ParsedSubpatternInfo parsedSubpatternInfo) {
        long l2 = parserState.offset;
        while (true) {
            switch (parserState.peek()) {
                case -1: 
                case 35: 
                case 42: 
                case 44: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 59: 
                case 64: {
                    return l2 |= (long)parserState.offset << 32;
                }
                case 37: {
                    parsedSubpatternInfo.hasPercentSign = true;
                    break;
                }
                case 8240: {
                    parsedSubpatternInfo.hasPerMilleSign = true;
                    break;
                }
                case 164: {
                    parsedSubpatternInfo.hasCurrencySign = true;
                    break;
                }
                case 45: {
                    parsedSubpatternInfo.hasMinusSign = true;
                    break;
                }
                case 43: {
                    parsedSubpatternInfo.hasPlusSign = true;
                }
            }
            PatternStringParser.consumeLiteral(parserState);
        }
    }

    private static void consumeLiteral(ParserState parserState) {
        if (parserState.peek() == -1) {
            throw parserState.toParseException("Expected unquoted literal but found EOL");
        }
        if (parserState.peek() == 39) {
            parserState.next();
            while (parserState.peek() != 39) {
                if (parserState.peek() == -1) {
                    throw parserState.toParseException("Expected quoted literal but found EOL");
                }
                parserState.next();
            }
            parserState.next();
        } else {
            parserState.next();
        }
    }

    private static void consumeFormat(ParserState parserState, ParsedSubpatternInfo parsedSubpatternInfo) {
        PatternStringParser.consumeIntegerFormat(parserState, parsedSubpatternInfo);
        if (parserState.peek() == 46) {
            parserState.next();
            parsedSubpatternInfo.hasDecimal = true;
            ++parsedSubpatternInfo.widthExceptAffixes;
            PatternStringParser.consumeFractionFormat(parserState, parsedSubpatternInfo);
        } else if (parserState.peek() == 164) {
            switch (parserState.peek2()) {
                case 35: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    break;
                }
                default: {
                    return;
                }
            }
            parsedSubpatternInfo.hasCurrencySign = true;
            parsedSubpatternInfo.hasCurrencyDecimal = true;
            parsedSubpatternInfo.hasDecimal = true;
            ++parsedSubpatternInfo.widthExceptAffixes;
            parserState.next();
            PatternStringParser.consumeFractionFormat(parserState, parsedSubpatternInfo);
        }
    }

    private static void consumeIntegerFormat(ParserState parserState, ParsedSubpatternInfo parsedSubpatternInfo) {
        block6: while (true) {
            switch (parserState.peek()) {
                case 44: {
                    ++parsedSubpatternInfo.widthExceptAffixes;
                    parsedSubpatternInfo.groupingSizes <<= 16;
                    break;
                }
                case 35: {
                    if (parsedSubpatternInfo.integerNumerals > 0) {
                        throw parserState.toParseException("# cannot follow 0 before decimal point");
                    }
                    ++parsedSubpatternInfo.widthExceptAffixes;
                    ++parsedSubpatternInfo.groupingSizes;
                    if (parsedSubpatternInfo.integerAtSigns > 0) {
                        ++parsedSubpatternInfo.integerTrailingHashSigns;
                    } else {
                        ++parsedSubpatternInfo.integerLeadingHashSigns;
                    }
                    ++parsedSubpatternInfo.integerTotal;
                    break;
                }
                case 64: {
                    if (parsedSubpatternInfo.integerNumerals > 0) {
                        throw parserState.toParseException("Cannot mix 0 and @");
                    }
                    if (parsedSubpatternInfo.integerTrailingHashSigns > 0) {
                        throw parserState.toParseException("Cannot nest # inside of a run of @");
                    }
                    ++parsedSubpatternInfo.widthExceptAffixes;
                    ++parsedSubpatternInfo.groupingSizes;
                    ++parsedSubpatternInfo.integerAtSigns;
                    ++parsedSubpatternInfo.integerTotal;
                    break;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    if (parsedSubpatternInfo.integerAtSigns > 0) {
                        throw parserState.toParseException("Cannot mix @ and 0");
                    }
                    ++parsedSubpatternInfo.widthExceptAffixes;
                    ++parsedSubpatternInfo.groupingSizes;
                    ++parsedSubpatternInfo.integerNumerals;
                    ++parsedSubpatternInfo.integerTotal;
                    if (parserState.peek() != 48 && parsedSubpatternInfo.rounding == null) {
                        parsedSubpatternInfo.rounding = new DecimalQuantity_DualStorageBCD();
                    }
                    if (parsedSubpatternInfo.rounding == null) break;
                    parsedSubpatternInfo.rounding.appendDigit((byte)(parserState.peek() - 48), 0, true);
                    break;
                }
                default: {
                    break block6;
                }
            }
            parserState.next();
        }
        short s2 = (short)(parsedSubpatternInfo.groupingSizes & 0xFFFFL);
        short s3 = (short)(parsedSubpatternInfo.groupingSizes >>> 16 & 0xFFFFL);
        short s4 = (short)(parsedSubpatternInfo.groupingSizes >>> 32 & 0xFFFFL);
        if (s2 == 0 && s3 != -1) {
            throw parserState.toParseException("Trailing grouping separator is invalid");
        }
        if (s3 == 0 && s4 != -1) {
            throw parserState.toParseException("Grouping width of zero is invalid");
        }
    }

    private static void consumeFractionFormat(ParserState parserState, ParsedSubpatternInfo parsedSubpatternInfo) {
        int n2 = 0;
        while (true) {
            switch (parserState.peek()) {
                case 35: {
                    ++parsedSubpatternInfo.widthExceptAffixes;
                    ++parsedSubpatternInfo.fractionHashSigns;
                    ++parsedSubpatternInfo.fractionTotal;
                    ++n2;
                    break;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    if (parsedSubpatternInfo.fractionHashSigns > 0) {
                        throw parserState.toParseException("0 cannot follow # after decimal point");
                    }
                    ++parsedSubpatternInfo.widthExceptAffixes;
                    ++parsedSubpatternInfo.fractionNumerals;
                    ++parsedSubpatternInfo.fractionTotal;
                    if (parserState.peek() == 48) {
                        ++n2;
                        break;
                    }
                    if (parsedSubpatternInfo.rounding == null) {
                        parsedSubpatternInfo.rounding = new DecimalQuantity_DualStorageBCD();
                    }
                    parsedSubpatternInfo.rounding.appendDigit((byte)(parserState.peek() - 48), n2, false);
                    n2 = 0;
                    break;
                }
                default: {
                    return;
                }
            }
            parserState.next();
        }
    }

    private static void consumeExponent(ParserState parserState, ParsedSubpatternInfo parsedSubpatternInfo) {
        if (parserState.peek() != 69) {
            return;
        }
        if ((parsedSubpatternInfo.groupingSizes & 0xFFFF0000L) != 0xFFFF0000L) {
            throw parserState.toParseException("Cannot have grouping separator in scientific notation");
        }
        parserState.next();
        ++parsedSubpatternInfo.widthExceptAffixes;
        if (parserState.peek() == 43) {
            parserState.next();
            parsedSubpatternInfo.exponentHasPlusSign = true;
            ++parsedSubpatternInfo.widthExceptAffixes;
        }
        while (parserState.peek() == 48) {
            parserState.next();
            ++parsedSubpatternInfo.exponentZeros;
            ++parsedSubpatternInfo.widthExceptAffixes;
        }
    }

    private static void parseToExistingPropertiesImpl(String string, DecimalFormatProperties decimalFormatProperties, int n2) {
        if (string == null || string.length() == 0) {
            decimalFormatProperties.clear();
            return;
        }
        ParsedPatternInfo parsedPatternInfo = PatternStringParser.parseToPatternInfo(string);
        PatternStringParser.patternInfoToProperties(decimalFormatProperties, parsedPatternInfo, n2);
    }

    private static void patternInfoToProperties(DecimalFormatProperties decimalFormatProperties, ParsedPatternInfo parsedPatternInfo, int n2) {
        int n3;
        int n4;
        boolean bl2;
        ParsedSubpatternInfo parsedSubpatternInfo = parsedPatternInfo.positive;
        if (n2 == 0) {
            bl2 = false;
        } else if (n2 == 1) {
            bl2 = parsedSubpatternInfo.hasCurrencySign;
        } else {
            assert (n2 == 2);
            bl2 = true;
        }
        short s2 = (short)(parsedSubpatternInfo.groupingSizes & 0xFFFFL);
        short s3 = (short)(parsedSubpatternInfo.groupingSizes >>> 16 & 0xFFFFL);
        short s4 = (short)(parsedSubpatternInfo.groupingSizes >>> 32 & 0xFFFFL);
        if (s3 != -1) {
            decimalFormatProperties.setGroupingSize(s2);
            decimalFormatProperties.setGroupingUsed(true);
        } else {
            decimalFormatProperties.setGroupingSize(-1);
            decimalFormatProperties.setGroupingUsed(false);
        }
        if (s4 != -1) {
            decimalFormatProperties.setSecondaryGroupingSize(s3);
        } else {
            decimalFormatProperties.setSecondaryGroupingSize(-1);
        }
        if (parsedSubpatternInfo.integerTotal == 0 && parsedSubpatternInfo.fractionTotal > 0) {
            n4 = 0;
            n3 = Math.max(1, parsedSubpatternInfo.fractionNumerals);
        } else if (parsedSubpatternInfo.integerNumerals == 0 && parsedSubpatternInfo.fractionNumerals == 0) {
            n4 = 1;
            n3 = 0;
        } else {
            n4 = parsedSubpatternInfo.integerNumerals;
            n3 = parsedSubpatternInfo.fractionNumerals;
        }
        if (parsedSubpatternInfo.integerAtSigns > 0) {
            decimalFormatProperties.setMinimumFractionDigits(-1);
            decimalFormatProperties.setMaximumFractionDigits(-1);
            decimalFormatProperties.setRoundingIncrement(null);
            decimalFormatProperties.setMinimumSignificantDigits(parsedSubpatternInfo.integerAtSigns);
            decimalFormatProperties.setMaximumSignificantDigits(parsedSubpatternInfo.integerAtSigns + parsedSubpatternInfo.integerTrailingHashSigns);
        } else if (parsedSubpatternInfo.rounding != null) {
            if (!bl2) {
                decimalFormatProperties.setMinimumFractionDigits(n3);
                decimalFormatProperties.setMaximumFractionDigits(parsedSubpatternInfo.fractionTotal);
                decimalFormatProperties.setRoundingIncrement(parsedSubpatternInfo.rounding.toBigDecimal().setScale(parsedSubpatternInfo.fractionNumerals));
            } else {
                decimalFormatProperties.setMinimumFractionDigits(-1);
                decimalFormatProperties.setMaximumFractionDigits(-1);
                decimalFormatProperties.setRoundingIncrement(null);
            }
            decimalFormatProperties.setMinimumSignificantDigits(-1);
            decimalFormatProperties.setMaximumSignificantDigits(-1);
        } else {
            if (!bl2) {
                decimalFormatProperties.setMinimumFractionDigits(n3);
                decimalFormatProperties.setMaximumFractionDigits(parsedSubpatternInfo.fractionTotal);
                decimalFormatProperties.setRoundingIncrement(null);
            } else {
                decimalFormatProperties.setMinimumFractionDigits(-1);
                decimalFormatProperties.setMaximumFractionDigits(-1);
                decimalFormatProperties.setRoundingIncrement(null);
            }
            decimalFormatProperties.setMinimumSignificantDigits(-1);
            decimalFormatProperties.setMaximumSignificantDigits(-1);
        }
        if (parsedSubpatternInfo.hasDecimal && parsedSubpatternInfo.fractionTotal == 0) {
            decimalFormatProperties.setDecimalSeparatorAlwaysShown(true);
        } else {
            decimalFormatProperties.setDecimalSeparatorAlwaysShown(false);
        }
        decimalFormatProperties.setCurrencyAsDecimal(parsedSubpatternInfo.hasCurrencyDecimal);
        if (parsedSubpatternInfo.exponentZeros > 0) {
            decimalFormatProperties.setExponentSignAlwaysShown(parsedSubpatternInfo.exponentHasPlusSign);
            decimalFormatProperties.setMinimumExponentDigits(parsedSubpatternInfo.exponentZeros);
            if (parsedSubpatternInfo.integerAtSigns == 0) {
                decimalFormatProperties.setMinimumIntegerDigits(parsedSubpatternInfo.integerNumerals);
                decimalFormatProperties.setMaximumIntegerDigits(parsedSubpatternInfo.integerTotal);
            } else {
                decimalFormatProperties.setMinimumIntegerDigits(1);
                decimalFormatProperties.setMaximumIntegerDigits(-1);
            }
        } else {
            decimalFormatProperties.setExponentSignAlwaysShown(false);
            decimalFormatProperties.setMinimumExponentDigits(-1);
            decimalFormatProperties.setMinimumIntegerDigits(n4);
            decimalFormatProperties.setMaximumIntegerDigits(-1);
        }
        String string = parsedPatternInfo.getString(256);
        String string2 = parsedPatternInfo.getString(0);
        if (parsedSubpatternInfo.paddingLocation != null) {
            int n5 = parsedSubpatternInfo.widthExceptAffixes + AffixUtils.estimateLength(string) + AffixUtils.estimateLength(string2);
            decimalFormatProperties.setFormatWidth(n5);
            String string3 = parsedPatternInfo.getString(1024);
            if (string3.length() == 1) {
                decimalFormatProperties.setPadString(string3);
            } else if (string3.length() == 2) {
                if (string3.charAt(0) == '\'') {
                    decimalFormatProperties.setPadString("'");
                } else {
                    decimalFormatProperties.setPadString(string3);
                }
            } else {
                decimalFormatProperties.setPadString(string3.substring(1, string3.length() - 1));
            }
            assert (parsedSubpatternInfo.paddingLocation != null);
            decimalFormatProperties.setPadPosition(parsedSubpatternInfo.paddingLocation);
        } else {
            decimalFormatProperties.setFormatWidth(-1);
            decimalFormatProperties.setPadString(null);
            decimalFormatProperties.setPadPosition(null);
        }
        decimalFormatProperties.setPositivePrefixPattern(string);
        decimalFormatProperties.setPositiveSuffixPattern(string2);
        if (parsedPatternInfo.negative != null) {
            decimalFormatProperties.setNegativePrefixPattern(parsedPatternInfo.getString(768));
            decimalFormatProperties.setNegativeSuffixPattern(parsedPatternInfo.getString(512));
        } else {
            decimalFormatProperties.setNegativePrefixPattern(null);
            decimalFormatProperties.setNegativeSuffixPattern(null);
        }
        if (parsedSubpatternInfo.hasPercentSign) {
            decimalFormatProperties.setMagnitudeMultiplier(2);
        } else if (parsedSubpatternInfo.hasPerMilleSign) {
            decimalFormatProperties.setMagnitudeMultiplier(3);
        } else {
            decimalFormatProperties.setMagnitudeMultiplier(0);
        }
    }

    private static class ParserState {
        final String pattern;
        int offset;

        ParserState(String string) {
            this.pattern = string;
            this.offset = 0;
        }

        int peek() {
            if (this.offset == this.pattern.length()) {
                return -1;
            }
            return this.pattern.codePointAt(this.offset);
        }

        int peek2() {
            if (this.offset == this.pattern.length()) {
                return -1;
            }
            int n2 = this.pattern.codePointAt(this.offset);
            int n3 = this.offset + Character.charCount(n2);
            if (n3 == this.pattern.length()) {
                return -1;
            }
            return this.pattern.codePointAt(n3);
        }

        int next() {
            int n2 = this.peek();
            this.offset += Character.charCount(n2);
            return n2;
        }

        IllegalArgumentException toParseException(String string) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Malformed pattern for ICU DecimalFormat: \"");
            stringBuilder.append(this.pattern);
            stringBuilder.append("\": ");
            stringBuilder.append(string);
            stringBuilder.append(" at position ");
            stringBuilder.append(this.offset);
            return new IllegalArgumentException(stringBuilder.toString());
        }
    }

    public static class ParsedSubpatternInfo {
        public long groupingSizes = 0xFFFFFFFF0000L;
        public int integerLeadingHashSigns = 0;
        public int integerTrailingHashSigns = 0;
        public int integerNumerals = 0;
        public int integerAtSigns = 0;
        public int integerTotal = 0;
        public int fractionNumerals = 0;
        public int fractionHashSigns = 0;
        public int fractionTotal = 0;
        public boolean hasDecimal = false;
        public int widthExceptAffixes = 0;
        public Padder.PadPosition paddingLocation = null;
        public DecimalQuantity_DualStorageBCD rounding = null;
        public boolean exponentHasPlusSign = false;
        public int exponentZeros = 0;
        public boolean hasPercentSign = false;
        public boolean hasPerMilleSign = false;
        public boolean hasCurrencySign = false;
        public boolean hasCurrencyDecimal = false;
        public boolean hasMinusSign = false;
        public boolean hasPlusSign = false;
        public long prefixEndpoints = 0L;
        public long suffixEndpoints = 0L;
        public long paddingEndpoints = 0L;
    }

    public static class ParsedPatternInfo
    implements AffixPatternProvider {
        public String pattern;
        public ParsedSubpatternInfo positive;
        public ParsedSubpatternInfo negative;

        private ParsedPatternInfo(String string) {
            this.pattern = string;
        }

        @Override
        public char charAt(int n2, int n3) {
            long l2 = this.getEndpoints(n2);
            int n4 = (int)(l2 & 0xFFFFFFFFFFFFFFFFL);
            int n5 = (int)(l2 >>> 32);
            if (n3 < 0 || n3 >= n5 - n4) {
                throw new IndexOutOfBoundsException();
            }
            return this.pattern.charAt(n4 + n3);
        }

        @Override
        public int length(int n2) {
            return ParsedPatternInfo.getLengthFromEndpoints(this.getEndpoints(n2));
        }

        public static int getLengthFromEndpoints(long l2) {
            int n2 = (int)(l2 & 0xFFFFFFFFFFFFFFFFL);
            int n3 = (int)(l2 >>> 32);
            return n3 - n2;
        }

        @Override
        public String getString(int n2) {
            int n3;
            long l2 = this.getEndpoints(n2);
            int n4 = (int)(l2 & 0xFFFFFFFFFFFFFFFFL);
            if (n4 == (n3 = (int)(l2 >>> 32))) {
                return "";
            }
            return this.pattern.substring(n4, n3);
        }

        private long getEndpoints(int n2) {
            boolean bl2;
            boolean bl3 = (n2 & 0x100) != 0;
            boolean bl4 = (n2 & 0x200) != 0;
            boolean bl5 = bl2 = (n2 & 0x400) != 0;
            if (bl4 && bl2) {
                return this.negative.paddingEndpoints;
            }
            if (bl2) {
                return this.positive.paddingEndpoints;
            }
            if (bl3 && bl4) {
                return this.negative.prefixEndpoints;
            }
            if (bl3) {
                return this.positive.prefixEndpoints;
            }
            if (bl4) {
                return this.negative.suffixEndpoints;
            }
            return this.positive.suffixEndpoints;
        }

        @Override
        public boolean positiveHasPlusSign() {
            return this.positive.hasPlusSign;
        }

        @Override
        public boolean hasNegativeSubpattern() {
            return this.negative != null;
        }

        @Override
        public boolean negativeHasMinusSign() {
            return this.negative.hasMinusSign;
        }

        @Override
        public boolean hasCurrencySign() {
            return this.positive.hasCurrencySign || this.negative != null && this.negative.hasCurrencySign;
        }

        @Override
        public boolean containsSymbolType(int n2) {
            return AffixUtils.containsType(this.pattern, n2);
        }

        @Override
        public boolean hasBody() {
            return this.positive.integerTotal > 0;
        }

        @Override
        public boolean currencyAsDecimal() {
            return this.positive.hasCurrencyDecimal;
        }
    }
}

