/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.number;

import java.text.Format;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.FormattedStringBuilder;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.StandardPlural;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.AdoptingModifierStore;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.AffixPatternProvider;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.AffixUtils;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.ConstantMultiFieldModifier;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.CurrencySpacingEnabledModifier;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.DecimalQuantity;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.MicroProps;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.MicroPropsGenerator;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.Modifier;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.PatternStringUtils;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.RoundingUtils;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.NumberFormatter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.DecimalFormatSymbols;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.NumberFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.PluralRules;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.Currency;

public class MutablePatternModifier
implements AffixUtils.SymbolProvider,
MicroPropsGenerator,
Modifier {
    final boolean isStrong;
    AffixPatternProvider patternInfo;
    NumberFormat.Field field;
    NumberFormatter.SignDisplay signDisplay;
    boolean perMilleReplacesPercent;
    boolean approximately;
    DecimalFormatSymbols symbols;
    NumberFormatter.UnitWidth unitWidth;
    Currency currency;
    PluralRules rules;
    Modifier.Signum signum;
    StandardPlural plural;
    MicroPropsGenerator parent;
    StringBuilder currentAffix;

    public MutablePatternModifier(boolean bl2) {
        this.isStrong = bl2;
    }

    public void setPatternInfo(AffixPatternProvider affixPatternProvider, NumberFormat.Field field) {
        this.patternInfo = affixPatternProvider;
        this.field = field;
    }

    public void setPatternAttributes(NumberFormatter.SignDisplay signDisplay, boolean bl2, boolean bl3) {
        this.signDisplay = signDisplay;
        this.perMilleReplacesPercent = bl2;
        this.approximately = bl3;
    }

    public void setSymbols(DecimalFormatSymbols decimalFormatSymbols, Currency currency, NumberFormatter.UnitWidth unitWidth, PluralRules pluralRules) {
        assert (pluralRules != null == this.needsPlurals());
        this.symbols = decimalFormatSymbols;
        this.currency = currency;
        this.unitWidth = unitWidth;
        this.rules = pluralRules;
    }

    public void setNumberProperties(Modifier.Signum signum, StandardPlural standardPlural) {
        assert (standardPlural != null == this.needsPlurals());
        this.signum = signum;
        this.plural = standardPlural;
    }

    public boolean needsPlurals() {
        return this.patternInfo.containsSymbolType(-8);
    }

    public ImmutablePatternModifier createImmutable() {
        FormattedStringBuilder formattedStringBuilder = new FormattedStringBuilder();
        FormattedStringBuilder formattedStringBuilder2 = new FormattedStringBuilder();
        if (this.needsPlurals()) {
            AdoptingModifierStore adoptingModifierStore = new AdoptingModifierStore();
            for (StandardPlural standardPlural : StandardPlural.VALUES) {
                this.setNumberProperties(Modifier.Signum.POS, standardPlural);
                adoptingModifierStore.setModifier(Modifier.Signum.POS, standardPlural, this.createConstantModifier(formattedStringBuilder, formattedStringBuilder2));
                this.setNumberProperties(Modifier.Signum.POS_ZERO, standardPlural);
                adoptingModifierStore.setModifier(Modifier.Signum.POS_ZERO, standardPlural, this.createConstantModifier(formattedStringBuilder, formattedStringBuilder2));
                this.setNumberProperties(Modifier.Signum.NEG_ZERO, standardPlural);
                adoptingModifierStore.setModifier(Modifier.Signum.NEG_ZERO, standardPlural, this.createConstantModifier(formattedStringBuilder, formattedStringBuilder2));
                this.setNumberProperties(Modifier.Signum.NEG, standardPlural);
                adoptingModifierStore.setModifier(Modifier.Signum.NEG, standardPlural, this.createConstantModifier(formattedStringBuilder, formattedStringBuilder2));
            }
            adoptingModifierStore.freeze();
            return new ImmutablePatternModifier(adoptingModifierStore, this.rules);
        }
        this.setNumberProperties(Modifier.Signum.POS, null);
        ConstantMultiFieldModifier constantMultiFieldModifier = this.createConstantModifier(formattedStringBuilder, formattedStringBuilder2);
        this.setNumberProperties(Modifier.Signum.POS_ZERO, null);
        ConstantMultiFieldModifier constantMultiFieldModifier2 = this.createConstantModifier(formattedStringBuilder, formattedStringBuilder2);
        this.setNumberProperties(Modifier.Signum.NEG_ZERO, null);
        ConstantMultiFieldModifier constantMultiFieldModifier3 = this.createConstantModifier(formattedStringBuilder, formattedStringBuilder2);
        this.setNumberProperties(Modifier.Signum.NEG, null);
        ConstantMultiFieldModifier constantMultiFieldModifier4 = this.createConstantModifier(formattedStringBuilder, formattedStringBuilder2);
        AdoptingModifierStore adoptingModifierStore = new AdoptingModifierStore(constantMultiFieldModifier, constantMultiFieldModifier2, constantMultiFieldModifier3, constantMultiFieldModifier4);
        return new ImmutablePatternModifier(adoptingModifierStore, null);
    }

    private ConstantMultiFieldModifier createConstantModifier(FormattedStringBuilder formattedStringBuilder, FormattedStringBuilder formattedStringBuilder2) {
        this.insertPrefix(formattedStringBuilder.clear(), 0);
        this.insertSuffix(formattedStringBuilder2.clear(), 0);
        if (this.patternInfo.hasCurrencySign()) {
            return new CurrencySpacingEnabledModifier(formattedStringBuilder, formattedStringBuilder2, !this.patternInfo.hasBody(), this.isStrong, this.symbols);
        }
        return new ConstantMultiFieldModifier(formattedStringBuilder, formattedStringBuilder2, !this.patternInfo.hasBody(), this.isStrong);
    }

    public MicroPropsGenerator addToChain(MicroPropsGenerator microPropsGenerator) {
        this.parent = microPropsGenerator;
        return this;
    }

    @Override
    public MicroProps processQuantity(DecimalQuantity decimalQuantity) {
        MicroProps microProps = this.parent.processQuantity(decimalQuantity);
        if (microProps.rounder != null) {
            microProps.rounder.apply(decimalQuantity);
        }
        if (microProps.modMiddle != null) {
            return microProps;
        }
        if (this.needsPlurals()) {
            StandardPlural standardPlural = RoundingUtils.getPluralSafe(microProps.rounder, this.rules, decimalQuantity);
            this.setNumberProperties(decimalQuantity.signum(), standardPlural);
        } else {
            this.setNumberProperties(decimalQuantity.signum(), null);
        }
        microProps.modMiddle = this;
        return microProps;
    }

    @Override
    public int apply(FormattedStringBuilder formattedStringBuilder, int n2, int n3) {
        int n4 = this.insertPrefix(formattedStringBuilder, n2);
        int n5 = this.insertSuffix(formattedStringBuilder, n3 + n4);
        int n6 = 0;
        if (!this.patternInfo.hasBody()) {
            n6 = formattedStringBuilder.splice(n2 + n4, n3 + n4, "", 0, 0, null);
        }
        CurrencySpacingEnabledModifier.applyCurrencySpacing(formattedStringBuilder, n2, n4, n3 + n4 + n6, n5, this.symbols);
        return n4 + n6 + n5;
    }

    @Override
    public int getPrefixLength() {
        this.prepareAffix(true);
        int n2 = AffixUtils.unescapedCount(this.currentAffix, true, this);
        return n2;
    }

    @Override
    public int getCodePointCount() {
        this.prepareAffix(true);
        int n2 = AffixUtils.unescapedCount(this.currentAffix, false, this);
        this.prepareAffix(false);
        return n2 += AffixUtils.unescapedCount(this.currentAffix, false, this);
    }

    @Override
    public boolean isStrong() {
        return this.isStrong;
    }

    @Override
    public boolean containsField(Format.Field field) {
        assert (false);
        return false;
    }

    @Override
    public Modifier.Parameters getParameters() {
        assert (false);
        return null;
    }

    @Override
    public boolean strictEquals(Modifier modifier) {
        assert (false);
        return false;
    }

    private int insertPrefix(FormattedStringBuilder formattedStringBuilder, int n2) {
        this.prepareAffix(true);
        int n3 = AffixUtils.unescape(this.currentAffix, formattedStringBuilder, n2, this, this.field);
        return n3;
    }

    private int insertSuffix(FormattedStringBuilder formattedStringBuilder, int n2) {
        this.prepareAffix(false);
        int n3 = AffixUtils.unescape(this.currentAffix, formattedStringBuilder, n2, this, this.field);
        return n3;
    }

    private void prepareAffix(boolean bl2) {
        if (this.currentAffix == null) {
            this.currentAffix = new StringBuilder();
        }
        PatternStringUtils.patternInfoToStringBuilder(this.patternInfo, bl2, PatternStringUtils.resolveSignDisplay(this.signDisplay, this.signum), this.approximately, this.plural, this.perMilleReplacesPercent, this.currentAffix);
    }

    @Override
    public CharSequence getSymbol(int n2) {
        switch (n2) {
            case -1: {
                return this.symbols.getMinusSignString();
            }
            case -2: {
                return this.symbols.getPlusSignString();
            }
            case -3: {
                return this.symbols.getApproximatelySignString();
            }
            case -4: {
                return this.symbols.getPercentString();
            }
            case -5: {
                return this.symbols.getPerMillString();
            }
            case -6: {
                return this.getCurrencySymbolForUnitWidth();
            }
            case -7: {
                return this.currency.getCurrencyCode();
            }
            case -8: {
                assert (this.plural != null);
                return this.currency.getName(this.symbols.getULocale(), 2, this.plural.getKeyword(), null);
            }
            case -9: {
                return "\ufffd";
            }
            case -10: {
                return this.currency.getName(this.symbols.getULocale(), 3, null);
            }
        }
        throw new AssertionError();
    }

    public String getCurrencySymbolForUnitWidth() {
        int n2;
        if (this.unitWidth == NumberFormatter.UnitWidth.ISO_CODE) {
            return this.currency.getCurrencyCode();
        }
        if (this.unitWidth == NumberFormatter.UnitWidth.HIDDEN) {
            return "";
        }
        switch (this.unitWidth) {
            case SHORT: {
                n2 = 0;
                break;
            }
            case NARROW: {
                n2 = 3;
                break;
            }
            case FORMAL: {
                n2 = 4;
                break;
            }
            case VARIANT: {
                n2 = 5;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return this.currency.getName(this.symbols.getULocale(), n2, null);
    }

    public static class ImmutablePatternModifier
    implements MicroPropsGenerator {
        final AdoptingModifierStore pm;
        final PluralRules rules;
        MicroPropsGenerator parent;

        ImmutablePatternModifier(AdoptingModifierStore adoptingModifierStore, PluralRules pluralRules) {
            this.pm = adoptingModifierStore;
            this.rules = pluralRules;
            this.parent = null;
        }

        public ImmutablePatternModifier addToChain(MicroPropsGenerator microPropsGenerator) {
            this.parent = microPropsGenerator;
            return this;
        }

        @Override
        public MicroProps processQuantity(DecimalQuantity decimalQuantity) {
            MicroProps microProps = this.parent.processQuantity(decimalQuantity);
            if (microProps.rounder != null) {
                microProps.rounder.apply(decimalQuantity);
            }
            if (microProps.modMiddle != null) {
                return microProps;
            }
            this.applyToMicros(microProps, decimalQuantity);
            return microProps;
        }

        public void applyToMicros(MicroProps microProps, DecimalQuantity decimalQuantity) {
            if (this.rules == null) {
                microProps.modMiddle = this.pm.getModifierWithoutPlural(decimalQuantity.signum());
            } else {
                StandardPlural standardPlural = RoundingUtils.getPluralSafe(microProps.rounder, this.rules, decimalQuantity);
                microProps.modMiddle = this.pm.getModifier(decimalQuantity.signum(), standardPlural);
            }
        }
    }
}

