/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.number;

import java.math.BigInteger;
import java.util.Arrays;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.DecimalQuantity;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.DecimalQuantity_AbstractBCD;
import macromedia.jdbc.db2.externals.com.ibm.icu.math.BigDecimal;

public final class DecimalQuantity_DualStorageBCD
extends DecimalQuantity_AbstractBCD {
    private byte[] bcdBytes;
    private long bcdLong = 0L;
    private boolean usingBytes = false;

    @Override
    public int maxRepresentableDigits() {
        return Integer.MAX_VALUE;
    }

    public DecimalQuantity_DualStorageBCD() {
        this.setBcdToZero();
        this.flags = 0;
    }

    public DecimalQuantity_DualStorageBCD(long l2) {
        this.setToLong(l2);
    }

    public DecimalQuantity_DualStorageBCD(int n2) {
        this.setToInt(n2);
    }

    public DecimalQuantity_DualStorageBCD(double d2) {
        this.setToDouble(d2);
    }

    public DecimalQuantity_DualStorageBCD(BigInteger bigInteger) {
        this.setToBigInteger(bigInteger);
    }

    public DecimalQuantity_DualStorageBCD(java.math.BigDecimal bigDecimal) {
        this.setToBigDecimal(bigDecimal);
    }

    public DecimalQuantity_DualStorageBCD(DecimalQuantity_DualStorageBCD decimalQuantity_DualStorageBCD) {
        this.copyFrom(decimalQuantity_DualStorageBCD);
    }

    public DecimalQuantity_DualStorageBCD(Number number) {
        if (number instanceof Long) {
            this.setToLong(number.longValue());
        } else if (number instanceof Integer) {
            this.setToInt(number.intValue());
        } else if (number instanceof Float) {
            this.setToDouble(number.doubleValue());
        } else if (number instanceof Double) {
            this.setToDouble(number.doubleValue());
        } else if (number instanceof BigInteger) {
            this.setToBigInteger((BigInteger)number);
        } else if (number instanceof java.math.BigDecimal) {
            this.setToBigDecimal((java.math.BigDecimal)number);
        } else if (number instanceof BigDecimal) {
            this.setToBigDecimal(((BigDecimal)number).toBigDecimal());
        } else {
            throw new IllegalArgumentException("Number is of an unsupported type: " + number.getClass().getName());
        }
    }

    @Override
    public DecimalQuantity createCopy() {
        return new DecimalQuantity_DualStorageBCD(this);
    }

    public static DecimalQuantity fromExponentString(String string) {
        if (string.contains("e") || string.contains("c") || string.contains("E") || string.contains("C")) {
            int n2 = string.lastIndexOf(101);
            if (n2 < 0) {
                n2 = string.lastIndexOf(99);
            }
            if (n2 < 0) {
                n2 = string.lastIndexOf(69);
            }
            if (n2 < 0) {
                n2 = string.lastIndexOf(67);
            }
            int n3 = n2 + 1;
            String string2 = string.substring(n3);
            int n4 = Integer.parseInt(string2);
            String string3 = string.substring(0, n2);
            java.math.BigDecimal bigDecimal = new java.math.BigDecimal(string3);
            DecimalQuantity_DualStorageBCD decimalQuantity_DualStorageBCD = new DecimalQuantity_DualStorageBCD(bigDecimal);
            int n5 = DecimalQuantity_DualStorageBCD.getVisibleFractionCount(string3);
            decimalQuantity_DualStorageBCD.setMinFraction(n5);
            decimalQuantity_DualStorageBCD.adjustExponent(n4);
            return decimalQuantity_DualStorageBCD;
        }
        int n6 = DecimalQuantity_DualStorageBCD.getVisibleFractionCount(string);
        DecimalQuantity_DualStorageBCD decimalQuantity_DualStorageBCD = new DecimalQuantity_DualStorageBCD(new java.math.BigDecimal(string));
        decimalQuantity_DualStorageBCD.setMinFraction(n6);
        return decimalQuantity_DualStorageBCD;
    }

    private static int getVisibleFractionCount(String string) {
        int n2 = string.indexOf(46) + 1;
        if (n2 == 0) {
            return 0;
        }
        return string.length() - n2;
    }

    @Override
    protected byte getDigitPos(int n2) {
        if (this.usingBytes) {
            if (n2 < 0 || n2 >= this.precision) {
                return 0;
            }
            return this.bcdBytes[n2];
        }
        if (n2 < 0 || n2 >= 16) {
            return 0;
        }
        return (byte)(this.bcdLong >>> n2 * 4 & 0xFL);
    }

    @Override
    protected void setDigitPos(int n2, byte by2) {
        assert (n2 >= 0);
        if (this.usingBytes) {
            this.ensureCapacity(n2 + 1);
            this.bcdBytes[n2] = by2;
        } else if (n2 >= 16) {
            this.switchStorage();
            this.ensureCapacity(n2 + 1);
            this.bcdBytes[n2] = by2;
        } else {
            int n3 = n2 * 4;
            this.bcdLong = this.bcdLong & (15L << n3 ^ 0xFFFFFFFFFFFFFFFFL) | (long)by2 << n3;
        }
    }

    @Override
    protected void shiftLeft(int n2) {
        if (!this.usingBytes && this.precision + n2 > 16) {
            this.switchStorage();
        }
        if (this.usingBytes) {
            this.ensureCapacity(this.precision + n2);
            System.arraycopy(this.bcdBytes, 0, this.bcdBytes, n2, this.precision);
            Arrays.fill(this.bcdBytes, 0, n2, (byte)0);
        } else {
            this.bcdLong <<= n2 * 4;
        }
        this.scale -= n2;
        this.precision += n2;
    }

    @Override
    protected void shiftRight(int n2) {
        if (this.usingBytes) {
            int n3;
            for (n3 = 0; n3 < this.precision - n2; ++n3) {
                this.bcdBytes[n3] = this.bcdBytes[n3 + n2];
            }
            while (n3 < this.precision) {
                this.bcdBytes[n3] = 0;
                ++n3;
            }
        } else {
            this.bcdLong >>>= n2 * 4;
        }
        this.scale += n2;
        this.precision -= n2;
    }

    @Override
    protected void popFromLeft(int n2) {
        assert (n2 <= this.precision);
        if (this.usingBytes) {
            for (int i2 = this.precision - 1; i2 >= this.precision - n2; --i2) {
                this.bcdBytes[i2] = 0;
            }
        } else {
            this.bcdLong &= (1L << (this.precision - n2) * 4) - 1L;
        }
        this.precision -= n2;
    }

    @Override
    protected void setBcdToZero() {
        if (this.usingBytes) {
            this.bcdBytes = null;
            this.usingBytes = false;
        }
        this.bcdLong = 0L;
        this.scale = 0;
        this.precision = 0;
        this.isApproximate = false;
        this.origDouble = 0.0;
        this.origDelta = 0;
        this.exponent = 0;
    }

    @Override
    protected void readIntToBcd(int n2) {
        assert (n2 != 0);
        long l2 = 0L;
        int n3 = 16;
        while (n2 != 0) {
            l2 = (l2 >>> 4) + ((long)n2 % 10L << 60);
            n2 /= 10;
            --n3;
        }
        assert (!this.usingBytes);
        this.bcdLong = l2 >>> n3 * 4;
        this.scale = 0;
        this.precision = 16 - n3;
    }

    @Override
    protected void readLongToBcd(long l2) {
        assert (l2 != 0L);
        if (l2 >= 10000000000000000L) {
            this.ensureCapacity();
            int n2 = 0;
            while (l2 != 0L) {
                this.bcdBytes[n2] = (byte)(l2 % 10L);
                l2 /= 10L;
                ++n2;
            }
            assert (this.usingBytes);
            this.scale = 0;
            this.precision = n2;
        } else {
            long l3 = 0L;
            int n3 = 16;
            while (l2 != 0L) {
                l3 = (l3 >>> 4) + (l2 % 10L << 60);
                l2 /= 10L;
                --n3;
            }
            assert (n3 >= 0);
            assert (!this.usingBytes);
            this.bcdLong = l3 >>> n3 * 4;
            this.scale = 0;
            this.precision = 16 - n3;
        }
    }

    @Override
    protected void readBigIntegerToBcd(BigInteger bigInteger) {
        assert (bigInteger.signum() != 0);
        this.ensureCapacity();
        int n2 = 0;
        while (bigInteger.signum() != 0) {
            BigInteger[] bigIntegerArray = bigInteger.divideAndRemainder(BigInteger.TEN);
            this.ensureCapacity(n2 + 1);
            this.bcdBytes[n2] = bigIntegerArray[1].byteValue();
            bigInteger = bigIntegerArray[0];
            ++n2;
        }
        this.scale = 0;
        this.precision = n2;
    }

    @Override
    protected java.math.BigDecimal bcdToBigDecimal() {
        if (this.usingBytes) {
            java.math.BigDecimal bigDecimal = new java.math.BigDecimal(this.toNumberString());
            if (this.isNegative()) {
                bigDecimal = bigDecimal.negate();
            }
            return bigDecimal;
        }
        long l2 = 0L;
        for (int i2 = this.precision - 1; i2 >= 0; --i2) {
            l2 = l2 * 10L + (long)this.getDigitPos(i2);
        }
        java.math.BigDecimal bigDecimal = java.math.BigDecimal.valueOf(l2);
        long l3 = bigDecimal.scale() + this.scale + this.exponent;
        bigDecimal = l3 <= Integer.MIN_VALUE ? java.math.BigDecimal.ZERO : bigDecimal.scaleByPowerOfTen(this.scale + this.exponent);
        if (this.isNegative()) {
            bigDecimal = bigDecimal.negate();
        }
        return bigDecimal;
    }

    @Override
    protected void compact() {
        if (this.usingBytes) {
            int n2;
            int n3;
            for (n3 = 0; n3 < this.precision && this.bcdBytes[n3] == 0; ++n3) {
            }
            if (n3 == this.precision) {
                this.setBcdToZero();
                return;
            }
            this.shiftRight(n3);
            for (n2 = this.precision - 1; n2 >= 0 && this.bcdBytes[n2] == 0; --n2) {
            }
            this.precision = n2 + 1;
            if (this.precision <= 16) {
                this.switchStorage();
            }
        } else {
            if (this.bcdLong == 0L) {
                this.setBcdToZero();
                return;
            }
            int n4 = Long.numberOfTrailingZeros(this.bcdLong) / 4;
            this.bcdLong >>>= n4 * 4;
            this.scale += n4;
            this.precision = 16 - Long.numberOfLeadingZeros(this.bcdLong) / 4;
        }
    }

    private void ensureCapacity() {
        this.ensureCapacity(40);
    }

    private void ensureCapacity(int n2) {
        int n3;
        if (n2 == 0) {
            return;
        }
        int n4 = n3 = this.usingBytes ? this.bcdBytes.length : 0;
        if (!this.usingBytes) {
            this.bcdBytes = new byte[n2];
        } else if (n3 < n2) {
            byte[] byArray = new byte[n2 * 2];
            System.arraycopy(this.bcdBytes, 0, byArray, 0, n3);
            this.bcdBytes = byArray;
        }
        this.usingBytes = true;
    }

    private void switchStorage() {
        if (this.usingBytes) {
            this.bcdLong = 0L;
            for (int i2 = this.precision - 1; i2 >= 0; --i2) {
                this.bcdLong <<= 4;
                this.bcdLong |= (long)this.bcdBytes[i2];
            }
            this.bcdBytes = null;
            this.usingBytes = false;
        } else {
            this.ensureCapacity();
            for (int i3 = 0; i3 < this.precision; ++i3) {
                this.bcdBytes[i3] = (byte)(this.bcdLong & 0xFL);
                this.bcdLong >>>= 4;
            }
            assert (this.usingBytes);
        }
    }

    @Override
    protected void copyBcdFrom(DecimalQuantity decimalQuantity) {
        DecimalQuantity_DualStorageBCD decimalQuantity_DualStorageBCD = (DecimalQuantity_DualStorageBCD)decimalQuantity;
        this.setBcdToZero();
        if (decimalQuantity_DualStorageBCD.usingBytes) {
            this.ensureCapacity(decimalQuantity_DualStorageBCD.precision);
            System.arraycopy(decimalQuantity_DualStorageBCD.bcdBytes, 0, this.bcdBytes, 0, decimalQuantity_DualStorageBCD.precision);
        } else {
            this.bcdLong = decimalQuantity_DualStorageBCD.bcdLong;
        }
    }

    @Deprecated
    public String checkHealth() {
        if (this.usingBytes) {
            int n2;
            if (this.bcdLong != 0L) {
                return "Value in bcdLong but we are in byte mode";
            }
            if (this.precision == 0) {
                return "Zero precision but we are in byte mode";
            }
            if (this.precision > this.bcdBytes.length) {
                return "Precision exceeds length of byte array";
            }
            if (this.getDigitPos(this.precision - 1) == 0) {
                return "Most significant digit is zero in byte mode";
            }
            if (this.getDigitPos(0) == 0) {
                return "Least significant digit is zero in long mode";
            }
            for (n2 = 0; n2 < this.precision; ++n2) {
                if (this.getDigitPos(n2) >= 10) {
                    return "Digit exceeding 10 in byte array";
                }
                if (this.getDigitPos(n2) >= 0) continue;
                return "Digit below 0 in byte array";
            }
            for (n2 = this.precision; n2 < this.bcdBytes.length; ++n2) {
                if (this.getDigitPos(n2) == 0) continue;
                return "Nonzero digits outside of range in byte array";
            }
        } else {
            int n3;
            if (this.bcdBytes != null) {
                for (n3 = 0; n3 < this.bcdBytes.length; ++n3) {
                    if (this.bcdBytes[n3] == 0) continue;
                    return "Nonzero digits in byte array but we are in long mode";
                }
            }
            if (this.precision == 0 && this.bcdLong != 0L) {
                return "Value in bcdLong even though precision is zero";
            }
            if (this.precision > 16) {
                return "Precision exceeds length of long";
            }
            if (this.precision != 0 && this.getDigitPos(this.precision - 1) == 0) {
                return "Most significant digit is zero in long mode";
            }
            if (this.precision != 0 && this.getDigitPos(0) == 0) {
                return "Least significant digit is zero in long mode";
            }
            for (n3 = 0; n3 < this.precision; ++n3) {
                if (this.getDigitPos(n3) >= 10) {
                    return "Digit exceeding 10 in long";
                }
                if (this.getDigitPos(n3) >= 0) continue;
                return "Digit below 0 in long (?!)";
            }
            for (n3 = this.precision; n3 < 16; ++n3) {
                if (this.getDigitPos(n3) == 0) continue;
                return "Nonzero digits outside of range in long";
            }
        }
        return null;
    }

    @Deprecated
    public boolean isUsingBytes() {
        return this.usingBytes;
    }

    public String toString() {
        return String.format("<DecimalQuantity %d:%d %s %s%s>", this.lReqPos, this.rReqPos, this.usingBytes ? "bytes" : "long", this.isNegative() ? "-" : "", this.toNumberString());
    }

    private String toNumberString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.usingBytes) {
            if (this.precision == 0) {
                stringBuilder.append('0');
            }
            for (int i2 = this.precision - 1; i2 >= 0; --i2) {
                stringBuilder.append(this.bcdBytes[i2]);
            }
        } else {
            stringBuilder.append(Long.toHexString(this.bcdLong));
        }
        stringBuilder.append("E");
        stringBuilder.append(this.scale);
        return stringBuilder.toString();
    }
}

