/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll;

import java.util.Arrays;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationData;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.SharedObject;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.UVector32;

public final class CollationSettings
extends SharedObject {
    public static final int CHECK_FCD = 1;
    public static final int NUMERIC = 2;
    static final int SHIFTED = 4;
    static final int ALTERNATE_MASK = 12;
    static final int MAX_VARIABLE_SHIFT = 4;
    static final int MAX_VARIABLE_MASK = 112;
    static final int UPPER_FIRST = 256;
    public static final int CASE_FIRST = 512;
    public static final int CASE_FIRST_AND_UPPER_MASK = 768;
    public static final int CASE_LEVEL = 1024;
    public static final int BACKWARD_SECONDARY = 2048;
    static final int STRENGTH_SHIFT = 12;
    static final int STRENGTH_MASK = 61440;
    static final int MAX_VAR_SPACE = 0;
    static final int MAX_VAR_PUNCT = 1;
    static final int MAX_VAR_SYMBOL = 2;
    static final int MAX_VAR_CURRENCY = 3;
    public int options = 8208;
    public long variableTop;
    public byte[] reorderTable;
    long minHighNoReorder;
    long[] reorderRanges;
    public int[] reorderCodes = EMPTY_INT_ARRAY;
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    public int fastLatinOptions = -1;
    public char[] fastLatinPrimaries = new char[384];

    CollationSettings() {
    }

    @Override
    public CollationSettings clone() {
        CollationSettings collationSettings = (CollationSettings)super.clone();
        collationSettings.fastLatinPrimaries = (char[])this.fastLatinPrimaries.clone();
        return collationSettings;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!this.getClass().equals(object.getClass())) {
            return false;
        }
        CollationSettings collationSettings = (CollationSettings)object;
        if (this.options != collationSettings.options) {
            return false;
        }
        if ((this.options & 0xC) != 0 && this.variableTop != collationSettings.variableTop) {
            return false;
        }
        return Arrays.equals(this.reorderCodes, collationSettings.reorderCodes);
    }

    public int hashCode() {
        int n2 = this.options << 8;
        if ((this.options & 0xC) != 0) {
            n2 = (int)((long)n2 ^ this.variableTop);
        }
        n2 ^= this.reorderCodes.length;
        for (int i2 = 0; i2 < this.reorderCodes.length; ++i2) {
            n2 ^= this.reorderCodes[i2] << i2;
        }
        return n2;
    }

    public void resetReordering() {
        this.reorderTable = null;
        this.minHighNoReorder = 0L;
        this.reorderRanges = null;
        this.reorderCodes = EMPTY_INT_ARRAY;
    }

    void aliasReordering(CollationData collationData, int[] nArray, int n2, byte[] byArray) {
        int[] nArray2 = n2 == nArray.length ? nArray : Arrays.copyOf(nArray, n2);
        int n3 = n2;
        int n4 = nArray.length;
        int n5 = n4 - n3;
        if (byArray != null && (n5 == 0 ? !CollationSettings.reorderTableHasSplitBytes(byArray) : n5 >= 2 && (nArray[n3] & 0xFFFF) == 0 && (nArray[n4 - 1] & 0xFFFF) != 0)) {
            int n6;
            this.reorderTable = byArray;
            this.reorderCodes = nArray2;
            for (n6 = n3; n6 < n4 && (nArray[n6] & 0xFF0000) == 0; ++n6) {
            }
            if (n6 == n4) {
                assert (!CollationSettings.reorderTableHasSplitBytes(byArray));
                this.minHighNoReorder = 0L;
                this.reorderRanges = null;
            } else {
                assert (byArray[nArray[n6] >>> 24] == 0);
                this.minHighNoReorder = (long)nArray[n4 - 1] & 0xFFFF0000L;
                this.setReorderRanges(nArray, n6, n4 - n6);
            }
            return;
        }
        this.setReordering(collationData, nArray2);
    }

    public void setReordering(CollationData collationData, int[] nArray) {
        int n2;
        if (nArray.length == 0 || nArray.length == 1 && nArray[0] == 103) {
            this.resetReordering();
            return;
        }
        UVector32 uVector32 = new UVector32();
        collationData.makeReorderRanges(nArray, uVector32);
        int n3 = uVector32.size();
        if (n3 == 0) {
            this.resetReordering();
            return;
        }
        int[] nArray2 = uVector32.getBuffer();
        assert (n3 >= 2);
        assert ((nArray2[0] & 0xFFFF) == 0 && (nArray2[n3 - 1] & 0xFFFF) != 0);
        this.minHighNoReorder = (long)nArray2[n3 - 1] & 0xFFFF0000L;
        byte[] byArray = new byte[256];
        int n4 = 0;
        int n5 = -1;
        for (n2 = 0; n2 < n3; ++n2) {
            int n6 = nArray2[n2];
            int n7 = n6 >>> 24;
            while (n4 < n7) {
                byArray[n4] = (byte)(n4 + n6);
                ++n4;
            }
            if ((n6 & 0xFF0000) == 0) continue;
            byArray[n7] = 0;
            n4 = n7 + 1;
            if (n5 >= 0) continue;
            n5 = n2;
        }
        while (n4 <= 255) {
            byArray[n4] = (byte)n4;
            ++n4;
        }
        if (n5 < 0) {
            n3 = 0;
            n2 = 0;
        } else {
            n2 = n5;
            n3 -= n5;
        }
        this.setReorderArrays(nArray, nArray2, n2, n3, byArray);
    }

    private void setReorderArrays(int[] nArray, int[] nArray2, int n2, int n3, byte[] byArray) {
        if (nArray == null) {
            nArray = EMPTY_INT_ARRAY;
        }
        assert (nArray.length == 0 == (byArray == null));
        this.reorderTable = byArray;
        this.reorderCodes = nArray;
        this.setReorderRanges(nArray2, n2, n3);
    }

    private void setReorderRanges(int[] nArray, int n2, int n3) {
        if (n3 == 0) {
            this.reorderRanges = null;
        } else {
            this.reorderRanges = new long[n3];
            int n4 = 0;
            do {
                this.reorderRanges[n4++] = (long)nArray[n2++] & 0xFFFFFFFFL;
            } while (n4 < n3);
        }
    }

    public void copyReorderingFrom(CollationSettings collationSettings) {
        if (!collationSettings.hasReordering()) {
            this.resetReordering();
            return;
        }
        this.minHighNoReorder = collationSettings.minHighNoReorder;
        this.reorderTable = collationSettings.reorderTable;
        this.reorderRanges = collationSettings.reorderRanges;
        this.reorderCodes = collationSettings.reorderCodes;
    }

    public boolean hasReordering() {
        return this.reorderTable != null;
    }

    private static boolean reorderTableHasSplitBytes(byte[] byArray) {
        assert (byArray[0] == 0);
        for (int i2 = 1; i2 < 256; ++i2) {
            if (byArray[i2] != 0) continue;
            return true;
        }
        return false;
    }

    public long reorder(long l2) {
        byte by2 = this.reorderTable[(int)l2 >>> 24];
        if (by2 != 0 || l2 <= 1L) {
            return ((long)by2 & 0xFFL) << 24 | l2 & 0xFFFFFFL;
        }
        return this.reorderEx(l2);
    }

    private long reorderEx(long l2) {
        long l3;
        assert (this.minHighNoReorder > 0L);
        if (l2 >= this.minHighNoReorder) {
            return l2;
        }
        long l4 = l2 | 0xFFFFL;
        int n2 = 0;
        while (l4 >= (l3 = this.reorderRanges[n2])) {
            ++n2;
        }
        return l2 + ((long)((short)l3) << 24);
    }

    public void setStrength(int n2) {
        int n3 = this.options & 0xFFFF0FFF;
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 15: {
                this.options = n3 | n2 << 12;
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal strength value " + n2);
            }
        }
    }

    public void setStrengthDefault(int n2) {
        int n3 = this.options & 0xFFFF0FFF;
        this.options = n3 | n2 & 0xF000;
    }

    static int getStrength(int n2) {
        return n2 >> 12;
    }

    public int getStrength() {
        return CollationSettings.getStrength(this.options);
    }

    public void setFlag(int n2, boolean bl2) {
        this.options = bl2 ? (this.options |= n2) : (this.options &= ~n2);
    }

    public void setFlagDefault(int n2, int n3) {
        this.options = this.options & ~n2 | n3 & n2;
    }

    public boolean getFlag(int n2) {
        return (this.options & n2) != 0;
    }

    public void setCaseFirst(int n2) {
        assert (n2 == 0 || n2 == 512 || n2 == 768);
        int n3 = this.options & 0xFFFFFCFF;
        this.options = n3 | n2;
    }

    public void setCaseFirstDefault(int n2) {
        int n3 = this.options & 0xFFFFFCFF;
        this.options = n3 | n2 & 0x300;
    }

    public int getCaseFirst() {
        return this.options & 0x300;
    }

    public void setAlternateHandlingShifted(boolean bl2) {
        int n2 = this.options & 0xFFFFFFF3;
        this.options = bl2 ? n2 | 4 : n2;
    }

    public void setAlternateHandlingDefault(int n2) {
        int n3 = this.options & 0xFFFFFFF3;
        this.options = n3 | n2 & 0xC;
    }

    public boolean getAlternateHandling() {
        return (this.options & 0xC) != 0;
    }

    public void setMaxVariable(int n2, int n3) {
        int n4 = this.options & 0xFFFFFF8F;
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.options = n4 | n2 << 4;
                break;
            }
            case -1: {
                this.options = n4 | n3 & 0x70;
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal maxVariable value " + n2);
            }
        }
    }

    public int getMaxVariable() {
        return (this.options & 0x70) >> 4;
    }

    static boolean isTertiaryWithCaseBits(int n2) {
        return (n2 & 0x600) == 512;
    }

    static int getTertiaryMask(int n2) {
        return CollationSettings.isTertiaryWithCaseBits(n2) ? 65343 : 16191;
    }

    static boolean sortsTertiaryUpperCaseFirst(int n2) {
        return (n2 & 0x700) == 768;
    }

    public boolean dontCheckFCD() {
        return (this.options & 1) == 0;
    }

    boolean hasBackwardSecondary() {
        return (this.options & 0x800) != 0;
    }

    public boolean isNumeric() {
        return (this.options & 2) != 0;
    }
}

