/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll;

import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Trie2_32;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.Collation;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationData;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationFCD;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.UVector32;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.BytesTrie;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.CharsTrie;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ICUException;

public abstract class CollationIterator {
    protected static final long NO_CP_AND_CE32 = -4294967104L;
    protected final Trie2_32 trie;
    protected final CollationData data;
    private CEBuffer ceBuffer;
    private int cesIndex;
    private SkippedState skipped;
    private int numCpFwd;
    private boolean isNumeric;

    public CollationIterator(CollationData collationData) {
        this.trie = collationData.trie;
        this.data = collationData;
        this.numCpFwd = -1;
        this.isNumeric = false;
        this.ceBuffer = null;
    }

    public CollationIterator(CollationData collationData, boolean bl2) {
        this.trie = collationData.trie;
        this.data = collationData;
        this.numCpFwd = -1;
        this.isNumeric = bl2;
        this.ceBuffer = new CEBuffer();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!this.getClass().equals(object.getClass())) {
            return false;
        }
        CollationIterator collationIterator = (CollationIterator)object;
        if (this.ceBuffer.length != collationIterator.ceBuffer.length || this.cesIndex != collationIterator.cesIndex || this.numCpFwd != collationIterator.numCpFwd || this.isNumeric != collationIterator.isNumeric) {
            return false;
        }
        for (int i2 = 0; i2 < this.ceBuffer.length; ++i2) {
            if (this.ceBuffer.get(i2) == collationIterator.ceBuffer.get(i2)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return 0;
    }

    public abstract void resetToOffset(int var1);

    public abstract int getOffset();

    public final long nextCE() {
        CollationData collationData;
        if (this.cesIndex < this.ceBuffer.length) {
            return this.ceBuffer.get(this.cesIndex++);
        }
        assert (this.cesIndex == this.ceBuffer.length);
        this.ceBuffer.incLength();
        long l2 = this.handleNextCE32();
        int n2 = (int)(l2 >> 32);
        int n3 = (int)l2;
        int n4 = n3 & 0xFF;
        if (n4 < 192) {
            return this.ceBuffer.set(this.cesIndex++, (long)(n3 & 0xFFFF0000) << 32 | (long)(n3 & 0xFF00) << 16 | (long)(n4 << 8));
        }
        if (n4 == 192) {
            if (n2 < 0) {
                return this.ceBuffer.set(this.cesIndex++, 0x101000100L);
            }
            collationData = this.data.base;
            n3 = collationData.getCE32(n2);
            n4 = n3 & 0xFF;
            if (n4 < 192) {
                return this.ceBuffer.set(this.cesIndex++, (long)(n3 & 0xFFFF0000) << 32 | (long)(n3 & 0xFF00) << 16 | (long)(n4 << 8));
            }
        } else {
            collationData = this.data;
        }
        if (n4 == 193) {
            return this.ceBuffer.set(this.cesIndex++, (long)(n3 - n4) << 32 | 0x5000500L);
        }
        return this.nextCEFromCE32(collationData, n2, n3);
    }

    public final int fetchCEs() {
        while (this.nextCE() != 0x101000100L) {
            this.cesIndex = this.ceBuffer.length;
        }
        return this.ceBuffer.length;
    }

    final void setCurrentCE(long l2) {
        assert (this.cesIndex > 0);
        this.ceBuffer.set(this.cesIndex - 1, l2);
    }

    public final long previousCE(UVector32 uVector32) {
        CollationData collationData;
        if (this.ceBuffer.length > 0) {
            return this.ceBuffer.get(--this.ceBuffer.length);
        }
        uVector32.removeAllElements();
        int n2 = this.getOffset();
        int n3 = this.previousCodePoint();
        if (n3 < 0) {
            return 0x101000100L;
        }
        if (this.data.isUnsafeBackward(n3, this.isNumeric)) {
            return this.previousCEUnsafe(n3, uVector32);
        }
        int n4 = this.data.getCE32(n3);
        if (n4 == 192) {
            collationData = this.data.base;
            n4 = collationData.getCE32(n3);
        } else {
            collationData = this.data;
        }
        if (Collation.isSimpleOrLongCE32(n4)) {
            return Collation.ceFromCE32(n4);
        }
        this.appendCEsFromCE32(collationData, n3, n4, false);
        if (this.ceBuffer.length > 1) {
            uVector32.addElement(this.getOffset());
            while (uVector32.size() <= this.ceBuffer.length) {
                uVector32.addElement(n2);
            }
        }
        return this.ceBuffer.get(--this.ceBuffer.length);
    }

    public final int getCEsLength() {
        return this.ceBuffer.length;
    }

    public final long getCE(int n2) {
        return this.ceBuffer.get(n2);
    }

    public final long[] getCEs() {
        return this.ceBuffer.getCEs();
    }

    final void clearCEs() {
        this.ceBuffer.length = 0;
        this.cesIndex = 0;
    }

    public final void clearCEsIfNoneRemaining() {
        if (this.cesIndex == this.ceBuffer.length) {
            this.clearCEs();
        }
    }

    public abstract int nextCodePoint();

    public abstract int previousCodePoint();

    protected final void reset() {
        this.ceBuffer.length = 0;
        this.cesIndex = 0;
        if (this.skipped != null) {
            this.skipped.clear();
        }
    }

    protected final void reset(boolean bl2) {
        if (this.ceBuffer == null) {
            this.ceBuffer = new CEBuffer();
        }
        this.reset();
        this.isNumeric = bl2;
    }

    protected long handleNextCE32() {
        int n2 = this.nextCodePoint();
        if (n2 < 0) {
            return -4294967104L;
        }
        return this.makeCodePointAndCE32Pair(n2, this.data.getCE32(n2));
    }

    protected long makeCodePointAndCE32Pair(int n2, int n3) {
        return (long)n2 << 32 | (long)n3 & 0xFFFFFFFFL;
    }

    protected char handleGetTrailSurrogate() {
        return '\u0000';
    }

    protected boolean forbidSurrogateCodePoints() {
        return false;
    }

    protected abstract void forwardNumCodePoints(int var1);

    protected abstract void backwardNumCodePoints(int var1);

    protected int getDataCE32(int n2) {
        return this.data.getCE32(n2);
    }

    protected int getCE32FromBuilderData(int n2) {
        throw new ICUException("internal program error: should be unreachable");
    }

    protected final void appendCEsFromCE32(CollationData collationData, int n2, int n3, boolean bl2) {
        while (Collation.isSpecialCE32(n3)) {
            switch (Collation.tagFromCE32(n3)) {
                case 0: 
                case 3: {
                    throw new ICUException("internal program error: should be unreachable");
                }
                case 1: {
                    this.ceBuffer.append(Collation.ceFromLongPrimaryCE32(n3));
                    return;
                }
                case 2: {
                    this.ceBuffer.append(Collation.ceFromLongSecondaryCE32(n3));
                    return;
                }
                case 4: {
                    this.ceBuffer.ensureAppendCapacity(2);
                    this.ceBuffer.set(this.ceBuffer.length, Collation.latinCE0FromCE32(n3));
                    this.ceBuffer.set(this.ceBuffer.length + 1, Collation.latinCE1FromCE32(n3));
                    this.ceBuffer.length += 2;
                    return;
                }
                case 5: {
                    int n4 = Collation.indexFromCE32(n3);
                    int n5 = Collation.lengthFromCE32(n3);
                    this.ceBuffer.ensureAppendCapacity(n5);
                    do {
                        this.ceBuffer.appendUnsafe(Collation.ceFromCE32(collationData.ce32s[n4++]));
                    } while (--n5 > 0);
                    return;
                }
                case 6: {
                    int n6 = Collation.indexFromCE32(n3);
                    int n5 = Collation.lengthFromCE32(n3);
                    this.ceBuffer.ensureAppendCapacity(n5);
                    do {
                        this.ceBuffer.appendUnsafe(collationData.ces[n6++]);
                    } while (--n5 > 0);
                    return;
                }
                case 7: {
                    n3 = this.getCE32FromBuilderData(n3);
                    if (n3 != 192) break;
                    collationData = this.data.base;
                    n3 = collationData.getCE32(n2);
                    break;
                }
                case 8: {
                    if (bl2) {
                        this.backwardNumCodePoints(1);
                    }
                    n3 = this.getCE32FromPrefix(collationData, n3);
                    if (!bl2) break;
                    this.forwardNumCodePoints(1);
                    break;
                }
                case 9: {
                    int n7;
                    int n8 = Collation.indexFromCE32(n3);
                    int n5 = collationData.getCE32FromContexts(n8);
                    if (!bl2) {
                        n3 = n5;
                        break;
                    }
                    if (this.skipped == null && this.numCpFwd < 0) {
                        n7 = this.nextCodePoint();
                        if (n7 < 0) {
                            n3 = n5;
                            break;
                        }
                        if ((n3 & 0x200) != 0 && !CollationFCD.mayHaveLccc(n7)) {
                            this.backwardNumCodePoints(1);
                            n3 = n5;
                            break;
                        }
                    } else {
                        n7 = this.nextSkippedCodePoint();
                        if (n7 < 0) {
                            n3 = n5;
                            break;
                        }
                        if ((n3 & 0x200) != 0 && !CollationFCD.mayHaveLccc(n7)) {
                            this.backwardNumSkipped(1);
                            n3 = n5;
                            break;
                        }
                    }
                    if ((n3 = this.nextCE32FromContraction(collationData, n3, collationData.contexts, n8 + 2, n5, n7)) != 1) break;
                    return;
                }
                case 10: {
                    if (this.isNumeric) {
                        this.appendNumericCEs(n3, bl2);
                        return;
                    }
                    n3 = collationData.ce32s[Collation.indexFromCE32(n3)];
                    break;
                }
                case 11: {
                    assert (n2 == 0);
                    n3 = collationData.ce32s[0];
                    break;
                }
                case 12: {
                    int[] nArray = collationData.jamoCE32s;
                    int n5 = (n2 -= 44032) % 28;
                    int n7 = (n2 /= 28) % 21;
                    n2 /= 21;
                    if ((n3 & 0x100) != 0) {
                        this.ceBuffer.ensureAppendCapacity(n5 == 0 ? 2 : 3);
                        this.ceBuffer.set(this.ceBuffer.length, Collation.ceFromCE32(nArray[n2]));
                        this.ceBuffer.set(this.ceBuffer.length + 1, Collation.ceFromCE32(nArray[19 + n7]));
                        this.ceBuffer.length += 2;
                        if (n5 != 0) {
                            this.ceBuffer.appendUnsafe(Collation.ceFromCE32(nArray[39 + n5]));
                        }
                        return;
                    }
                    this.appendCEsFromCE32(collationData, -1, nArray[n2], bl2);
                    this.appendCEsFromCE32(collationData, -1, nArray[19 + n7], bl2);
                    if (n5 == 0) {
                        return;
                    }
                    n3 = nArray[39 + n5];
                    n2 = -1;
                    break;
                }
                case 13: {
                    assert (bl2);
                    assert (CollationIterator.isLeadSurrogate(n2));
                    char c2 = this.handleGetTrailSurrogate();
                    if (Character.isLowSurrogate(c2)) {
                        n2 = Character.toCodePoint((char)n2, c2);
                        if ((n3 &= 0x300) == 0) {
                            n3 = -1;
                            break;
                        }
                        if (n3 != 256 && (n3 = collationData.getCE32FromSupplementary(n2)) != 192) break;
                        collationData = collationData.base;
                        n3 = collationData.getCE32FromSupplementary(n2);
                        break;
                    }
                    n3 = -1;
                    break;
                }
                case 14: {
                    assert (n2 >= 0);
                    this.ceBuffer.append(collationData.getCEFromOffsetCE32(n2, n3));
                    return;
                }
                case 15: {
                    assert (n2 >= 0);
                    if (CollationIterator.isSurrogate(n2) && this.forbidSurrogateCodePoints()) {
                        n3 = -195323;
                        break;
                    }
                    this.ceBuffer.append(Collation.unassignedCEFromCodePoint(n2));
                    return;
                }
            }
        }
        this.ceBuffer.append(Collation.ceFromSimpleCE32(n3));
    }

    private static final boolean isSurrogate(int n2) {
        return (n2 & 0xFFFFF800) == 55296;
    }

    protected static final boolean isLeadSurrogate(int n2) {
        return (n2 & 0xFFFFFC00) == 55296;
    }

    protected static final boolean isTrailSurrogate(int n2) {
        return (n2 & 0xFFFFFC00) == 56320;
    }

    private final long nextCEFromCE32(CollationData collationData, int n2, int n3) {
        --this.ceBuffer.length;
        this.appendCEsFromCE32(collationData, n2, n3, true);
        return this.ceBuffer.get(this.cesIndex++);
    }

    private final int getCE32FromPrefix(CollationData collationData, int n2) {
        int n3;
        int n4 = Collation.indexFromCE32(n2);
        n2 = collationData.getCE32FromContexts(n4);
        int n5 = 0;
        CharsTrie charsTrie = new CharsTrie(collationData.contexts, n4 += 2);
        while ((n3 = this.previousCodePoint()) >= 0) {
            ++n5;
            BytesTrie.Result result = charsTrie.nextForCodePoint(n3);
            if (result.hasValue()) {
                n2 = charsTrie.getValue();
            }
            if (result.hasNext()) continue;
            break;
        }
        this.forwardNumCodePoints(n5);
        return n2;
    }

    private final int nextSkippedCodePoint() {
        if (this.skipped != null && this.skipped.hasNext()) {
            return this.skipped.next();
        }
        if (this.numCpFwd == 0) {
            return -1;
        }
        int n2 = this.nextCodePoint();
        if (this.skipped != null && !this.skipped.isEmpty() && n2 >= 0) {
            this.skipped.incBeyond();
        }
        if (this.numCpFwd > 0 && n2 >= 0) {
            --this.numCpFwd;
        }
        return n2;
    }

    private final void backwardNumSkipped(int n2) {
        if (this.skipped != null && !this.skipped.isEmpty()) {
            n2 = this.skipped.backwardNumCodePoints(n2);
        }
        this.backwardNumCodePoints(n2);
        if (this.numCpFwd >= 0) {
            this.numCpFwd += n2;
        }
    }

    private final int nextCE32FromContraction(CollationData collationData, int n2, CharSequence charSequence, int n3, int n4, int n5) {
        int n6 = 1;
        int n7 = 1;
        CharsTrie charsTrie = new CharsTrie(charSequence, n3);
        if (this.skipped != null && !this.skipped.isEmpty()) {
            this.skipped.saveTrieState(charsTrie);
        }
        BytesTrie.Result result = charsTrie.firstForCodePoint(n5);
        while (true) {
            if (result.hasValue()) {
                n4 = charsTrie.getValue();
                if (!result.hasNext() || (n5 = this.nextSkippedCodePoint()) < 0) {
                    return n4;
                }
                if (this.skipped != null && !this.skipped.isEmpty()) {
                    this.skipped.saveTrieState(charsTrie);
                }
                n7 = 1;
            } else {
                int n8;
                if (result == BytesTrie.Result.NO_MATCH || (n8 = this.nextSkippedCodePoint()) < 0) {
                    if ((n2 & 0x400) == 0 || (n2 & 0x100) != 0 && n7 >= n6) break;
                    if (n7 > 1) {
                        this.backwardNumSkipped(n7);
                        n5 = this.nextSkippedCodePoint();
                        n6 -= n7 - 1;
                        n7 = 1;
                    }
                    if (collationData.getFCD16(n5) <= 255) break;
                    return this.nextCE32FromDiscontiguousContraction(collationData, charsTrie, n4, n6, n5);
                }
                n5 = n8;
                ++n7;
            }
            ++n6;
            result = charsTrie.nextForCodePoint(n5);
        }
        this.backwardNumSkipped(n7);
        return n4;
    }

    private final int nextCE32FromDiscontiguousContraction(CollationData collationData, CharsTrie charsTrie, int n2, int n3, int n4) {
        int n5;
        int n6 = collationData.getFCD16(n4);
        assert (n6 > 255);
        int n7 = this.nextSkippedCodePoint();
        if (n7 < 0) {
            this.backwardNumSkipped(1);
            return n2;
        }
        ++n3;
        int n8 = n6 & 0xFF;
        n6 = collationData.getFCD16(n7);
        if (n6 <= 255) {
            this.backwardNumSkipped(2);
            return n2;
        }
        if (this.skipped == null || this.skipped.isEmpty()) {
            if (this.skipped == null) {
                this.skipped = new SkippedState();
            }
            charsTrie.reset();
            if (n3 > 2) {
                this.backwardNumCodePoints(n3);
                charsTrie.firstForCodePoint(this.nextCodePoint());
                for (n5 = 3; n5 < n3; ++n5) {
                    charsTrie.nextForCodePoint(this.nextCodePoint());
                }
                this.forwardNumCodePoints(2);
            }
            this.skipped.saveTrieState(charsTrie);
        } else {
            this.skipped.resetToTrieState(charsTrie);
        }
        this.skipped.setFirstSkipped(n4);
        n5 = 2;
        n4 = n7;
        do {
            BytesTrie.Result result;
            if (n8 < n6 >> 8 && (result = charsTrie.nextForCodePoint(n4)).hasValue()) {
                n2 = charsTrie.getValue();
                n5 = 0;
                this.skipped.recordMatch();
                if (!result.hasNext()) break;
                this.skipped.saveTrieState(charsTrie);
            } else {
                this.skipped.skip(n4);
                this.skipped.resetToTrieState(charsTrie);
                n8 = n6 & 0xFF;
            }
            n4 = this.nextSkippedCodePoint();
            if (n4 < 0) break;
            ++n5;
        } while ((n6 = collationData.getFCD16(n4)) > 255);
        this.backwardNumSkipped(n5);
        boolean bl2 = this.skipped.isEmpty();
        this.skipped.replaceMatch();
        if (bl2 && !this.skipped.isEmpty()) {
            n4 = -1;
            while (true) {
                this.appendCEsFromCE32(collationData, n4, n2, true);
                if (!this.skipped.hasNext()) break;
                n4 = this.skipped.next();
                n2 = this.getDataCE32(n4);
                if (n2 == 192) {
                    collationData = this.data.base;
                    n2 = collationData.getCE32(n4);
                    continue;
                }
                collationData = this.data;
            }
            this.skipped.clear();
            n2 = 1;
        }
        return n2;
    }

    private final long previousCEUnsafe(int n2, UVector32 uVector32) {
        int n3 = 1;
        while ((n2 = this.previousCodePoint()) >= 0) {
            ++n3;
            if (this.data.isUnsafeBackward(n2, this.isNumeric)) continue;
        }
        this.numCpFwd = n3;
        this.cesIndex = 0;
        assert (this.ceBuffer.length == 0);
        int n4 = this.getOffset();
        while (this.numCpFwd > 0) {
            --this.numCpFwd;
            this.nextCE();
            assert (this.ceBuffer.get(this.ceBuffer.length - 1) != 0x101000100L);
            this.cesIndex = this.ceBuffer.length;
            assert (uVector32.size() < this.ceBuffer.length);
            uVector32.addElement(n4);
            n4 = this.getOffset();
            while (uVector32.size() < this.ceBuffer.length) {
                uVector32.addElement(n4);
            }
        }
        assert (uVector32.size() == this.ceBuffer.length);
        uVector32.addElement(n4);
        this.numCpFwd = -1;
        this.backwardNumCodePoints(n3);
        this.cesIndex = 0;
        return this.ceBuffer.get(--this.ceBuffer.length);
    }

    private final void appendNumericCEs(int n2, boolean bl2) {
        int n3;
        int n4;
        StringBuilder stringBuilder;
        block8: {
            block9: {
                stringBuilder = new StringBuilder();
                if (bl2) {
                    while (true) {
                        n4 = Collation.digitFromCE32(n2);
                        stringBuilder.append((char)n4);
                        if (this.numCpFwd == 0 || (n3 = this.nextCodePoint()) < 0) break block8;
                        n2 = this.data.getCE32(n3);
                        if (n2 == 192) {
                            n2 = this.data.base.getCE32(n3);
                        }
                        if (!Collation.hasCE32Tag(n2, 10)) {
                            this.backwardNumCodePoints(1);
                            break block8;
                        }
                        if (this.numCpFwd <= 0) continue;
                        --this.numCpFwd;
                    }
                }
                do {
                    n4 = Collation.digitFromCE32(n2);
                    stringBuilder.append((char)n4);
                    n3 = this.previousCodePoint();
                    if (n3 < 0) break block9;
                    n2 = this.data.getCE32(n3);
                    if (n2 != 192) continue;
                    n2 = this.data.base.getCE32(n3);
                } while (Collation.hasCE32Tag(n2, 10));
                this.forwardNumCodePoints(1);
            }
            stringBuilder.reverse();
        }
        n4 = 0;
        while (true) {
            if (n4 < stringBuilder.length() - 1 && stringBuilder.charAt(n4) == '\u0000') {
                ++n4;
                continue;
            }
            n3 = stringBuilder.length() - n4;
            if (n3 > 254) {
                n3 = 254;
            }
            this.appendNumericSegmentCEs(stringBuilder.subSequence(n4, n4 + n3));
            if ((n4 += n3) >= stringBuilder.length()) break;
        }
    }

    private final void appendNumericSegmentCEs(CharSequence charSequence) {
        int n2;
        int n3;
        int n4;
        int n5 = charSequence.length();
        assert (1 <= n5 && n5 <= 254);
        assert (n5 == 1 || charSequence.charAt(0) != '\u0000');
        long l2 = this.data.numericPrimary;
        if (n5 <= 7) {
            int n6;
            n4 = charSequence.charAt(0);
            for (n6 = 1; n6 < n5; ++n6) {
                n4 = n4 * 10 + charSequence.charAt(n6);
            }
            n6 = 2;
            int n7 = 74;
            if (n4 < n7) {
                long l3 = l2 | (long)(n6 + n4 << 16);
                this.ceBuffer.append(Collation.makeCE(l3));
                return;
            }
            n4 -= n7;
            n6 += n7;
            n7 = 40;
            if (n4 < n7 * 254) {
                long l4 = l2 | (long)(n6 + n4 / 254 << 16) | (long)(2 + n4 % 254 << 8);
                this.ceBuffer.append(Collation.makeCE(l4));
                return;
            }
            n4 -= n7 * 254;
            n6 += n7;
            n7 = 16;
            if (n4 < n7 * 254 * 254) {
                long l5 = l2 | (long)(2 + n4 % 254);
                l5 |= (long)(2 + (n4 /= 254) % 254 << 8);
                this.ceBuffer.append(Collation.makeCE(l5 |= (long)(n6 + (n4 /= 254) % 254 << 16)));
                return;
            }
        }
        assert (n5 >= 7);
        n4 = (n5 + 1) / 2;
        long l6 = l2 | (long)(128 + n4 << 16);
        while (charSequence.charAt(n5 - 1) == '\u0000' && charSequence.charAt(n5 - 2) == '\u0000') {
            n5 -= 2;
        }
        if ((n5 & 1) != 0) {
            n3 = charSequence.charAt(0);
            n2 = 1;
        } else {
            n3 = charSequence.charAt(0) * 10 + charSequence.charAt(1);
            n2 = 2;
        }
        n3 = 11 + 2 * n3;
        int n8 = 8;
        while (n2 < n5) {
            if (n8 == 0) {
                this.ceBuffer.append(Collation.makeCE(l6 |= (long)n3));
                l6 = l2;
                n8 = 16;
            } else {
                l6 |= (long)(n3 << n8);
                n8 -= 8;
            }
            n3 = 11 + 2 * (charSequence.charAt(n2) * 10 + charSequence.charAt(n2 + 1));
            n2 += 2;
        }
        this.ceBuffer.append(Collation.makeCE(l6 |= (long)(n3 - 1 << n8)));
    }

    private static final class SkippedState {
        private final StringBuilder oldBuffer = new StringBuilder();
        private final StringBuilder newBuffer = new StringBuilder();
        private int pos;
        private int skipLengthAtMatch;
        private CharsTrie.State state = new CharsTrie.State();

        SkippedState() {
        }

        void clear() {
            this.oldBuffer.setLength(0);
            this.pos = 0;
        }

        boolean isEmpty() {
            return this.oldBuffer.length() == 0;
        }

        boolean hasNext() {
            return this.pos < this.oldBuffer.length();
        }

        int next() {
            int n2 = this.oldBuffer.codePointAt(this.pos);
            this.pos += Character.charCount(n2);
            return n2;
        }

        void incBeyond() {
            assert (!this.hasNext());
            ++this.pos;
        }

        int backwardNumCodePoints(int n2) {
            int n3 = this.oldBuffer.length();
            int n4 = this.pos - n3;
            if (n4 > 0) {
                if (n4 >= n2) {
                    this.pos -= n2;
                    return n2;
                }
                this.pos = this.oldBuffer.offsetByCodePoints(n3, n4 - n2);
                return n4;
            }
            this.pos = this.oldBuffer.offsetByCodePoints(this.pos, -n2);
            return 0;
        }

        void setFirstSkipped(int n2) {
            this.skipLengthAtMatch = 0;
            this.newBuffer.setLength(0);
            this.newBuffer.appendCodePoint(n2);
        }

        void skip(int n2) {
            this.newBuffer.appendCodePoint(n2);
        }

        void recordMatch() {
            this.skipLengthAtMatch = this.newBuffer.length();
        }

        void replaceMatch() {
            int n2 = this.oldBuffer.length();
            if (this.pos > n2) {
                this.pos = n2;
            }
            this.oldBuffer.delete(0, this.pos).insert(0, this.newBuffer, 0, this.skipLengthAtMatch);
            this.pos = 0;
        }

        void saveTrieState(CharsTrie charsTrie) {
            charsTrie.saveState(this.state);
        }

        void resetToTrieState(CharsTrie charsTrie) {
            charsTrie.resetToState(this.state);
        }
    }

    private static final class CEBuffer {
        private static final int INITIAL_CAPACITY = 40;
        int length = 0;
        private long[] buffer = new long[40];

        CEBuffer() {
        }

        void append(long l2) {
            if (this.length >= 40) {
                this.ensureAppendCapacity(1);
            }
            this.buffer[this.length++] = l2;
        }

        void appendUnsafe(long l2) {
            this.buffer[this.length++] = l2;
        }

        void ensureAppendCapacity(int n2) {
            int n3 = this.buffer.length;
            if (this.length + n2 <= n3) {
                return;
            }
            do {
                if (n3 < 1000) {
                    n3 *= 4;
                    continue;
                }
                n3 *= 2;
            } while (n3 < this.length + n2);
            long[] lArray = new long[n3];
            System.arraycopy(this.buffer, 0, lArray, 0, this.length);
            this.buffer = lArray;
        }

        void incLength() {
            if (this.length >= 40) {
                this.ensureAppendCapacity(1);
            }
            ++this.length;
        }

        long set(int n2, long l2) {
            this.buffer[n2] = l2;
            return this.buffer[n2];
        }

        long get(int n2) {
            return this.buffer[n2];
        }

        long[] getCEs() {
            return this.buffer;
        }
    }
}

