/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.nio.ByteBuffer;

public final class UResource {

    public static abstract class Sink {
        public abstract void put(Key var1, Value var2, boolean var3);
    }

    public static abstract class Value {
        protected Value() {
        }

        public abstract int getType();

        public abstract String getString();

        public abstract String getAliasString();

        public abstract int getInt();

        public abstract int getUInt();

        public abstract int[] getIntVector();

        public abstract ByteBuffer getBinary();

        public abstract Array getArray();

        public abstract Table getTable();

        public abstract boolean isNoInheritanceMarker();

        public abstract String[] getStringArray();

        public abstract String[] getStringArrayOrStringAsArray();

        public abstract String getStringOrFirstOfArray();

        public String toString() {
            switch (this.getType()) {
                case 0: {
                    return this.getString();
                }
                case 7: {
                    return Integer.toString(this.getInt());
                }
                case 14: {
                    int[] nArray = this.getIntVector();
                    StringBuilder stringBuilder = new StringBuilder("[");
                    stringBuilder.append(nArray.length).append("]{");
                    if (nArray.length != 0) {
                        stringBuilder.append(nArray[0]);
                        for (int i2 = 1; i2 < nArray.length; ++i2) {
                            stringBuilder.append(", ").append(nArray[i2]);
                        }
                    }
                    return stringBuilder.append('}').toString();
                }
                case 1: {
                    return "(binary blob)";
                }
                case 8: {
                    return "(array)";
                }
                case 2: {
                    return "(table)";
                }
            }
            return "???";
        }
    }

    public static interface Table {
        public int getSize();

        public boolean getKeyAndValue(int var1, Key var2, Value var3);

        public boolean findValue(CharSequence var1, Value var2);
    }

    public static interface Array {
        public int getSize();

        public boolean getValue(int var1, Value var2);
    }

    public static final class Key
    implements CharSequence,
    Cloneable,
    Comparable<Key> {
        private byte[] bytes;
        private int offset;
        private int length;
        private String s;

        public Key() {
            this.s = "";
        }

        public Key(String string) {
            this.setString(string);
        }

        private Key(byte[] byArray, int n2, int n3) {
            this.bytes = byArray;
            this.offset = n2;
            this.length = n3;
        }

        public Key setBytes(byte[] byArray, int n2) {
            this.bytes = byArray;
            this.offset = n2;
            this.length = 0;
            while (byArray[n2 + this.length] != 0) {
                ++this.length;
            }
            this.s = null;
            return this;
        }

        public Key setToEmpty() {
            this.bytes = null;
            this.length = 0;
            this.offset = 0;
            this.s = "";
            return this;
        }

        public Key setString(String string) {
            if (string.isEmpty()) {
                this.setToEmpty();
            } else {
                this.bytes = new byte[string.length()];
                this.offset = 0;
                this.length = string.length();
                for (int i2 = 0; i2 < this.length; ++i2) {
                    char c2 = string.charAt(i2);
                    if (c2 > '\u007f') {
                        throw new IllegalArgumentException('\"' + string + "\" is not an ASCII string");
                    }
                    this.bytes[i2] = (byte)c2;
                }
                this.s = string;
            }
            return this;
        }

        public Key clone() {
            try {
                return (Key)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        @Override
        public char charAt(int n2) {
            assert (0 <= n2 && n2 < this.length);
            return (char)this.bytes[this.offset + n2];
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public Key subSequence(int n2, int n3) {
            assert (0 <= n2 && n2 < this.length);
            assert (n2 <= n3 && n3 <= this.length);
            return new Key(this.bytes, this.offset + n2, n3 - n2);
        }

        @Override
        public String toString() {
            if (this.s == null) {
                this.s = this.internalSubString(0, this.length);
            }
            return this.s;
        }

        private String internalSubString(int n2, int n3) {
            StringBuilder stringBuilder = new StringBuilder(n3 - n2);
            for (int i2 = n2; i2 < n3; ++i2) {
                stringBuilder.append((char)this.bytes[this.offset + i2]);
            }
            return stringBuilder.toString();
        }

        public String substring(int n2) {
            assert (0 <= n2 && n2 < this.length);
            return this.internalSubString(n2, this.length);
        }

        public String substring(int n2, int n3) {
            assert (0 <= n2 && n2 < this.length);
            assert (n2 <= n3 && n3 <= this.length);
            return this.internalSubString(n2, n3);
        }

        private boolean regionMatches(byte[] byArray, int n2, int n3) {
            for (int i2 = 0; i2 < n3; ++i2) {
                if (this.bytes[this.offset + i2] == byArray[n2 + i2]) continue;
                return false;
            }
            return true;
        }

        private boolean regionMatches(int n2, CharSequence charSequence, int n3) {
            for (int i2 = 0; i2 < n3; ++i2) {
                if (this.bytes[this.offset + n2 + i2] == charSequence.charAt(i2)) continue;
                return false;
            }
            return true;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this == object) {
                return true;
            }
            if (object instanceof Key) {
                Key key = (Key)object;
                return this.length == key.length && this.regionMatches(key.bytes, key.offset, this.length);
            }
            return false;
        }

        public boolean contentEquals(CharSequence charSequence) {
            if (charSequence == null) {
                return false;
            }
            return this == charSequence || charSequence.length() == this.length && this.regionMatches(0, charSequence, this.length);
        }

        public boolean startsWith(CharSequence charSequence) {
            int n2 = charSequence.length();
            return n2 <= this.length && this.regionMatches(0, charSequence, n2);
        }

        public boolean endsWith(CharSequence charSequence) {
            int n2 = charSequence.length();
            return n2 <= this.length && this.regionMatches(this.length - n2, charSequence, n2);
        }

        public boolean regionMatches(int n2, CharSequence charSequence) {
            int n3 = charSequence.length();
            return n3 == this.length - n2 && this.regionMatches(n2, charSequence, n3);
        }

        public int hashCode() {
            if (this.length == 0) {
                return 0;
            }
            int n2 = this.bytes[this.offset];
            for (int i2 = 1; i2 < this.length; ++i2) {
                n2 = 37 * n2 + this.bytes[this.offset];
            }
            return n2;
        }

        @Override
        public int compareTo(Key key) {
            return this.compareTo((CharSequence)key);
        }

        @Override
        public int compareTo(CharSequence charSequence) {
            int n2 = charSequence.length();
            int n3 = this.length <= n2 ? this.length : n2;
            for (int i2 = 0; i2 < n3; ++i2) {
                int n4 = this.charAt(i2) - charSequence.charAt(i2);
                if (n4 == 0) continue;
                return n4;
            }
            return this.length - n2;
        }
    }
}

