/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUBinary;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.UCharacterName;

final class UCharacterNameReader
implements ICUBinary.Authenticate {
    private ByteBuffer m_byteBuffer_;
    private static final int GROUP_INFO_SIZE_ = 3;
    private int m_tokenstringindex_;
    private int m_groupindex_;
    private int m_groupstringindex_;
    private int m_algnamesindex_;
    private static final int ALG_INFO_SIZE_ = 12;
    private static final int DATA_FORMAT_ID_ = 1970168173;

    @Override
    public boolean isDataVersionAcceptable(byte[] byArray) {
        return byArray[0] == 1;
    }

    protected UCharacterNameReader(ByteBuffer byteBuffer) throws IOException {
        ICUBinary.readHeader(byteBuffer, 1970168173, this);
        this.m_byteBuffer_ = byteBuffer;
    }

    protected void read(UCharacterName uCharacterName) throws IOException {
        this.m_tokenstringindex_ = this.m_byteBuffer_.getInt();
        this.m_groupindex_ = this.m_byteBuffer_.getInt();
        this.m_groupstringindex_ = this.m_byteBuffer_.getInt();
        this.m_algnamesindex_ = this.m_byteBuffer_.getInt();
        int n2 = this.m_byteBuffer_.getChar();
        char[] cArray = ICUBinary.getChars(this.m_byteBuffer_, n2, 0);
        int n3 = this.m_groupindex_ - this.m_tokenstringindex_;
        byte[] byArray = new byte[n3];
        this.m_byteBuffer_.get(byArray);
        uCharacterName.setToken(cArray, byArray);
        n2 = this.m_byteBuffer_.getChar();
        uCharacterName.setGroupCountSize(n2, 3);
        char[] cArray2 = ICUBinary.getChars(this.m_byteBuffer_, n2 *= 3, 0);
        n3 = this.m_algnamesindex_ - this.m_groupstringindex_;
        byte[] byArray2 = new byte[n3];
        this.m_byteBuffer_.get(byArray2);
        uCharacterName.setGroup(cArray2, byArray2);
        n2 = this.m_byteBuffer_.getInt();
        UCharacterName.AlgorithmName[] algorithmNameArray = new UCharacterName.AlgorithmName[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            UCharacterName.AlgorithmName algorithmName = this.readAlg();
            if (algorithmName == null) {
                throw new IOException("unames.icu read error: Algorithmic names creation error");
            }
            algorithmNameArray[i2] = algorithmName;
        }
        uCharacterName.setAlgorithm(algorithmNameArray);
    }

    protected boolean authenticate(byte[] byArray, byte[] byArray2) {
        return Arrays.equals(ICUBinary.getVersionByteArrayFromCompactInt(1970168173), byArray) && this.isDataVersionAcceptable(byArray2);
    }

    private UCharacterName.AlgorithmName readAlg() throws IOException {
        Object object;
        byte by2;
        byte by3;
        int n2;
        UCharacterName.AlgorithmName algorithmName = new UCharacterName.AlgorithmName();
        int n3 = this.m_byteBuffer_.getInt();
        if (!algorithmName.setInfo(n3, n2 = this.m_byteBuffer_.getInt(), by3 = this.m_byteBuffer_.get(), by2 = this.m_byteBuffer_.get())) {
            return null;
        }
        int n4 = this.m_byteBuffer_.getChar();
        if (by3 == 1) {
            object = ICUBinary.getChars(this.m_byteBuffer_, by2, 0);
            algorithmName.setFactor((char[])object);
            n4 -= by2 << 1;
        }
        object = new StringBuilder();
        char c2 = (char)(this.m_byteBuffer_.get() & 0xFF);
        while (c2 != '\u0000') {
            ((StringBuilder)object).append(c2);
            c2 = (char)(this.m_byteBuffer_.get() & 0xFF);
        }
        algorithmName.setPrefix(((StringBuilder)object).toString());
        if ((n4 -= 12 + ((StringBuilder)object).length() + 1) > 0) {
            byte[] byArray = new byte[n4];
            this.m_byteBuffer_.get(byArray);
            algorithmName.setFactorString(byArray);
        }
        return algorithmName;
    }
}

