/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.TreeMap;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUResourceBundle;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.range.StandardPluralRanges;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.PluralRules;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.UResourceBundle;

public class PluralRulesLoader
extends PluralRules.Factory {
    private final Map<String, PluralRules> pluralRulesCache = new HashMap<String, PluralRules>();
    private Map<String, String> localeIdToCardinalRulesId;
    private Map<String, String> localeIdToOrdinalRulesId;
    private Map<String, ULocale> rulesIdToEquivalentULocale;
    public static final PluralRulesLoader loader = new PluralRulesLoader();

    private PluralRulesLoader() {
    }

    @Override
    public ULocale[] getAvailableULocales() {
        Set<String> set = this.getLocaleIdToRulesIdMap(PluralRules.PluralType.CARDINAL).keySet();
        LinkedHashSet<ULocale> linkedHashSet = new LinkedHashSet<ULocale>(set.size());
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            linkedHashSet.add(ULocale.createCanonical(iterator.next()));
        }
        return linkedHashSet.toArray(new ULocale[0]);
    }

    @Override
    public ULocale getFunctionalEquivalent(ULocale uLocale, boolean[] blArray) {
        Object object;
        String string;
        if (blArray != null && blArray.length > 0) {
            string = ULocale.canonicalize(uLocale.getBaseName());
            object = this.getLocaleIdToRulesIdMap(PluralRules.PluralType.CARDINAL);
            blArray[0] = object.containsKey(string);
        }
        if ((string = this.getRulesIdForLocale(uLocale, PluralRules.PluralType.CARDINAL)) == null || string.trim().length() == 0) {
            return ULocale.ROOT;
        }
        object = this.getRulesIdToEquivalentULocaleMap().get(string);
        if (object == null) {
            return ULocale.ROOT;
        }
        return object;
    }

    private Map<String, String> getLocaleIdToRulesIdMap(PluralRules.PluralType pluralType) {
        this.checkBuildRulesIdMaps();
        return pluralType == PluralRules.PluralType.CARDINAL ? this.localeIdToCardinalRulesId : this.localeIdToOrdinalRulesId;
    }

    private Map<String, ULocale> getRulesIdToEquivalentULocaleMap() {
        this.checkBuildRulesIdMaps();
        return this.rulesIdToEquivalentULocale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkBuildRulesIdMaps() {
        boolean bl2;
        TreeMap<String, String> treeMap = this;
        synchronized (treeMap) {
            bl2 = this.localeIdToCardinalRulesId != null;
        }
        if (!bl2) {
            Map<String, String> map;
            Map<String, ULocale> map2;
            Object object;
            try {
                String string;
                String string2;
                UResourceBundle uResourceBundle;
                int n2;
                object = this.getPluralBundle();
                UResourceBundle uResourceBundle2 = ((UResourceBundle)object).get("locales");
                treeMap = new TreeMap<String, String>();
                map2 = new HashMap();
                for (n2 = 0; n2 < uResourceBundle2.getSize(); ++n2) {
                    uResourceBundle = uResourceBundle2.get(n2);
                    string2 = uResourceBundle.getKey();
                    string = uResourceBundle.getString().intern();
                    treeMap.put(string2, string);
                    if (map2.containsKey(string)) continue;
                    map2.put(string, new ULocale(string2));
                }
                uResourceBundle2 = ((UResourceBundle)object).get("locales_ordinals");
                map = new TreeMap();
                for (n2 = 0; n2 < uResourceBundle2.getSize(); ++n2) {
                    uResourceBundle = uResourceBundle2.get(n2);
                    string2 = uResourceBundle.getKey();
                    string = uResourceBundle.getString().intern();
                    map.put(string2, string);
                }
            }
            catch (MissingResourceException missingResourceException) {
                treeMap = Collections.emptyMap();
                map = Collections.emptyMap();
                map2 = Collections.emptyMap();
            }
            object = this;
            synchronized (object) {
                if (this.localeIdToCardinalRulesId == null) {
                    this.localeIdToCardinalRulesId = treeMap;
                    this.localeIdToOrdinalRulesId = map;
                    this.rulesIdToEquivalentULocale = map2;
                }
            }
        }
    }

    public String getRulesIdForLocale(ULocale uLocale, PluralRules.PluralType pluralType) {
        int n2;
        Map<String, String> map = this.getLocaleIdToRulesIdMap(pluralType);
        String string = ULocale.canonicalize(uLocale.getBaseName());
        String string2 = null;
        while (null == (string2 = map.get(string)) && (n2 = string.lastIndexOf("_")) != -1) {
            string = string.substring(0, n2);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluralRules getOrCreateRulesForLocale(ULocale uLocale, PluralRules.PluralType pluralType) {
        boolean bl2;
        String string = this.getRulesIdForLocale(uLocale, pluralType);
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        String string2 = StandardPluralRanges.getSetForLocale(uLocale);
        String string3 = string + "/" + string2;
        PluralRules pluralRules = null;
        Map<String, PluralRules> map = this.pluralRulesCache;
        synchronized (map) {
            bl2 = this.pluralRulesCache.containsKey(string3);
            if (bl2) {
                pluralRules = this.pluralRulesCache.get(string3);
            }
        }
        if (!bl2) {
            try {
                map = this.getPluralBundle();
                UResourceBundle uResourceBundle = ((UResourceBundle)((Object)map)).get("rules");
                UResourceBundle uResourceBundle2 = uResourceBundle.get(string);
                StringBuilder stringBuilder = new StringBuilder();
                for (int i2 = 0; i2 < uResourceBundle2.getSize(); ++i2) {
                    UResourceBundle uResourceBundle3 = uResourceBundle2.get(i2);
                    if (i2 > 0) {
                        stringBuilder.append("; ");
                    }
                    stringBuilder.append(uResourceBundle3.getKey());
                    stringBuilder.append(": ");
                    stringBuilder.append(uResourceBundle3.getString());
                }
                StandardPluralRanges standardPluralRanges = StandardPluralRanges.forSet(string2);
                pluralRules = PluralRules.newInternal(stringBuilder.toString(), standardPluralRanges);
            }
            catch (ParseException parseException) {
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            map = this.pluralRulesCache;
            synchronized (map) {
                if (this.pluralRulesCache.containsKey(string3)) {
                    pluralRules = this.pluralRulesCache.get(string3);
                } else {
                    this.pluralRulesCache.put(string3, pluralRules);
                }
            }
        }
        return pluralRules;
    }

    public UResourceBundle getPluralBundle() throws MissingResourceException {
        return ICUResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b", "plurals", ICUResourceBundle.ICU_DATA_CLASS_LOADER, true);
    }

    @Override
    public PluralRules forLocale(ULocale uLocale, PluralRules.PluralType pluralType) {
        PluralRules pluralRules = this.getOrCreateRulesForLocale(uLocale, pluralType);
        if (pluralRules == null) {
            pluralRules = PluralRules.DEFAULT;
        }
        return pluralRules;
    }

    @Override
    public boolean hasOverride(ULocale uLocale) {
        return false;
    }
}

