/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

public final class PatternProps {
    private static final byte[] latin1 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 0, 3, 0, 3, 3, 0, 3, 0, 3, 3, 0, 0, 0, 0, 3, 0, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] index2000 = new byte[]{2, 3, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 6, 7, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 9};
    private static final int[] syntax2000 = new int[]{0, -1, -65536, 0x7FFF00FF, 0x7FEFFFFE, -65536, 0x3FFFFF, -1048576, -242, 65537};
    private static final int[] syntaxOrWhiteSpace2000 = new int[]{0, -1, -16384, 2147419135, 0x7FEFFFFE, -65536, 0x3FFFFF, -1048576, -242, 65537};

    public static boolean isSyntax(int n2) {
        if (n2 < 0) {
            return false;
        }
        if (n2 <= 255) {
            return latin1[n2] == 3;
        }
        if (n2 < 8208) {
            return false;
        }
        if (n2 <= 12336) {
            int n3 = syntax2000[index2000[n2 - 8192 >> 5]];
            return (n3 >> (n2 & 0x1F) & 1) != 0;
        }
        if (64830 <= n2 && n2 <= 65094) {
            return n2 <= 64831 || 65093 <= n2;
        }
        return false;
    }

    public static boolean isSyntaxOrWhiteSpace(int n2) {
        if (n2 < 0) {
            return false;
        }
        if (n2 <= 255) {
            return latin1[n2] != 0;
        }
        if (n2 < 8206) {
            return false;
        }
        if (n2 <= 12336) {
            int n3 = syntaxOrWhiteSpace2000[index2000[n2 - 8192 >> 5]];
            return (n3 >> (n2 & 0x1F) & 1) != 0;
        }
        if (64830 <= n2 && n2 <= 65094) {
            return n2 <= 64831 || 65093 <= n2;
        }
        return false;
    }

    public static boolean isWhiteSpace(int n2) {
        if (n2 < 0) {
            return false;
        }
        if (n2 <= 255) {
            return latin1[n2] == 5;
        }
        if (8206 <= n2 && n2 <= 8233) {
            return n2 <= 8207 || 8232 <= n2;
        }
        return false;
    }

    public static int skipWhiteSpace(CharSequence charSequence, int n2) {
        while (n2 < charSequence.length() && PatternProps.isWhiteSpace(charSequence.charAt(n2))) {
            ++n2;
        }
        return n2;
    }

    public static String trimWhiteSpace(String string) {
        int n2;
        if (string.length() == 0 || !PatternProps.isWhiteSpace(string.charAt(0)) && !PatternProps.isWhiteSpace(string.charAt(string.length() - 1))) {
            return string;
        }
        int n3 = string.length();
        for (n2 = 0; n2 < n3 && PatternProps.isWhiteSpace(string.charAt(n2)); ++n2) {
        }
        if (n2 < n3) {
            while (PatternProps.isWhiteSpace(string.charAt(n3 - 1))) {
                --n3;
            }
        }
        return string.substring(n2, n3);
    }

    public static String trimSpaceChar(String string) {
        int n2;
        if (string.length() == 0 || !Character.isSpaceChar(string.charAt(0)) && !Character.isSpaceChar(string.charAt(string.length() - 1))) {
            return string;
        }
        int n3 = string.length();
        for (n2 = 0; n2 < n3 && Character.isSpaceChar(string.charAt(n2)); ++n2) {
        }
        if (n2 < n3) {
            while (PatternProps.isWhiteSpace(string.charAt(n3 - 1))) {
                --n3;
            }
        }
        return string.substring(n2, n3);
    }

    public static boolean isIdentifier(CharSequence charSequence) {
        int n2 = charSequence.length();
        if (n2 == 0) {
            return false;
        }
        int n3 = 0;
        do {
            if (!PatternProps.isSyntaxOrWhiteSpace(charSequence.charAt(n3++))) continue;
            return false;
        } while (n3 < n2);
        return true;
    }

    public static boolean isIdentifier(CharSequence charSequence, int n2, int n3) {
        if (n2 >= n3) {
            return false;
        }
        do {
            if (!PatternProps.isSyntaxOrWhiteSpace(charSequence.charAt(n2++))) continue;
            return false;
        } while (n2 < n3);
        return true;
    }

    public static int skipIdentifier(CharSequence charSequence, int n2) {
        while (n2 < charSequence.length() && !PatternProps.isSyntaxOrWhiteSpace(charSequence.charAt(n2))) {
            ++n2;
        }
        return n2;
    }
}

