/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.MissingResourceException;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Grego;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUDebug;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUResourceBundle;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Utility;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ZoneMeta;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.AnnualTimeZoneRule;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.BasicTimeZone;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.DateTimeRule;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.InitialTimeZoneRule;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.SimpleTimeZone;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.TimeArrayTimeZoneRule;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.TimeZone;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.TimeZoneRule;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.TimeZoneTransition;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.UResourceBundle;

public class OlsonTimeZone
extends BasicTimeZone {
    static final long serialVersionUID = -6281977362477515376L;
    private static final int MAX_OFFSET_SECONDS = 86400;
    private int transitionCount;
    private int typeCount;
    private long[] transitionTimes64;
    private int[] typeOffsets;
    private byte[] typeMapData;
    private int finalStartYear = Integer.MAX_VALUE;
    private double finalStartMillis = Double.MAX_VALUE;
    private SimpleTimeZone finalZone = null;
    private volatile String canonicalID = null;
    private static final String ZONEINFORES = "zoneinfo64";
    private static final boolean DEBUG = ICUDebug.enabled("olson");
    private static final int SECONDS_PER_DAY = 86400;
    private transient InitialTimeZoneRule initialRule;
    private transient TimeZoneTransition firstTZTransition;
    private transient int firstTZTransitionIdx;
    private transient TimeZoneTransition firstFinalTZTransition;
    private transient TimeArrayTimeZoneRule[] historicRules;
    private transient SimpleTimeZone finalZoneWithStartYear;
    private transient boolean transitionRulesInitialized;
    private static final int currentSerialVersion = 1;
    private int serialVersionOnStream = 1;
    private volatile transient boolean isFrozen = false;

    @Override
    public int getOffset(int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n4 < 0 || n4 > 11) {
            throw new IllegalArgumentException("Month is not in the legal range: " + n4);
        }
        return this.getOffset(n2, n3, n4, n5, n6, n7, Grego.monthLength(n3, n4));
    }

    public int getOffset(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (n2 != 1 && n2 != 0 || n4 < 0 || n4 > 11 || n5 < 1 || n5 > n8 || n6 < 1 || n6 > 7 || n7 < 0 || n7 >= 86400000 || n8 < 28 || n8 > 31) {
            throw new IllegalArgumentException();
        }
        if (n2 == 0) {
            n3 = -n3;
        }
        if (this.finalZone != null && n3 >= this.finalStartYear) {
            return this.finalZone.getOffset(n2, n3, n4, n5, n6, n7);
        }
        long l2 = Grego.fieldsToDay(n3, n4, n5) * 86400000L + (long)n7;
        int[] nArray = new int[2];
        this.getHistoricalOffset(l2, true, 3, 1, nArray);
        return nArray[0] + nArray[1];
    }

    @Override
    public void setRawOffset(int n2) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify a frozen OlsonTimeZone instance.");
        }
        if (this.getRawOffset() == n2) {
            return;
        }
        long l2 = System.currentTimeMillis();
        if ((double)l2 < this.finalStartMillis) {
            Object[] objectArray;
            SimpleTimeZone simpleTimeZone = new SimpleTimeZone(n2, this.getID());
            boolean bl2 = this.useDaylightTime();
            if (bl2) {
                Object object;
                objectArray = this.getSimpleTimeZoneRulesNear(l2);
                if (objectArray.length != 3 && (object = this.getPreviousTransition(l2, false)) != null) {
                    objectArray = this.getSimpleTimeZoneRulesNear(((TimeZoneTransition)object).getTime() - 1L);
                }
                if (objectArray.length == 3 && objectArray[1] instanceof AnnualTimeZoneRule && objectArray[2] instanceof AnnualTimeZoneRule) {
                    int n3;
                    DateTimeRule dateTimeRule;
                    DateTimeRule dateTimeRule2;
                    int n4;
                    object = (AnnualTimeZoneRule)objectArray[1];
                    AnnualTimeZoneRule annualTimeZoneRule = (AnnualTimeZoneRule)objectArray[2];
                    int n5 = ((TimeZoneRule)object).getRawOffset() + ((TimeZoneRule)object).getDSTSavings();
                    if (n5 > (n4 = annualTimeZoneRule.getRawOffset() + annualTimeZoneRule.getDSTSavings())) {
                        dateTimeRule2 = ((AnnualTimeZoneRule)object).getRule();
                        dateTimeRule = annualTimeZoneRule.getRule();
                        n3 = n5 - n4;
                    } else {
                        dateTimeRule2 = annualTimeZoneRule.getRule();
                        dateTimeRule = ((AnnualTimeZoneRule)object).getRule();
                        n3 = n4 - n5;
                    }
                    simpleTimeZone.setStartRule(dateTimeRule2.getRuleMonth(), dateTimeRule2.getRuleWeekInMonth(), dateTimeRule2.getRuleDayOfWeek(), dateTimeRule2.getRuleMillisInDay());
                    simpleTimeZone.setEndRule(dateTimeRule.getRuleMonth(), dateTimeRule.getRuleWeekInMonth(), dateTimeRule.getRuleDayOfWeek(), dateTimeRule.getRuleMillisInDay());
                    simpleTimeZone.setDSTSavings(n3);
                } else {
                    simpleTimeZone.setStartRule(0, 1, 0);
                    simpleTimeZone.setEndRule(11, 31, 86399999);
                }
            }
            objectArray = Grego.timeToFields(l2, null);
            this.finalStartYear = (int)objectArray[0];
            this.finalStartMillis = Grego.fieldsToDay((int)objectArray[0], 0, 1);
            if (bl2) {
                simpleTimeZone.setStartYear(this.finalStartYear);
            }
            this.finalZone = simpleTimeZone;
        } else {
            this.finalZone.setRawOffset(n2);
        }
        this.transitionRulesInitialized = false;
    }

    @Override
    public Object clone() {
        if (this.isFrozen()) {
            return this;
        }
        return this.cloneAsThawed();
    }

    @Override
    public void getOffset(long l2, boolean bl2, int[] nArray) {
        if (this.finalZone != null && (double)l2 >= this.finalStartMillis) {
            this.finalZone.getOffset(l2, bl2, nArray);
        } else {
            this.getHistoricalOffset(l2, bl2, 4, 12, nArray);
        }
    }

    @Override
    public void getOffsetFromLocal(long l2, BasicTimeZone.LocalOption localOption, BasicTimeZone.LocalOption localOption2, int[] nArray) {
        if (this.finalZone != null && (double)l2 >= this.finalStartMillis) {
            this.finalZone.getOffsetFromLocal(l2, localOption, localOption2, nArray);
        } else {
            this.getHistoricalOffset(l2, true, OlsonTimeZone.getLocalOptionValue(localOption), OlsonTimeZone.getLocalOptionValue(localOption2), nArray);
        }
    }

    @Override
    public int getRawOffset() {
        int[] nArray = new int[2];
        this.getOffset(System.currentTimeMillis(), false, nArray);
        return nArray[0];
    }

    @Override
    public boolean useDaylightTime() {
        long l2 = System.currentTimeMillis();
        if (this.finalZone != null && (double)l2 >= this.finalStartMillis) {
            return this.finalZone != null && this.finalZone.useDaylightTime();
        }
        int[] nArray = Grego.timeToFields(l2, null);
        long l3 = Grego.fieldsToDay(nArray[0], 0, 1) * 86400L;
        long l4 = Grego.fieldsToDay(nArray[0] + 1, 0, 1) * 86400L;
        for (int i2 = 0; i2 < this.transitionCount && this.transitionTimes64[i2] < l4; ++i2) {
            if ((this.transitionTimes64[i2] < l3 || this.dstOffsetAt(i2) == 0) && (this.transitionTimes64[i2] <= l3 || i2 <= 0 || this.dstOffsetAt(i2 - 1) == 0)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean observesDaylightTime() {
        long l2 = System.currentTimeMillis();
        if (this.finalZone != null) {
            if (this.finalZone.useDaylightTime()) {
                return true;
            }
            if ((double)l2 >= this.finalStartMillis) {
                return false;
            }
        }
        long l3 = Grego.floorDivide(l2, 1000L);
        int n2 = this.transitionCount - 1;
        if (this.dstOffsetAt(n2) != 0) {
            return true;
        }
        while (n2 >= 0 && this.transitionTimes64[n2] > l3) {
            if (this.dstOffsetAt(n2 - 1) != 0) {
                return true;
            }
            --n2;
        }
        return false;
    }

    @Override
    public int getDSTSavings() {
        if (this.finalZone != null) {
            return this.finalZone.getDSTSavings();
        }
        return super.getDSTSavings();
    }

    @Override
    public boolean inDaylightTime(Date date) {
        int[] nArray = new int[2];
        this.getOffset(date.getTime(), false, nArray);
        return nArray[1] != 0;
    }

    @Override
    public boolean hasSameRules(TimeZone timeZone) {
        if (this == timeZone) {
            return true;
        }
        if (!super.hasSameRules(timeZone)) {
            return false;
        }
        if (!(timeZone instanceof OlsonTimeZone)) {
            return false;
        }
        OlsonTimeZone olsonTimeZone = (OlsonTimeZone)timeZone;
        if (this.finalZone == null ? olsonTimeZone.finalZone != null : olsonTimeZone.finalZone == null || this.finalStartYear != olsonTimeZone.finalStartYear || !this.finalZone.hasSameRules(olsonTimeZone.finalZone)) {
            return false;
        }
        return this.transitionCount == olsonTimeZone.transitionCount && Arrays.equals(this.transitionTimes64, olsonTimeZone.transitionTimes64) && this.typeCount == olsonTimeZone.typeCount && Arrays.equals(this.typeMapData, olsonTimeZone.typeMapData) && Arrays.equals(this.typeOffsets, olsonTimeZone.typeOffsets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCanonicalID() {
        if (this.canonicalID == null) {
            OlsonTimeZone olsonTimeZone = this;
            synchronized (olsonTimeZone) {
                if (this.canonicalID == null) {
                    this.canonicalID = OlsonTimeZone.getCanonicalID(this.getID());
                    assert (this.canonicalID != null);
                    if (this.canonicalID == null) {
                        this.canonicalID = this.getID();
                    }
                }
            }
        }
        return this.canonicalID;
    }

    private void constructEmpty() {
        this.transitionCount = 0;
        this.transitionTimes64 = null;
        this.typeMapData = null;
        this.typeCount = 1;
        this.typeOffsets = new int[]{0, 0};
        this.finalZone = null;
        this.finalStartYear = Integer.MAX_VALUE;
        this.finalStartMillis = Double.MAX_VALUE;
        this.transitionRulesInitialized = false;
    }

    public OlsonTimeZone(UResourceBundle uResourceBundle, UResourceBundle uResourceBundle2, String string) {
        super(string);
        this.construct(uResourceBundle, uResourceBundle2, string);
    }

    private void construct(UResourceBundle uResourceBundle, UResourceBundle uResourceBundle2, String string) {
        block25: {
            int n2;
            UResourceBundle uResourceBundle3;
            if (uResourceBundle == null || uResourceBundle2 == null) {
                throw new IllegalArgumentException();
            }
            if (DEBUG) {
                System.out.println("OlsonTimeZone(" + uResourceBundle2.getKey() + ")");
            }
            int[] nArray = null;
            int[] nArray2 = null;
            int[] nArray3 = null;
            this.transitionCount = 0;
            try {
                uResourceBundle3 = uResourceBundle2.get("transPre32");
                nArray3 = uResourceBundle3.getIntVector();
                if (nArray3.length % 2 != 0) {
                    throw new IllegalArgumentException("Invalid Format");
                }
                this.transitionCount += nArray3.length / 2;
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            try {
                uResourceBundle3 = uResourceBundle2.get("trans");
                nArray2 = uResourceBundle3.getIntVector();
                this.transitionCount += nArray2.length;
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            try {
                uResourceBundle3 = uResourceBundle2.get("transPost32");
                nArray = uResourceBundle3.getIntVector();
                if (nArray.length % 2 != 0) {
                    throw new IllegalArgumentException("Invalid Format");
                }
                this.transitionCount += nArray.length / 2;
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            if (this.transitionCount > 0) {
                this.transitionTimes64 = new long[this.transitionCount];
                int n3 = 0;
                if (nArray3 != null) {
                    n2 = 0;
                    while (n2 < nArray3.length / 2) {
                        this.transitionTimes64[n3] = ((long)nArray3[n2 * 2] & 0xFFFFFFFFL) << 32 | (long)nArray3[n2 * 2 + 1] & 0xFFFFFFFFL;
                        ++n2;
                        ++n3;
                    }
                }
                if (nArray2 != null) {
                    n2 = 0;
                    while (n2 < nArray2.length) {
                        this.transitionTimes64[n3] = nArray2[n2];
                        ++n2;
                        ++n3;
                    }
                }
                if (nArray != null) {
                    n2 = 0;
                    while (n2 < nArray.length / 2) {
                        this.transitionTimes64[n3] = ((long)nArray[n2 * 2] & 0xFFFFFFFFL) << 32 | (long)nArray[n2 * 2 + 1] & 0xFFFFFFFFL;
                        ++n2;
                        ++n3;
                    }
                }
            } else {
                this.transitionTimes64 = null;
            }
            uResourceBundle3 = uResourceBundle2.get("typeOffsets");
            this.typeOffsets = uResourceBundle3.getIntVector();
            if (this.typeOffsets.length < 2 || this.typeOffsets.length > 32766 || this.typeOffsets.length % 2 != 0) {
                throw new IllegalArgumentException("Invalid Format");
            }
            this.typeCount = this.typeOffsets.length / 2;
            if (this.transitionCount > 0) {
                uResourceBundle3 = uResourceBundle2.get("typeMap");
                this.typeMapData = uResourceBundle3.getBinary(null);
                if (this.typeMapData == null || this.typeMapData.length != this.transitionCount) {
                    throw new IllegalArgumentException("Invalid Format");
                }
            } else {
                this.typeMapData = null;
            }
            this.finalZone = null;
            this.finalStartYear = Integer.MAX_VALUE;
            this.finalStartMillis = Double.MAX_VALUE;
            String string2 = null;
            try {
                string2 = uResourceBundle2.getString("finalRule");
                uResourceBundle3 = uResourceBundle2.get("finalRaw");
                n2 = uResourceBundle3.getInt() * 1000;
                uResourceBundle3 = OlsonTimeZone.loadRule(uResourceBundle, string2);
                int[] nArray4 = uResourceBundle3.getIntVector();
                if (nArray4 == null || nArray4.length != 11) {
                    throw new IllegalArgumentException("Invalid Format");
                }
                this.finalZone = new SimpleTimeZone(n2, string, nArray4[0], nArray4[1], nArray4[2], nArray4[3] * 1000, nArray4[4], nArray4[5], nArray4[6], nArray4[7], nArray4[8] * 1000, nArray4[9], nArray4[10] * 1000);
                uResourceBundle3 = uResourceBundle2.get("finalYear");
                this.finalStartYear = uResourceBundle3.getInt();
                this.finalStartMillis = Grego.fieldsToDay(this.finalStartYear, 0, 1) * 86400000L;
            }
            catch (MissingResourceException missingResourceException) {
                if (string2 == null) break block25;
                throw new IllegalArgumentException("Invalid Format");
            }
        }
    }

    public OlsonTimeZone(String string) {
        super(string);
        UResourceBundle uResourceBundle = UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b", ZONEINFORES, ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        UResourceBundle uResourceBundle2 = ZoneMeta.openOlsonResource(uResourceBundle, string);
        this.construct(uResourceBundle, uResourceBundle2, string);
    }

    @Override
    public void setID(String string) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify a frozen OlsonTimeZone instance.");
        }
        if (this.canonicalID == null) {
            this.canonicalID = OlsonTimeZone.getCanonicalID(this.getID());
            assert (this.canonicalID != null);
            if (this.canonicalID == null) {
                this.canonicalID = this.getID();
            }
        }
        if (this.finalZone != null) {
            this.finalZone.setID(string);
        }
        super.setID(string);
        this.transitionRulesInitialized = false;
    }

    private void getHistoricalOffset(long l2, boolean bl2, int n2, int n3, int[] nArray) {
        if (this.transitionCount != 0) {
            long l3 = Grego.floorDivide(l2, 1000L);
            if (!bl2 && l3 < this.transitionTimes64[0]) {
                nArray[0] = this.initialRawOffset() * 1000;
                nArray[1] = this.initialDstOffset() * 1000;
            } else {
                int n4;
                for (n4 = this.transitionCount - 1; n4 >= 0; --n4) {
                    long l4 = this.transitionTimes64[n4];
                    if (bl2 && l3 >= l4 - 86400L) {
                        boolean bl3;
                        int n5 = this.zoneOffsetAt(n4 - 1);
                        boolean bl4 = this.dstOffsetAt(n4 - 1) != 0;
                        int n6 = this.zoneOffsetAt(n4);
                        boolean bl5 = this.dstOffsetAt(n4) != 0;
                        boolean bl6 = bl4 && !bl5;
                        boolean bl7 = bl3 = !bl4 && bl5;
                        l4 = n6 - n5 >= 0 ? ((n2 & 3) == 1 && bl6 || (n2 & 3) == 3 && bl3 ? (l4 += (long)n5) : ((n2 & 3) == 1 && bl3 || (n2 & 3) == 3 && bl6 ? (l4 += (long)n6) : ((n2 & 0xC) == 12 ? (l4 += (long)n5) : (l4 += (long)n6)))) : ((n3 & 3) == 1 && bl6 || (n3 & 3) == 3 && bl3 ? (l4 += (long)n6) : ((n3 & 3) == 1 && bl3 || (n3 & 3) == 3 && bl6 ? (l4 += (long)n5) : ((n3 & 0xC) == 4 ? (l4 += (long)n5) : (l4 += (long)n6))));
                    }
                    if (l3 >= l4) break;
                }
                nArray[0] = this.rawOffsetAt(n4) * 1000;
                nArray[1] = this.dstOffsetAt(n4) * 1000;
            }
        } else {
            nArray[0] = this.initialRawOffset() * 1000;
            nArray[1] = this.initialDstOffset() * 1000;
        }
    }

    private int getInt(byte by2) {
        return by2 & 0xFF;
    }

    private int zoneOffsetAt(int n2) {
        int n3 = n2 >= 0 ? this.getInt(this.typeMapData[n2]) * 2 : 0;
        return this.typeOffsets[n3] + this.typeOffsets[n3 + 1];
    }

    private int rawOffsetAt(int n2) {
        int n3 = n2 >= 0 ? this.getInt(this.typeMapData[n2]) * 2 : 0;
        return this.typeOffsets[n3];
    }

    private int dstOffsetAt(int n2) {
        int n3 = n2 >= 0 ? this.getInt(this.typeMapData[n2]) * 2 : 0;
        return this.typeOffsets[n3 + 1];
    }

    private int initialRawOffset() {
        return this.typeOffsets[0];
    }

    private int initialDstOffset() {
        return this.typeOffsets[1];
    }

    public String toString() {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append('[');
        stringBuilder.append("transitionCount=" + this.transitionCount);
        stringBuilder.append(",typeCount=" + this.typeCount);
        stringBuilder.append(",transitionTimes=");
        if (this.transitionTimes64 != null) {
            stringBuilder.append('[');
            for (n2 = 0; n2 < this.transitionTimes64.length; ++n2) {
                if (n2 > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(Long.toString(this.transitionTimes64[n2]));
            }
            stringBuilder.append(']');
        } else {
            stringBuilder.append("null");
        }
        stringBuilder.append(",typeOffsets=");
        if (this.typeOffsets != null) {
            stringBuilder.append('[');
            for (n2 = 0; n2 < this.typeOffsets.length; ++n2) {
                if (n2 > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(Integer.toString(this.typeOffsets[n2]));
            }
            stringBuilder.append(']');
        } else {
            stringBuilder.append("null");
        }
        stringBuilder.append(",typeMapData=");
        if (this.typeMapData != null) {
            stringBuilder.append('[');
            for (n2 = 0; n2 < this.typeMapData.length; ++n2) {
                if (n2 > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(Byte.toString(this.typeMapData[n2]));
            }
        } else {
            stringBuilder.append("null");
        }
        stringBuilder.append(",finalStartYear=" + this.finalStartYear);
        stringBuilder.append(",finalStartMillis=" + this.finalStartMillis);
        stringBuilder.append(",finalZone=" + this.finalZone);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private static UResourceBundle loadRule(UResourceBundle uResourceBundle, String string) {
        UResourceBundle uResourceBundle2 = uResourceBundle.get("Rules");
        uResourceBundle2 = uResourceBundle2.get(string);
        return uResourceBundle2;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        OlsonTimeZone olsonTimeZone = (OlsonTimeZone)object;
        return Utility.arrayEquals(this.typeMapData, (Object)olsonTimeZone.typeMapData) || this.finalStartYear == olsonTimeZone.finalStartYear && (this.finalZone == null && olsonTimeZone.finalZone == null || this.finalZone != null && olsonTimeZone.finalZone != null && this.finalZone.equals(olsonTimeZone.finalZone) && this.transitionCount == olsonTimeZone.transitionCount && this.typeCount == olsonTimeZone.typeCount && Utility.arrayEquals((Object)this.transitionTimes64, (Object)olsonTimeZone.transitionTimes64) && Utility.arrayEquals(this.typeOffsets, (Object)olsonTimeZone.typeOffsets) && Utility.arrayEquals(this.typeMapData, (Object)olsonTimeZone.typeMapData));
    }

    @Override
    public int hashCode() {
        int n2;
        int n3 = (int)((long)(this.finalStartYear ^ (this.finalStartYear >>> 4) + this.transitionCount ^ (this.transitionCount >>> 6) + this.typeCount) ^ (long)(this.typeCount >>> 8) + Double.doubleToLongBits(this.finalStartMillis) + (long)(this.finalZone == null ? 0 : this.finalZone.hashCode()) + (long)super.hashCode());
        if (this.transitionTimes64 != null) {
            for (n2 = 0; n2 < this.transitionTimes64.length; ++n2) {
                n3 = (int)((long)n3 + (this.transitionTimes64[n2] ^ this.transitionTimes64[n2] >>> 8));
            }
        }
        for (n2 = 0; n2 < this.typeOffsets.length; ++n2) {
            n3 += this.typeOffsets[n2] ^ this.typeOffsets[n2] >>> 8;
        }
        if (this.typeMapData != null) {
            for (n2 = 0; n2 < this.typeMapData.length; ++n2) {
                n3 += this.typeMapData[n2] & 0xFF;
            }
        }
        return n3;
    }

    @Override
    public TimeZoneTransition getNextTransition(long l2, boolean bl2) {
        this.initTransitionRules();
        if (this.finalZone != null) {
            if (bl2 && l2 == this.firstFinalTZTransition.getTime()) {
                return this.firstFinalTZTransition;
            }
            if (l2 >= this.firstFinalTZTransition.getTime()) {
                if (this.finalZone.useDaylightTime()) {
                    return this.finalZoneWithStartYear.getNextTransition(l2, bl2);
                }
                return null;
            }
        }
        if (this.historicRules != null) {
            long l3;
            int n2;
            for (n2 = this.transitionCount - 1; n2 >= this.firstTZTransitionIdx && l2 <= (l3 = this.transitionTimes64[n2] * 1000L) && (bl2 || l2 != l3); --n2) {
            }
            if (n2 == this.transitionCount - 1) {
                return this.firstFinalTZTransition;
            }
            if (n2 < this.firstTZTransitionIdx) {
                return this.firstTZTransition;
            }
            TimeArrayTimeZoneRule timeArrayTimeZoneRule = this.historicRules[this.getInt(this.typeMapData[n2 + 1])];
            TimeArrayTimeZoneRule timeArrayTimeZoneRule2 = this.historicRules[this.getInt(this.typeMapData[n2])];
            long l4 = this.transitionTimes64[n2 + 1] * 1000L;
            if (timeArrayTimeZoneRule2.getName().equals(timeArrayTimeZoneRule.getName()) && timeArrayTimeZoneRule2.getRawOffset() == timeArrayTimeZoneRule.getRawOffset() && timeArrayTimeZoneRule2.getDSTSavings() == timeArrayTimeZoneRule.getDSTSavings()) {
                return this.getNextTransition(l4, false);
            }
            return new TimeZoneTransition(l4, timeArrayTimeZoneRule2, timeArrayTimeZoneRule);
        }
        return null;
    }

    @Override
    public TimeZoneTransition getPreviousTransition(long l2, boolean bl2) {
        this.initTransitionRules();
        if (this.finalZone != null) {
            if (bl2 && l2 == this.firstFinalTZTransition.getTime()) {
                return this.firstFinalTZTransition;
            }
            if (l2 > this.firstFinalTZTransition.getTime()) {
                if (this.finalZone.useDaylightTime()) {
                    return this.finalZoneWithStartYear.getPreviousTransition(l2, bl2);
                }
                return this.firstFinalTZTransition;
            }
        }
        if (this.historicRules != null) {
            long l3;
            int n2;
            for (n2 = this.transitionCount - 1; !(n2 < this.firstTZTransitionIdx || l2 > (l3 = this.transitionTimes64[n2] * 1000L) || bl2 && l2 == l3); --n2) {
            }
            if (n2 < this.firstTZTransitionIdx) {
                return null;
            }
            if (n2 == this.firstTZTransitionIdx) {
                return this.firstTZTransition;
            }
            TimeArrayTimeZoneRule timeArrayTimeZoneRule = this.historicRules[this.getInt(this.typeMapData[n2])];
            TimeArrayTimeZoneRule timeArrayTimeZoneRule2 = this.historicRules[this.getInt(this.typeMapData[n2 - 1])];
            long l4 = this.transitionTimes64[n2] * 1000L;
            if (timeArrayTimeZoneRule2.getName().equals(timeArrayTimeZoneRule.getName()) && timeArrayTimeZoneRule2.getRawOffset() == timeArrayTimeZoneRule.getRawOffset() && timeArrayTimeZoneRule2.getDSTSavings() == timeArrayTimeZoneRule.getDSTSavings()) {
                return this.getPreviousTransition(l4, false);
            }
            return new TimeZoneTransition(l4, timeArrayTimeZoneRule2, timeArrayTimeZoneRule);
        }
        return null;
    }

    @Override
    public TimeZoneRule[] getTimeZoneRules() {
        this.initTransitionRules();
        int n2 = 1;
        if (this.historicRules != null) {
            for (int i2 = 0; i2 < this.historicRules.length; ++i2) {
                if (this.historicRules[i2] == null) continue;
                ++n2;
            }
        }
        if (this.finalZone != null) {
            n2 = this.finalZone.useDaylightTime() ? (n2 += 2) : ++n2;
        }
        TimeZoneRule[] timeZoneRuleArray = new TimeZoneRule[n2];
        int n3 = 0;
        timeZoneRuleArray[n3++] = this.initialRule;
        if (this.historicRules != null) {
            for (int i3 = 0; i3 < this.historicRules.length; ++i3) {
                if (this.historicRules[i3] == null) continue;
                timeZoneRuleArray[n3++] = this.historicRules[i3];
            }
        }
        if (this.finalZone != null) {
            if (this.finalZone.useDaylightTime()) {
                TimeZoneRule[] timeZoneRuleArray2 = this.finalZoneWithStartYear.getTimeZoneRules();
                timeZoneRuleArray[n3++] = timeZoneRuleArray2[1];
                timeZoneRuleArray[n3++] = timeZoneRuleArray2[2];
            } else {
                timeZoneRuleArray[n3++] = new TimeArrayTimeZoneRule(this.getID() + "(STD)", this.finalZone.getRawOffset(), 0, new long[]{(long)this.finalStartMillis}, 2);
            }
        }
        return timeZoneRuleArray;
    }

    private synchronized void initTransitionRules() {
        Object object;
        if (this.transitionRulesInitialized) {
            return;
        }
        this.initialRule = null;
        this.firstTZTransition = null;
        this.firstFinalTZTransition = null;
        this.historicRules = null;
        this.firstTZTransitionIdx = 0;
        this.finalZoneWithStartYear = null;
        String string = this.getID() + "(STD)";
        String string2 = this.getID() + "(DST)";
        int n2 = this.initialRawOffset() * 1000;
        int n3 = this.initialDstOffset() * 1000;
        this.initialRule = new InitialTimeZoneRule(n3 == 0 ? string : string2, n2, n3);
        if (this.transitionCount > 0) {
            int n4;
            for (n4 = 0; n4 < this.transitionCount && this.getInt(this.typeMapData[n4]) == 0; ++n4) {
                ++this.firstTZTransitionIdx;
            }
            if (n4 != this.transitionCount) {
                int n5;
                object = new long[this.transitionCount];
                for (n5 = 0; n5 < this.typeCount; ++n5) {
                    int n6 = 0;
                    for (n4 = this.firstTZTransitionIdx; n4 < this.transitionCount; ++n4) {
                        long l2;
                        if (n5 != this.getInt(this.typeMapData[n4]) || !((double)(l2 = this.transitionTimes64[n4] * 1000L) < this.finalStartMillis)) continue;
                        object[n6++] = l2;
                    }
                    if (n6 <= 0) continue;
                    long[] lArray = new long[n6];
                    System.arraycopy(object, 0, lArray, 0, n6);
                    n2 = this.typeOffsets[n5 * 2] * 1000;
                    n3 = this.typeOffsets[n5 * 2 + 1] * 1000;
                    if (this.historicRules == null) {
                        this.historicRules = new TimeArrayTimeZoneRule[this.typeCount];
                    }
                    this.historicRules[n5] = new TimeArrayTimeZoneRule(n3 == 0 ? string : string2, n2, n3, lArray, 2);
                }
                n5 = this.getInt(this.typeMapData[this.firstTZTransitionIdx]);
                this.firstTZTransition = new TimeZoneTransition(this.transitionTimes64[this.firstTZTransitionIdx] * 1000L, this.initialRule, this.historicRules[n5]);
            }
        }
        if (this.finalZone != null) {
            long l3 = (long)this.finalStartMillis;
            if (this.finalZone.useDaylightTime()) {
                this.finalZoneWithStartYear = (SimpleTimeZone)this.finalZone.clone();
                this.finalZoneWithStartYear.setStartYear(this.finalStartYear);
                TimeZoneTransition timeZoneTransition = this.finalZoneWithStartYear.getNextTransition(l3, false);
                object = timeZoneTransition.getTo();
                l3 = timeZoneTransition.getTime();
            } else {
                this.finalZoneWithStartYear = this.finalZone;
                object = new TimeArrayTimeZoneRule(this.finalZone.getID(), this.finalZone.getRawOffset(), 0, new long[]{l3}, 2);
            }
            TimeZoneRule timeZoneRule = null;
            if (this.transitionCount > 0) {
                timeZoneRule = this.historicRules[this.getInt(this.typeMapData[this.transitionCount - 1])];
            }
            if (timeZoneRule == null) {
                timeZoneRule = this.initialRule;
            }
            this.firstFinalTZTransition = new TimeZoneTransition(l3, timeZoneRule, (TimeZoneRule)object);
        }
        this.transitionRulesInitialized = true;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            boolean bl2 = false;
            String string = this.getID();
            if (string != null) {
                try {
                    UResourceBundle uResourceBundle = UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b", ZONEINFORES, ICUResourceBundle.ICU_DATA_CLASS_LOADER);
                    UResourceBundle uResourceBundle2 = ZoneMeta.openOlsonResource(uResourceBundle, string);
                    this.construct(uResourceBundle, uResourceBundle2, string);
                    bl2 = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!bl2) {
                this.constructEmpty();
            }
        }
        this.transitionRulesInitialized = false;
    }

    @Override
    public boolean isFrozen() {
        return this.isFrozen;
    }

    @Override
    public TimeZone freeze() {
        this.isFrozen = true;
        return this;
    }

    @Override
    public TimeZone cloneAsThawed() {
        OlsonTimeZone olsonTimeZone = (OlsonTimeZone)super.cloneAsThawed();
        if (this.finalZone != null) {
            olsonTimeZone.finalZone = (SimpleTimeZone)this.finalZone.clone();
        }
        olsonTimeZone.isFrozen = false;
        return olsonTimeZone;
    }
}

