/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.CacheBase;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Normalizer2Impl;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.SoftCache;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Normalizer;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Normalizer2;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ICUUncheckedIOException;

public final class Norm2AllModes {
    public final Normalizer2Impl impl;
    public final ComposeNormalizer2 comp;
    public final DecomposeNormalizer2 decomp;
    public final FCDNormalizer2 fcd;
    public final ComposeNormalizer2 fcc;
    private static CacheBase<String, Norm2AllModes, ByteBuffer> cache = new SoftCache<String, Norm2AllModes, ByteBuffer>(){

        @Override
        protected Norm2AllModes createInstance(String string, ByteBuffer byteBuffer) {
            Normalizer2Impl normalizer2Impl = byteBuffer == null ? new Normalizer2Impl().load(string + ".nrm") : new Normalizer2Impl().load(byteBuffer);
            return new Norm2AllModes(normalizer2Impl);
        }
    };
    public static final NoopNormalizer2 NOOP_NORMALIZER2 = new NoopNormalizer2();

    private Norm2AllModes(Normalizer2Impl normalizer2Impl) {
        this.impl = normalizer2Impl;
        this.comp = new ComposeNormalizer2(normalizer2Impl, false);
        this.decomp = new DecomposeNormalizer2(normalizer2Impl);
        this.fcd = new FCDNormalizer2(normalizer2Impl);
        this.fcc = new ComposeNormalizer2(normalizer2Impl, true);
    }

    private static Norm2AllModes getInstanceFromSingleton(Norm2AllModesSingleton norm2AllModesSingleton) {
        if (norm2AllModesSingleton.exception != null) {
            throw norm2AllModesSingleton.exception;
        }
        return norm2AllModesSingleton.allModes;
    }

    public static Norm2AllModes getNFCInstance() {
        return Norm2AllModes.getInstanceFromSingleton(NFCSingleton.INSTANCE);
    }

    public static Norm2AllModes getNFKCInstance() {
        return Norm2AllModes.getInstanceFromSingleton(NFKCSingleton.INSTANCE);
    }

    public static Norm2AllModes getNFKC_CFInstance() {
        return Norm2AllModes.getInstanceFromSingleton(NFKC_CFSingleton.INSTANCE);
    }

    public static Norm2AllModes getNFKC_SCFInstance() {
        return Norm2AllModes.getInstanceFromSingleton(NFKC_SCFSingleton.INSTANCE);
    }

    public static Normalizer2WithImpl getN2WithImpl(int n2) {
        switch (n2) {
            case 0: {
                return Norm2AllModes.getNFCInstance().decomp;
            }
            case 1: {
                return Norm2AllModes.getNFKCInstance().decomp;
            }
            case 2: {
                return Norm2AllModes.getNFCInstance().comp;
            }
            case 3: {
                return Norm2AllModes.getNFKCInstance().comp;
            }
        }
        return null;
    }

    public static Norm2AllModes getInstance(ByteBuffer byteBuffer, String string) {
        Norm2AllModesSingleton norm2AllModesSingleton;
        if (byteBuffer == null && (norm2AllModesSingleton = string.equals("nfc") ? NFCSingleton.INSTANCE : (string.equals("nfkc") ? NFKCSingleton.INSTANCE : (string.equals("nfkc_cf") ? NFKC_CFSingleton.INSTANCE : null))) != null) {
            if (norm2AllModesSingleton.exception != null) {
                throw norm2AllModesSingleton.exception;
            }
            return norm2AllModesSingleton.allModes;
        }
        return cache.getInstance(string, byteBuffer);
    }

    public static Normalizer2 getFCDNormalizer2() {
        return Norm2AllModes.getNFCInstance().fcd;
    }

    private static final class NFKC_SCFSingleton {
        private static final Norm2AllModesSingleton INSTANCE = new Norm2AllModesSingleton("nfkc_scf");

        private NFKC_SCFSingleton() {
        }
    }

    private static final class NFKC_CFSingleton {
        private static final Norm2AllModesSingleton INSTANCE = new Norm2AllModesSingleton("nfkc_cf");

        private NFKC_CFSingleton() {
        }
    }

    private static final class NFKCSingleton {
        private static final Norm2AllModesSingleton INSTANCE = new Norm2AllModesSingleton("nfkc");

        private NFKCSingleton() {
        }
    }

    private static final class NFCSingleton {
        private static final Norm2AllModesSingleton INSTANCE = new Norm2AllModesSingleton("nfc");

        private NFCSingleton() {
        }
    }

    private static final class Norm2AllModesSingleton {
        private Norm2AllModes allModes;
        private RuntimeException exception;

        private Norm2AllModesSingleton(String string) {
            try {
                Normalizer2Impl normalizer2Impl = new Normalizer2Impl().load(string + ".nrm");
                this.allModes = new Norm2AllModes(normalizer2Impl);
            }
            catch (RuntimeException runtimeException) {
                this.exception = runtimeException;
            }
        }
    }

    public static final class FCDNormalizer2
    extends Normalizer2WithImpl {
        public FCDNormalizer2(Normalizer2Impl normalizer2Impl) {
            super(normalizer2Impl);
        }

        @Override
        protected void normalize(CharSequence charSequence, Normalizer2Impl.ReorderingBuffer reorderingBuffer) {
            this.impl.makeFCD(charSequence, 0, charSequence.length(), reorderingBuffer);
        }

        @Override
        protected void normalizeAndAppend(CharSequence charSequence, boolean bl2, Normalizer2Impl.ReorderingBuffer reorderingBuffer) {
            this.impl.makeFCDAndAppend(charSequence, bl2, reorderingBuffer);
        }

        @Override
        public int spanQuickCheckYes(CharSequence charSequence) {
            return this.impl.makeFCD(charSequence, 0, charSequence.length(), null);
        }

        @Override
        public int getQuickCheck(int n2) {
            return this.impl.isDecompYes(this.impl.getNorm16(n2)) ? 1 : 0;
        }

        @Override
        public boolean hasBoundaryBefore(int n2) {
            return this.impl.hasFCDBoundaryBefore(n2);
        }

        @Override
        public boolean hasBoundaryAfter(int n2) {
            return this.impl.hasFCDBoundaryAfter(n2);
        }

        @Override
        public boolean isInert(int n2) {
            return this.impl.isFCDInert(n2);
        }
    }

    public static final class ComposeNormalizer2
    extends Normalizer2WithImpl {
        private final boolean onlyContiguous;

        public ComposeNormalizer2(Normalizer2Impl normalizer2Impl, boolean bl2) {
            super(normalizer2Impl);
            this.onlyContiguous = bl2;
        }

        @Override
        protected void normalize(CharSequence charSequence, Normalizer2Impl.ReorderingBuffer reorderingBuffer) {
            this.impl.compose(charSequence, 0, charSequence.length(), this.onlyContiguous, true, reorderingBuffer);
        }

        @Override
        protected void normalizeAndAppend(CharSequence charSequence, boolean bl2, Normalizer2Impl.ReorderingBuffer reorderingBuffer) {
            this.impl.composeAndAppend(charSequence, bl2, this.onlyContiguous, reorderingBuffer);
        }

        @Override
        public boolean isNormalized(CharSequence charSequence) {
            return this.impl.compose(charSequence, 0, charSequence.length(), this.onlyContiguous, false, new Normalizer2Impl.ReorderingBuffer(this.impl, new StringBuilder(), 5));
        }

        @Override
        public Normalizer.QuickCheckResult quickCheck(CharSequence charSequence) {
            int n2 = this.impl.composeQuickCheck(charSequence, 0, charSequence.length(), this.onlyContiguous, false);
            if ((n2 & 1) != 0) {
                return Normalizer.MAYBE;
            }
            if (n2 >>> 1 == charSequence.length()) {
                return Normalizer.YES;
            }
            return Normalizer.NO;
        }

        @Override
        public int spanQuickCheckYes(CharSequence charSequence) {
            return this.impl.composeQuickCheck(charSequence, 0, charSequence.length(), this.onlyContiguous, true) >>> 1;
        }

        @Override
        public int getQuickCheck(int n2) {
            return this.impl.getCompQuickCheck(this.impl.getNorm16(n2));
        }

        @Override
        public boolean hasBoundaryBefore(int n2) {
            return this.impl.hasCompBoundaryBefore(n2);
        }

        @Override
        public boolean hasBoundaryAfter(int n2) {
            return this.impl.hasCompBoundaryAfter(n2, this.onlyContiguous);
        }

        @Override
        public boolean isInert(int n2) {
            return this.impl.isCompInert(n2, this.onlyContiguous);
        }
    }

    public static final class DecomposeNormalizer2
    extends Normalizer2WithImpl {
        public DecomposeNormalizer2(Normalizer2Impl normalizer2Impl) {
            super(normalizer2Impl);
        }

        @Override
        protected void normalize(CharSequence charSequence, Normalizer2Impl.ReorderingBuffer reorderingBuffer) {
            this.impl.decompose(charSequence, 0, charSequence.length(), reorderingBuffer);
        }

        @Override
        protected void normalizeAndAppend(CharSequence charSequence, boolean bl2, Normalizer2Impl.ReorderingBuffer reorderingBuffer) {
            this.impl.decomposeAndAppend(charSequence, bl2, reorderingBuffer);
        }

        @Override
        public int spanQuickCheckYes(CharSequence charSequence) {
            return this.impl.decompose(charSequence, 0, charSequence.length(), null);
        }

        @Override
        public int getQuickCheck(int n2) {
            return this.impl.isDecompYes(this.impl.getNorm16(n2)) ? 1 : 0;
        }

        @Override
        public boolean hasBoundaryBefore(int n2) {
            return this.impl.hasDecompBoundaryBefore(n2);
        }

        @Override
        public boolean hasBoundaryAfter(int n2) {
            return this.impl.hasDecompBoundaryAfter(n2);
        }

        @Override
        public boolean isInert(int n2) {
            return this.impl.isDecompInert(n2);
        }
    }

    public static abstract class Normalizer2WithImpl
    extends Normalizer2 {
        public final Normalizer2Impl impl;

        public Normalizer2WithImpl(Normalizer2Impl normalizer2Impl) {
            this.impl = normalizer2Impl;
        }

        @Override
        public StringBuilder normalize(CharSequence charSequence, StringBuilder stringBuilder) {
            if (stringBuilder == charSequence) {
                throw new IllegalArgumentException();
            }
            stringBuilder.setLength(0);
            this.normalize(charSequence, new Normalizer2Impl.ReorderingBuffer(this.impl, stringBuilder, charSequence.length()));
            return stringBuilder;
        }

        @Override
        public Appendable normalize(CharSequence charSequence, Appendable appendable) {
            if (appendable == charSequence) {
                throw new IllegalArgumentException();
            }
            Normalizer2Impl.ReorderingBuffer reorderingBuffer = new Normalizer2Impl.ReorderingBuffer(this.impl, appendable, charSequence.length());
            this.normalize(charSequence, reorderingBuffer);
            reorderingBuffer.flush();
            return appendable;
        }

        protected abstract void normalize(CharSequence var1, Normalizer2Impl.ReorderingBuffer var2);

        @Override
        public StringBuilder normalizeSecondAndAppend(StringBuilder stringBuilder, CharSequence charSequence) {
            return this.normalizeSecondAndAppend(stringBuilder, charSequence, true);
        }

        @Override
        public StringBuilder append(StringBuilder stringBuilder, CharSequence charSequence) {
            return this.normalizeSecondAndAppend(stringBuilder, charSequence, false);
        }

        public StringBuilder normalizeSecondAndAppend(StringBuilder stringBuilder, CharSequence charSequence, boolean bl2) {
            if (stringBuilder == charSequence) {
                throw new IllegalArgumentException();
            }
            this.normalizeAndAppend(charSequence, bl2, new Normalizer2Impl.ReorderingBuffer(this.impl, stringBuilder, stringBuilder.length() + charSequence.length()));
            return stringBuilder;
        }

        protected abstract void normalizeAndAppend(CharSequence var1, boolean var2, Normalizer2Impl.ReorderingBuffer var3);

        @Override
        public String getDecomposition(int n2) {
            return this.impl.getDecomposition(n2);
        }

        @Override
        public String getRawDecomposition(int n2) {
            return this.impl.getRawDecomposition(n2);
        }

        @Override
        public int composePair(int n2, int n3) {
            return this.impl.composePair(n2, n3);
        }

        @Override
        public int getCombiningClass(int n2) {
            return this.impl.getCC(this.impl.getNorm16(n2));
        }

        @Override
        public boolean isNormalized(CharSequence charSequence) {
            return charSequence.length() == this.spanQuickCheckYes(charSequence);
        }

        @Override
        public Normalizer.QuickCheckResult quickCheck(CharSequence charSequence) {
            return this.isNormalized(charSequence) ? Normalizer.YES : Normalizer.NO;
        }

        public abstract int getQuickCheck(int var1);
    }

    public static final class NoopNormalizer2
    extends Normalizer2 {
        @Override
        public StringBuilder normalize(CharSequence charSequence, StringBuilder stringBuilder) {
            if (stringBuilder != charSequence) {
                stringBuilder.setLength(0);
                return stringBuilder.append(charSequence);
            }
            throw new IllegalArgumentException();
        }

        @Override
        public Appendable normalize(CharSequence charSequence, Appendable appendable) {
            if (appendable != charSequence) {
                try {
                    return appendable.append(charSequence);
                }
                catch (IOException iOException) {
                    throw new ICUUncheckedIOException(iOException);
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public StringBuilder normalizeSecondAndAppend(StringBuilder stringBuilder, CharSequence charSequence) {
            if (stringBuilder != charSequence) {
                return stringBuilder.append(charSequence);
            }
            throw new IllegalArgumentException();
        }

        @Override
        public StringBuilder append(StringBuilder stringBuilder, CharSequence charSequence) {
            if (stringBuilder != charSequence) {
                return stringBuilder.append(charSequence);
            }
            throw new IllegalArgumentException();
        }

        @Override
        public String getDecomposition(int n2) {
            return null;
        }

        @Override
        public boolean isNormalized(CharSequence charSequence) {
            return true;
        }

        @Override
        public Normalizer.QuickCheckResult quickCheck(CharSequence charSequence) {
            return Normalizer.YES;
        }

        @Override
        public int spanQuickCheckYes(CharSequence charSequence) {
            return charSequence.length();
        }

        @Override
        public boolean hasBoundaryBefore(int n2) {
            return true;
        }

        @Override
        public boolean hasBoundaryAfter(int n2) {
            return true;
        }

        @Override
        public boolean isInert(int n2) {
            return true;
        }
    }
}

