/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.LocaleIDs;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.locale.AsciiUtil;

public final class LocaleIDParser {
    private char[] id;
    private int index;
    private StringBuilder buffer;
    private boolean canonicalize;
    private boolean hadCountry;
    Map<String, String> keywords;
    String baseName;
    private static final char KEYWORD_SEPARATOR = '@';
    private static final char HYPHEN = '-';
    private static final char KEYWORD_ASSIGN = '=';
    private static final char COMMA = ',';
    private static final char ITEM_SEPARATOR = ';';
    private static final char DOT = '.';
    private static final char UNDERSCORE = '_';
    private static final char DONE = '\uffff';
    private static final int MAX_VARIANTS_LENGTH = 179;

    public LocaleIDParser(String string) {
        this(string, false);
    }

    public LocaleIDParser(String string, boolean bl2) {
        this.id = string.toCharArray();
        this.index = 0;
        this.buffer = new StringBuilder(this.id.length + 5);
        this.canonicalize = bl2;
    }

    private void reset() {
        this.index = 0;
        this.buffer = new StringBuilder(this.id.length + 5);
    }

    private void append(char c2) {
        this.buffer.append(c2);
    }

    private void addSeparator() {
        this.append('_');
    }

    private String getString(int n2) {
        return this.buffer.substring(n2);
    }

    private void set(int n2, String string) {
        this.buffer.delete(n2, this.buffer.length());
        this.buffer.insert(n2, string);
    }

    private void append(String string) {
        this.buffer.append(string);
    }

    private char next() {
        if (this.index == this.id.length) {
            ++this.index;
            return '\uffff';
        }
        return this.id[this.index++];
    }

    private void skipUntilTerminatorOrIDSeparator() {
        while (!this.isTerminatorOrIDSeparator(this.next())) {
        }
        --this.index;
    }

    private boolean atTerminator() {
        return this.index >= this.id.length || this.isTerminator(this.id[this.index]);
    }

    private boolean isTerminator(char c2) {
        return c2 == '@' || c2 == '\uffff' || c2 == '.';
    }

    private boolean isTerminatorOrIDSeparator(char c2) {
        return c2 == '_' || c2 == '-' || this.isTerminator(c2);
    }

    private boolean haveExperimentalLanguagePrefix() {
        char c2;
        if (this.id.length > 2 && ((c2 = this.id[1]) == '-' || c2 == '_')) {
            c2 = this.id[0];
            return c2 == 'x' || c2 == 'X' || c2 == 'i' || c2 == 'I';
        }
        return false;
    }

    private boolean haveKeywordAssign() {
        for (int i2 = this.index; i2 < this.id.length; ++i2) {
            if (this.id[i2] != '=') continue;
            return true;
        }
        return false;
    }

    private int parseLanguage() {
        String string;
        char c2;
        int n2 = this.buffer.length();
        if (this.haveExperimentalLanguagePrefix()) {
            this.append(AsciiUtil.toLower(this.id[0]));
            this.append('-');
            this.index = 2;
        }
        while (!this.isTerminatorOrIDSeparator(c2 = this.next())) {
            this.append(AsciiUtil.toLower(c2));
        }
        --this.index;
        if (this.buffer.length() - n2 == 3 && (string = LocaleIDs.threeToTwoLetterLanguage(this.getString(0))) != null) {
            this.set(0, string);
        }
        return 0;
    }

    private void skipLanguage() {
        if (this.haveExperimentalLanguagePrefix()) {
            this.index = 2;
        }
        this.skipUntilTerminatorOrIDSeparator();
    }

    private int parseScript() {
        if (!this.atTerminator()) {
            char c2;
            int n2 = this.index++;
            int n3 = this.buffer.length();
            boolean bl2 = true;
            while (!this.isTerminatorOrIDSeparator(c2 = this.next()) && AsciiUtil.isAlpha(c2)) {
                if (bl2) {
                    this.addSeparator();
                    this.append(AsciiUtil.toUpper(c2));
                    bl2 = false;
                    continue;
                }
                this.append(AsciiUtil.toLower(c2));
            }
            --this.index;
            if (this.index - n2 != 5) {
                this.index = n2;
                this.buffer.delete(n3, this.buffer.length());
            } else {
                ++n3;
            }
            return n3;
        }
        return this.buffer.length();
    }

    private void skipScript() {
        if (!this.atTerminator()) {
            char c2;
            int n2 = this.index++;
            while (!this.isTerminatorOrIDSeparator(c2 = this.next()) && AsciiUtil.isAlpha(c2)) {
            }
            --this.index;
            if (this.index - n2 != 5) {
                this.index = n2;
            }
        }
    }

    private int parseCountry() {
        if (!this.atTerminator()) {
            char c2;
            int n2 = this.index++;
            int n3 = this.buffer.length();
            boolean bl2 = true;
            while (!this.isTerminatorOrIDSeparator(c2 = this.next())) {
                if (bl2) {
                    this.hadCountry = true;
                    this.addSeparator();
                    ++n3;
                    bl2 = false;
                }
                this.append(AsciiUtil.toUpper(c2));
            }
            --this.index;
            int n4 = this.buffer.length() - n3;
            if (n4 != 0) {
                String string;
                if (n4 < 2 || n4 > 3) {
                    this.index = n2;
                    this.buffer.delete(--n3, this.buffer.length());
                    this.hadCountry = false;
                } else if (n4 == 3 && (string = LocaleIDs.threeToTwoLetterRegion(this.getString(n3))) != null) {
                    this.set(n3, string);
                }
            }
            return n3;
        }
        return this.buffer.length();
    }

    private void skipCountry() {
        if (!this.atTerminator()) {
            if (this.id[this.index] == '_' || this.id[this.index] == '-') {
                ++this.index;
            }
            int n2 = this.index;
            this.skipUntilTerminatorOrIDSeparator();
            int n3 = this.index - n2;
            if (n3 < 2 || n3 > 3) {
                this.index = n2;
            }
        }
    }

    private int parseVariant() {
        char c2;
        int n2 = this.buffer.length();
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = false;
        boolean bl5 = true;
        while ((c2 = this.next()) != '\uffff') {
            if (c2 == '.') {
                bl2 = false;
                bl4 = true;
                continue;
            }
            if (c2 == '@') {
                if (this.haveKeywordAssign()) break;
                bl4 = false;
                bl2 = false;
                bl3 = true;
                continue;
            }
            if (bl2) {
                bl2 = false;
                if (c2 == '_' || c2 == '-') continue;
                --this.index;
                continue;
            }
            if (bl4) continue;
            if (bl3) {
                bl3 = false;
                if (bl5 && !this.hadCountry) {
                    this.addSeparator();
                    ++n2;
                }
                this.addSeparator();
                if (bl5) {
                    ++n2;
                    bl5 = false;
                }
            }
            if ((c2 = AsciiUtil.toUpper(c2)) == '-' || c2 == ',') {
                c2 = '_';
            }
            this.append(c2);
            if (this.buffer.length() - n2 <= 179) continue;
            throw new IllegalArgumentException("variants is too long");
        }
        --this.index;
        return n2;
    }

    public String getLanguage() {
        this.reset();
        return this.getString(this.parseLanguage());
    }

    public String getScript() {
        this.reset();
        this.skipLanguage();
        return this.getString(this.parseScript());
    }

    public String getCountry() {
        this.reset();
        this.skipLanguage();
        this.skipScript();
        return this.getString(this.parseCountry());
    }

    public String getVariant() {
        this.reset();
        this.skipLanguage();
        this.skipScript();
        this.skipCountry();
        return this.getString(this.parseVariant());
    }

    public String[] getLanguageScriptCountryVariant() {
        this.reset();
        return new String[]{this.getString(this.parseLanguage()), this.getString(this.parseScript()), this.getString(this.parseCountry()), this.getString(this.parseVariant())};
    }

    public void setBaseName(String string) {
        this.baseName = string;
    }

    public void parseBaseName() {
        if (this.baseName != null) {
            this.set(0, this.baseName);
        } else {
            this.reset();
            this.parseLanguage();
            this.parseScript();
            this.parseCountry();
            this.parseVariant();
            int n2 = this.buffer.length();
            if (n2 > 0 && this.buffer.charAt(n2 - 1) == '_') {
                this.buffer.deleteCharAt(n2 - 1);
            }
        }
    }

    public String getBaseName() {
        if (this.baseName != null) {
            return this.baseName;
        }
        this.parseBaseName();
        return this.getString(0);
    }

    public String getName() {
        this.parseBaseName();
        this.parseKeywords();
        return this.getString(0);
    }

    private boolean setToKeywordStart() {
        for (int i2 = this.index; i2 < this.id.length; ++i2) {
            if (this.id[i2] != '@') continue;
            if (this.canonicalize) {
                for (int i3 = ++i2; i3 < this.id.length; ++i3) {
                    if (this.id[i3] != '=') continue;
                    this.index = i2;
                    return true;
                }
                break;
            }
            if (++i2 >= this.id.length) break;
            this.index = i2;
            return true;
        }
        return false;
    }

    private static boolean isDoneOrKeywordAssign(char c2) {
        return c2 == '\uffff' || c2 == '=';
    }

    private static boolean isDoneOrItemSeparator(char c2) {
        return c2 == '\uffff' || c2 == ';';
    }

    private String getKeyword() {
        int n2 = this.index;
        while (!LocaleIDParser.isDoneOrKeywordAssign(this.next())) {
        }
        --this.index;
        return AsciiUtil.toLowerString(new String(this.id, n2, this.index - n2).trim());
    }

    private String getValue() {
        int n2 = this.index;
        while (!LocaleIDParser.isDoneOrItemSeparator(this.next())) {
        }
        --this.index;
        return new String(this.id, n2, this.index - n2).trim();
    }

    private Comparator<String> getKeyComparator() {
        Comparator<String> comparator = new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                return string.compareTo(string2);
            }
        };
        return comparator;
    }

    public Map<String, String> getKeywordMap() {
        block6: {
            Map<String, String> map;
            block7: {
                String string;
                if (this.keywords != null) break block6;
                map = null;
                if (!this.setToKeywordStart()) break block7;
                while ((string = this.getKeyword()).length() != 0) {
                    block9: {
                        String string2;
                        block11: {
                            block10: {
                                block8: {
                                    char c2 = this.next();
                                    if (c2 == '=') break block8;
                                    if (c2 == '\uffff') {
                                        break;
                                    }
                                    break block9;
                                }
                                string2 = this.getValue();
                                if (string2.length() == 0) break block9;
                                if (map != null) break block10;
                                map = new TreeMap(this.getKeyComparator());
                                break block11;
                            }
                            if (((TreeMap)map).containsKey(string)) break block9;
                        }
                        ((TreeMap)map).put(string, string2);
                    }
                    if (this.next() == ';') continue;
                }
            }
            this.keywords = map != null ? map : Collections.emptyMap();
        }
        return this.keywords;
    }

    private int parseKeywords() {
        int n2 = this.buffer.length();
        Map<String, String> map = this.getKeywordMap();
        if (!map.isEmpty()) {
            boolean bl2 = true;
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.append(bl2 ? (char)'@' : ';');
                bl2 = false;
                this.append(entry.getKey());
                this.append('=');
                this.append(entry.getValue());
            }
            if (!bl2) {
                ++n2;
            }
        }
        return n2;
    }

    public Iterator<String> getKeywords() {
        Map<String, String> map = this.getKeywordMap();
        return map.isEmpty() ? null : map.keySet().iterator();
    }

    public String getKeywordValue(String string) {
        Map<String, String> map = this.getKeywordMap();
        return map.isEmpty() ? null : map.get(AsciiUtil.toLowerString(string.trim()));
    }

    public void defaultKeywordValue(String string, String string2) {
        this.setKeywordValue(string, string2, false);
    }

    public void setKeywordValue(String string, String string2) {
        this.setKeywordValue(string, string2, true);
    }

    private void setKeywordValue(String string, String string2, boolean bl2) {
        if (string == null) {
            if (bl2) {
                this.keywords = Collections.emptyMap();
            }
        } else {
            if ((string = AsciiUtil.toLowerString(string.trim())).length() == 0) {
                throw new IllegalArgumentException("keyword must not be empty");
            }
            if (string2 != null && (string2 = string2.trim()).length() == 0) {
                throw new IllegalArgumentException("value must not be empty");
            }
            Map<String, String> map = this.getKeywordMap();
            if (map.isEmpty()) {
                if (string2 != null) {
                    this.keywords = new TreeMap<String, String>(this.getKeyComparator());
                    this.keywords.put(string, string2.trim());
                }
            } else if (bl2 || !map.containsKey(string)) {
                if (string2 != null) {
                    map.put(string, string2);
                } else {
                    map.remove(string);
                    if (map.isEmpty()) {
                        this.keywords = Collections.emptyMap();
                    }
                }
            }
        }
    }
}

